# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.auth_params import AuthParams
from regula.documentreader.webclient.gen.models.document_format import DocumentFormat
from regula.documentreader.webclient.gen.models.document_type import DocumentType
from regula.documentreader.webclient.gen.models.face_api import FaceApi
from regula.documentreader.webclient.gen.models.image_qa import ImageQA
from regula.documentreader.webclient.gen.models.input_barcode_type import InputBarcodeType
from regula.documentreader.webclient.gen.models.lcid import LCID
from regula.documentreader.webclient.gen.models.log_level import LogLevel
from regula.documentreader.webclient.gen.models.measure_system import MeasureSystem
from regula.documentreader.webclient.gen.models.mrz_detect_mode_enum import MrzDetectModeEnum
from regula.documentreader.webclient.gen.models.mrz_format import MRZFormat
from regula.documentreader.webclient.gen.models.per_document_config import PerDocumentConfig
from regula.documentreader.webclient.gen.models.process_params_rfid import ProcessParamsRfid
from regula.documentreader.webclient.gen.models.result import Result
from regula.documentreader.webclient.gen.models.scenario import Scenario
from regula.documentreader.webclient.gen.models.text_field_type import TextFieldType
from regula.documentreader.webclient.gen.models.text_post_processing import TextPostProcessing
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class ProcessParams(BaseModel):
    """
    ProcessParams
    """ # noqa: E501
    generate_dtcvc: SkipValidation[Optional[bool]] = Field(alias="generateDTCVC", default=None, description="This parameter is used to generate separate DTC-VC data container from RFID session data.")
    lcid_filter: SkipValidation[Optional[List[LCID]]] = Field(alias="lcidFilter", default=None, description="The list of LCID types to recognize. If empty, values with all LCID types will be extracted. Empty by default.")
    check_liveness: SkipValidation[Optional[bool]] = Field(alias="checkLiveness", default=None, description="This parameter is used to enable document liveness check.")
    lcid_ignore_filter: SkipValidation[Optional[List[LCID]]] = Field(alias="lcidIgnoreFilter", default=None, description="The list of LCID types to ignore during the recognition. If empty, values with all LCID types will be extracted. Narrowing down the list can reduce processing time. Empty by default.")
    one_shot_identification: SkipValidation[Optional[bool]] = Field(alias="oneShotIdentification", default=None, description="This parameter allows processing an image that contains a person and a document and compare the portrait photo from the document with the person's face")
    use_face_api: SkipValidation[Optional[bool]] = Field(alias="useFaceApi", default=None, description="This parameter allows comparing faces on Regula Face Web Service")
    face_api: SkipValidation[Optional[FaceApi]] = Field(alias="faceApi", default=None)
    do_detect_can: SkipValidation[Optional[bool]] = Field(alias="doDetectCan", default=None, description="This parameter allows enabling the CAN (Card Access Number) detection and recognition when using scenarios with document location and MRZ reading, such as the MrzAndLocate scenario.")
    image_output_max_height: SkipValidation[Optional[int]] = Field(alias="imageOutputMaxHeight", default=None, description="This parameter allows setting maximum height in pixels of output images and thus reducing image size to desired. Does not change the aspect ratio. Changes disabled if equals to 0. Default 0.")
    image_output_max_width: SkipValidation[Optional[int]] = Field(alias="imageOutputMaxWidth", default=None, description="This parameter allows setting maximum width in pixels of output images and thus reducing image size to desired. Does not change the aspect ratio. Changes disabled if equals to 0. Default 0.")
    scenario: SkipValidation[Scenario] = Field(alias="scenario")
    result_type_output: SkipValidation[Optional[List[Result]]] = Field(alias="resultTypeOutput", default=None, description="Types of results to return in response. See 'Result' enum for available options")
    double_page_spread: SkipValidation[Optional[bool]] = Field(alias="doublePageSpread", default=None, description="Enable this option if the image you provide contains double page spread of the passport and you want to process both pages in one go. It makes sense to use it for documents that have meaningful information on both pages, like Russian domestic passport, or some others. Disabled by default.")
    generate_double_page_spread_image: SkipValidation[Optional[bool]] = Field(alias="generateDoublePageSpreadImage", default=None, description="When enabled together with \"doublePageSpread\" and there is a passport with two pages spread in the image, pages will be cropped, straightened and aligned together, as if the document was captured on a flatbed scanner. Disabled by default.")
    field_types_filter: SkipValidation[Optional[List[TextFieldType]]] = Field(alias="fieldTypesFilter", default=None, description="If a document contains Visual zone, you can set the list of field types to extract. In this case, other fields are skipped during the processing, i.e. document recognition becomes faster. This filter is not applicable to the MRZ, barcode or RFID. If the fieldTypesFilter is empty, all fields are extracted. Empty by default. If fieldTypesFilter and fieldTypesIgnoreFilter are used simultaneously, fieldTypesFilter takes priority.")
    field_types_ignore_filter: SkipValidation[Optional[List[TextFieldType]]] = Field(alias="fieldTypesIgnoreFilter", default=None, description="If a document contains a Visual zone, you can specify a list of field types that should be excluded from extraction. All field types listed in this array are skipped during processing, while the remaining fields are recognized. This filter is not applicable to the MRZ, barcode or RFID. If the fieldTypesIgnoreFilter is empty, all fields are extracted. Empty by default. If fieldTypesFilter and fieldTypesIgnoreFilter are used simultaneously, fieldTypesFilter takes priority.")
    date_format: SkipValidation[Optional[str]] = Field(alias="dateFormat", default=None, description="This option allows you to set dates format so that solution will return dates in this format. For example, if you supply 'MM/dd/yyyy', and document have printed date '09 JUL 2020' for the date os issue, you will get '07/09/2020' as a result. By default it is set to system locale default (where the service is running).")
    measure_system: SkipValidation[Optional[MeasureSystem]] = Field(alias="measureSystem", default=None)
    image_dpi_out_max: SkipValidation[Optional[int]] = Field(alias="imageDpiOutMax", default=None, description="This parameter controls maximum resolution in dpi of output images. Resolution will remain original in case 0 is supplied. By default is set to return images in response with resolution not greater than 300 dpi for all scenarios except FullAuth. In FullAuth scenario this limit is 1000 dpi by default.")
    already_cropped: SkipValidation[Optional[bool]] = Field(alias="alreadyCropped", default=None, description="This option can be enabled if you know for sure that the image you provide contains already cropped document by its edges. This was designed to process on the server side images captured and cropped on mobile. Disabled by default.")
    custom_params: SkipValidation[Optional[Dict[str, object]]] = Field(alias="customParams", default=None, description="This option allows passing custom processing parameters that can be implemented in future without changing API.")
    config: SkipValidation[Optional[List[PerDocumentConfig]]] = Field(alias="config", default=None, description="This option allows setting additional custom configuration per document type. If recognized document has ID specified in config, processing adjusts according to designated configuration.")
    log: SkipValidation[Optional[bool]] = Field(alias="log", default=None, description="When enabled, results will contain transaction processing log. Disabled by default")
    log_level: SkipValidation[Optional[LogLevel]] = Field(alias="logLevel", default=None)
    force_doc_id: SkipValidation[Optional[int]] = Field(alias="forceDocID", default=None, description="Force use of specific template ID and skip document type identification step.")
    match_text_field_mask: SkipValidation[Optional[bool]] = Field(alias="matchTextFieldMask", default=None, description="When disabled, text field OCR will be done as is and then the recognized value will be matched to the field mask for validity. If enabled, we are trying to read a field value with maximum efforts to match the mask and provide a correctly formatted value, making assumptions based on the provided field mask in the template. Enabled by default.")
    fast_doc_detect: SkipValidation[Optional[bool]] = Field(alias="fastDocDetect", default=None, description="When enabled, shorten the list of candidates to process during document detection in a single image process mode. Reduces processing time for specific backgrounds. Enabled by default.")
    update_ocr_validity_by_glare: SkipValidation[Optional[bool]] = Field(alias="updateOCRValidityByGlare", default=None, description="When enabled, fail OCR field validity, if there is a glare over the text field on the image. Disabled by default.")
    check_required_text_fields: SkipValidation[Optional[bool]] = Field(alias="checkRequiredTextFields", default=None, description="When enabled, each field in template will be checked for value presence and if the field is marked as required, but has no value, it will have 'error' in validity status. Disabled by default.")
    return_cropped_barcode: SkipValidation[Optional[bool]] = Field(alias="returnCroppedBarcode", default=None, description="When enabled, returns cropped barcode images for unknown documents. Disabled by default.")
    image_qa: SkipValidation[Optional[ImageQA]] = Field(alias="imageQa", default=None)
    strict_image_quality: SkipValidation[Optional[bool]] = Field(alias="strictImageQuality", default=None, description="When enabled, the image quality check status affects the document optical and overall status. Disabled by default.")
    respect_image_quality: SkipValidation[Optional[bool]] = Field(alias="respectImageQuality", default=None, description="Deprecated. Please use strictImageQuality instead. When enabled, image quality checks status affects document optical and overall status. Disabled by default.")
    force_doc_format: SkipValidation[Optional[DocumentFormat]] = Field(alias="forceDocFormat", default=None)
    no_graphics: SkipValidation[Optional[bool]] = Field(alias="noGraphics", default=None, description="When enabled, no graphic fields will be cropped from document image. Disabled by default.")
    depersonalize_log: SkipValidation[Optional[bool]] = Field(alias="depersonalizeLog", default=None, description="When enabled, all personal data will be forcibly removed from the logs. Disabled by default.")
    multi_doc_on_image: SkipValidation[Optional[bool]] = Field(alias="multiDocOnImage", default=None, description="This option allows locating and cropping multiple documents from one image if enabled. Disabled by default.")
    shift_expiry_date: SkipValidation[Optional[int]] = Field(alias="shiftExpiryDate", default=None, description="This option allows shifting the date of expiry into the future or past for number of months specified. This is useful, for example, in some cases when document might be still valid for some period after original expiration date to prevent negative validity status for such documents. Or by shifting the date to the past will set negative validity for the documents that is about to expire in a specified number of months. 0 by default")
    minimal_holder_age: SkipValidation[Optional[int]] = Field(alias="minimalHolderAge", default=None, description="This options allows specifying the minimal age in years of the document holder for the document to be considered valid.")
    return_uncropped_image: SkipValidation[Optional[bool]] = Field(alias="returnUncroppedImage", default=None, description="When enabled, returns input images in output. Disabled by default.")
    mrz_formats_filter: SkipValidation[Optional[List[MRZFormat]]] = Field(alias="mrzFormatsFilter", default=None, description="This option allows limiting MRZ formats to be recognized by specifying them in array.")
    force_read_mrz_before_locate: SkipValidation[Optional[bool]] = Field(alias="forceReadMrzBeforeLocate", default=None, description="When enabled, make sure that in series processing MRZ is located fully inside the result document image, if present on the document. Enabling this option may add extra processing time, by disabling optimizations, but allows more stability in output image quality. Disabled by default.")
    parse_barcodes: SkipValidation[Optional[bool]] = Field(alias="parseBarcodes", default=None, description="This option can be disabled to stop parsing after barcode is read. Enabled by default.")
    convert_case: SkipValidation[Optional[TextPostProcessing]] = Field(alias="convertCase", default=None)
    split_names: SkipValidation[Optional[bool]] = Field(alias="splitNames", default=None, description="When enabled, the Surname and GivenNames fields from MRZ will be divided into ft_First_Name, ft_Second_Name, ft_Third_Name, ft_Fourth_Name, ft_Last_Name fields. Disabled by default.")
    disable_perforation_ocr: SkipValidation[Optional[bool]] = Field(alias="disablePerforationOCR", default=None, description="When enabled, OCR of perforated fields in the document template will not be performed. Disabled by default.")
    document_group_filter: SkipValidation[Optional[List[DocumentType]]] = Field(alias="documentGroupFilter", default=None, description="List of specific eligible document types from DocumentType enum to recognize from. You may, for example, specify only passports to be recognized by setting this property. Empty by default.")
    process_auth: SkipValidation[Optional[int]] = Field(alias="processAuth", default=None, description="Authenticity checks that should be performed regardless of the document type. The available checks are listed in the eRPRM_Authenticity enum. Note that only supported by your license checks can be added.")
    device_id: SkipValidation[Optional[int]] = Field(alias="deviceId", default=None, description="This parameter is used to specify the document reader device type from which input images were captured. Default 0.")
    device_type: SkipValidation[Optional[int]] = Field(alias="deviceType", default=None, description="This parameter is used to specify the document reader device type from which input images were captured. Default 0.")
    device_type_hex: SkipValidation[Optional[str]] = Field(alias="deviceTypeHex", default=None, description="This parameter is used to specify the document reader device type from which input images were captured")
    ignore_device_id_from_image: SkipValidation[Optional[bool]] = Field(alias="ignoreDeviceIdFromImage", default=None, description="This parameter is used to tell the processing engine to ignore any parameters saved in the image when scanned from the document reader device. Default false")
    document_id_list: SkipValidation[Optional[List[int]]] = Field(alias="documentIdList", default=None, description="List of the document ID's to process. All documents will be processed, if empty.")
    rfid: SkipValidation[Optional[ProcessParamsRfid]] = Field(alias="rfid", default=None)
    check_auth: SkipValidation[Optional[bool]] = Field(alias="checkAuth", default=None, description="This parameter is used to enable authenticity checks")
    auth_params: SkipValidation[Optional[AuthParams]] = Field(alias="authParams", default=None)
    mrz_detect_mode: SkipValidation[Optional[MrzDetectModeEnum]] = Field(alias="mrzDetectMode", default=None)
    generate_numeric_codes: SkipValidation[Optional[bool]] = Field(alias="generateNumericCodes", default=None, description="This parameter is used to generate numeric representation for issuing state and nationality codes")
    strict_barcode_digital_signature_check: SkipValidation[Optional[bool]] = Field(alias="strictBarcodeDigitalSignatureCheck", default=None, description="This parameter if enabled will require all necessary certificates to verify digital signature in barcode data to be present in order for the Barcode format check to succeed.")
    select_longest_names: SkipValidation[Optional[bool]] = Field(alias="selectLongestNames", default=None, description="Select the longest value from the different value sources and write it to the value field if comparison is done successfully. The parameter applies this logic to the personal names, such as given name, surname, surname and given name, middle name and etc.")
    do_barcodes: SkipValidation[Optional[List[InputBarcodeType]]] = Field(alias="doBarcodes", default=None, description="Set the types of barcodes to process.")
    strict_dl_category_expiry: SkipValidation[Optional[bool]] = Field(alias="strictDLCategoryExpiry", default=None, description="Set to force DL categories expiry date to affect the overall status or not. As documents usually have their own date of expiry, which might be less or greater than category expiry date, this might be handy for specific cases.")
    generate_alpha2_codes: SkipValidation[Optional[bool]] = Field(alias="generateAlpha2Codes", default=None, description="Set to generate Alpha-2 codes for nationality and issuing state fields.")
    pdf_pages_limit: SkipValidation[Optional[int]] = Field(alias="pdfPagesLimit", default=None, description="Limits the number of pages to be processed from a PDF file.")
    disable_auth_resolution_filter: SkipValidation[Optional[bool]] = Field(alias="disableAuthResolutionFilter", default=None, description="This parameter if enabled will ignore the minimum barcode resolution needed to start processing.")
    strict_security_checks: SkipValidation[Optional[bool]] = Field(alias="strictSecurityChecks", default=None, description="When enabled, this parameter marks security checks that don’t meet minimum requirements as 'Failed' (instead of 'WasNotDone'), which causes the overall security status to be 'Failed'.")
    return_transliterated_fields: SkipValidation[Optional[bool]] = Field(alias="returnTransliteratedFields", default=None, description="Allows transliteration to be turned on or off; by default, it is enabled.")
    bsi_tr03135_results: SkipValidation[Optional[bool]] = Field(alias="bsiTr03135Results", default=None, description="When enabled, returns processing results in accordance with the BSI TR-03135 standard in addition to the existing processing results.")
    check_holders_signature: SkipValidation[Optional[bool]] = Field(alias="checkHoldersSignature", default=None, description="When enabled, activates detection of the document holder’s signature presence.")
    __properties: ClassVar[List[str]] = ["generateDTCVC", "lcidFilter", "checkLiveness", "lcidIgnoreFilter", "oneShotIdentification", "useFaceApi", "faceApi", "doDetectCan", "imageOutputMaxHeight", "imageOutputMaxWidth", "scenario", "resultTypeOutput", "doublePageSpread", "generateDoublePageSpreadImage", "fieldTypesFilter", "fieldTypesIgnoreFilter", "dateFormat", "measureSystem", "imageDpiOutMax", "alreadyCropped", "customParams", "config", "log", "logLevel", "forceDocID", "matchTextFieldMask", "fastDocDetect", "updateOCRValidityByGlare", "checkRequiredTextFields", "returnCroppedBarcode", "imageQa", "strictImageQuality", "respectImageQuality", "forceDocFormat", "noGraphics", "depersonalizeLog", "multiDocOnImage", "shiftExpiryDate", "minimalHolderAge", "returnUncroppedImage", "mrzFormatsFilter", "forceReadMrzBeforeLocate", "parseBarcodes", "convertCase", "splitNames", "disablePerforationOCR", "documentGroupFilter", "processAuth", "deviceId", "deviceType", "deviceTypeHex", "ignoreDeviceIdFromImage", "documentIdList", "rfid", "checkAuth", "authParams", "mrzDetectMode", "generateNumericCodes", "strictBarcodeDigitalSignatureCheck", "selectLongestNames", "doBarcodes", "strictDLCategoryExpiry", "generateAlpha2Codes", "pdfPagesLimit", "disableAuthResolutionFilter", "strictSecurityChecks", "returnTransliteratedFields", "bsiTr03135Results", "checkHoldersSignature"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProcessParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of face_api
        if self.face_api and isinstance(self.face_api, FaceApi):
            _dict['faceApi'] = self.face_api.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in config (list)
        _items = []
        if self.config:
            for _item_config in self.config:
                if _item_config and hasattr(_item_config, "to_dict"):
                    _items.append(_item_config.to_dict())
            _dict['config'] = _items
        # override the default output from pydantic by calling `to_dict()` of image_qa
        if self.image_qa and isinstance(self.image_qa, ImageQA):
            _dict['imageQa'] = self.image_qa.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rfid
        if self.rfid and isinstance(self.rfid, ProcessParamsRfid):
            _dict['rfid'] = self.rfid.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auth_params
        if self.auth_params and isinstance(self.auth_params, AuthParams):
            _dict['authParams'] = self.auth_params.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProcessParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "generateDTCVC": obj.get("generateDTCVC"),
            "lcidFilter": obj.get("lcidFilter"),
            "checkLiveness": obj.get("checkLiveness"),
            "lcidIgnoreFilter": obj.get("lcidIgnoreFilter"),
            "oneShotIdentification": obj.get("oneShotIdentification"),
            "useFaceApi": obj.get("useFaceApi"),
            "faceApi": FaceApi.from_dict(obj["faceApi"]) if obj.get("faceApi") is not None else None,
            "doDetectCan": obj.get("doDetectCan"),
            "imageOutputMaxHeight": obj.get("imageOutputMaxHeight"),
            "imageOutputMaxWidth": obj.get("imageOutputMaxWidth"),
            "scenario": obj.get("scenario"),
            "resultTypeOutput": obj.get("resultTypeOutput"),
            "doublePageSpread": obj.get("doublePageSpread"),
            "generateDoublePageSpreadImage": obj.get("generateDoublePageSpreadImage"),
            "fieldTypesFilter": obj.get("fieldTypesFilter"),
            "fieldTypesIgnoreFilter": obj.get("fieldTypesIgnoreFilter"),
            "dateFormat": obj.get("dateFormat"),
            "measureSystem": obj.get("measureSystem"),
            "imageDpiOutMax": obj.get("imageDpiOutMax"),
            "alreadyCropped": obj.get("alreadyCropped"),
            "customParams": obj.get("customParams"),
            "config": [PerDocumentConfig.from_dict(_item) for _item in obj.get("config", []) if PerDocumentConfig.from_dict(_item) is not None],
            "log": obj.get("log"),
            "logLevel": obj.get("logLevel"),
            "forceDocID": obj.get("forceDocID"),
            "matchTextFieldMask": obj.get("matchTextFieldMask"),
            "fastDocDetect": obj.get("fastDocDetect"),
            "updateOCRValidityByGlare": obj.get("updateOCRValidityByGlare"),
            "checkRequiredTextFields": obj.get("checkRequiredTextFields"),
            "returnCroppedBarcode": obj.get("returnCroppedBarcode"),
            "imageQa": ImageQA.from_dict(obj["imageQa"]) if obj.get("imageQa") is not None else None,
            "strictImageQuality": obj.get("strictImageQuality"),
            "respectImageQuality": obj.get("respectImageQuality"),
            "forceDocFormat": obj.get("forceDocFormat"),
            "noGraphics": obj.get("noGraphics"),
            "depersonalizeLog": obj.get("depersonalizeLog"),
            "multiDocOnImage": obj.get("multiDocOnImage"),
            "shiftExpiryDate": obj.get("shiftExpiryDate"),
            "minimalHolderAge": obj.get("minimalHolderAge"),
            "returnUncroppedImage": obj.get("returnUncroppedImage"),
            "mrzFormatsFilter": obj.get("mrzFormatsFilter"),
            "forceReadMrzBeforeLocate": obj.get("forceReadMrzBeforeLocate"),
            "parseBarcodes": obj.get("parseBarcodes"),
            "convertCase": obj.get("convertCase"),
            "splitNames": obj.get("splitNames"),
            "disablePerforationOCR": obj.get("disablePerforationOCR"),
            "documentGroupFilter": obj.get("documentGroupFilter"),
            "processAuth": obj.get("processAuth"),
            "deviceId": obj.get("deviceId"),
            "deviceType": obj.get("deviceType"),
            "deviceTypeHex": obj.get("deviceTypeHex"),
            "ignoreDeviceIdFromImage": obj.get("ignoreDeviceIdFromImage"),
            "documentIdList": obj.get("documentIdList"),
            "rfid": ProcessParamsRfid.from_dict(obj["rfid"]) if obj.get("rfid") is not None else None,
            "checkAuth": obj.get("checkAuth"),
            "authParams": AuthParams.from_dict(obj["authParams"]) if obj.get("authParams") is not None else None,
            "mrzDetectMode": obj.get("mrzDetectMode"),
            "generateNumericCodes": obj.get("generateNumericCodes"),
            "strictBarcodeDigitalSignatureCheck": obj.get("strictBarcodeDigitalSignatureCheck"),
            "selectLongestNames": obj.get("selectLongestNames"),
            "doBarcodes": obj.get("doBarcodes"),
            "strictDLCategoryExpiry": obj.get("strictDLCategoryExpiry"),
            "generateAlpha2Codes": obj.get("generateAlpha2Codes"),
            "pdfPagesLimit": obj.get("pdfPagesLimit"),
            "disableAuthResolutionFilter": obj.get("disableAuthResolutionFilter"),
            "strictSecurityChecks": obj.get("strictSecurityChecks"),
            "returnTransliteratedFields": obj.get("returnTransliteratedFields"),
            "bsiTr03135Results": obj.get("bsiTr03135Results"),
            "checkHoldersSignature": obj.get("checkHoldersSignature")
        })
        return _obj


