# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.document_format import DocumentFormat
from regula.documentreader.webclient.gen.models.point import Point
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class DocumentPosition(BaseModel):
    """
    DocumentPosition
    """ # noqa: E501
    doc_format: SkipValidation[DocumentFormat] = Field(alias="docFormat")
    angle: SkipValidation[float] = Field(alias="Angle", description="Document rotation angle")
    width: SkipValidation[int] = Field(alias="Width", description="Document width")
    height: SkipValidation[int] = Field(alias="Height", description="Document height")
    center: SkipValidation[Point] = Field(alias="Center")
    left_bottom: SkipValidation[Point] = Field(alias="LeftBottom")
    left_top: SkipValidation[Point] = Field(alias="LeftTop")
    right_bottom: SkipValidation[Point] = Field(alias="RightBottom")
    right_top: SkipValidation[Point] = Field(alias="RightTop")
    dpi: SkipValidation[int] = Field(alias="Dpi")
    inverse: SkipValidation[Optional[int]] = Field(alias="Inverse", default=None)
    obj_area: SkipValidation[Optional[int]] = Field(alias="ObjArea", default=None)
    obj_int_angle_dev: SkipValidation[Optional[int]] = Field(alias="ObjIntAngleDev", default=None)
    perspective_tr: SkipValidation[Optional[int]] = Field(alias="PerspectiveTr", default=None)
    result_status: SkipValidation[Optional[int]] = Field(alias="ResultStatus", default=None)
    __properties: ClassVar[List[str]] = ["docFormat", "Angle", "Width", "Height", "Center", "LeftBottom", "LeftTop", "RightBottom", "RightTop", "Dpi", "Inverse", "ObjArea", "ObjIntAngleDev", "PerspectiveTr", "ResultStatus"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentPosition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of center
        if self.center and isinstance(self.center, Point):
            _dict['Center'] = self.center.to_dict()
        # override the default output from pydantic by calling `to_dict()` of left_bottom
        if self.left_bottom and isinstance(self.left_bottom, Point):
            _dict['LeftBottom'] = self.left_bottom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of left_top
        if self.left_top and isinstance(self.left_top, Point):
            _dict['LeftTop'] = self.left_top.to_dict()
        # override the default output from pydantic by calling `to_dict()` of right_bottom
        if self.right_bottom and isinstance(self.right_bottom, Point):
            _dict['RightBottom'] = self.right_bottom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of right_top
        if self.right_top and isinstance(self.right_top, Point):
            _dict['RightTop'] = self.right_top.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentPosition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "docFormat": obj.get("docFormat"),
            "Angle": obj.get("Angle"),
            "Width": obj.get("Width"),
            "Height": obj.get("Height"),
            "Center": Point.from_dict(obj["Center"]) if obj.get("Center") is not None else None,
            "LeftBottom": Point.from_dict(obj["LeftBottom"]) if obj.get("LeftBottom") is not None else None,
            "LeftTop": Point.from_dict(obj["LeftTop"]) if obj.get("LeftTop") is not None else None,
            "RightBottom": Point.from_dict(obj["RightBottom"]) if obj.get("RightBottom") is not None else None,
            "RightTop": Point.from_dict(obj["RightTop"]) if obj.get("RightTop") is not None else None,
            "Dpi": obj.get("Dpi"),
            "Inverse": obj.get("Inverse"),
            "ObjArea": obj.get("ObjArea"),
            "ObjIntAngleDev": obj.get("ObjIntAngleDev"),
            "PerspectiveTr": obj.get("PerspectiveTr"),
            "ResultStatus": obj.get("ResultStatus")
        })
        return _obj


