# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.document_type import DocumentType
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class DatabaseDocument(BaseModel):
    """
    DatabaseDocument
    """ # noqa: E501
    barcode_fields: SkipValidation[bool] = Field(alias="barcode_fields", description="Whether the document has a barcode.")
    country: SkipValidation[str] = Field(alias="country", description="Country name.")
    createad: SkipValidation[str] = Field(alias="createad", description="Date when the document description was created in the database.")
    doc_type: SkipValidation[DocumentType] = Field(alias="doc_type")
    document: SkipValidation[str] = Field(alias="document", description="Document name.")
    graphic_fields: SkipValidation[bool] = Field(alias="graphic_fields", description="The presence of graphic fields in the document.")
    id: SkipValidation[int] = Field(alias="id", description="Document code.")
    mrz: SkipValidation[bool] = Field(alias="mrz", description="The document has an MRZ.")
    region: SkipValidation[Optional[str]] = Field(alias="region", default=None, description="Country region.")
    rfid_chip: SkipValidation[bool] = Field(alias="rfid_chip", description="The document has an RFID chip.")
    text_fields: SkipValidation[bool] = Field(alias="text_fields", description="The presence of text fields in the document.")
    updated: SkipValidation[str] = Field(alias="updated", description="Date when the document description was updated in the database.")
    year: SkipValidation[Optional[str]] = Field(alias="year", default=None, description="The year when the document was issued.")
    sovereignty: SkipValidation[Optional[str]] = Field(alias="sovereignty", default=None, description="Guardian country.")
    deprecated: SkipValidation[Optional[bool]] = Field(alias="deprecated", default=None, description="Whether the document is no longer in circulation.")
    __properties: ClassVar[List[str]] = ["barcode_fields", "country", "createad", "doc_type", "document", "graphic_fields", "id", "mrz", "region", "rfid_chip", "text_fields", "updated", "year", "sovereignty", "deprecated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatabaseDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatabaseDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "barcode_fields": obj.get("barcode_fields"),
            "country": obj.get("country"),
            "createad": obj.get("createad"),
            "doc_type": obj.get("doc_type"),
            "document": obj.get("document"),
            "graphic_fields": obj.get("graphic_fields"),
            "id": obj.get("id"),
            "mrz": obj.get("mrz"),
            "region": obj.get("region"),
            "rfid_chip": obj.get("rfid_chip"),
            "text_fields": obj.get("text_fields"),
            "updated": obj.get("updated"),
            "year": obj.get("year"),
            "sovereignty": obj.get("sovereignty"),
            "deprecated": obj.get("deprecated")
        })
        return _obj


