# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.healthcheck_documents_database import HealthcheckDocumentsDatabase
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class Healthcheck(BaseModel):
    """
    Healthcheck
    """ # noqa: E501
    app: SkipValidation[str] = Field(alias="app", description="Application name.")
    license_id: SkipValidation[str] = Field(alias="licenseId", description="Unique license identifier.")
    license_type: SkipValidation[str] = Field(alias="licenseType", description="License type.")
    license_serial: SkipValidation[str] = Field(alias="licenseSerial", description="License serial number.")
    license_valid_until: SkipValidation[datetime] = Field(alias="licenseValidUntil", description="License validity date.")
    scenarios: SkipValidation[List[str]] = Field(alias="scenarios", description="List of supported scenarios.")
    version: SkipValidation[str] = Field(alias="version", description="Product version.")
    metadata: SkipValidation[Optional[Dict[str, object]]] = Field(alias="metadata", default=None)
    documents_database: SkipValidation[Optional[HealthcheckDocumentsDatabase]] = Field(alias="documentsDatabase", default=None)
    __properties: ClassVar[List[str]] = ["app", "licenseId", "licenseType", "licenseSerial", "licenseValidUntil", "scenarios", "version", "metadata", "documentsDatabase"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Healthcheck from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of documents_database
        if self.documents_database and isinstance(self.documents_database, HealthcheckDocumentsDatabase):
            _dict['documentsDatabase'] = self.documents_database.to_dict()
        # set to None if license_id (nullable) is None
        # and model_fields_set contains the field
        if self.license_id is None and "license_id" in self.model_fields_set:
            _dict['licenseId'] = None

        # set to None if license_type (nullable) is None
        # and model_fields_set contains the field
        if self.license_type is None and "license_type" in self.model_fields_set:
            _dict['licenseType'] = None

        # set to None if license_serial (nullable) is None
        # and model_fields_set contains the field
        if self.license_serial is None and "license_serial" in self.model_fields_set:
            _dict['licenseSerial'] = None

        # set to None if license_valid_until (nullable) is None
        # and model_fields_set contains the field
        if self.license_valid_until is None and "license_valid_until" in self.model_fields_set:
            _dict['licenseValidUntil'] = None

        # set to None if scenarios (nullable) is None
        # and model_fields_set contains the field
        if self.scenarios is None and "scenarios" in self.model_fields_set:
            _dict['scenarios'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Healthcheck from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "app": obj.get("app"),
            "licenseId": obj.get("licenseId"),
            "licenseType": obj.get("licenseType"),
            "licenseSerial": obj.get("licenseSerial"),
            "licenseValidUntil": obj.get("licenseValidUntil"),
            "scenarios": obj.get("scenarios"),
            "version": obj.get("version"),
            "metadata": obj.get("metadata"),
            "documentsDatabase": HealthcheckDocumentsDatabase.from_dict(obj["documentsDatabase"]) if obj.get("documentsDatabase") is not None else None
        })
        return _obj


