# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from regula.documentreader.webclient.gen.models.rfid_access_control_procedure_type import RfidAccessControlProcedureType
from regula.documentreader.webclient.gen.models.rfid_password_type import RfidPasswordType
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class RfidAccessKey(BaseModel):
    """
    Structure is used to describe the contents of secure data access key within the context of the communication session with electronic document
    """ # noqa: E501
    access_key: SkipValidation[str] = Field(alias="AccessKey", description="Key contents")
    key_type: SkipValidation[RfidPasswordType] = Field(alias="KeyType")
    access_type: SkipValidation[RfidAccessControlProcedureType] = Field(alias="AccessType")
    check_full_key_matching: SkipValidation[bool] = Field(alias="CheckFullKeyMatching", description="Logical sign of the need for a full comparison of AccessKey contents with the contents of DG1 (MRZ) data group")
    __properties: ClassVar[List[str]] = ["AccessKey", "KeyType", "AccessType", "CheckFullKeyMatching"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidAccessKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidAccessKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AccessKey": obj.get("AccessKey"),
            "KeyType": obj.get("KeyType"),
            "AccessType": obj.get("AccessType"),
            "CheckFullKeyMatching": obj.get("CheckFullKeyMatching")
        })
        return _obj


