# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from regula.documentreader.webclient.gen.models.document_format import DocumentFormat
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class RfidDG1(BaseModel):
    """
    Structure used to store the contents of EF.DG1 informational data group of ePassport application – document MRZ data
    """ # noqa: E501
    type: SkipValidation[int] = Field(alias="Type")
    document_id: SkipValidation[DocumentFormat] = Field(alias="DocumentID")
    document_type: SkipValidation[str] = Field(alias="DocumentType", description="Symbolic code of document type")
    state: SkipValidation[str] = Field(alias="State", description="Symbolic code of document issuing state")
    holder: SkipValidation[str] = Field(alias="Holder", description="DO’s name and surname")
    document_number: SkipValidation[str] = Field(alias="DocumentNumber", description="Document number")
    check_digit_document_number: SkipValidation[float] = Field(alias="CheckDigitDocumentNumber", description="Check digit of document number")
    nationality: SkipValidation[str] = Field(alias="Nationality", description="Symbolic code of DO’s nationality")
    birthday: SkipValidation[str] = Field(alias="Birthday", description="DO’s date of birth")
    check_digit_birthday: SkipValidation[float] = Field(alias="CheckDigitBirthday", description="Check digit of DO’s date of birth")
    sex: SkipValidation[str] = Field(alias="Sex", description="DO’s sex")
    expiry_date: SkipValidation[str] = Field(alias="ExpiryDate", description="Term of validity of the document")
    check_digit_expiry_date: SkipValidation[float] = Field(alias="CheckDigitExpiryDate", description="Check digit of term of validity of the document")
    optional_data: SkipValidation[str] = Field(alias="OptionalData", description="DO’s personal number or other additional data")
    check_digit_optional_data: SkipValidation[float] = Field(alias="CheckDigitOptionalData", description="Check digit of additional data")
    check_digit_composite: SkipValidation[float] = Field(alias="CheckDigitComposite", description="General check digit")
    __properties: ClassVar[List[str]] = ["Type", "DocumentID", "DocumentType", "State", "Holder", "DocumentNumber", "CheckDigitDocumentNumber", "Nationality", "Birthday", "CheckDigitBirthday", "Sex", "ExpiryDate", "CheckDigitExpiryDate", "OptionalData", "CheckDigitOptionalData", "CheckDigitComposite"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidDG1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidDG1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "DocumentID": obj.get("DocumentID"),
            "DocumentType": obj.get("DocumentType"),
            "State": obj.get("State"),
            "Holder": obj.get("Holder"),
            "DocumentNumber": obj.get("DocumentNumber"),
            "CheckDigitDocumentNumber": obj.get("CheckDigitDocumentNumber"),
            "Nationality": obj.get("Nationality"),
            "Birthday": obj.get("Birthday"),
            "CheckDigitBirthday": obj.get("CheckDigitBirthday"),
            "Sex": obj.get("Sex"),
            "ExpiryDate": obj.get("ExpiryDate"),
            "CheckDigitExpiryDate": obj.get("CheckDigitExpiryDate"),
            "OptionalData": obj.get("OptionalData"),
            "CheckDigitOptionalData": obj.get("CheckDigitOptionalData"),
            "CheckDigitComposite": obj.get("CheckDigitComposite")
        })
        return _obj


