"""add_task_expiry

Revision ID: adfa6c905b9d
Revises: 32c843eb8225
Create Date: 2025-05-19 22:12:21.981729

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "adfa6c905b9d"
down_revision = "32c843eb8225"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "variables",
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("encrypted_value", sa.String(), nullable=False),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("created_by", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("name"),
    )
    with op.batch_alter_table("variables", schema=None) as batch_op:
        batch_op.create_index("idx_variables_name", ["name"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("variables", schema=None) as batch_op:
        batch_op.drop_index("idx_variables_name")

    op.drop_table("variables")
    # ### end Alembic commands ###
