"""rename_sql_sources_to_data_sources

Revision ID: a261d8461fde
Revises: b8c1bd22cb20
Create Date: 2025-07-20 15:12:28.888898

"""

import enum
import json

import sqlalchemy as sa
from alembic import op
from sqlalchemy import Boolean, Column, DateTime, Enum, ForeignKey, Index, Integer, String, Text, text

from resinkit_api.db.models import JSONString, TaskStatus

# revision identifiers, used by Alembic.
revision = "a261d8461fde"
down_revision = "b8c1bd22cb20"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # Create new data_sources table
    op.create_table(
        "data_sources",
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("kind", sa.String(), nullable=False),
        sa.Column("host", sa.String(), nullable=False),
        sa.Column("port", sa.Integer(), nullable=False),
        sa.Column("database", sa.String(), nullable=False),
        sa.Column("encrypted_user", sa.String(), nullable=False),
        sa.Column("encrypted_password", sa.String(), nullable=False),
        sa.Column("query_timeout", sa.String(), nullable=False),
        sa.Column("extra_params", JSONString(), nullable=True),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("created_by", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("name"),
    )
    with op.batch_alter_table("data_sources", schema=None) as batch_op:
        batch_op.create_index("idx_data_sources_kind", ["kind"], unique=False)
        batch_op.create_index("idx_data_sources_name", ["name"], unique=False)

    # Copy data from sql_sources to data_sources if sql_sources table exists
    connection = op.get_bind()
    result = connection.execute(sa.text("SELECT name FROM sqlite_master WHERE type='table' AND name='sql_sources'"))
    if result.fetchone():
        connection.execute(
            sa.text("""
            INSERT INTO data_sources (name, kind, host, port, database, encrypted_user, encrypted_password, 
                                    query_timeout, extra_params, created_at, updated_at, created_by)
            SELECT name, kind, host, port, database, encrypted_user, encrypted_password, 
                   query_timeout, extra_params, created_at, updated_at, created_by
            FROM sql_sources
        """)
        )

        # Drop old table and indexes
        with op.batch_alter_table("sql_sources", schema=None) as batch_op:
            batch_op.drop_index("idx_sql_sources_kind")
            batch_op.drop_index("idx_sql_sources_name")
        op.drop_table("sql_sources")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "sql_sources",
        sa.Column("name", sa.VARCHAR(), nullable=False),
        sa.Column("kind", sa.VARCHAR(), nullable=False),
        sa.Column("host", sa.VARCHAR(), nullable=False),
        sa.Column("port", sa.INTEGER(), nullable=False),
        sa.Column("database", sa.VARCHAR(), nullable=False),
        sa.Column("encrypted_user", sa.VARCHAR(), nullable=False),
        sa.Column("encrypted_password", sa.VARCHAR(), nullable=False),
        sa.Column("query_timeout", sa.VARCHAR(), nullable=False),
        sa.Column("extra_params", sa.VARCHAR(), nullable=True),
        sa.Column("created_at", sa.DATETIME(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DATETIME(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("created_by", sa.VARCHAR(), nullable=False),
        sa.PrimaryKeyConstraint("name"),
    )
    with op.batch_alter_table("sql_sources", schema=None) as batch_op:
        batch_op.create_index("idx_sql_sources_name", ["name"], unique=False)
        batch_op.create_index("idx_sql_sources_kind", ["kind"], unique=False)

    with op.batch_alter_table("data_sources", schema=None) as batch_op:
        batch_op.drop_index("idx_data_sources_name")
        batch_op.drop_index("idx_data_sources_kind")

    op.drop_table("data_sources")
    # ### end Alembic commands ###
