"""create_initial_tables

Revision ID: a53a22092259
Revises:
Create Date: 2025-05-10 20:12:05.309042

"""

import enum
import json

import sqlalchemy as sa
from alembic import op
from sqlalchemy import Boolean, Column, DateTime, Enum, ForeignKey, Index, Integer, String, Text, text

from resinkit_api.db.models import JSONString, TaskStatus

# revision identifiers, used by Alembic.
revision = "a53a22092259"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "tasks",
        sa.Column("task_id", sa.String(), nullable=False),
        sa.Column("task_type", sa.String(), nullable=False),
        sa.Column("task_name", sa.String(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column(
            "status",
            sa.Enum(
                "PENDING", "SUBMITTED", "VALIDATING", "PREPARING", "BUILDING", "RUNNING", "COMPLETED", "FAILED", "CANCELLING", "CANCELLED", name="taskstatus"
            ),
            server_default=sa.text("'PENDING'"),
            nullable=False,
        ),
        sa.Column("priority", sa.Integer(), server_default=sa.text("0"), nullable=False),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("started_at", sa.DateTime(), nullable=True),
        sa.Column("finished_at", sa.DateTime(), nullable=True),
        sa.Column("submitted_configs", JSONString(), nullable=False),
        sa.Column("error_info", JSONString(), nullable=True),
        sa.Column("result_summary", JSONString(), nullable=True),
        sa.Column("execution_details", JSONString(), nullable=True),
        sa.Column("progress_details", JSONString(), nullable=True),
        sa.Column("created_by", sa.String(), nullable=False),
        sa.Column("notification_config", JSONString(), nullable=True),
        sa.Column("tags", JSONString(), nullable=True),
        sa.Column("active", sa.Boolean(), server_default=sa.text("1"), nullable=False),
        sa.CheckConstraint(
            "status IN ('PENDING', 'SUBMITTED', 'VALIDATING', 'PREPARING', 'BUILDING', 'RUNNING', 'COMPLETED', 'FAILED', 'CANCELLING', 'CANCELLED')",
            name="valid_task_status",
        ),
        sa.PrimaryKeyConstraint("task_id"),
    )
    with op.batch_alter_table("tasks", schema=None) as batch_op:
        batch_op.create_index("idx_tasks_created_at", ["created_at"], unique=False)
        batch_op.create_index("idx_tasks_created_by", ["created_by"], unique=False)
        batch_op.create_index("idx_tasks_status", ["status"], unique=False, sqlite_where=sa.text("active = 1"))
        batch_op.create_index("idx_tasks_task_type", ["task_type"], unique=False, sqlite_where=sa.text("active = 1"))

    op.create_table(
        "task_events",
        sa.Column("event_id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("task_id", sa.String(), nullable=False),
        sa.Column("event_type", sa.String(), nullable=False),
        sa.Column("event_data", JSONString(), nullable=True),
        sa.Column(
            "previous_status",
            sa.Enum(
                "PENDING", "SUBMITTED", "VALIDATING", "PREPARING", "BUILDING", "RUNNING", "COMPLETED", "FAILED", "CANCELLING", "CANCELLED", name="taskstatus"
            ),
            nullable=True,
        ),
        sa.Column(
            "new_status",
            sa.Enum(
                "PENDING", "SUBMITTED", "VALIDATING", "PREPARING", "BUILDING", "RUNNING", "COMPLETED", "FAILED", "CANCELLING", "CANCELLED", name="taskstatus"
            ),
            nullable=True,
        ),
        sa.Column("timestamp", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("actor", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["task_id"],
            ["tasks.task_id"],
        ),
        sa.PrimaryKeyConstraint("event_id"),
    )
    with op.batch_alter_table("task_events", schema=None) as batch_op:
        batch_op.create_index("idx_task_events_event_type", ["event_type"], unique=False)
        batch_op.create_index("idx_task_events_task_id", ["task_id"], unique=False)
        batch_op.create_index("idx_task_events_timestamp", ["timestamp"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("task_events", schema=None) as batch_op:
        batch_op.drop_index("idx_task_events_timestamp")
        batch_op.drop_index("idx_task_events_task_id")
        batch_op.drop_index("idx_task_events_event_type")

    op.drop_table("task_events")
    with op.batch_alter_table("tasks", schema=None) as batch_op:
        batch_op.drop_index("idx_tasks_task_type", sqlite_where=sa.text("active = 1"))
        batch_op.drop_index("idx_tasks_status", sqlite_where=sa.text("active = 1"))
        batch_op.drop_index("idx_tasks_created_by")
        batch_op.drop_index("idx_tasks_created_at")

    op.drop_table("tasks")
    # ### end Alembic commands ###
