"""add_sql_sources_table

Revision ID: b8c1bd22cb20
Revises: adfa6c905b9d
Create Date: 2025-07-12 15:44:12.656403

"""

import enum
import json

import sqlalchemy as sa
from alembic import op
from sqlalchemy import Boolean, Column, DateTime, Enum, ForeignKey, Index, Integer, String, Text, text

from resinkit_api.db.models import JSONString, TaskStatus

# revision identifiers, used by Alembic.
revision = "b8c1bd22cb20"
down_revision = "adfa6c905b9d"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "sql_sources",
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("kind", sa.String(), nullable=False),
        sa.Column("host", sa.String(), nullable=False),
        sa.Column("port", sa.Integer(), nullable=False),
        sa.Column("database", sa.String(), nullable=False),
        sa.Column("encrypted_user", sa.String(), nullable=False),
        sa.Column("encrypted_password", sa.String(), nullable=False),
        sa.Column("query_timeout", sa.String(), nullable=False),
        sa.Column("extra_params", JSONString(), nullable=True),
        sa.Column("created_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("updated_at", sa.DateTime(), server_default=sa.text("(CURRENT_TIMESTAMP)"), nullable=False),
        sa.Column("created_by", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("name"),
    )
    with op.batch_alter_table("sql_sources", schema=None) as batch_op:
        batch_op.create_index("idx_sql_sources_kind", ["kind"], unique=False)
        batch_op.create_index("idx_sql_sources_name", ["name"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("sql_sources", schema=None) as batch_op:
        batch_op.drop_index("idx_sql_sources_name")
        batch_op.drop_index("idx_sql_sources_kind")

    op.drop_table("sql_sources")
    # ### end Alembic commands ###
