# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.2.1] - 2025-12-26

### Added
- **Stagehand Agent Support**: Added Stagehand as an alternative agent provider alongside browser-use
  - Supports OpenAI Computer Use models (e.g., `computer-use-preview-2025-03-11`)
  - Supports Anthropic Computer Use models (e.g., `claude-sonnet-4-5-20250929`, `claude-haiku-4-5-20251001`, `claude-opus-4-5-20251101`)
- **Separate Model Configurations**: Enhanced settings system with independent model configurations
  - `claude_code_model`: Model for Claude SDK (renamed from `model`)
  - `opencode_provider`: Provider for OpenCode SDK (e.g., "anthropic", "openai", "google")
  - `opencode_model`: Model for OpenCode SDK
  - `browser_use_model`: Model for browser-use agent provider
  - `stagehand_model`: Model for stagehand agent provider

### Changed
- **Improved Settings Management**: Separated model configurations for different SDKs and agent providers
  - Each SDK and agent provider now has its own independent model setting
  - Settings menu updated with clearer options for each component
- **Better Configuration Isolation**: OpenCode model settings no longer interfere with Claude SDK settings
- **Backward Compatibility**: Automatic migration of old config files to new structure

### Fixed
- Fixed issue where OpenCode model settings were being overridden by Claude SDK model settings
- Fixed model configuration conflicts between different SDKs and agent providers

## [0.2.0] - 2025-12-25

### Added
- **OpenCode SDK Support**: Native integration with OpenCode SDK for more flexibility in reverse engineering workflows
- **Agent Mode**: Fully automated browser interaction using AI agents (browser-use) with support for multiple LLM providers
  - Browser-Use LLM (default)
  - OpenAI models (gpt-4, gpt-3.5-turbo, etc.)
  - Google models (gemini-pro, gemini-1.5-pro, etc.)
- **Multi-Provider Agent Support**: Configure agent models via settings with automatic API key detection

### Changed
- Improved UX with better CLI interactions and mode cycling
- Enhanced settings management for model, agent model, SDK, and output directory configuration
- Better error handling and user feedback throughout the application

## [0.1.0] - 2025-12-22

### Added
- Initial release
- Browser automation with Playwright and stealth mode
- HAR recording and capture
- AI-powered API client generation using Claude
- Interactive CLI with manual and engineer modes
- Session history and cost tracking
- Production-ready code generation with type hints and documentation

