# Release v0.2.1 - Instructions

## ✅ Completed Steps

1. ✅ Updated version to 0.2.1 in `pyproject.toml`
2. ✅ Updated version to 0.2.1 in `src/reverse_api/__init__.py`
3. ✅ Updated `CHANGELOG.md` with release notes

## 📦 Next Steps

### 1. Create Git Commit and Tag

```bash
# Make sure you're in the project root
cd /Users/kalilbouzigues/Projects/browgents/reverse-api

# Stage the changes
git add pyproject.toml src/reverse_api/__init__.py CHANGELOG.md RELEASE.md

# Create commit
git commit -m "chore: bump version to 0.2.1 - Stagehand support & better settings params"

# Create tag
git tag -a v0.2.1 -m "Release v0.2.1: Stagehand support & better settings params"
```

### 2. Push to GitHub

```bash
# Push the commit and tag to GitHub
git push origin main
git push origin v0.2.1

# Or if you're on a feature branch:
# git push origin your-branch-name
# git push origin v0.2.1
```

### 3. Create GitHub Release

1. Go to: https://github.com/kalil0321/reverse-api-engineer/releases/new
2. Select tag: `v0.2.1`
3. Release title: `v0.2.1 - Stagehand Support & Better Settings Params`
4. Description (copy from CHANGELOG.md):

```markdown
## [0.2.1] - 2025-01-XX

### Added
- **Stagehand Agent Support**: Added Stagehand as an alternative agent provider alongside browser-use
  - Supports OpenAI Computer Use models (e.g., `computer-use-preview-2025-03-11`)
  - Supports Anthropic Computer Use models (e.g., `claude-sonnet-4-5-20250929`, `claude-haiku-4-5-20251001`, `claude-opus-4-5-20251101`)
- **Separate Model Configurations**: Enhanced settings system with independent model configurations
  - `claude_code_model`: Model for Claude SDK (renamed from `model`)
  - `opencode_provider`: Provider for OpenCode SDK (e.g., "anthropic", "openai", "google")
  - `opencode_model`: Model for OpenCode SDK
  - `browser_use_model`: Model for browser-use agent provider
  - `stagehand_model`: Model for stagehand agent provider

### Changed
- **Improved Settings Management**: Separated model configurations for different SDKs and agent providers
  - Each SDK and agent provider now has its own independent model setting
  - Settings menu updated with clearer options for each component
- **Better Configuration Isolation**: OpenCode model settings no longer interfere with Claude SDK settings
- **Backward Compatibility**: Automatic migration of old config files to new structure

### Fixed
- Fixed issue where OpenCode model settings were being overridden by Claude SDK model settings
- Fixed model configuration conflicts between different SDKs and agent providers
```

5. Click "Publish release"

### 4. Build and Publish to PyPI

```bash
# Make sure you're in the project root
cd /Users/kalilbouzigues/Projects/browgents/reverse-api

# Clean previous builds
rm -rf dist/ build/ *.egg-info

# Build the package
uv build

# Verify the build
ls -lh dist/

# Upload to PyPI (requires PyPI credentials)
# Option 1: Using twine (recommended)
pip install twine
twine upload dist/*

# Option 2: Using uv
uv publish

# You'll be prompted for PyPI credentials
# Username: __token__
# Password: your-pypi-api-token
```

### 5. Verify Release

After publishing:

1. **PyPI**: Check https://pypi.org/project/reverse-api-engineer/
2. **GitHub**: Check https://github.com/kalil0321/reverse-api-engineer/releases
3. **Test installation**:
   ```bash
   pip install --upgrade reverse-api-engineer
   reverse-api-engineer --version  # Should show 0.2.1
   ```

## 📝 Notes

- Make sure you have PyPI API token ready (create at https://pypi.org/manage/account/token/)
- The tag `v0.2.1` will be created locally and needs to be pushed
- This release adds Stagehand support and improves settings management with separate model configurations

## 🔍 Key Changes in v0.2.1

### Settings Structure

The configuration file (`~/.reverse-api/config.json`) now has this structure:

```json
{
  "claude_code_model": "claude-sonnet-4-5",
  "opencode_provider": "anthropic",
  "opencode_model": "claude-sonnet-4-5",
  "sdk": "claude",
  "agent_provider": "browser-use",
  "browser_use_model": "bu-llm",
  "stagehand_model": "openai/computer-use-preview-2025-03-11",
  "output_dir": null
}
```

### Migration

Old config files are automatically migrated:
- `model` → `claude_code_model`
- `agent_model` → `browser_use_model` or `stagehand_model` (based on `agent_provider`)
