# Contributing 

Thank you for your interest in contributing! This document provides guidelines and instructions for contributing.

## Development Setup

1. **Fork and clone the repository**
   ```bash
   git clone https://github.com/kalil0321/reverse-api-engineer.git
   cd reverse-api-engineer
   ```

2. **Install dependencies**
   ```bash
   uv sync
   playwright install chromium
   ```

3. **Run locally**
   ```bash
   uv run reverse-api-engineer
   ```

## Code Style

- Follow PEP 8 guidelines
- Use type hints where applicable
- Add docstrings to functions and classes

## Pull Request Process

1. Create a feature branch from `main`
2. Make your changes
3. Test your changes locally
4. Submit a pull request with a clear description

## Reporting Issues

- Use the GitHub issue tracker
- Include steps to reproduce
- Provide system information (OS, Python version)
- Include error messages and logs

## Questions?

Feel free to open an issue for any questions or suggestions!
