# BLAS最適化版スパースRK4・行列計算 デバッグ修正履歴

## 概要

BLAS最適化版のスパース行列計算・RK4実装において、セグメンテーション違反や計算結果の不一致が発生した際のデバッグ・修正の経緯をまとめます。

---

## 1. 問題発生

- BLAS最適化版（`rk4_sparse_blas_optimized`）のPythonバインディング経由でセグメンテーション違反が発生。
- 標準版（Eigen演算）は正常動作。
- スパース行列-ベクトル積のテストは成功するが、BLAS最適化版RK4のみでsegfault。

---

## 2. 初期デバッグ・切り分け

- Python→C++バインディングで渡す配列（psi0, data, indices, indptr）の型・C順性を明示的に`np.ascontiguousarray`で保証。
- C++側の受け取りも`Eigen::Ref<const Eigen::VectorXcd>&`等で厳密化。
- それでもBLAS最適化版のみsegfaultが継続。

---

## 3. CSRデータの受け渡し・境界チェック

- Python側でCSRデータ（data, indices, indptr）を明示的にC順・型指定で作成し直し。
- C++側で受け取ったデータの内容・長さをデバッグ出力で確認。
- CSR配列の長さ不足や型不一致を修正。
- 依然としてsegfaultが継続。

---

## 4. BLAS最適化版の実装切り分け

- `rk4_sparse_blas_optimized`関数内でCSRデータ取得部分をコメントアウトし、Eigen標準演算に一時的に切り替え→segfault消失。
- 問題はBLAS最適化版のCSRデータアクセス・行列更新・メモリ割り当て部分に限定。

---

## 5. スパース行列-ベクトル積の単体テスト

- PythonバインディングにBLASスパース行列-ベクトル積専用のテスト関数（`test_blas_sparse_multiply`）を追加。
- 小さな3x3行列でscipyの期待値と比較。
- C++側の計算過程・データを詳細にデバッグ出力。
- Python→C++のCSRデータ受け渡しが正しくなったことを確認。
- しかし計算結果が一致しない。

---

## 6. 虚数単位の掛け算の符号ミス

- C++側でスパース行列-ベクトル積後に掛ける虚数単位の符号が逆（`y *= std::complex<double>(0, 1)` vs `y *= std::complex<double>(0, -1)`）。
- 正しい物理式（dψ/dt = -i Hψ）に合わせて`-i`を掛けるよう修正。
- 期待値側も`expected = -1j * H0.dot(psi0)`と修正。
- テストが正常にパスすることを確認。

---

## 7. RK4本体への反映

- BLAS最適化版のRK4本体でも同様に虚数単位の掛け算・CSRデータ受け渡し・境界チェックを徹底。
- Pythonバインディング・テストスクリプトも同様に修正。

---

## 8. 参考にしたドキュメント

- [セグメンテーション違反のデバッグ手順](./segmentation_fault_debugging.md)
- [性能回帰問題の分析と解決](./performance_regression_analysis.md)

---

## まとめ・教訓

- Python→C++バインディングでの配列受け渡しは型・C順・長さを厳密に。
- CSR配列の境界チェック・長さ検証を徹底。
- BLAS関数の使用時は連続メモリ・stride・型変換に注意。
- 物理式に合わせた虚数単位の符号に注意。
- 小さなテストケースで逐次的に切り分け・検証することが有効。 