# robotcode-language-server

[![PyPI - Version](https://img.shields.io/pypi/v/robotcode-language-server.svg)](https://pypi.org/project/robotcode-language-server)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/robotcode-language-server.svg)](https://pypi.org/project/robotcode-language-server)
[![License](https://img.shields.io/github/license/robotcodedev/robotcode?style=flat&logo=apache)](https://github.com/robotcodedev/robotcode/blob/master/LICENSE.txt)

-----

## Introduction

Language Server Protocol (LSP) implementation for [RobotCode](https://robotcode.io), enabling enhanced IDE features such as code completion, linting, and navigation.

This package is part of the [RobotCode](https://robotcode.io) project. The complete source code is available at [github.com/robotcodedev/robotcode](https://github.com/robotcodedev/robotcode).

## Features

- Code completion for Robot Framework keywords
- Real-time linting and error checking
- Support for multi-workspace environments
- Integration with various IDEs through LSP

## Installation

```console
pip install robotcode-language-server
```

## Documentation

For comprehensive documentation, please visit [robotcode.io](https://robotcode.io).

## Security

For security concerns, please refer to our [Security Policy](https://github.com/robotcodedev/robotcode/security/policy).

## License

`robotcode-language-server` is distributed under the terms of the [Apache-2.0](https://spdx.org/licenses/Apache-2.0.html) license.

## Support

- 📖 [Documentation](https://robotcode.io)
- 💬 [Discussions](https://github.com/robotcodedev/robotcode/discussions)
- 🐛 [Issues](https://github.com/robotcodedev/robotcode/issues)
