# This file was auto-generated by ZETUP
#
# Zimmermann's Extensible Tools for Unified Project setups
#
# https://github.com/zimmermanncode/zetup


from __future__ import absolute_import

import sys
import os
from collections import OrderedDict

from zetup.version import Version
from zetup.dist import Distribution
from zetup.requires import Requirements
from zetup.extras import Extras
from zetup.package import Packages, Package
from zetup.notebook import Notebook



zfg = sys.modules[__name__]

NAME = 'robotframework-tools'

PACKAGES = Packages([

Package('robottools',
  sources=[
    '__init__.py',
    'conftest.py'
    ],
  subpackages=[
    
Package('robottools.libdoc',
  sources=[
    '__init__.py',
    'html.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library',
  sources=[
    '__init__.py',
    'base.py'
    ],
  subpackages=[
    
Package('robottools.library.context',
  sources=[
    '__init__.py',
    'method.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.inspector',
  sources=[
    '__init__.py',
    'arguments.py',
    'conftest.py',
    'keyword.py',
    'multi.py',
    'test_inspector.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.keywords',
  sources=[
    '__init__.py',
    'deco.py',
    'errors.py',
    'utils.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.session',
  sources=[
    '__init__.py',
    'meta.py',
    'metaoptions.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )
,
    
Package('robottools.remote',
  sources=[
    '__init__.py',
    'keywords.py',
    'library.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.testrobot',
  sources=[
    '__init__.py',
    'conftest.py',
    'context.py',
    'handler.py',
    'highlighting.py',
    'keyword.py',
    'library.py',
    'output.py',
    'result.py',
    'test_robot.py',
    'variables.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.utils',
  sources=[
    '__init__.py',
    'normbool.py',
    'normdict.py',
    'normstr.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )
,
  
Package('robotshell',
  sources=[
    '__init__.py',
    'base.py',
    'extension.py',
    'library.py',
    'result.py',
    'shell.py'
    ],
  subpackages=[
    
Package('robotshell.magic',
  sources=[
    '__init__.py',
    'base.py',
    'keyword.py',
    'robot.py',
    'variable.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )

  ], root=os.path.dirname(os.path.dirname(os.path.realpath(__file__))))

DESCRIPTION = 'Python Tools for Robot Framework and Test Libraries.'

URL = 'http://github.com/zimmermanncode/robotframework-tools'

TITLE = 'robotframework-tools'

SETUP_HOOKS = []

EXTRAS = Extras([
('remote', Requirements("""
robotremoteserver >= 1.0.1

""")),
('robotshell', Requirements("""
ipython >= 6.0 #import IPython

"""))
], zfg=zfg)

TEST_COMMANDS = ['py.test -v test']

CLASSIFIERS = ['Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'License :: OSI Approved :: GNU General Public License (GPL)', 'Operating System :: OS Independent', 'Topic :: Software Development', 'Topic :: Utilities', 'Programming Language :: Python', 'Programming Language :: Python :: 2.7', 'Programming Language :: Python :: 3.3', 'Programming Language :: Python :: 3.4', 'Programming Language :: Python :: 3.5', 'Programming Language :: Python :: 3.6']

SETUP_REQUIRES = None

DISTRIBUTION = Distribution(zfg)

SCRIPTS = None

REQUIRES = Requirements("""
zetup >= 0.2.34
six >= 1.10
path.py >= 10.3 #import path
moretools >= 0.1.8
modeled >= 0.1.8

""", zfg=zfg)

NO_MAKE = ['tox.ini']

SETUP_KEYWORDS = None

LICENSE = 'GPLv3'

KEYWORDS = ['robottools', 'robot', 'framework', 'robotframework', 'tools', 'test', 'automation', 'testautomation', 'acceptance', 'atdd', 'testlibrary', 'testcase', 'keyword', 'pybot', 'testrobot', 'remoterobot', 'remote', 'server', 'robotremoteserver', 'robotshell', 'ipython', 'jupyter', 'notebook', 'python3']

VERSION = Version('0.1rc4.dev3')

PYTHON = ['2.7', '3.3', '3.4', '3.5', '3.6']

FORCE_MAKE = True

KEEP_MADE = ['setup.py', 'tox.ini']

AUTHOR = 'Stefan Zimmermann'

EMAIL = 'zimmermann.code@gmail.com'

MODULES = ['ToolsLibrary']

in_repo = True