/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl.pool;

import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCCommonDataSource;
import com.datapps.linkoopdb.jdbc.impl.JDBCConnection;
import com.datapps.linkoopdb.jdbc.impl.JDBCDriver;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import com.datapps.linkoopdb.jdbc.impl.pool.JDBCXAConnection;
import com.datapps.linkoopdb.jdbc.impl.pool.JDBCXAResource;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;

public class JDBCXADataSource
extends JDBCCommonDataSource
implements XADataSource,
Serializable,
Referenceable,
CommonDataSource {
    private HashMap resources = new HashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    @Override
    public XAConnection getXAConnection() throws SQLException {
        JDBCConnection connection = (JDBCConnection)JDBCDriver.getConnection(this.url, this.connectionProps);
        JDBCXAConnection xaConnection = new JDBCXAConnection(this, connection);
        return xaConnection;
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (user == null || password == null) {
            throw JDBCUtil.nullArgument();
        }
        if (user.equals(this.user) && password.equals(this.password)) {
            return this.getXAConnection();
        }
        throw JDBCUtil.sqlException(Error.error(4000));
    }

    @Override
    public Reference getReference() throws NamingException {
        String cname = "com.datapps.linkoopdb.jdbc.jdbc.JDBCDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), cname, null);
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return ref;
    }

    public void addResource(Xid xid, JDBCXAResource xaResource) {
        this.lock.writeLock().lock();
        try {
            this.resources.put(xid, xaResource);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public JDBCXAResource removeResource(Xid xid) {
        this.lock.writeLock().lock();
        try {
            JDBCXAResource jDBCXAResource = (JDBCXAResource)this.resources.remove(xid);
            return jDBCXAResource;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Xid[] getPreparedXids() {
        this.lock.writeLock().lock();
        try {
            Iterator it = this.resources.keySet().iterator();
            HashSet<Xid> preparedSet = new HashSet<Xid>();
            while (it.hasNext()) {
                Xid curXid = (Xid)it.next();
                if (((JDBCXAResource)this.resources.get((Object)curXid)).state != JDBCXAResource.XA_STATE_PREPARED) continue;
                preparedSet.add(curXid);
            }
            Xid[] array = new Xid[preparedSet.size()];
            preparedSet.toArray(array);
            Xid[] xidArray = array;
            return xidArray;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    JDBCXAResource getResource(Xid xid) {
        this.lock.readLock().lock();
        try {
            JDBCXAResource jDBCXAResource = (JDBCXAResource)this.resources.get(xid);
            return jDBCXAResource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

