/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CertificateDetails;
import com.microsoft.sqlserver.jdbc.KeyStoreProviderCommon;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SQLServerColumnEncryptionJavaKeyStoreProvider
extends SQLServerColumnEncryptionKeyStoreProvider {
    String name = "MSSQL_JAVA_KEYSTORE";
    String keyStorePath = null;
    char[] keyStorePwd = null;
    private static final Logger javaKeyStoreLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionJavaKeyStoreProvider");

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SQLServerColumnEncryptionJavaKeyStoreProvider(String string, char[] cArray) throws SQLServerException {
        javaKeyStoreLogger.entering(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), "SQLServerColumnEncryptionJavaKeyStoreProvider");
        if (null == string || 0 == string.length()) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidConnectionSetting"));
            Object[] objectArray = new Object[]{"keyStoreLocation", string};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        this.keyStorePath = string;
        if (javaKeyStoreLogger.isLoggable(Level.FINE)) {
            javaKeyStoreLogger.fine("Path of key store provider is set.");
        }
        if (null == cArray) {
            cArray = "".toCharArray();
        }
        this.keyStorePwd = new char[cArray.length];
        System.arraycopy(cArray, 0, this.keyStorePwd, 0, cArray.length);
        if (javaKeyStoreLogger.isLoggable(Level.FINE)) {
            javaKeyStoreLogger.fine("Password for key store provider is set.");
        }
        javaKeyStoreLogger.exiting(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), "SQLServerColumnEncryptionJavaKeyStoreProvider");
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String string, String string2, byte[] byArray) throws SQLServerException {
        javaKeyStoreLogger.entering(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), "decryptColumnEncryptionKey", "Decrypting Column Encryption Key.");
        KeyStoreProviderCommon.validateNonEmptyMasterKeyPath(string);
        CertificateDetails certificateDetails = this.getCertificateDetails(string);
        byte[] byArray2 = KeyStoreProviderCommon.decryptColumnEncryptionKey(string, string2, byArray, certificateDetails);
        javaKeyStoreLogger.exiting(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), "decryptColumnEncryptionKey", "Finished decrypting Column Encryption Key.");
        return byArray2;
    }

    private CertificateDetails getCertificateDetails(String string) throws SQLServerException {
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        CertificateDetails certificateDetails = null;
        try {
            if (null == string || 0 == string.length()) {
                throw new SQLServerException(null, SQLServerException.getErrString("R_InvalidMasterKeyDetails"), null, 0, false);
            }
            try {
                keyStore = KeyStore.getInstance("JKS");
                fileInputStream = new FileInputStream(this.keyStorePath);
                keyStore.load(fileInputStream, this.keyStorePwd);
            }
            catch (IOException iOException) {
                if (null != fileInputStream) {
                    fileInputStream.close();
                }
                keyStore = KeyStore.getInstance("PKCS12");
                fileInputStream = new FileInputStream(this.keyStorePath);
                keyStore.load(fileInputStream, this.keyStorePwd);
            }
            certificateDetails = this.getCertificateDetailsByAlias(keyStore, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SQLServerException((Object)this, SQLServerException.getErrString("R_KeyStoreNotFound"), null, 0, false);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidKeyStoreFile"));
            Object[] objectArray = new Object[]{this.keyStorePath};
            throw new SQLServerException(messageFormat.format(objectArray), exception);
        }
        finally {
            try {
                if (null != fileInputStream) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return certificateDetails;
    }

    private CertificateDetails getCertificateDetailsByAlias(KeyStore keyStore, String string) throws SQLServerException {
        try {
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            Key key = keyStore.getKey(string, this.keyStorePwd);
            if (null == x509Certificate) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CertificateNotFoundForAlias"));
                Object[] objectArray = new Object[]{string, "MSSQL_JAVA_KEYSTORE"};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
            if (null == key) {
                throw new UnrecoverableKeyException();
            }
            return new CertificateDetails(x509Certificate, key);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnrecoverableKeyAE"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CertificateError"));
            Object[] objectArray = new Object[]{string, this.name};
            throw new SQLServerException(messageFormat.format(objectArray), generalSecurityException);
        }
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String string, String string2, byte[] byArray) throws SQLServerException {
        byte[] byArray2;
        javaKeyStoreLogger.entering(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), Thread.currentThread().getStackTrace()[1].getMethodName(), "Encrypting Column Encryption Key.");
        byte[] byArray3 = KeyStoreProviderCommon.version;
        KeyStoreProviderCommon.validateNonEmptyMasterKeyPath(string);
        if (null == byArray) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullColumnEncryptionKey"), null, 0, false);
        }
        if (0 == byArray.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_EmptyColumnEncryptionKey"), null, 0, false);
        }
        KeyStoreProviderCommon.validateEncryptionAlgorithm(string2, true);
        CertificateDetails certificateDetails = this.getCertificateDetails(string);
        byte[] byArray4 = this.encryptRSAOAEP(byArray, certificateDetails);
        byte[] byArray5 = this.getLittleEndianBytesFromShort((short)byArray4.length);
        try {
            byArray2 = string.toLowerCase().getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
            throw new SQLServerException(messageFormat.format(new Object[]{"UTF-16LE"}), null, 0, null);
        }
        byte[] byArray6 = this.getLittleEndianBytesFromShort((short)byArray2.length);
        byte[] byArray7 = new byte[byArray3.length + byArray6.length + byArray5.length + byArray2.length + byArray4.length];
        int n = byArray3.length;
        System.arraycopy(byArray3, 0, byArray7, 0, byArray3.length);
        System.arraycopy(byArray6, 0, byArray7, n, byArray6.length);
        System.arraycopy(byArray5, 0, byArray7, n += byArray6.length, byArray5.length);
        System.arraycopy(byArray2, 0, byArray7, n += byArray5.length, byArray2.length);
        System.arraycopy(byArray4, 0, byArray7, n += byArray2.length, byArray4.length);
        byte[] byArray8 = this.rsaSignHashedData(byArray7, certificateDetails);
        int n2 = byArray3.length + byArray5.length + byArray6.length + byArray4.length + byArray2.length + byArray8.length;
        byte[] byArray9 = new byte[n2];
        int n3 = 0;
        System.arraycopy(byArray3, 0, byArray9, n3, byArray3.length);
        System.arraycopy(byArray6, 0, byArray9, n3 += byArray3.length, byArray6.length);
        System.arraycopy(byArray5, 0, byArray9, n3 += byArray6.length, byArray5.length);
        System.arraycopy(byArray2, 0, byArray9, n3 += byArray5.length, byArray2.length);
        System.arraycopy(byArray4, 0, byArray9, n3 += byArray2.length, byArray4.length);
        System.arraycopy(byArray8, 0, byArray9, n3 += byArray4.length, byArray8.length);
        javaKeyStoreLogger.exiting(SQLServerColumnEncryptionJavaKeyStoreProvider.class.getName(), Thread.currentThread().getStackTrace()[1].getMethodName(), "Finished encrypting Column Encryption Key.");
        return byArray9;
    }

    private byte[] encryptRSAOAEP(byte[] byArray, CertificateDetails certificateDetails) throws SQLServerException {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, certificateDetails.certificate.getPublicKey());
            cipher.update(byArray);
            byArray2 = cipher.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_EncryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return byArray2;
    }

    private byte[] rsaSignHashedData(byte[] byArray, CertificateDetails certificateDetails) throws SQLServerException {
        byte[] byArray2 = null;
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign((PrivateKey)certificateDetails.privateKey);
            signature.update(byArray);
            byArray2 = signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_EncryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return byArray2;
    }

    private byte[] getLittleEndianBytesFromShort(short s) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = byteBuffer.putShort(s).array();
        return byArray;
    }
}

