/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.GeneratedKeysRequest;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ContinueContextParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.CreateProcedureStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementAbortState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementCancelState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public abstract class TDStatement
implements Mutex.AcquireCallback {
    protected TDSession m_session;
    private Vector m_vNonPrepBatch = new Vector();
    private Results results;
    protected TDResultSet m_rsOutParams;
    private SQLWarning warning;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int m_nResultSetType;
    private int m_nResultSetConcurrency;
    private int fetchSize = 0;
    private int fetchDirection = 1000;
    private StatementState statementState;
    private long statementStartTime;
    private Thread executingThread;
    private int currentRequestNumber = 0;
    private boolean abortLobTransfer = false;
    protected boolean escapeProcessing = true;
    private boolean m_bRequestClosed = false;
    private boolean useKeepResponse;
    protected Log log;
    private boolean m_isFinalized = false;
    protected GeneratedKeysRequest m_generatedKeys;
    private MetaDataList metaDataList = new MetaDataList();
    protected int m_nMetadataStatementNumber = 1;
    private byte m_nRequestMode = (byte)73;
    protected Map m_mapSQLRequestEscapeFunctions = new LinkedHashMap();
    private int m_nResultSetHoldability;
    private ContinueContextParcel m_continueContext = null;

    public TDStatement(TDSession tDSession, int n, int n2, int n3) throws SQLException {
        this.m_session = tDSession;
        this.log = this.m_session.getLog();
        this.m_nResultSetType = n;
        this.m_nResultSetConcurrency = n2;
        this.m_nResultSetHoldability = TDSession.validateHoldability(n3);
        if (this.m_nResultSetConcurrency == 1008 && !this.m_session.isStatementInfoSupported()) {
            this.m_nResultSetConcurrency = 1007;
            this.m_session.addWarning(ErrorFactory.makeSQLWarning("TJ367"));
        }
        if (this.m_nResultSetType == 1004) {
            if (!this.m_session.isPositioningSupported()) {
                this.m_nResultSetType = 1003;
                this.m_session.addWarning(ErrorFactory.makeSQLWarning("TJ368"));
            } else if (!this.m_session.isLobSupported()) {
                this.m_nResultSetType = 1003;
                this.m_session.addWarning(ErrorFactory.makeSQLWarning("TJ554"));
            }
        } else if (this.m_nResultSetType == 1005) {
            if (this.m_session.isPositioningSupported() && this.m_session.isLobSupported()) {
                this.m_nResultSetType = 1004;
                this.m_session.addWarning(ErrorFactory.makeSQLWarning("TJ369"));
            } else if (!this.m_session.isPositioningSupported()) {
                this.m_nResultSetType = 1003;
                this.m_session.addWarning(ErrorFactory.makeSQLWarning("TJ370"));
            } else if (!this.m_session.isLobSupported()) {
                this.m_nResultSetType = 1003;
                this.m_session.addWarning(ErrorFactory.makeSQLWarning("TJ555"));
            }
        }
        if (this.m_nResultSetType == 1003 && this.m_nResultSetConcurrency == 1008 && this.m_session.isPositioningSupported()) {
            this.m_nResultSetType = 1004;
            this.m_session.addWarning(ErrorFactory.makeSQLWarning("TJ502"));
        }
        if (this.m_session.isLobSupported()) {
            this.m_nRequestMode = (byte)77;
        }
        this.results = new Results(this.log);
        this.statementState = new StatementState();
        this.m_session.addToCloseCursorsAtCommitStatements(this);
    }

    public TDResultSet conditionalGetResultSet() throws SQLException {
        if (this.results.getResultType() == 2 || this.results.getResultType() == 3) {
            return this.results.getResult().getResultSet();
        }
        return null;
    }

    public LocalEscapeFunctions getLocalEscapeFunctions() {
        return this.m_session;
    }

    public byte getRequestMode() {
        return this.m_nRequestMode;
    }

    public void setRequestMode(byte by) {
        this.m_nRequestMode = by;
    }

    public String getSQLRequestEscapeFunction(String string) {
        return (String)this.m_mapSQLRequestEscapeFunctions.get(string);
    }

    public GeneratedKeysRequest getGeneratedKeysRequest() {
        return this.m_generatedKeys;
    }

    public boolean hasGeneratedKeysRequest() {
        return this.m_generatedKeys != null;
    }

    protected boolean isGeneratedKeysRsAvailable() {
        return this.m_generatedKeys != null && this.results != null && this.results.getResultType() == 3;
    }

    public MetaDataList getMetaDataList() {
        return this.metaDataList;
    }

    public void setOutParamResultSet(TDResultSet tDResultSet) {
        this.m_rsOutParams = tDResultSet;
    }

    private synchronized boolean doNonPrepExecute(String string, GeneratedKeysRequest generatedKeysRequest) throws SQLException {
        this.m_generatedKeys = generatedKeysRequest;
        this.clearWarnings();
        string = EscapeUtil.nativeSQL(string, this.escapeProcessing, this.getLocalEscapeFunctions(), this.m_mapSQLRequestEscapeFunctions);
        if (TDStatement.parseCreateProcedure(string)) {
            this.executeStatement(new CreateProcedureStatementController(this, this.m_session, string), 3, (byte)69, false);
            return this.results.getResult(0).getType() == 2;
        }
        byte by = 66;
        if (this.m_generatedKeys != null && this.m_generatedKeys.returnGeneratedKeys()) {
            this.prepareRequest(string, 3, (byte)80);
            by = 69;
        }
        this.executeStatement(new StatementController(this, this.m_session, string), 3, by);
        return this.results.moreResults() && this.results.getResult(0).getType() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doNonPrepExecuteQuery(String string) throws SQLException {
        this.m_generatedKeys = null;
        this.clearWarnings();
        string = EscapeUtil.nativeSQL(string, this.escapeProcessing, this.getLocalEscapeFunctions(), this.m_mapSQLRequestEscapeFunctions);
        if (TDStatement.parseCreateProcedure(string)) {
            this.executeStatement(new CreateProcedureStatementController(this, this.m_session, string), 3, (byte)69, false);
        }
        try {
            this.m_session.registerStatement(this);
            this.executeStatement(new StatementController(this, this.m_session, string), 2, (byte)66);
        }
        finally {
            this.m_session.unregisterStatement(this);
        }
    }

    protected void executeStatement(StatementController statementController, int n, byte by) throws SQLException {
        this.executeStatement(statementController, n, by, this.m_session.isLobSupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeStatement(StatementController statementController, int n, byte by, boolean bl) throws SQLException {
        if (this.log.canLog(1)) {
            this.log.info("executeStatement queryTimeout=" + this.queryTimeout);
        }
        this.initStatement(bl);
        this.m_session.acquireSessionLock(this);
        try {
            boolean bl2;
            statementController.setResultTypeExpected(n);
            statementController.setMode(by);
            boolean bl3 = bl2 = by == 83 || by == 80;
            if (!bl2) {
                this.m_session.beforeExecuteStatement();
            }
            this.checkAborted("prior to executing the statement request");
            try {
                this.changeStatementState(3);
                statementController.run();
            }
            catch (SQLException sQLException) {
                this.log.info("Exception caught from request execution", sQLException);
                try {
                    if (!bl2) {
                        this.m_session.afterExecuteStatement(this);
                    }
                }
                catch (SQLException sQLException2) {
                    this.log.info("Exception caught from afterExecuteStatement", sQLException2);
                    sQLException.setNextException(sQLException2);
                }
                this.changeStatementState(1);
                throw ErrorAnalyzer.analyzeError(sQLException);
            }
            try {
                if (!bl2) {
                    this.m_session.afterExecuteStatement(this);
                }
            }
            finally {
                this.changeStatementState(1);
            }
        }
        finally {
            this.m_session.releaseSessionLock();
            this.log.debug("executeStatement() exit");
        }
    }

    private void checkAborted(String string) throws SQLException {
        SQLException sQLException = null;
        this.statementState.acquireStatementStateLock();
        if (!this.statementState.isState(2)) {
            if (this.statementState.isState(11)) {
                sQLException = ErrorFactory.makeDriverJDBCException("TJ057");
            } else if (this.statementState.isState(8)) {
                sQLException = ErrorFactory.makeDriverJDBCException("TJ159", "StatementState.TIMEOUT " + string);
            }
        }
        this.statementState.releaseStatementStateLock();
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public void changeStatementState(int n) throws SQLException {
        this.statementState.acquireStatementStateLock();
        this.statementState.setState(n);
        this.statementState.releaseStatementStateLock();
    }

    public synchronized void close() throws SQLException {
        this.internalClose(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            try {
                if (this.m_session.getURLParameters().getFinalizeAutoClose()) {
                    this.internalClose(true, true);
                }
            }
            finally {
                super.finalize();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void internalClose(boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            this.m_isFinalized = true;
        }
        if (this.getState() == 0) {
            this.changeStatementState(7);
        }
        if (this.getState() == 7) {
            return;
        }
        if (this.m_rsOutParams != null) {
            this.m_rsOutParams.close();
        }
        for (int i = 0; i < this.results.getResultsSize(); ++i) {
            if (this.results.getResultType(i) != 2) continue;
            this.results.getResult(i).getResultSet().internalClose(bl, bl2);
        }
        if (this.m_session.isLobSupported() || !this.results.requestComplete()) {
            this.closeRequest(bl, bl2);
        }
        this.executingThread = null;
        this.warning = null;
        this.results.reinit();
        this.m_rsOutParams = null;
        this.changeStatementState(7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeRequest(boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            this.m_isFinalized = true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statement.closeRequest: upon entry m_bRequestClosed=" + this.m_bRequestClosed + ", this=" + this);
        }
        if (this.m_bRequestClosed) {
            return;
        }
        this.m_bRequestClosed = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statement.closeRequest: now m_bRequestClosed=" + this.m_bRequestClosed + ", this=" + this);
        }
        if (!this.useKeepResponse && this.results.requestComplete()) {
            return;
        }
        if (this.m_session.isClosed()) {
            return;
        }
        StatementController statementController = new StatementController(this, this.m_session);
        if (bl2) {
            this.log.debug("closeRequest() enter - requesting session lock");
            this.m_session.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        }
        try {
            statementController.setHistoricalState(new StatementCancelState(statementController));
            statementController.setCurrentRequestNumber(this.currentRequestNumber);
            this.log.debug("closeRequest() preparing to send cancel to the server");
            statementController.run();
            Object var5_4 = null;
            if (bl2) {
                this.log.debug("closeRequest() exit - releasing the session lock");
                this.m_session.releaseSessionLock();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bl2) {
                this.log.debug("closeRequest() exit - releasing the session lock");
                this.m_session.releaseSessionLock();
            }
            throw throwable;
        }
    }

    public void suppressResponseCancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("TDStatement.suppressResponseCancel this=" + this);
        }
        this.m_bRequestClosed = true;
    }

    public synchronized void prepareRequest(String string, int n, byte by) throws SQLException {
        StatementController statementController = new StatementController(this, this.m_session, string);
        this.executeStatement(statementController, n, by, false);
    }

    private synchronized int doNonPrepExecuteUpdate(String string, GeneratedKeysRequest generatedKeysRequest) throws SQLException {
        this.m_generatedKeys = generatedKeysRequest;
        this.clearWarnings();
        string = EscapeUtil.nativeSQL(string, this.escapeProcessing, this.getLocalEscapeFunctions(), this.m_mapSQLRequestEscapeFunctions);
        if (TDStatement.parseCreateProcedure(string)) {
            this.executeStatement(new CreateProcedureStatementController(this, this.m_session, string), 1, (byte)69, false);
            return this.getUpdateCount();
        }
        boolean bl = false;
        if (this.m_generatedKeys != null && this.m_generatedKeys.returnGeneratedKeys()) {
            this.prepareRequest(string, 3, (byte)80);
            if (!ActivityAnalyzer.update(this.getMetaDataList().getFirstMetaData().getActivityType())) {
                throw ErrorFactory.makeDriverJDBCException("TJ389");
            }
            bl = this.m_session.isLobSupported();
        }
        StatementController statementController = new StatementController(this, this.m_session, string);
        this.executeStatement(statementController, 1, (byte)69, bl);
        return this.results.getResult().getSmallUpdateCount();
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warning == null) {
            this.warning = sQLWarning;
        } else {
            this.warning.setNextWarning(sQLWarning);
        }
    }

    public SQLWarning getWarnings() {
        return this.warning;
    }

    public void clearWarnings() {
        this.warning = null;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) {
        this.maxFieldSize = n <= 0 ? 0 : n;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int n) {
        this.maxRows = n <= 0 ? 0 : n;
    }

    public void setEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean isFinalized() {
        return this.m_isFinalized;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public int[] executeBatchMSR(String string, int n) throws SQLException {
        this.m_generatedKeys = null;
        this.clearWarnings();
        string = EscapeUtil.nativeSQL(string, this.escapeProcessing, this.getLocalEscapeFunctions(), this.m_mapSQLRequestEscapeFunctions);
        try {
            StatementController statementController = new StatementController(this, this.m_session, string);
            this.executeStatement(statementController, 5, (byte)69, false);
        }
        catch (SQLException sQLException) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = -3;
            }
            throw ErrorFactory.convertToBatchUpdateException(sQLException, nArray);
        }
        this.checkResults();
        return this.results.getSmallUpdateCountArray();
    }

    public void setUseKeepResponse(boolean bl) {
        this.useKeepResponse = bl;
    }

    public boolean useKeepResponse() {
        return this.useKeepResponse;
    }

    public int getResultSetConcurrency() {
        return this.m_nResultSetConcurrency;
    }

    public int getResultSetType() {
        return this.m_nResultSetType;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = n;
                return;
            }
        }
        throw ErrorFactory.makeDriverJDBCException("TJ322");
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0 || this.maxRows > 0 && n > this.maxRows) {
            throw ErrorFactory.makeDriverJDBCException("TJ321", n);
        }
        this.fetchSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        if (this.executingThread != null) {
            this.log.debug("cancel() entered: executing thread is: " + this.executingThread.getName());
        } else {
            this.log.debug("cancel() entered but no active thread");
        }
        this.log.debug("cancel() current statementState is: " + this.statementState.getState());
        this.log.debug("cancel() Thread cancelling the Statement: " + Thread.currentThread().getName());
        this.log.debug("cancel() trying to get statementStateLock");
        this.statementState.acquireStatementStateLock();
        this.log.debug("cancel() have statementStateLock");
        try {
            int n = this.statementState.getState();
            if (n == 12) {
                this.setAbortLobTransfer(true);
                this.log.debug("cancel() setting flag to abort deferred LOB transfer");
            } else if (n == 3) {
                try {
                    this.log.debug("cancel() StatementState is REQUEST_SENT, preparing to send ABORT request to server");
                    StatementController statementController = new StatementController(this, this.m_session);
                    statementController.setResultTypeExpected(4);
                    statementController.setHistoricalState(new StatementAbortState(statementController));
                    statementController.setCurrentRequestNumber(this.currentRequestNumber);
                    statementController.run();
                }
                catch (SQLException sQLException) {
                    this.log.error("Exception while attempting to cancel statement", sQLException);
                }
            } else if (n == 2) {
                this.log.debug("cancel() StatementState is ACTIVE - changing state to ABORTED");
                this.statementState.setState(11);
                if (this.executingThread != null) {
                    this.log.debug("cancel() Interrupting executingThread: " + this.executingThread.getName());
                    this.executingThread.interrupt();
                }
            } else {
                this.log.debug("cancel() no request to cancel: StatementState is: " + this.statementState.getState());
            }
        }
        finally {
            this.log.debug("cancel() releasing the StatementState lock");
            this.statementState.releaseStatementStateLock();
        }
    }

    public void setCursorName(String string) {
    }

    public int getUpdateCount() throws SQLException {
        if (this.results.moreResults() && (this.results.getResultType() == 1 || this.results.getResultType() == 3)) {
            return this.results.getResult().getSmallUpdateCount();
        }
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int n) throws SQLException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.m_session.isStatementPositioningSupported()) {
                    throw ErrorFactory.makeDriverJDBCException("TJ549", "getMoreResults(KEEP_CURRENT_RESULT)");
                }
                if (this.getResultSetType() == 1004) break;
                throw ErrorFactory.makeDriverJDBCException("TJ551", "getMoreResults(KEEP_CURRENT_RESULT)");
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ634", n);
            }
        }
        if (this.noResultsAndHaveMetaDataFromPrepare()) {
            boolean bl;
            boolean bl2 = bl = this.m_nMetadataStatementNumber < this.metaDataList.size();
            if (bl) {
                ++this.m_nMetadataStatementNumber;
            }
            return bl;
        }
        if (n == 1 && this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    protected boolean noResultsAndHaveMetaDataFromPrepare() {
        return this.results.getResultsSize() == 0 && this.metaDataList.size() > 0;
    }

    public void initResults() {
        this.results.reinit();
    }

    public Results getResults() {
        return this.results;
    }

    private void initStatement(boolean bl) throws SQLException {
        if (this.m_session.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        this.log.debug("initStatement()");
        this.close();
        this.useKeepResponse = bl;
        this.statementStartTime = System.currentTimeMillis();
        this.changeStatementState(2);
        this.results.reinit();
        this.warning = null;
        this.m_rsOutParams = null;
        this.currentRequestNumber = 0;
        this.abortLobTransfer = false;
        this.m_bRequestClosed = false;
        this.m_continueContext = null;
    }

    public void acquireStatementStateLock() throws SQLException {
        this.statementState.acquireStatementStateLock();
    }

    public void releaseStatementStateLock() {
        this.statementState.releaseStatementStateLock();
    }

    public void setState(int n) {
        this.statementState.setState(n);
    }

    public int getState() {
        return this.statementState.getState();
    }

    public String toString() {
        return super.toString() + "(statecode=" + this.getState() + " sess=" + this.m_session + ")";
    }

    public int getRemainingTime() {
        long l = 0L;
        if (this.queryTimeout == 0) {
            return 0;
        }
        long l2 = this.statementStartTime + (long)(this.queryTimeout * 1000);
        long l3 = System.currentTimeMillis();
        if (l2 > l3) {
            l = l2 - l3;
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }
        return 1;
    }

    public void resetStatementStartTime() {
        this.statementStartTime = System.currentTimeMillis();
    }

    protected void checkResults() throws BatchUpdateException {
        int n = this.results.getResultsSize();
        for (int i = 0; i < n; ++i) {
            if (this.results.getResultType(i) != 2) continue;
            throw ErrorFactory.makeBatchUpdateException("TJ191", this.results.getSmallUpdateCountArray());
        }
    }

    public void setCurrentRequestNumber(int n) {
        this.currentRequestNumber = n;
    }

    public void setAbortLobTransfer(boolean bl) {
        this.abortLobTransfer = bl;
    }

    public boolean abortLobTransfer() {
        return this.abortLobTransfer;
    }

    private static boolean parseCreateProcedure(String string) {
        return (string.trim().regionMatches(true, 0, "CREATE", 0, "CREATE".length()) || string.trim().regionMatches(true, 0, "REPLACE", 0, "REPLACE".length())) && string.substring("REPLACE".length()).trim().regionMatches(true, 0, "PROCEDURE", 0, "PROCEDURE".length());
    }

    public static int endOfWordIndex(String string) {
        return ComUtil.indexOf(string, "(", 0);
    }

    public void addBatch(String string) throws SQLException {
        if (!(string = string.trim()).endsWith(";")) {
            string = string + ";";
        }
        this.m_vNonPrepBatch.addElement(string);
    }

    public void clearBatch() {
        this.m_vNonPrepBatch.removeAllElements();
    }

    public TDSession getTDSession() {
        return this.m_session;
    }

    public Connection getConnection() {
        return (Connection)((Object)this.m_session);
    }

    protected ResultSet internalGetResultSet(boolean bl, boolean bl2) throws SQLException {
        TDResultSet tDResultSet = this.conditionalGetResultSet();
        if (tDResultSet == null || bl2) {
            if (bl) {
                return null;
            }
            TeraResultSetMetaData teraResultSetMetaData = this.m_session.constructResultSetMetaData();
            tDResultSet = this.m_session.constructResultSet(teraResultSetMetaData, 1, (Statement)((Object)this), null, this.m_session.getLog());
        }
        return (ResultSet)((Object)tDResultSet);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (!this.m_session.generatedKeysSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ441");
        }
        if (this.isGeneratedKeysRsAvailable()) {
            return this.internalGetResultSet(false, false);
        }
        return this.internalGetResultSet(false, true);
    }

    public int getResultSetHoldability() {
        return this.m_nResultSetHoldability;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.doNonPrepExecuteQuery(string);
        return this.internalGetResultSet(false, false);
    }

    public int executeUpdate(String string) throws SQLException {
        return this.doNonPrepExecuteUpdate(string, null);
    }

    public boolean execute(String string) throws SQLException {
        return this.doNonPrepExecute(string, null);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.internalGetResultSet(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        if (this.m_vNonPrepBatch.size() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ689");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_vNonPrepBatch.size(); ++i) {
            stringBuffer.append((String)this.m_vNonPrepBatch.elementAt(i));
        }
        try {
            int[] nArray = this.executeBatchMSR(stringBuffer.toString(), this.m_vNonPrepBatch.size());
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (n == 2) {
            return this.executeUpdate(string);
        }
        return this.doNonPrepExecuteUpdate(string, new GeneratedKeysRequest(n, this.m_session.generatedKeysSupported()));
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.doNonPrepExecuteUpdate(string, new GeneratedKeysRequest(nArray, this.m_session.generatedKeysSupported()));
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.doNonPrepExecuteUpdate(string, new GeneratedKeysRequest(stringArray, this.m_session.generatedKeysSupported()));
    }

    public boolean execute(String string, int n) throws SQLException {
        if (n == 2) {
            return this.execute(string);
        }
        return this.doNonPrepExecute(string, new GeneratedKeysRequest(n, this.m_session.generatedKeysSupported()));
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.doNonPrepExecute(string, new GeneratedKeysRequest(nArray, this.m_session.generatedKeysSupported()));
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.doNonPrepExecute(string, new GeneratedKeysRequest(stringArray, this.m_session.generatedKeysSupported()));
    }

    public ContinueContextParcel getContinueContext() {
        return this.m_continueContext;
    }

    public void setContinueContext(ContinueContextParcel continueContextParcel) {
        this.m_continueContext = continueContextParcel;
    }

    public boolean isClosed() {
        return this.getState() == 7;
    }

    public void setPoolable(boolean bl) {
    }

    public boolean isPoolable() {
        return true;
    }

    public class StatementState {
        private int state = 0;
        private Mutex lock;
        public static final int CREATED = 0;
        public static final int INACTIVE = 1;
        public static final int ACTIVE = 2;
        public static final int REQUEST_SENT = 3;
        public static final int HAVE_RESULTS = 4;
        public static final int CANCEL_SENT = 5;
        public static final int CANCELLED = 6;
        public static final int CLOSED = 7;
        public static final int TIMEOUT = 8;
        public static final int ABORT_TIMEOUT_SENT = 9;
        public static final int ABORT_SENT = 10;
        public static final int ABORTED = 11;
        public static final int LOB_SENDING_DEFERRED = 12;

        StatementState() {
            this.lock = new Mutex("StatementStateLock", TDStatement.this.log);
        }

        synchronized void setState(int n) {
            this.state = n;
            TDStatement.this.executingThread = this.state == 2 ? Thread.currentThread() : null;
            if (TDStatement.this.log.isDebugEnabled()) {
                TDStatement.this.log.debug("StatementState.setState enclosing instance=" + TDStatement.this);
            }
        }

        synchronized int getState() {
            return this.state;
        }

        synchronized boolean isState(int n) {
            return this.state == n;
        }

        void acquireStatementStateLock() throws SQLException {
            this.lock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        }

        void releaseStatementStateLock() {
            this.lock.release();
        }
    }
}

