/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.encode;

import com.teradata.jdbc.encode.CharSetNames;
import com.teradata.jdbc.encode.ColumnDisplaySizes;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class ConnectionCharsetInfo {
    public static final String ASCII_CHARSET_NAME = "ASCII";
    public static final String UTF8_CHARSET_NAME = "UTF8";
    public static final byte[] REPLACE_WITH_QUESTION_MARK_ASCII = new byte[]{63};
    public static final byte[] REPLACE_WITH_QUESTION_MARK_UTF8 = new byte[]{63};
    public static final byte[] REPLACE_WITH_QUESTION_MARK_UTF16 = new byte[]{0, 63};
    private static final CharSetNames CHARSET_NAMES = new CharSetNames();
    private String m_sSessionJavaCharsetName = null;
    private String m_sSerializeDeserializeCharsetName = null;
    private Charset m_charsetSerializeDeserialize = null;
    private Charset m_charsetAscii = null;
    private Charset m_charsetUTF8 = null;
    private byte[] m_abyReplacement = null;
    private ThreadLocal m_charsetEncoderReplace = new ThreadLocal();
    private ThreadLocal m_charsetEncoderReport = new ThreadLocal();
    private ThreadLocal m_asciiCharsetEncoderReplace = new ThreadLocal();
    private ThreadLocal m_asciiCharsetEncoderReport = new ThreadLocal();
    private ThreadLocal m_utf8CharsetEncoderReport = new ThreadLocal();
    private ThreadLocal m_asciiCharsetDecoderReport = new ThreadLocal();

    public ConnectionCharsetInfo(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        this.m_sSessionJavaCharsetName = CHARSET_NAMES.getMappedName(genericTeradataConnection.getURLParameters().getCharSet());
        if (this.m_sSessionJavaCharsetName == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ302", genericTeradataConnection.getURLParameters().getCharSet());
        }
        String string = genericTeradataConnection.getURLParameters().getClientCharset();
        this.m_sSerializeDeserializeCharsetName = string != null ? string : this.m_sSessionJavaCharsetName;
        byte[] byArray = this.m_abyReplacement = this.m_sSerializeDeserializeCharsetName.equalsIgnoreCase("UTF-16BE") ? REPLACE_WITH_QUESTION_MARK_UTF16 : REPLACE_WITH_QUESTION_MARK_ASCII;
        if (genericTeradataConnection.isStrictEncode()) {
            this.m_charsetSerializeDeserialize = ConnectionCharsetInfo.obtainCharset(this.m_sSerializeDeserializeCharsetName);
            this.m_charsetAscii = ConnectionCharsetInfo.obtainCharset(ASCII_CHARSET_NAME);
            this.m_charsetUTF8 = ConnectionCharsetInfo.obtainCharset(UTF8_CHARSET_NAME);
        }
    }

    private static Charset obtainCharset(String string) throws SQLException {
        try {
            return Charset.forName(string);
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ670", string);
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    public int getMaxBytePerCharacter() throws SQLException {
        return ColumnDisplaySizes.getJavaCharSetMaxBytePerCharacter(this.m_sSessionJavaCharsetName);
    }

    String getSessionJavaCharsetName() {
        return this.m_sSessionJavaCharsetName;
    }

    String getSerializeDeserializeCharsetName() {
        return this.m_sSerializeDeserializeCharsetName;
    }

    static Object deref(ThreadLocal threadLocal) {
        SoftReference softReference = (SoftReference)threadLocal.get();
        return softReference == null ? null : softReference.get();
    }

    static void set(ThreadLocal threadLocal, Object object) {
        threadLocal.set(new SoftReference<Object>(object));
    }

    ThreadLocal getCharsetEncoderReplace() {
        return this.m_charsetEncoderReplace;
    }

    ThreadLocal getCharsetEncoderReport() {
        return this.m_charsetEncoderReport;
    }

    ThreadLocal getAsciiCharsetEncoderReplace() {
        return this.m_asciiCharsetEncoderReplace;
    }

    ThreadLocal getAsciiCharsetEncoderReport() {
        return this.m_asciiCharsetEncoderReport;
    }

    ThreadLocal getUTF8CharsetEncoderReport() {
        return this.m_utf8CharsetEncoderReport;
    }

    ThreadLocal getAsciiCharsetDecoderReport() {
        return this.m_asciiCharsetDecoderReport;
    }

    byte[] getReplacementBytes() {
        return this.m_abyReplacement;
    }

    public String getClientCharsetNameForClientAttributes() {
        return this.m_sSerializeDeserializeCharsetName;
    }

    Charset getSerializeDeseralizeCharset() {
        return this.m_charsetSerializeDeserialize;
    }

    Charset getAsciiCharset() {
        return this.m_charsetAscii;
    }

    Charset getUTF8Charset() {
        return this.m_charsetUTF8;
    }
}

