/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedIndicMultiPartProtocol;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedIndicProtocol;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class PreparedStatementSendState
extends StatementSendState {
    ParameterProperties paramProperties = null;
    PreparedIndicProtocol protocol = null;

    public PreparedStatementSendState(StatementController statementController) {
        super(statementController);
        this.paramProperties = ((TDPreparedStatement)statementController.getStatement()).getParameterProperties();
    }

    protected void altHeaderRequired() throws SQLException {
        this.protocol = this.getController().getSession().getConfigResponse().isMultiPartProtocolSupported() ? new PreparedIndicMultiPartProtocol(this, this.paramProperties) : new PreparedIndicProtocol(this, this.paramProperties);
        int n = this.protocol.getSize();
        if (n > 65104) {
            if (this.getController().getSession().isAphSupported()) {
                this.setAltHeader(true);
            } else {
                this.log.debug("Request is too large for 64K buffer, no APH support on server");
                throw ErrorFactory.makeDriverJDBCException("TJ313", n, 65104);
            }
        }
        this.setBufferSize(n);
        this.log.debug("USING ALTHEADER : " + this.altHeader);
        this.log.debug("Buffer size needed is: " + this.getBufferSize());
    }

    protected void initSubclassParcels() throws SQLException {
        if (this.protocol == null) {
            throw new IllegalStateException("protocol is null; initSubclassParcels must be called after altHeaderRequired");
        }
        this.protocol.initDataInfoParcel();
        this.protocol.initIndicData();
    }
}

