/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.lib.ArrayUtil;
import com.datapps.linkoopdb.jdbc.lib.LdbSqlByteArrayOutputStream;
import com.datapps.linkoopdb.jdbc.map.BitMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class StringConverter {
    private static final byte[] HEXBYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private static int getNibble(int value) {
        if (value >= 48 && value <= 57) {
            return value - 48;
        }
        if (value >= 97 && value <= 102) {
            return 10 + value - 97;
        }
        if (value >= 65 && value <= 70) {
            return 10 + value - 65;
        }
        return -1;
    }

    public static byte[] hexStringToByteArray(String s) throws IOException {
        int l = s.length();
        byte[] data = new byte[l / 2 + l % 2];
        int b = 0;
        boolean high = true;
        int i = 0;
        for (int j = 0; j < l; ++j) {
            char c = s.charAt(j);
            if (c == ' ') continue;
            int n = StringConverter.getNibble(c);
            if (n == -1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            if (high) {
                b = (n & 0xF) << 4;
                high = false;
                continue;
            }
            high = true;
            data[i++] = (byte)(b += n & 0xF);
        }
        if (!high) {
            throw new IOException("hexadecimal string with odd number of characters");
        }
        if (i < data.length) {
            data = (byte[])ArrayUtil.resizeArray(data, i);
        }
        return data;
    }

    public static BitMap sqlBitStringToBitMap(String s) throws IOException {
        int l = s.length();
        int bitIndex = 0;
        BitMap map = new BitMap(0, true);
        for (int j = 0; j < l; ++j) {
            char c = s.charAt(j);
            if (c == ' ') continue;
            int n = StringConverter.getNibble(c);
            if (n != 0 && n != 1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            if (n == 1) {
                map.set(bitIndex);
            }
            ++bitIndex;
        }
        map.setSize(bitIndex);
        return map;
    }

    public static String byteArrayToHexString(byte[] b) {
        int len = b.length;
        char[] s = new char[len * 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int c = b[i] & 0xFF;
            s[j++] = (char)HEXBYTES[c >> 4 & 0xF];
            s[j++] = (char)HEXBYTES[c & 0xF];
        }
        return new String(s);
    }

    public static String byteArrayToSQLHexString(byte[] b) {
        int len = b.length;
        char[] s = new char[len * 2 + 3];
        s[0] = 88;
        s[1] = 39;
        int j = 2;
        for (int i = 0; i < len; ++i) {
            int c = b[i] & 0xFF;
            s[j++] = (char)HEXBYTES[c >> 4 & 0xF];
            s[j++] = (char)HEXBYTES[c & 0xF];
        }
        s[j] = 39;
        return new String(s);
    }

    public static String byteArrayToBitString(byte[] bytes, int bitCount) {
        char[] s = new char[bitCount];
        for (int j = 0; j < bitCount; ++j) {
            byte b = bytes[j / 8];
            s[j] = BitMap.isSet(b, j % 8) ? 49 : 48;
        }
        return new String(s);
    }

    public static String byteArrayToSQLBitString(byte[] bytes, int bitCount) {
        char[] s = new char[bitCount + 3];
        s[0] = 66;
        s[1] = 39;
        int pos = 2;
        for (int j = 0; j < bitCount; ++j) {
            byte b = bytes[j / 8];
            s[pos++] = BitMap.isSet(b, j % 8) ? 49 : 48;
        }
        s[pos] = 39;
        return new String(s);
    }

    public static int writeHexBytes(byte[] o, int from, byte[] b) {
        int len = b.length;
        int pos = from;
        for (int i = 0; i < len; ++i) {
            int c = b[i] & 0xFF;
            o[pos++] = HEXBYTES[c >> 4 & 0xF];
            o[pos++] = HEXBYTES[c & 0xF];
        }
        return pos - from;
    }

    public static String byteArrayToString(byte[] b, String charset) {
        try {
            return charset == null ? new String(b) : new String(b, charset);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void stringToUnicodeBytes(LdbSqlByteArrayOutputStream b, String s, boolean doubleSingleQuotes) {
        if (s == null) {
            return;
        }
        int len = s.length();
        int extras = 0;
        if (len == 0) {
            return;
        }
        b.ensureRoom(len * 2 + 5);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (i < len - 1 && s.charAt(i + 1) == 'u') {
                    b.writeNoCheck(c);
                    b.writeNoCheck(117);
                    b.writeNoCheck(48);
                    b.writeNoCheck(48);
                    b.writeNoCheck(53);
                    b.writeNoCheck(99);
                    extras += 5;
                } else {
                    b.write(c);
                }
            } else if (c >= ' ' && c <= '\u007f') {
                b.writeNoCheck(c);
                if (c == '\'' && doubleSingleQuotes) {
                    b.writeNoCheck(c);
                    ++extras;
                }
            } else {
                b.writeNoCheck(92);
                b.writeNoCheck(117);
                b.writeNoCheck(HEXBYTES[c >> 12 & 0xF]);
                b.writeNoCheck(HEXBYTES[c >> 8 & 0xF]);
                b.writeNoCheck(HEXBYTES[c >> 4 & 0xF]);
                b.writeNoCheck(HEXBYTES[c & 0xF]);
                extras += 5;
            }
            if (extras <= len) continue;
            b.ensureRoom(len + extras + 5);
            extras = 0;
        }
    }

    public static String unicodeStringToString(String s) {
        if (s == null || s.indexOf("\\u") == -1) {
            return s;
        }
        int len = s.length();
        char[] b = new char[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < len - 5) {
                char c1 = s.charAt(i + 1);
                if (c1 == 'u') {
                    ++i;
                    int k = StringConverter.getNibble(s.charAt(++i)) << 12;
                    k += StringConverter.getNibble(s.charAt(++i)) << 8;
                    k += StringConverter.getNibble(s.charAt(++i)) << 4;
                    b[j++] = (char)(k += StringConverter.getNibble(s.charAt(++i)));
                    continue;
                }
                b[j++] = c;
                continue;
            }
            b[j++] = c;
        }
        return new String(b, 0, j);
    }

    public static String readUTF(byte[] bytearr, int offset, int length) throws IOException {
        char[] buf = new char[length];
        return StringConverter.readUTF(bytearr, offset, length, buf);
    }

    public static String readUTF(byte[] bytearr, int offset, int length, char[] buf) throws IOException {
        int bcount = 0;
        int count = 0;
        block4: while (count < length) {
            int c = bytearr[offset + count];
            if (bcount == buf.length) {
                buf = (char[])ArrayUtil.resizeArray(buf, length);
            }
            if (c > 0) {
                ++count;
                buf[bcount++] = (char)c;
                continue;
            }
            switch ((c &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((count += 2) > length) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[offset + count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    buf[bcount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block4;
                }
                case 14: {
                    if ((count += 3) > length) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[offset + count - 2];
                    byte char3 = bytearr[offset + count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    buf[bcount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block4;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(buf, 0, bcount);
    }

    public static int stringToUTFBytes(String str, LdbSqlByteArrayOutputStream out) {
        int strlen = str.length();
        int count = 0;
        if (out.count + strlen + 8 > out.buffer.length) {
            out.ensureRoom(strlen + 8);
        }
        char[] arr = str.toCharArray();
        for (int i = 0; i < strlen; ++i) {
            char c = arr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                out.buffer[out.count++] = (byte)c;
                ++count;
            } else if (c > '\u07ff') {
                out.buffer[out.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                out.buffer[out.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                out.buffer[out.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                count += 3;
            } else {
                out.buffer[out.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                out.buffer[out.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                count += 2;
            }
            if (out.count + 8 <= out.buffer.length) continue;
            out.ensureRoom(strlen - i + 8);
        }
        return count;
    }

    public static int getUTFSize(String s) {
        int len = s == null ? 0 : s.length();
        int l = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++l;
                continue;
            }
            if (c > '\u07ff') {
                l += 3;
                continue;
            }
            l += 2;
        }
        return l;
    }

    public static String inputStreamToString(InputStream is, String encoding) throws IOException {
        int c;
        LdbSqlByteArrayOutputStream baOS = new LdbSqlByteArrayOutputStream(1024);
        while ((c = is.read()) != -1) {
            baOS.write(c);
        }
        return new String(baOS.getBuffer(), 0, baOS.size(), encoding);
    }

    public static String toQuotedString(String s, char quoteChar, boolean extraQuote) {
        if (s == null) {
            return null;
        }
        int count = extraQuote ? StringConverter.count(s, quoteChar) : 0;
        int len = s.length();
        char[] b = new char[2 + count + len];
        int j = 0;
        b[j++] = quoteChar;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            b[j++] = c;
            if (!extraQuote || c != quoteChar) continue;
            b[j++] = c;
        }
        b[j] = quoteChar;
        return new String(b);
    }

    static int count(String s, char c) {
        int pos = 0;
        int count = 0;
        if (s != null) {
            while ((pos = s.indexOf(c, pos)) > -1) {
                ++count;
                ++pos;
            }
        }
        return count;
    }

    public static void stringToHtmlBytes(LdbSqlByteArrayOutputStream b, String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len == 0) {
            return;
        }
        char[] chars = s.toCharArray();
        b.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c > '\u007f' || c == '\"' || c == '&' || c == '<' || c == '>') {
                int codePoint = Character.codePointAt(chars, i);
                if (Character.charCount(codePoint) == 2) {
                    ++i;
                }
                b.ensureRoom(16);
                b.writeNoCheck(38);
                b.writeNoCheck(35);
                b.writeBytes(String.valueOf(codePoint));
                b.writeNoCheck(59);
                continue;
            }
            if (c < ' ') {
                b.writeNoCheck(32);
                continue;
            }
            b.writeNoCheck(c);
        }
    }

    public static String toStringUUID(byte[] b) {
        if (b == null) {
            return null;
        }
        if (b.length != 16) {
            throw new NumberFormatException();
        }
        char[] chars = new char[36];
        int i = 0;
        int j = 0;
        while (i < b.length) {
            int hexIndex = (b[i] & 0xF0) >> 4;
            chars[j++] = (char)HEXBYTES[hexIndex];
            hexIndex = b[i] & 0xF;
            chars[j++] = (char)HEXBYTES[hexIndex];
            if (++i < 4 || i > 10 || i % 2 != 0) continue;
            chars[j++] = 45;
        }
        return new String(chars);
    }

    public static int writeUUIDHexBytes(byte[] o, int from, byte[] b) {
        if (b.length != 16) {
            throw new NumberFormatException();
        }
        int pos = from;
        int i = 0;
        while (i < b.length) {
            int hexIndex = (b[i] & 0xF0) >> 4;
            o[pos++] = HEXBYTES[hexIndex];
            hexIndex = b[i] & 0xF;
            o[pos++] = HEXBYTES[hexIndex];
            if (++i < 4 || i > 10 || i % 2 != 0) continue;
            o[pos++] = 45;
        }
        return pos - from;
    }

    public static byte[] toBinaryUUID(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() != 36) {
            throw new NumberFormatException();
        }
        byte[] bytes = new byte[16];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            char c = s.charAt(j++);
            int high = StringConverter.getNibble(c);
            c = s.charAt(j++);
            bytes[i] = (byte)((high << 4) + StringConverter.getNibble(c));
            if (++i < 4 || i > 10 || i % 2 != 0 || (c = s.charAt(j++)) == '-') continue;
            throw new NumberFormatException();
        }
        return bytes;
    }
}

