/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;

public class JwtTokenHdr {
    private byte version;
    private byte msgType;
    private byte clientorServer;
    private int capability;
    private byte requestFlag;

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte by) {
        this.version = by;
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public void setMsgType(byte by) {
        this.msgType = by;
    }

    public byte getClientorServer() {
        return this.clientorServer;
    }

    public void setClientorServer(byte by) {
        this.clientorServer = by;
    }

    public int getCapability() {
        return this.capability;
    }

    public void setCapability(int n) {
        this.capability = n;
    }

    public byte getRequestFlag() {
        return this.requestFlag;
    }

    public void setRequestFlag(byte by) {
        this.requestFlag = by;
    }

    public DER getDERObject() {
        ListArray listArray = new ListArray(DER.class);
        DER dER = new DER(0, listArray);
        if (this.version == 0) {
            throw new IllegalArgumentException("Argument version is not valid");
        }
        DER dER2 = new DER(0, this.version);
        dER.add(dER2);
        if (this.msgType == 0) {
            throw new IllegalArgumentException("Argument Message type is not valid");
        }
        dER2 = new DER(1, this.msgType);
        dER.add(dER2);
        dER2 = new DER(2, this.clientorServer);
        dER.add(dER2);
        if (this.capability == 0) {
            throw new IllegalArgumentException("Argument capability is not valid");
        }
        DER dER3 = new DER(3, (long)this.capability);
        dER.add(dER3);
        dER3 = new DER(4, this.requestFlag);
        dER.add(dER3);
        return dER;
    }

    public void parseDERObject(DER dER) {
        if (0 != dER.getTagNumber()) {
            throw new IllegalArgumentException("TokenHdr tag is not valid");
        }
        DER dER2 = dER.getChildrenWithTag(0);
        if (dER2 == null) {
            throw new IllegalArgumentException("Version field of token header not found");
        }
        this.version = dER2.getValueAsByte();
        DER dER3 = dER.getChildrenWithTag(1);
        if (dER3 == null) {
            throw new IllegalArgumentException("Message Type field of TokenHeader not found");
        }
        this.msgType = dER3.getValueAsByte();
        DER dER4 = dER.getChildrenWithTag(2);
        if (dER4 == null) {
            throw new IllegalArgumentException("clientOrserver field of TokenHeader not found");
        }
        this.clientorServer = dER4.getValueAsByte();
        DER dER5 = dER.getChildrenWithTag(3);
        if (dER5 == null) {
            throw new IllegalArgumentException("Capability field of TokenHeader not found");
        }
        this.capability = (int)dER5.getValueAsInt();
        DER dER6 = dER.getChildrenWithTag(4);
        if (dER6 == null) {
            throw new IllegalArgumentException("RequestFlag field of TokenHeader not found");
        }
        this.requestFlag = dER6.getValueAsByte();
    }
}

