/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.error.Error;

public final class SqlInvariants {
    public static final String SYSTEM_AUTHORIZATION_NAME = "_SYSTEM";
    public static final String SYSTEM_ADMIN = "ADMIN";
    public static final String SYSTEM_ADMIN_INIT_PASSWORD = "123456";
    public static final String DBA_ADMIN_ROLE_NAME = "DBA";
    public static final String SCHEMA_CREATE_ROLE_NAME = "CREATE_SCHEMA";
    public static final String CHANGE_AUTH_ROLE_NAME = "CHANGE_AUTHORIZATION";
    public static final String SYSTEM_SUBQUERY = "SYSTEM_SUBQUERY";
    public static final String PUBLIC_ROLE_NAME = "PUBLIC";
    public static final String DEFAULT_CATALOG_NAME = "PUBLIC";
    public static final String SYSTEM_SCHEMA = "SYSTEM_SCHEMA";
    public static final String LOBS_SCHEMA = "SYSTEM_LOBS";
    public static final String DEFINITION_SCHEMA = "DEFINITION_SCHEMA";
    public static final String INFORMATION_SCHEMA = "INFORMATION_SCHEMA";
    public static final String SQLJ_SCHEMA = "SQLJ";
    public static final String PUBLIC_SCHEMA = "PUBLIC";
    public static final String LDB_INFO_SCHEMA = "LDB_INFO_SCHEMA";
    public static final String CLASSPATH_NAME = "CLASSPATH";
    public static final String TABLE_STATS = "TABLE_STATS";
    public static final String SYN_LOG_TABLE = "SYN_LOG_TABLE";
    public static final String PALLAS_DIST_TABLE = "PALLAS_DIST_TABLE";
    public static final String MODULE = "MODULE";
    public static final String DUAL = "DUAL";
    public static final String DUMMY = "DUMMY";
    public static final String IDX = "IDX";
    public static final String DEFAULT_RESOURCE_GROUP = "DEFAULT";
    public static final String DEFAULT_STREAM_RESOURCE_GROUP = "STREAM_DEFAULT";
    public static final String LOW_PRIORITY = "LOW";
    public static final String MEDIUM_PRIORITY = "MEDIUM";
    public static final String HIGH_PRIORITY = "HIGH";
    public static final String EMERGENCY_PRIORITY = "EMERGENCY";
    public static final String DEFAULT_JOB_PRIORITY = "MEDIUM";
    public static final String PALLASID = "_LDBID_";
    public static final LdbSqlNameManager.LdbSqlName INFORMATION_SCHEMA_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName SYSTEM_SCHEMA_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName LOBS_SCHEMA_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName SQLJ_SCHEMA_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName SYSTEM_SUBQUERY_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName MODULE_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName DUAL_TABLE_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName DUAL_COLUMN_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName SYSTEM_INDEX_HSQLNAME;
    public static final String[] statsColumnName;
    public static final String[] synLogColumnName;
    public static final String[] pallaDistColumnName;
    public static final LdbSqlNameManager.LdbSqlName LDB_INFO_SCHEMA_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName TABLE_STATS_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName SYN_LOG_TABLE_HSQLNAME;
    public static final LdbSqlNameManager.LdbSqlName PALLAS_DIST_TABLE_HSQLNAME;

    public static void checkSchemaNameNotSystem(String name) {
        if (SqlInvariants.isSystemSchemaName(name)) {
            throw Error.error(5503, name);
        }
    }

    public static boolean isSystemSchemaNameToHandleInServer(String name) {
        return DEFINITION_SCHEMA.equals(name) || INFORMATION_SCHEMA.equals(name) || LOBS_SCHEMA.equals(name) || SQLJ_SCHEMA.equals(name);
    }

    public static boolean isSystemSchemaName(String name) {
        return DEFINITION_SCHEMA.equals(name) || INFORMATION_SCHEMA.equals(name) || SYSTEM_SCHEMA.equals(name) || LDB_INFO_SCHEMA.equals(name) || SQLJ_SCHEMA.equals(name);
    }

    public static boolean isLobsSchemaName(String name) {
        return LOBS_SCHEMA.equals(name);
    }

    public static boolean isSchemaNameSystem(LdbSqlNameManager.LdbSqlName name) {
        if (name.schema != null) {
            name = name.schema;
        }
        return INFORMATION_SCHEMA_HSQLNAME.equals(name) || SYSTEM_SCHEMA_HSQLNAME.equals(name) || SQLJ_SCHEMA_HSQLNAME.equals(name);
    }

    static {
        statsColumnName = new String[]{"tableID", "tableName", "columnName", "numRows", "distinctCount", "min", "max", "nullCount", "avgLen", "maxLen", "histogram"};
        synLogColumnName = new String[]{PALLASID, "cid", "data"};
        pallaDistColumnName = new String[]{PALLASID, "lobId"};
        INFORMATION_SCHEMA_HSQLNAME = LdbSqlNameManager.newSystemObjectName(INFORMATION_SCHEMA, 2);
        LDB_INFO_SCHEMA_HSQLNAME = LdbSqlNameManager.newSystemObjectName(LDB_INFO_SCHEMA, 2);
        SYSTEM_SCHEMA_HSQLNAME = LdbSqlNameManager.newSystemObjectName(SYSTEM_SCHEMA, 2);
        LOBS_SCHEMA_HSQLNAME = LdbSqlNameManager.newSystemObjectName(LOBS_SCHEMA, 2);
        SQLJ_SCHEMA_HSQLNAME = LdbSqlNameManager.newSystemObjectName(SQLJ_SCHEMA, 2);
        SYSTEM_SUBQUERY_HSQLNAME = LdbSqlNameManager.newSystemObjectName(SYSTEM_SUBQUERY, 3);
        MODULE_HSQLNAME = LdbSqlNameManager.newSystemObjectName(MODULE, 2);
        DUAL_TABLE_HSQLNAME = LdbSqlNameManager.newSystemObjectName(DUAL, 3);
        TABLE_STATS_HSQLNAME = LdbSqlNameManager.newSystemObjectName(TABLE_STATS, 3);
        SYN_LOG_TABLE_HSQLNAME = LdbSqlNameManager.newSystemObjectName(SYN_LOG_TABLE, 3);
        PALLAS_DIST_TABLE_HSQLNAME = LdbSqlNameManager.newSystemObjectName(PALLAS_DIST_TABLE, 3);
        SqlInvariants.DUAL_TABLE_HSQLNAME.schema = SYSTEM_SCHEMA_HSQLNAME;
        DUAL_COLUMN_HSQLNAME = LdbSqlNameManager.newSystemObjectName(DUMMY, 9);
        SqlInvariants.DUAL_COLUMN_HSQLNAME.parent = DUAL_TABLE_HSQLNAME;
        SYSTEM_INDEX_HSQLNAME = LdbSqlNameManager.newSystemObjectName(IDX, 20);
        SYSTEM_SUBQUERY_HSQLNAME.setSchemaIfNull(SYSTEM_SCHEMA_HSQLNAME);
    }
}

