/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SocketFinder;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

final class TDSChannel {
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Channel");
    private final String traceID;
    private final SQLServerConnection con;
    private final TDSWriter tdsWriter;
    private Socket tcpSocket;
    private SSLSocket sslSocket;
    private Socket channelSocket;
    ProxySocket proxySocket = null;
    private InputStream tcpInputStream;
    private OutputStream tcpOutputStream;
    private InputStream inputStream;
    private OutputStream outputStream;
    private static Logger packetLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.DATA");
    private final boolean isLoggingPackets = packetLogger.isLoggable(Level.FINEST);
    int numMsgsSent = 0;
    int numMsgsRcvd = 0;
    private int spid = 0;
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String JAVA_SECURITY = JAVA_HOME + SEPARATOR + "lib" + SEPARATOR + "security";
    private static final String JSSECACERTS = JAVA_SECURITY + SEPARATOR + "jssecacerts";
    private static final String CACERTS = JAVA_SECURITY + SEPARATOR + "cacerts";

    final Logger getLogger() {
        return logger;
    }

    public final String toString() {
        return this.traceID;
    }

    final TDSWriter getWriter() {
        return this.tdsWriter;
    }

    final TDSReader getReader(TDSCommand tDSCommand) {
        return new TDSReader(this, this.con, tDSCommand);
    }

    final boolean isLoggingPackets() {
        return this.isLoggingPackets;
    }

    void setSPID(int n) {
        this.spid = n;
    }

    int getSPID() {
        return this.spid;
    }

    void resetPooledConnection() {
        this.tdsWriter.resetPooledConnection();
    }

    TDSChannel(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        this.traceID = "TDSChannel (" + sQLServerConnection.toString() + ")";
        this.tcpSocket = null;
        this.sslSocket = null;
        this.channelSocket = null;
        this.tcpInputStream = null;
        this.tcpOutputStream = null;
        this.inputStream = null;
        this.outputStream = null;
        this.tdsWriter = new TDSWriter(this, sQLServerConnection);
    }

    final void open(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3) throws SQLServerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + ": Opening TCP socket...");
        }
        SocketFinder socketFinder = new SocketFinder(this.traceID, this.con);
        this.channelSocket = this.tcpSocket = socketFinder.findSocket(string, n, n2, bl, bl2, bl3, n3);
        try {
            this.tcpSocket.setTcpNoDelay(true);
            this.tcpSocket.setKeepAlive(true);
            this.inputStream = this.tcpInputStream = this.tcpSocket.getInputStream();
            this.outputStream = this.tcpOutputStream = this.tcpSocket.getOutputStream();
        }
        catch (IOException iOException) {
            SQLServerException.ConvertConnectExceptionToSQLServerException(string, n, this.con, iOException);
        }
    }

    void disableSSL() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " Disabling SSL...");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        try {
            ((InputStream)byteArrayInputStream).close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing InputStream: " + iOException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing OutputStream: " + iOException.getMessage());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Rewiring proxy streams for SSL socket close");
        }
        this.proxySocket.setStreams(byteArrayInputStream, byteArrayOutputStream);
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Closing SSL socket");
            }
            this.sslSocket.close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing SSLSocket: " + iOException.getMessage());
        }
        this.proxySocket = null;
        this.inputStream = this.tcpInputStream;
        this.outputStream = this.tcpOutputStream;
        this.channelSocket = this.tcpSocket;
        this.sslSocket = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " SSL disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableSSL(String string, int n) throws SQLServerException {
        Provider provider = null;
        Provider provider2 = null;
        Provider provider3 = null;
        String string2 = null;
        SSLHandhsakeState sSLHandhsakeState = SSLHandhsakeState.SSL_HANDHSAKE_NOT_STARTED;
        try {
            Object object;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Enabling SSL...");
            }
            String string3 = this.con.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.TRUST_STORE.toString());
            String string4 = this.con.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.TRUST_STORE_PASSWORD.toString());
            String string5 = this.con.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.HOSTNAME_IN_CERTIFICATE.toString());
            assert (0 == this.con.getRequestedEncryptionLevel() || 1 == this.con.getRequestedEncryptionLevel());
            assert (0 == this.con.getNegotiatedEncryptionLevel() || 1 == this.con.getNegotiatedEncryptionLevel() || 3 == this.con.getNegotiatedEncryptionLevel());
            TrustManager[] trustManagerArray = null;
            if (0 == this.con.getRequestedEncryptionLevel() || 1 == this.con.getRequestedEncryptionLevel() && this.con.trustServerCertificate()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " SSL handshake will trust any certificate");
                }
                trustManagerArray = new TrustManager[]{new PermissiveX509TrustManager(this)};
            } else {
                Object object2;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " SSL handshake will validate server certificate");
                }
                object = null;
                if (null == string3 && null == string4) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + " Using system default trust store and password");
                    }
                } else {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + " Finding key store interface");
                    }
                    object = KeyStore.getInstance("JKS");
                    provider3 = ((KeyStore)object).getProvider();
                    object2 = this.loadTrustStore(string3);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + " Loading key store");
                    }
                    try {
                        ((KeyStore)object).load((InputStream)object2, null == string4 ? null : string4.toCharArray());
                    }
                    finally {
                        block37: {
                            this.con.activeConnectionProperties.remove(SQLServerDriverStringProperty.TRUST_STORE_PASSWORD.toString());
                            if (null != object2) {
                                try {
                                    ((InputStream)object2).close();
                                }
                                catch (IOException iOException) {
                                    if (!logger.isLoggable(Level.FINE)) break block37;
                                    logger.fine(this.toString() + " Ignoring error closing trust material InputStream...");
                                }
                            }
                        }
                    }
                }
                object2 = null;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + " Locating X.509 trust manager factory");
                }
                string2 = TrustManagerFactory.getDefaultAlgorithm();
                object2 = TrustManagerFactory.getInstance(string2);
                provider = ((TrustManagerFactory)object2).getProvider();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + " Getting trust manager");
                }
                ((TrustManagerFactory)object2).init((KeyStore)object);
                trustManagerArray = ((TrustManagerFactory)object2).getTrustManagers();
                trustManagerArray = null != string5 ? new TrustManager[]{new HostNameOverrideX509TrustManager(this, (X509TrustManager)trustManagerArray[0], string5)} : new TrustManager[]{new HostNameOverrideX509TrustManager(this, (X509TrustManager)trustManagerArray[0], string)};
            }
            object = null;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Getting TLS or better SSL context");
            }
            object = SSLContext.getInstance("TLS");
            provider2 = ((SSLContext)object).getProvider();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Initializing SSL context");
            }
            ((SSLContext)object).init(null, trustManagerArray, null);
            this.proxySocket = new ProxySocket(this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Creating SSL socket");
            }
            this.sslSocket = (SSLSocket)((SSLContext)object).getSocketFactory().createSocket(this.proxySocket, string, n, false);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Starting SSL handshake");
            }
            sSLHandhsakeState = SSLHandhsakeState.SSL_HANDHSAKE_STARTED;
            this.sslSocket.startHandshake();
            sSLHandhsakeState = SSLHandhsakeState.SSL_HANDHSAKE_COMPLETE;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Rewiring proxy streams after handshake");
            }
            this.proxySocket.setStreams(this.inputStream, this.outputStream);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Getting SSL InputStream");
            }
            this.inputStream = this.sslSocket.getInputStream();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Getting SSL OutputStream");
            }
            this.outputStream = this.sslSocket.getOutputStream();
            this.channelSocket = this.sslSocket;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " SSL enabled");
            }
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, exception.getMessage(), exception);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "java.security path: " + JAVA_SECURITY + "\n" + "Security providers: " + Arrays.asList(Security.getProviders()) + "\n" + (null != provider2 ? "SSLContext provider info: " + provider2.getInfo() + "\n" + "SSLContext provider services:\n" + provider2.getServices() + "\n" : "") + (null != provider ? "TrustManagerFactory provider info: " + provider.getInfo() + "\n" : "") + (null != string2 ? "TrustManagerFactory default algorithm: " + string2 + "\n" : "") + (null != provider3 ? "KeyStore provider info: " + provider3.getInfo() + "\n" : "") + "java.ext.dirs: " + System.getProperty("java.ext.dirs"));
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_sslFailed"));
            Object[] objectArray = new Object[]{exception.getMessage()};
            String string6 = exception.getLocalizedMessage();
            if (-1 != string6.indexOf(" ClientConnectionId:")) {
                string6 = string6.substring(0, string6.indexOf(" ClientConnectionId:"));
            }
            if (exception instanceof IOException && SSLHandhsakeState.SSL_HANDHSAKE_STARTED == sSLHandhsakeState && string6.equals(SQLServerException.getErrString("R_truncatedServerResponse"))) {
                this.con.terminate(7, messageFormat.format(objectArray), exception);
            }
            this.con.terminate(5, messageFormat.format(objectArray), exception);
        }
    }

    final InputStream loadTrustStore(String string) {
        FileInputStream fileInputStream;
        block17: {
            block18: {
                fileInputStream = null;
                if (null != string) {
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toString() + " Opening specified trust store: " + string);
                        }
                        fileInputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toString() + " Trust store not found: " + fileNotFoundException.getMessage());
                        }
                        break block17;
                    }
                }
                string = System.getProperty("javax.net.ssl.trustStore");
                if (null != string) {
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toString() + " Opening default trust store (from javax.net.ssl.trustStore): " + string);
                        }
                        fileInputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toString() + " Trust store not found: " + fileNotFoundException.getMessage());
                        }
                        break block17;
                    }
                }
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + " Opening default trust store: " + JSSECACERTS);
                    }
                    fileInputStream = new FileInputStream(JSSECACERTS);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!logger.isLoggable(Level.FINE)) break block18;
                    logger.fine(this.toString() + " Trust store not found: " + fileNotFoundException.getMessage());
                }
            }
            if (null == fileInputStream) {
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + " Opening default trust store: " + CACERTS);
                    }
                    fileInputStream = new FileInputStream(CACERTS);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!logger.isLoggable(Level.FINE)) break block17;
                    logger.fine(this.toString() + " Trust store not found: " + fileNotFoundException.getMessage());
                }
            }
        }
        return fileInputStream;
    }

    final int read(byte[] byArray, int n, int n2) throws SQLServerException {
        try {
            return this.inputStream.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toString() + " read failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
            return 0;
        }
    }

    final void write(byte[] byArray, int n, int n2) throws SQLServerException {
        try {
            this.outputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " write failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
        }
    }

    final void flush() throws SQLServerException {
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " flush failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
        }
    }

    final void close() {
        block15: {
            block14: {
                block13: {
                    if (null != this.sslSocket) {
                        this.disableSSL();
                    }
                    if (null != this.inputStream) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toString() + ": Closing inputStream...");
                        }
                        try {
                            this.inputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!logger.isLoggable(Level.FINE)) break block13;
                            logger.log(Level.FINE, this.toString() + ": Ignored error closing inputStream", iOException);
                        }
                    }
                }
                if (null != this.outputStream) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + ": Closing outputStream...");
                    }
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!logger.isLoggable(Level.FINE)) break block14;
                        logger.log(Level.FINE, this.toString() + ": Ignored error closing outputStream", iOException);
                    }
                }
            }
            if (null != this.tcpSocket) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + ": Closing TCP socket...");
                }
                try {
                    this.tcpSocket.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block15;
                    logger.log(Level.FINE, this.toString() + ": Ignored error closing socket", iOException);
                }
            }
        }
    }

    void logPacket(byte[] byArray, int n, int n2, String string) {
        assert (0 <= n2 && n2 <= byArray.length);
        assert (0 <= n && n <= byArray.length);
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray3 = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray4 = new char[cArray3.length];
        System.arraycopy(cArray3, 0, cArray4, 0, cArray3.length);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 4 * n2 + 4 * (1 + n2 / 16) + 80);
        stringBuilder.append(this.tcpSocket.getLocalAddress().toString() + ":" + this.tcpSocket.getLocalPort() + " SPID:" + this.spid + " " + string + "\r\n");
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            for (n5 = 0; n5 < 16 && n3 < n2; ++n5, ++n3) {
                n4 = (byArray[n + n3] + 256) % 256;
                cArray4[3 * n5] = cArray[n4 / 16];
                cArray4[3 * n5 + 1] = cArray[n4 % 16];
                cArray4[50 + n5] = cArray2[n4];
            }
            for (n4 = n5; n4 < 16; ++n4) {
                cArray4[3 * n4] = 32;
                cArray4[3 * n4 + 1] = 32;
            }
            stringBuilder.append(cArray4, 0, 50 + n5);
            if (n3 == n2) break;
            stringBuilder.append("\r\n");
        }
        packetLogger.finest(stringBuilder.toString());
    }

    static enum SSLHandhsakeState {
        SSL_HANDHSAKE_NOT_STARTED,
        SSL_HANDHSAKE_STARTED,
        SSL_HANDHSAKE_COMPLETE;

    }

    private final class HostNameOverrideX509TrustManager
    implements X509TrustManager {
        private final Logger logger;
        private final String logContext;
        private final X509TrustManager defaultTrustManager;
        private String hostName;

        HostNameOverrideX509TrustManager(TDSChannel tDSChannel2, X509TrustManager x509TrustManager, String string) {
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (HostNameOverrideX509TrustManager):";
            this.defaultTrustManager = x509TrustManager;
            this.hostName = string.toLowerCase();
        }

        private String parseCommonName(String string) {
            int n = string.indexOf("cn=");
            if (n == -1) {
                return null;
            }
            string = string.substring(n + 3);
            for (n = 0; n < string.length() && string.charAt(n) != ','; ++n) {
            }
            String string2 = string.substring(0, n);
            if (string2.length() > 1 && '\"' == string2.charAt(0)) {
                string2 = '\"' == string2.charAt(string2.length() - 1) ? string2.substring(1, string2.length() - 1) : null;
            }
            return string2;
        }

        private boolean validateServerName(String string) throws CertificateException {
            if (null == string) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer(this.logContext + " Failed to parse the name from the certificate or name is empty.");
                }
                return false;
            }
            if (!string.equals(this.hostName)) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer(this.logContext + " The name in certificate " + string + " does not match with the server name " + this.hostName + ".");
                }
                return false;
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " The name in certificate:" + string + " validated against server name " + this.hostName + ".");
            }
            return true;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Forwarding ClientTrusted.");
            }
            this.defaultTrustManager.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Forwarding Trusting server certificate");
            }
            this.defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " default serverTrusted succeeded proceeding with server name validation");
            }
            this.validateServerNameInCertificate(x509CertificateArray[0]);
        }

        private void validateServerNameInCertificate(X509Certificate x509Certificate) throws CertificateException {
            Object object;
            String string = x509Certificate.getSubjectX500Principal().getName("canonical");
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " Validating the server name:" + this.hostName);
                this.logger.finer(this.logContext + " The DN name in certificate:" + string);
            }
            boolean bl = false;
            String string2 = this.parseCommonName(string);
            bl = this.validateServerName(string2);
            if (!bl && (object = x509Certificate.getSubjectAlternativeNames()) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    if (list != null && list.size() >= 2) {
                        Object e = list.get(0);
                        Object e2 = list.get(1);
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer(this.logContext + "Key: " + e + "; KeyClass:" + (e != null ? e.getClass() : null) + ";value: " + e2 + "; valueClass:" + (e2 != null ? e2.getClass() : null));
                        }
                        if (e == null || !(e instanceof Integer) || (Integer)e != 2) continue;
                        if (e2 != null && e2 instanceof String) {
                            String string3 = (String)e2;
                            string3 = string3.toUpperCase(Locale.US);
                            bl = this.validateServerName(string3 = string3.toLowerCase(Locale.US));
                            if (bl) {
                                if (!this.logger.isLoggable(Level.FINER)) break;
                                this.logger.finer(this.logContext + " found a valid name in certificate: " + string3);
                                break;
                            }
                        }
                        if (!this.logger.isLoggable(Level.FINER)) continue;
                        this.logger.finer(this.logContext + " the following name in certificate does not match the serverName: " + e2);
                        continue;
                    }
                    if (!this.logger.isLoggable(Level.FINER)) continue;
                    this.logger.finer(this.logContext + " found an invalid san entry: " + list);
                }
            }
            if (!bl) {
                object = SQLServerException.getErrString("R_certNameFailed");
                throw new CertificateException((String)object);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.defaultTrustManager.getAcceptedIssuers();
        }
    }

    private final class PermissiveX509TrustManager
    implements X509TrustManager {
        private final TDSChannel tdsChannel;
        private final Logger logger;
        private final String logContext;

        PermissiveX509TrustManager(TDSChannel tDSChannel2) {
            this.tdsChannel = tDSChannel2;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (PermissiveX509TrustManager):";
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " Trusting client certificate (!)");
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " Trusting server certificate");
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private class ProxySocket
    extends Socket {
        private final TDSChannel tdsChannel;
        private final Logger logger;
        private final String logContext;
        private final ProxyInputStream proxyInputStream;
        private final ProxyOutputStream proxyOutputStream;

        ProxySocket(TDSChannel tDSChannel2) {
            this.tdsChannel = tDSChannel2;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (ProxySocket):";
            SSLHandshakeOutputStream sSLHandshakeOutputStream = new SSLHandshakeOutputStream(tDSChannel2);
            SSLHandshakeInputStream sSLHandshakeInputStream = new SSLHandshakeInputStream(tDSChannel2, sSLHandshakeOutputStream);
            this.proxyOutputStream = new ProxyOutputStream(sSLHandshakeOutputStream);
            this.proxyInputStream = new ProxyInputStream(sSLHandshakeInputStream);
        }

        void setStreams(InputStream inputStream, OutputStream outputStream) {
            this.proxyInputStream.setFilteredStream(inputStream);
            this.proxyOutputStream.setFilteredStream(outputStream);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Getting input stream");
            }
            return this.proxyInputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Getting output stream");
            }
            return this.proxyOutputStream;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.tdsChannel.tcpSocket.getInetAddress();
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.tdsChannel.tcpSocket.getKeepAlive();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.tdsChannel.tcpSocket.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.tdsChannel.tcpSocket.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.tdsChannel.tcpSocket.getLocalSocketAddress();
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.tdsChannel.tcpSocket.getOOBInline();
        }

        @Override
        public int getPort() {
            return this.tdsChannel.tcpSocket.getPort();
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.tdsChannel.tcpSocket.getReceiveBufferSize();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.tdsChannel.tcpSocket.getRemoteSocketAddress();
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.tdsChannel.tcpSocket.getReuseAddress();
        }

        @Override
        public int getSendBufferSize() throws SocketException {
            return this.tdsChannel.tcpSocket.getSendBufferSize();
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.tdsChannel.tcpSocket.getSoLinger();
        }

        @Override
        public int getSoTimeout() throws SocketException {
            return this.tdsChannel.tcpSocket.getSoTimeout();
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.tdsChannel.tcpSocket.getTcpNoDelay();
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.tdsChannel.tcpSocket.getTrafficClass();
        }

        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public boolean isInputShutdown() {
            return false;
        }

        @Override
        public boolean isOutputShutdown() {
            return false;
        }

        @Override
        public String toString() {
            return this.tdsChannel.tcpSocket.toString();
        }

        @Override
        public SocketChannel getChannel() {
            return null;
        }

        @Override
        public void bind(SocketAddress socketAddress) throws IOException {
            this.logger.finer(this.logContext + " Disallowed call to bind.  Throwing IOException.");
            throw new IOException();
        }

        @Override
        public void connect(SocketAddress socketAddress) throws IOException {
            this.logger.finer(this.logContext + " Disallowed call to connect (without timeout).  Throwing IOException.");
            throw new IOException();
        }

        @Override
        public void connect(SocketAddress socketAddress, int n) throws IOException {
            this.logger.finer(this.logContext + " Disallowed call to connect (with timeout).  Throwing IOException.");
            throw new IOException();
        }

        @Override
        public void close() throws IOException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " Ignoring close");
            }
        }

        @Override
        public void setReceiveBufferSize(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setReceiveBufferSize size:" + n);
            }
        }

        @Override
        public void setSendBufferSize(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setSendBufferSize size:" + n);
            }
        }

        @Override
        public void setReuseAddress(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setReuseAddress");
            }
        }

        @Override
        public void setSoLinger(boolean bl, int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setSoLinger");
            }
        }

        @Override
        public void setSoTimeout(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setSoTimeout");
            }
        }

        @Override
        public void setTcpNoDelay(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setTcpNoDelay");
            }
        }

        @Override
        public void setTrafficClass(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setTrafficClass");
            }
        }

        @Override
        public void shutdownInput() throws IOException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring shutdownInput");
            }
        }

        @Override
        public void shutdownOutput() throws IOException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring shutdownOutput");
            }
        }

        @Override
        public void sendUrgentData(int n) throws IOException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring sendUrgentData");
            }
        }

        @Override
        public void setKeepAlive(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setKeepAlive");
            }
        }

        @Override
        public void setOOBInline(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setOOBInline");
            }
        }
    }

    final class ProxyOutputStream
    extends OutputStream {
        private OutputStream filteredStream;
        private final byte[] singleByte = new byte[1];

        ProxyOutputStream(OutputStream outputStream) {
            this.filteredStream = outputStream;
        }

        final void setFilteredStream(OutputStream outputStream) {
            this.filteredStream = outputStream;
        }

        @Override
        public void close() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Closing");
            }
            this.filteredStream.close();
        }

        @Override
        public void flush() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Flushing");
            }
            this.filteredStream.flush();
        }

        @Override
        public void write(int n) throws IOException {
            this.singleByte[0] = (byte)(n & 0xFF);
            this.writeInternal(this.singleByte, 0, this.singleByte.length);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.writeInternal(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.writeInternal(byArray, n, n2);
        }

        private void writeInternal(byte[] byArray, int n, int n2) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Writing " + n2 + " bytes");
            }
            this.filteredStream.write(byArray, n, n2);
        }
    }

    private final class ProxyInputStream
    extends InputStream {
        private InputStream filteredStream;
        private final byte[] oneByte = new byte[1];

        ProxyInputStream(InputStream inputStream) {
            this.filteredStream = inputStream;
        }

        final void setFilteredStream(InputStream inputStream) {
            this.filteredStream = inputStream;
        }

        @Override
        public long skip(long l) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Skipping " + l + " bytes");
            }
            long l2 = this.filteredStream.skip(l);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Skipped " + l + " bytes");
            }
            return l2;
        }

        @Override
        public int available() throws IOException {
            int n = this.filteredStream.available();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " " + n + " bytes available");
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int n;
            while (0 == (n = this.readInternal(this.oneByte, 0, this.oneByte.length))) {
            }
            assert (1 == n || -1 == n);
            return 1 == n ? this.oneByte[0] : -1;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.readInternal(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.readInternal(byArray, n, n2);
        }

        private int readInternal(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Reading " + n2 + " bytes");
            }
            try {
                n3 = this.filteredStream.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " " + iOException.getMessage());
                }
                logger.finer(this.toString() + " Reading bytes threw exception:" + iOException.getMessage());
                throw iOException;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Read " + n3 + " bytes");
            }
            return n3;
        }

        @Override
        public boolean markSupported() {
            boolean bl = this.filteredStream.markSupported();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Returning markSupported: " + bl);
            }
            return bl;
        }

        @Override
        public void mark(int n) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Marking next " + n + " bytes");
            }
            this.filteredStream.mark(n);
        }

        @Override
        public void reset() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Resetting to previous mark");
            }
            this.filteredStream.reset();
        }

        @Override
        public void close() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Closing");
            }
            this.filteredStream.close();
        }
    }

    private class SSLHandshakeOutputStream
    extends OutputStream {
        private final TDSWriter tdsWriter;
        private boolean messageStarted;
        private final Logger logger;
        private final String logContext;
        private final byte[] singleByte = new byte[1];

        SSLHandshakeOutputStream(TDSChannel tDSChannel2) {
            this.tdsWriter = tDSChannel2.getWriter();
            this.messageStarted = false;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (SSLHandshakeOutputStream):";
        }

        @Override
        public void flush() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Ignored a request to flush the stream");
            }
        }

        void endMessage() throws SQLServerException {
            assert (this.messageStarted);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Finishing TDS message");
            }
            this.tdsWriter.endMessage();
            this.messageStarted = false;
        }

        @Override
        public void write(int n) throws IOException {
            this.singleByte[0] = (byte)(n & 0xFF);
            this.writeInternal(this.singleByte, 0, this.singleByte.length);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.writeInternal(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.writeInternal(byArray, n, n2);
        }

        private void writeInternal(byte[] byArray, int n, int n2) throws IOException {
            try {
                if (!this.messageStarted) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.logContext + " Starting new TDS packet...");
                    }
                    this.tdsWriter.startMessage(null, (byte)18);
                    this.messageStarted = true;
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " Writing " + n2 + " bytes...");
                }
                this.tdsWriter.writeBytes(byArray, n, n2);
            }
            catch (SQLServerException sQLServerException) {
                this.logger.finer(this.logContext + " Writing bytes threw exception:" + sQLServerException.getMessage());
                throw new IOException(sQLServerException.getMessage());
            }
        }
    }

    private class SSLHandshakeInputStream
    extends InputStream {
        private final TDSReader tdsReader;
        private final SSLHandshakeOutputStream sslHandshakeOutputStream;
        private final Logger logger;
        private final String logContext;
        private final byte[] oneByte = new byte[1];

        SSLHandshakeInputStream(TDSChannel tDSChannel2, SSLHandshakeOutputStream sSLHandshakeOutputStream) {
            this.tdsReader = tDSChannel2.getReader(null);
            this.sslHandshakeOutputStream = sSLHandshakeOutputStream;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (SSLHandshakeInputStream):";
        }

        private final void ensureSSLPayload() throws IOException {
            if (0 == this.tdsReader.available()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " No handshake response bytes available. Flushing SSL handshake output stream.");
                }
                try {
                    this.sslHandshakeOutputStream.endMessage();
                }
                catch (SQLServerException sQLServerException) {
                    this.logger.finer(this.logContext + " Ending TDS message threw exception:" + sQLServerException.getMessage());
                    throw new IOException(sQLServerException.getMessage());
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " Reading first packet of SSL handshake response");
                }
                try {
                    this.tdsReader.readPacket();
                }
                catch (SQLServerException sQLServerException) {
                    this.logger.finer(this.logContext + " Reading response packet threw exception:" + sQLServerException.getMessage());
                    throw new IOException(sQLServerException.getMessage());
                }
            }
        }

        @Override
        public long skip(long l) throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Skipping " + l + " bytes...");
            }
            if (l <= 0L) {
                return 0L;
            }
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            this.ensureSSLPayload();
            try {
                this.tdsReader.skip((int)l);
            }
            catch (SQLServerException sQLServerException) {
                this.logger.finer(this.logContext + " Skipping bytes threw exception:" + sQLServerException.getMessage());
                throw new IOException(sQLServerException.getMessage());
            }
            return l;
        }

        @Override
        public int read() throws IOException {
            int n;
            while (0 == (n = this.readInternal(this.oneByte, 0, this.oneByte.length))) {
            }
            assert (1 == n || -1 == n);
            return 1 == n ? this.oneByte[0] : -1;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.readInternal(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.readInternal(byArray, n, n2);
        }

        private int readInternal(byte[] byArray, int n, int n2) throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Reading " + n2 + " bytes...");
            }
            this.ensureSSLPayload();
            try {
                this.tdsReader.readBytes(byArray, n, n2);
            }
            catch (SQLServerException sQLServerException) {
                this.logger.finer(this.logContext + " Reading bytes threw exception:" + sQLServerException.getMessage());
                throw new IOException(sQLServerException.getMessage());
            }
            return n2;
        }
    }
}

