/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util;

import com.datapps.linkoopdb.jdbc.util.Traceable;
import com.datapps.linkoopdb.jdbc.util.TransferDb;
import com.datapps.linkoopdb.jdbc.util.TransferHelper;

class SqlServerTransferHelper
extends TransferHelper {
    private boolean firstTinyintRow;
    private boolean firstSmallintRow;

    SqlServerTransferHelper() {
    }

    SqlServerTransferHelper(TransferDb database, Traceable t, String q) {
        super(database, t, q);
    }

    String formatTableName(String t) {
        if (t == null) {
            return t;
        }
        if (t.equals("")) {
            return t;
        }
        if (t.indexOf(32) != -1) {
            return "[" + t + "]";
        }
        return this.formatIdentifier(t);
    }

    @Override
    int convertFromType(int type) {
        if (type == 11) {
            this.tracer.trace("Converted DATETIME (type 11) to TIMESTAMP");
            type = 93;
        } else if (type == -9) {
            this.tracer.trace("Converted NVARCHAR (type -9) to VARCHAR");
            type = 12;
        } else if (type == -8) {
            this.tracer.trace("Converted NCHAR (type -8) to VARCHAR");
            type = 12;
        } else if (type == -10) {
            this.tracer.trace("Converted NTEXT (type -10) to VARCHAR");
            type = 12;
        } else if (type == -1) {
            this.tracer.trace("Converted LONGTEXT (type -1) to LONGVARCHAR");
            type = -1;
        }
        return type;
    }

    void beginTransfer() {
        this.firstSmallintRow = true;
        this.firstTinyintRow = true;
    }

    @Override
    Object convertColumnValue(Object value, int column, int type) {
        if (type == 5 && value instanceof Integer) {
            if (this.firstSmallintRow) {
                this.firstSmallintRow = false;
                this.tracer.trace("SMALLINT: Converted column " + column + " Integer to Short");
            }
            value = new Short((short)((Integer)value).intValue());
        } else if (type == -6 && value instanceof Integer) {
            if (this.firstTinyintRow) {
                this.firstTinyintRow = false;
                this.tracer.trace("TINYINT: Converted column " + column + " Integer to Byte");
            }
            value = new Byte((byte)((Integer)value).intValue());
        }
        return value;
    }
}

