/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;

public abstract class JDBCCommonDataSource
implements CommonDataSource,
Serializable {
    protected Properties connectionProps = new Properties();
    protected String description = null;
    protected String dataSourceName = null;
    protected String serverName = null;
    protected String networkProtocol = null;
    protected int loginTimeout = 0;
    protected transient PrintWriter logWriter;
    protected String user = null;
    protected String password = null;
    protected String url = null;

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
        this.connectionProps.setProperty("loginTimeout", Integer.toString(this.loginTimeout));
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDatabaseName() {
        return this.url;
    }

    public void setDatabaseName(String databaseName) {
        this.url = databaseName;
    }

    public String getDatabase() {
        return this.url;
    }

    public void setDatabase(String database) {
        this.url = database;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.connectionProps.setProperty("user", user);
    }

    public void setPassword(String password) {
        this.password = password;
        this.connectionProps.setProperty("password", password);
    }

    public void setProperties(Properties props) {
        Properties properties = this.connectionProps = props == null ? new Properties() : (Properties)props.clone();
        if (this.user != null) {
            this.connectionProps.setProperty("user", this.user);
        }
        if (this.password != null) {
            this.connectionProps.setProperty("password", this.password);
        }
        if (this.loginTimeout != 0) {
            this.connectionProps.setProperty("loginTimeout", Integer.toString(this.loginTimeout));
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }
}

