/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.lib.Collection;
import com.datapps.linkoopdb.jdbc.lib.HashMap;
import com.datapps.linkoopdb.jdbc.lib.Set;

public class HashMappedListBase
extends HashMap {
    public HashMappedListBase() {
        this(8);
    }

    public HashMappedListBase(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity);
        this.isList = true;
    }

    public synchronized Object get(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.objectValueTable[index];
    }

    @Override
    public synchronized Object remove(Object key) {
        int lookup = this.getLookup(key, key.hashCode());
        if (lookup < 0) {
            return null;
        }
        Object returnValue = super.remove(key);
        this.removeRow(lookup);
        return returnValue;
    }

    public synchronized Object remove(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.remove(this.objectKeyTable[index]);
    }

    public synchronized boolean add(Object key, Object value) {
        int lookup = this.getLookup(key, key.hashCode());
        if (lookup >= 0) {
            return false;
        }
        super.put(key, value);
        return true;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public synchronized Object set(int index, Object value) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object returnValue = this.objectKeyTable[index];
        this.objectKeyTable[index] = value;
        return returnValue;
    }

    public synchronized boolean insert(int index, Object key, Object value) throws IndexOutOfBoundsException {
        int i;
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int lookup = this.getLookup(key, key.hashCode());
        if (lookup >= 0) {
            return false;
        }
        if (index == this.size()) {
            return this.add(key, value);
        }
        HashMappedListBase hm = new HashMappedListBase(this.size());
        for (i = index; i < this.size(); ++i) {
            hm.add(this.getKey(i), this.get(i));
        }
        for (i = this.size() - 1; i >= index; --i) {
            this.remove(i);
        }
        for (i = 0; i < hm.size(); ++i) {
            this.add(hm.getKey(i), hm.get(i));
        }
        return true;
    }

    public synchronized boolean set(int index, Object key, Object value) throws IndexOutOfBoundsException {
        this.checkRange(index);
        if (this.keySet().contains(key) && this.getIndex(key) != index) {
            return false;
        }
        super.remove(this.objectKeyTable[index]);
        super.put(key, value);
        return true;
    }

    public synchronized boolean setKey(int index, Object key) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object value = this.objectValueTable[index];
        return this.set(index, key, value);
    }

    public synchronized boolean setValue(int index, Object value) throws IndexOutOfBoundsException {
        Object existing = this.objectValueTable[index];
        boolean result = value == null ? existing != null : !value.equals(existing);
        this.objectValueTable[index] = value;
        return result;
    }

    public synchronized Object getKey(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.objectKeyTable[index];
    }

    public synchronized int getIndex(Object key) {
        return this.getLookup(key, key.hashCode());
    }

    public synchronized Object[] toValuesArray(Object[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new Object[size];
        }
        for (int i = 0; i < size; ++i) {
            a[i] = this.objectValueTable[i];
        }
        return a;
    }

    public synchronized Object[] toKeysArray(Object[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new Object[size];
        }
        for (int i = 0; i < size; ++i) {
            a[i] = this.objectKeyTable[i];
        }
        return a;
    }

    @Override
    public synchronized int size() {
        return super.size();
    }

    @Override
    public synchronized Collection values() {
        return super.values();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public synchronized Object get(Object key) {
        return super.get(key);
    }

    @Override
    public synchronized Set keySet() {
        return super.keySet();
    }

    @Override
    public synchronized void clear() {
        super.clear();
    }

    @Override
    public synchronized void putAll(HashMap t) {
        super.putAll(t);
    }

    @Override
    public synchronized boolean isEmpty() {
        return super.isEmpty();
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

