/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.Locale;

enum SqlAuthentication {
    NotSpecified,
    SqlPassword,
    ActiveDirectoryPassword,
    ActiveDirectoryIntegrated;


    static SqlAuthentication valueOfString(String string) throws SQLServerException {
        SqlAuthentication sqlAuthentication = null;
        if (string.toLowerCase(Locale.US).equalsIgnoreCase(NotSpecified.toString())) {
            sqlAuthentication = NotSpecified;
        } else if (string.toLowerCase(Locale.US).equalsIgnoreCase(SqlPassword.toString())) {
            sqlAuthentication = SqlPassword;
        } else if (string.toLowerCase(Locale.US).equalsIgnoreCase(ActiveDirectoryPassword.toString())) {
            sqlAuthentication = ActiveDirectoryPassword;
        } else if (string.toLowerCase(Locale.US).equalsIgnoreCase(ActiveDirectoryIntegrated.toString())) {
            sqlAuthentication = ActiveDirectoryIntegrated;
        } else {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidConnectionSetting"));
            Object[] objectArray = new Object[]{"authentication", string};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return sqlAuthentication;
    }
}

