/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.HsqlDateTime;
import com.datapps.linkoopdb.jdbc.LdbSqlException;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCArray;
import com.datapps.linkoopdb.jdbc.impl.JDBCBlobClient;
import com.datapps.linkoopdb.jdbc.impl.JDBCClobClient;
import com.datapps.linkoopdb.jdbc.impl.JDBCConnection;
import com.datapps.linkoopdb.jdbc.impl.JDBCPreparedStatement;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import com.datapps.linkoopdb.jdbc.lib.IntValueHashMap;
import com.datapps.linkoopdb.jdbc.types.BinaryData;
import com.datapps.linkoopdb.jdbc.types.BlobDataID;
import com.datapps.linkoopdb.jdbc.types.ClobDataID;
import com.datapps.linkoopdb.jdbc.types.DateTimeType;
import com.datapps.linkoopdb.jdbc.types.IntervalMonthData;
import com.datapps.linkoopdb.jdbc.types.IntervalSecondData;
import com.datapps.linkoopdb.jdbc.types.JavaObjectData;
import com.datapps.linkoopdb.jdbc.types.TimeData;
import com.datapps.linkoopdb.jdbc.types.TimestampData;
import com.datapps.linkoopdb.jdbc.types.Type;
import com.datapps.linkoopdb.jdbc.types.Types;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public class JDBCCallableStatement
extends JDBCPreparedStatement
implements CallableStatement {
    private IntValueHashMap parameterNameMap = new IntValueHashMap();
    private boolean wasNullValue;

    public JDBCCallableStatement(JDBCConnection c, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws LdbSqlException, SQLException {
        super(c, sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
        if (this.parameterMetaData != null) {
            String[] names = this.parameterMetaData.columnLabels;
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (name == null || name.length() == 0) continue;
                this.parameterNameMap.put(name, i);
            }
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        if (this.parameterModes[--parameterIndex] == 1) {
            throw JDBCUtil.invalidArgument();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.wasNullValue;
    }

    @Override
    public synchronized String getString(int parameterIndex) throws SQLException {
        return (String)this.getColumnInType(parameterIndex, Type.SQL_VARCHAR);
    }

    @Override
    public synchronized boolean getBoolean(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_BOOLEAN);
        return o == null ? false : (Boolean)o;
    }

    @Override
    public synchronized byte getByte(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.TINYINT);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    @Override
    public synchronized short getShort(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_SMALLINT);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    @Override
    public synchronized int getInt(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_INTEGER);
        return o == null ? 0 : ((Number)o).intValue();
    }

    @Override
    public synchronized long getLong(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_BIGINT);
        return o == null ? 0L : ((Number)o).longValue();
    }

    @Override
    public synchronized float getFloat(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    @Override
    public synchronized double getDouble(int parameterIndex) throws SQLException {
        Object o = this.getColumnInType(parameterIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (scale < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bd = this.getBigDecimal(parameterIndex);
        if (bd != null) {
            bd = bd.setScale(scale, 1);
        }
        return bd;
    }

    @Override
    public synchronized byte[] getBytes(int parameterIndex) throws SQLException {
        Object x = this.getColumnInType(parameterIndex, Type.SQL_VARBINARY);
        if (x == null) {
            return null;
        }
        return ((BinaryData)x).getBytes();
    }

    @Override
    public synchronized Date getDate(int parameterIndex) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(parameterIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, t);
    }

    @Override
    public synchronized Time getTime(int parameterIndex) throws SQLException {
        TimeData t = (TimeData)this.getColumnInType(parameterIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, t);
    }

    @Override
    public synchronized Timestamp getTimestamp(int parameterIndex) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(parameterIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, t);
    }

    @Override
    public synchronized Object getObject(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type sourceType = this.parameterTypes[parameterIndex - 1];
        switch (sourceType.typeCode) {
            case 50: {
                return this.getArray(parameterIndex);
            }
            case 91: {
                return this.getDate(parameterIndex);
            }
            case 92: {
                return this.getTime(parameterIndex);
            }
            case 94: {
                return this.getTimeWithZone(parameterIndex);
            }
            case 93: {
                return this.getTimestamp(parameterIndex);
            }
            case 95: {
                return this.getTimestampWithZone(parameterIndex);
            }
            case 60: 
            case 61: {
                return this.getBytes(parameterIndex);
            }
            case 14: {
                boolean b = this.getBoolean(parameterIndex);
                return this.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
            }
            case 40: {
                return this.getClob(parameterIndex);
            }
            case 30: {
                return this.getBlob(parameterIndex);
            }
            case 1111: 
            case 2000: {
                Object o = this.getColumnInType(parameterIndex, sourceType);
                if (o == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)o).getObject();
                }
                catch (LdbSqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
            }
        }
        return this.getColumnInType(parameterIndex, sourceType);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Type targetType = this.parameterMetaData.columnTypes[parameterIndex - 1];
        switch (targetType.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                targetType = Type.SQL_DECIMAL;
                break;
            }
            default: {
                targetType = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(parameterIndex, targetType);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw JDBCUtil.notSupported();
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Blob getBlob(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type sourceType = this.parameterMetaData.columnTypes[parameterIndex - 1];
        Object o = this.getColumnInType(parameterIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof BlobDataID) {
            return new JDBCBlobClient(this.session, (BlobDataID)o);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Clob getClob(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type sourceType = this.parameterMetaData.columnTypes[parameterIndex - 1];
        Object o = this.getColumnInType(parameterIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof ClobDataID) {
            return new JDBCClobClient(this.session, (ClobDataID)o);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type type = this.parameterMetaData.columnTypes[parameterIndex - 1];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        Object[] data = (Object[])this.parameterValues[parameterIndex - 1];
        if (data == null) {
            return null;
        }
        return new JDBCArray(data, type.collectionBaseType(), type, this.connection);
    }

    @Override
    public synchronized Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(parameterIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        long millis = t.getSeconds() * 1000L;
        if (cal != null) {
            millis = HsqlDateTime.convertMillisToCalendar(cal, millis);
        }
        return new Date(millis);
    }

    @Override
    public synchronized Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        TimeData t = (TimeData)this.getColumnInType(parameterIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        long millis = (long)DateTimeType.normaliseTime(t.getSeconds()) * 1000L;
        if (!this.parameterMetaData.columnTypes[--parameterIndex].isDateTimeTypeWithZone()) {
            Calendar calendar = cal == null ? this.session.getCalendar() : cal;
            millis = HsqlDateTime.convertMillisToCalendar(calendar, millis);
            millis = HsqlDateTime.getNormalisedTime(millis);
        }
        return new Time(millis);
    }

    @Override
    public synchronized Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(parameterIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        long millis = t.getSeconds() * 1000L;
        if (!this.parameterMetaData.columnTypes[--parameterIndex].isDateTimeTypeWithZone()) {
            Calendar calendar;
            Calendar calendar2 = calendar = cal == null ? this.session.getCalendar() : cal;
            if (cal != null) {
                millis = HsqlDateTime.convertMillisToCalendar(calendar, millis);
            }
        }
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(t.getNanos());
        return ts;
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw JDBCUtil.notSupported();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.findParameterIndex(parameterName), val);
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public synchronized void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParameterIndex(parameterName), x, length);
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParameterIndex(parameterName), x, length);
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x, targetSqlType, scale);
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x, targetSqlType);
    }

    @Override
    public synchronized void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.findParameterIndex(parameterName), reader, length);
    }

    @Override
    public synchronized void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public synchronized void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameterIndex(parameterName), x, cal);
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.findParameterIndex(parameterName), sqlType, typeName);
    }

    @Override
    public synchronized String getString(String parameterName) throws SQLException {
        return this.getString(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized short getShort(String parameterName) throws SQLException {
        return this.getShort(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized int getInt(String parameterName) throws SQLException {
        return this.getInt(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized long getLong(String parameterName) throws SQLException {
        return this.getLong(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName), map);
    }

    @Override
    public synchronized Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public synchronized Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(parameterName), cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.findParameterIndex(parameterName));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized RowId getRowId(String parameterName) throws SQLException {
        return this.getRowId(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized void setRowId(String parameterName, RowId x) throws SQLException {
        super.setRowId(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setNString(String parameterName, String value) throws SQLException {
        super.setNString(this.findParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        super.setNCharacterStream(this.findParameterIndex(parameterName), value, length);
    }

    @Override
    public synchronized void setNClob(String parameterName, NClob value) throws SQLException {
        super.setNClob(this.findParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setClob(String parameterName, Reader reader, long length) throws SQLException {
        super.setClob(this.findParameterIndex(parameterName), reader, length);
    }

    @Override
    public synchronized void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        super.setBlob(this.findParameterIndex(parameterName), inputStream, length);
    }

    @Override
    public synchronized void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        super.setNClob(this.findParameterIndex(parameterName), reader, length);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        super.setSQLXML(this.findParameterIndex(parameterName), xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getSQLXML(this.findParameterIndex(parameterName));
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized String getNString(String parameterName) throws SQLException {
        return this.getNString(this.findParameterIndex(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.findParameterIndex(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.checkGetParameterIndex(parameterIndex);
        Type sourceType = this.parameterMetaData.columnTypes[parameterIndex - 1];
        Object o = this.getColumnInType(parameterIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof ClobDataID) {
            return ((ClobDataID)o).getCharacterStream(this.session);
        }
        if (o instanceof Clob) {
            return ((Clob)o).getCharacterStream();
        }
        if (o instanceof String) {
            return new StringReader((String)o);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.findParameterIndex(parameterName));
    }

    @Override
    public synchronized void setBlob(String parameterName, Blob x) throws SQLException {
        super.setBlob(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setClob(String parameterName, Clob x) throws SQLException {
        super.setClob(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            String msg = "Maximum ASCII input octet length exceeded: " + length;
            throw JDBCUtil.sqlException(422, msg);
        }
        this.setAsciiStream(parameterName, x, (int)length);
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            String msg = "Maximum Binary input octet length exceeded: " + length;
            throw JDBCUtil.sqlException(422, msg);
        }
        this.setBinaryStream(parameterName, x, (int)length);
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            String msg = "Maximum character input length exceeded: " + length;
            throw JDBCUtil.sqlException(422, msg);
        }
        this.setCharacterStream(parameterName, reader, (int)length);
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        super.setAsciiStream(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        super.setBinaryStream(this.findParameterIndex(parameterName), x);
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        super.setCharacterStream(this.findParameterIndex(parameterName), reader);
    }

    @Override
    public synchronized void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        super.setNCharacterStream(this.findParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setClob(String parameterName, Reader reader) throws SQLException {
        super.setClob(this.findParameterIndex(parameterName), reader);
    }

    @Override
    public synchronized void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        super.setBlob(this.findParameterIndex(parameterName), inputStream);
    }

    @Override
    public synchronized void setNClob(String parameterName, Reader reader) throws SQLException {
        super.setNClob(this.findParameterIndex(parameterName), reader);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw JDBCUtil.nullArgument();
        }
        Type hsqlType = Types.getParameterSQLType(type);
        if (hsqlType == null) {
            throw JDBCUtil.sqlException(Error.error(5561));
        }
        if (this.wasNullValue) {
            return null;
        }
        Object o = null;
        switch (type.getName()) {
            case "int": 
            case "java.lang.Integer": {
                o = this.getInt(parameterIndex);
                break;
            }
            case "double": 
            case "java.lang.Double": {
                o = this.getDouble(parameterIndex);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                o = this.getBoolean(parameterIndex);
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                o = this.getByte(parameterIndex);
                break;
            }
            case "short": 
            case "java.lang.Short": {
                o = this.getShort(parameterIndex);
                break;
            }
            case "long": 
            case "java.lang.Long": {
                o = this.getLong(parameterIndex);
                break;
            }
            case "[B": {
                o = this.getBytes(parameterIndex);
                break;
            }
            case "java.lang.Object": {
                o = this.getObject(parameterIndex);
                break;
            }
            case "java.math.BigDecimal": {
                o = this.getBigDecimal(parameterIndex);
                break;
            }
            case "java.sql.Blob": {
                o = this.getBlob(parameterIndex);
                break;
            }
            case "java.sql.Clob": {
                o = this.getClob(parameterIndex);
                break;
            }
            case "java.lang.String": 
            case "java.lang.CharSequence": {
                o = this.getString(parameterIndex);
                break;
            }
            case "java.sql.Date": {
                o = this.getDate(parameterIndex);
                break;
            }
            case "java.sql.Time": {
                o = this.getTime(parameterIndex);
                break;
            }
            case "java.sql.Timestamp": {
                o = this.getTimestamp(parameterIndex);
                break;
            }
            case "java.util.UUID": {
                Object source = this.getColumnInType(parameterIndex, hsqlType);
                o = Type.SQL_GUID.convertSQLToJava(this.session, source);
                break;
            }
            case "java.time.LocalDate": {
                Object source = this.getColumnInType(parameterIndex, hsqlType);
                TimestampData v = (TimestampData)source;
                long millis = v.getMillis();
                Calendar cal = this.session.getCalendarGMT();
                cal.setTimeInMillis(millis);
                o = LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
                break;
            }
            case "java.time.LocalTime": {
                Object source = this.getColumnInType(parameterIndex, hsqlType);
                TimeData v = (TimeData)source;
                o = LocalTime.ofNanoOfDay((long)v.getSeconds() * 1000000000L + (long)v.getNanos());
                break;
            }
            case "java.time.LocalDateTime": {
                Object source = this.getColumnInType(parameterIndex, hsqlType);
                TimestampData v = (TimestampData)source;
                o = LocalDateTime.ofEpochSecond(v.getSeconds(), v.getNanos(), ZoneOffset.UTC);
                break;
            }
            case "java.time.OffsetTime": {
                o = this.getTimeWithZone(parameterIndex);
                break;
            }
            case "java.time.OffsetDateTime": {
                o = this.getTimestampWithZone(parameterIndex);
                break;
            }
            case "java.time.Duration": {
                Type sourceType = this.parameterMetaData.columnTypes[parameterIndex - 1];
                if (!sourceType.isIntervalDaySecondType()) break;
                Object source = this.getColumnInType(parameterIndex, hsqlType);
                IntervalSecondData v = (IntervalSecondData)source;
                o = Duration.ofSeconds(v.getSeconds(), v.getNanos());
                break;
            }
            case "java.time.Period": {
                Type sourceType = this.parameterMetaData.columnTypes[parameterIndex - 1];
                if (!sourceType.isIntervalYearMonthType()) break;
                Object source = this.getColumnInType(parameterIndex, hsqlType);
                IntervalMonthData v = (IntervalMonthData)source;
                int months = v.getMonths();
                if (sourceType.typeCode == 102) {
                    o = Period.ofMonths(months);
                    break;
                }
                o = Period.of(months / 12, months % 12, 0);
                break;
            }
        }
        if (o == null) {
            throw JDBCUtil.sqlException(Error.error(5561));
        }
        return (T)o;
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName), type);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterName, x, (int)targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterName, x, (int)targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    void fetchResult() throws SQLException {
        super.fetchResult();
        if (this.resultIn.getType() == 43) {
            Object[] data = this.resultIn.getParameterData();
            for (int i = 0; i < this.parameterValues.length; ++i) {
                this.parameterValues[i] = data[i];
            }
        }
    }

    int findParameterIndex(String parameterName) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (parameterName == null) {
            throw JDBCUtil.nullArgument();
        }
        int index = this.parameterNameMap.get((Object)parameterName, -1);
        if (index >= 0) {
            return index + 1;
        }
        index = this.parameterNameMap.get((Object)parameterName.toUpperCase(Locale.ENGLISH), -1);
        if (index >= 0) {
            return index + 1;
        }
        throw JDBCUtil.sqlException(421, parameterName);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    private Object getColumnInType(int columnIndex, Type targetType) throws SQLException {
        this.checkGetParameterIndex(columnIndex);
        Type sourceType = this.parameterTypes[--columnIndex];
        Object value = this.parameterValues[columnIndex];
        if (this.trackNull(value)) {
            return null;
        }
        if (sourceType.typeCode != targetType.typeCode) {
            try {
                value = targetType.convertToTypeJDBC(this.session, value, sourceType);
            }
            catch (LdbSqlException e) {
                String stringValue = value instanceof Number || value instanceof String || value instanceof java.util.Date ? value.toString() : "instance of " + value.getClass().getName();
                String msg = "from SQL type " + sourceType.getNameString() + " to " + targetType.getJDBCClassName() + ", value: " + stringValue;
                LdbSqlException err = Error.error(5561, msg);
                throw JDBCUtil.sqlException(err, e);
            }
        }
        return value;
    }

    private Object getTimestampWithZone(int columnIndex) throws SQLException {
        TimestampData v = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
        if (v == null) {
            return null;
        }
        ZoneOffset z = ZoneOffset.ofTotalSeconds(v.getZone());
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(v.getSeconds(), v.getNanos(), z);
        return OffsetDateTime.of(ldt, z);
    }

    private Object getTimeWithZone(int columnIndex) throws SQLException {
        TimeData v = (TimeData)this.getColumnInType(columnIndex, Type.SQL_TIME_WITH_TIME_ZONE);
        if (v == null) {
            return null;
        }
        ZoneOffset z = ZoneOffset.ofTotalSeconds(v.getZone());
        LocalTime lt = LocalTime.ofNanoOfDay((long)(v.getSeconds() + v.getZone()) * 1000000000L + (long)v.getNanos());
        return OffsetTime.of(lt, z);
    }

    private boolean trackNull(Object o) {
        this.wasNullValue = o == null;
        return this.wasNullValue;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        this.fetchResult();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs;
        }
        if (this.getMoreResults()) {
            return this.getResultSet();
        }
        throw JDBCUtil.sqlException(1254);
    }
}

