/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.SchemaObject;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.lib.OrderedHashSet;
import com.datapps.linkoopdb.jdbc.rights.Grantee;

public class Charset
implements SchemaObject {
    public static final int[][] uppercaseLetters = new int[][]{{65, 90}};
    public static final int[][] unquotedIdentifier = new int[][]{{48, 57}, {65, 90}, {95, 95}};
    public static final int[][] basicIdentifier = new int[][]{{48, 57}, {65, 90}, {95, 95}, {97, 122}};
    public static final Charset SQL_TEXT;
    public static final Charset SQL_IDENTIFIER_CHARSET;
    public static final Charset SQL_CHARACTER;
    public static final Charset ASCII_GRAPHIC;
    public static final Charset GRAPHIC_IRV;
    public static final Charset ASCII_FULL;
    public static final Charset ISO8BIT;
    public static final Charset LATIN1;
    public static final Charset UTF32;
    public static final Charset UTF16;
    public static final Charset UTF8;
    public LdbSqlNameManager.LdbSqlName base;
    LdbSqlNameManager.LdbSqlName name;
    int[][] ranges;

    public Charset(LdbSqlNameManager.LdbSqlName name) {
        this.name = name;
    }

    public static boolean isInSet(String value, int[][] ranges) {
        int length = value.length();
        block0: for (int index = 0; index < length; ++index) {
            char ch = value.charAt(index);
            for (int i = 0; i < ranges.length; ++i) {
                if (ch > ranges[i][1]) continue;
                if (ch >= ranges[i][0]) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean startsWith(String value, int[][] ranges) {
        char ch = value.charAt(0);
        for (int i = 0; i < ranges.length; ++i) {
            if (ch > ranges[i][1]) continue;
            return ch >= ranges[i][0];
        }
        return false;
    }

    public static Charset getDefaultInstance() {
        return SQL_TEXT;
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getName() {
        return this.name;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        set.add(this.base);
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(SessionInterface session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("CHARACTER").append(' ').append("SET").append(' ');
        if ("INFORMATION_SCHEMA".equals(this.name.schema.name)) {
            sb.append(this.name.getStatementName());
        } else {
            sb.append(this.name.getSchemaQualifiedStatementName());
        }
        if (this.base != null) {
            sb.append(' ').append("AS").append(' ').append("GET");
            sb.append(' ');
            if ("INFORMATION_SCHEMA".equals(this.base.schema.name)) {
                sb.append(this.base.getStatementName());
            } else {
                sb.append(this.base.getSchemaQualifiedStatementName());
            }
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    static {
        LdbSqlNameManager.LdbSqlName name = LdbSqlNameManager.newInfoSchemaObjectName("SQL_TEXT", false, 14);
        SQL_TEXT = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("SQL_IDENTIFIER", false, 14);
        SQL_IDENTIFIER_CHARSET = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("SQL_CHARACTER", false, 14);
        SQL_CHARACTER = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("LATIN1", false, 14);
        LATIN1 = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("ASCII_GRAPHIC", false, 14);
        ASCII_GRAPHIC = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("GRAPHIC_IRV", false, 14);
        GRAPHIC_IRV = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("ASCII_FULL", false, 14);
        ASCII_FULL = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("ISO8BIT", false, 14);
        ISO8BIT = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("UTF32", false, 14);
        UTF32 = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("UTF16", false, 14);
        UTF16 = new Charset(name);
        name = LdbSqlNameManager.newInfoSchemaObjectName("UTF8", false, 14);
        UTF8 = new Charset(name);
    }
}

