/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.impl.JDBCConnection;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import java.sql.SQLException;
import java.sql.Savepoint;

public class JDBCSavepoint
implements Savepoint {
    int id;
    String name;
    JDBCConnection connection;

    JDBCSavepoint(String name, JDBCConnection conn) throws SQLException {
        if (name == null) {
            throw JDBCUtil.nullArgument("name");
        }
        if (conn == null) {
            throw JDBCUtil.nullArgument("conn");
        }
        this.name = name;
        this.id = -1;
        this.connection = conn;
    }

    JDBCSavepoint(JDBCConnection conn) throws SQLException {
        if (conn == null) {
            throw JDBCUtil.nullArgument("conn");
        }
        this.id = conn.getSavepointID();
        this.name = "SYSTEM_SAVEPOINT_" + this.id;
        this.connection = conn;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.id != -1) {
            return this.id;
        }
        throw JDBCUtil.notSupported();
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.id == -1) {
            return this.name;
        }
        throw JDBCUtil.notSupported();
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

