/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td1;

import com.teradata.tdgss.jgssp2td1.Td1Mechanism;
import com.teradata.tdgss.jgssp2td1.Td1MinorStatus;
import com.teradata.tdgss.jgssp2td1.Td1Name;
import com.teradata.tdgss.jtdgss.TdgssException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class Td1Credential
implements GSSCredential {
    private Td1Name name;
    private int initLifetime;
    private int acceptLifetime;
    private int usage;
    private long initEnd;
    private long acceptEnd;
    private boolean indefiniteInit = false;
    private boolean indefiniteAccept = false;
    private boolean acceptOnly = false;
    private boolean initOnly = false;
    private char[] password;

    public Td1Credential(Td1Name td1Name, int n, int n2) throws GSSException {
        this.name = td1Name == null ? new Td1Name(null, null) : td1Name;
        long l = System.currentTimeMillis();
        this.usage = n2;
        if (this.usage != 2) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteInit = true;
            } else {
                this.initLifetime = n;
                this.initEnd = l + (long)this.initLifetime;
            }
        } else {
            this.acceptOnly = true;
        }
        if (n2 != 1) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteAccept = true;
            } else {
                this.acceptLifetime = n;
                this.acceptEnd = l + (long)this.acceptLifetime;
            }
        } else {
            this.initOnly = true;
        }
        if (n2 != 2) {
            this.password = "dummypassword".toCharArray();
        }
    }

    public void dispose() throws GSSException {
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
        this.password = null;
    }

    public GSSName getName() throws GSSException {
        return this.name;
    }

    public GSSName getName(Oid oid) throws GSSException {
        if (oid != Td1Mechanism.mechOid) {
            throw new TdgssException(2, Td1MinorStatus.TD1_ERR_INVALID_ARGUMENT);
        }
        return this.name;
    }

    public int getRemainingLifetime() throws GSSException {
        int n;
        if (this.initOnly) {
            return this.getRemainingInitLifetime(Td1Mechanism.mechOid);
        }
        if (this.acceptOnly) {
            return this.getRemainingAcceptLifetime(Td1Mechanism.mechOid);
        }
        int n2 = this.getRemainingAcceptLifetime(Td1Mechanism.mechOid);
        return n2 < (n = this.getRemainingInitLifetime(Td1Mechanism.mechOid)) ? n2 : n;
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (oid != Td1Mechanism.mechOid) {
            throw new TdgssException(2, Td1MinorStatus.TD1_ERR_INVALID_ARGUMENT);
        }
        if (this.acceptOnly) {
            return 0;
        }
        if (this.indefiniteInit) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.initEnd);
        return n < 0 ? 0 : n;
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (oid != Td1Mechanism.mechOid) {
            throw new TdgssException(2, Td1MinorStatus.TD1_ERR_INVALID_ARGUMENT);
        }
        if (this.initOnly) {
            return 0;
        }
        if (this.indefiniteAccept) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.acceptEnd);
        return n < 0 ? 0 : n;
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid oid) throws GSSException {
        if (oid != Td1Mechanism.mechOid) {
            throw new TdgssException(2, Td1MinorStatus.TD1_ERR_INVALID_ARGUMENT);
        }
        return this.usage;
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{Td1Mechanism.mechOid};
        return oidArray;
    }

    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        throw new TdgssException(16, Td1MinorStatus.TD1_ERR_API_NOT_SUPPORTED);
    }

    public boolean equals(Object object) {
        try {
            GSSCredential gSSCredential = (GSSCredential)object;
            if (gSSCredential == null) {
                return false;
            }
            if (!gSSCredential.getName().equals(this.name)) {
                return false;
            }
            Oid[] oidArray = gSSCredential.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (gSSCredential.getUsage(oidArray[i]) != this.getUsage(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingAcceptLifetime(oidArray[i]) != this.getRemainingAcceptLifetime(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingInitLifetime(oidArray[i]) == this.getRemainingInitLifetime(oidArray[i])) continue;
                return false;
            }
        }
        catch (GSSException gSSException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    protected char[] getPassword() {
        return this.password;
    }
}

