/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityCorrelator;
import com.microsoft.sqlserver.jdbc.ActivityId;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.GregorianChange;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.Nanos;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import com.microsoft.sqlserver.jdbc.SQLServerSortOrder;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSType;
import com.microsoft.sqlserver.jdbc.TVP;
import com.microsoft.sqlserver.jdbc.UTC;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import microsoft.sql.DateTimeOffset;

final class TDSWriter {
    private static Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Writer");
    private final String traceID;
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private boolean dataIsLoggable = true;
    private TDSCommand command = null;
    private byte tdsMessageType;
    private volatile int sendResetConnection = 0;
    private int currentPacketSize = 0;
    private static final int TDS_PACKET_HEADER_SIZE = 8;
    private static final byte[] placeholderHeader = new byte[8];
    private byte[] valueBytes = new byte[256];
    private volatile int packetNum = 0;
    private static final int BYTES4 = 4;
    private static final int BYTES8 = 8;
    private static final int BYTES12 = 12;
    private static final int BYTES16 = 16;
    public static final int BIGDECIMAL_MAX_LENGTH = 17;
    private boolean isEOMSent = false;
    private ByteBuffer stagingBuffer;
    private ByteBuffer socketBuffer;
    private ByteBuffer logBuffer;
    private CryptoMetadata cryptoMeta = null;

    public final String toString() {
        return this.traceID;
    }

    void setDataLoggable(boolean bl) {
        this.dataIsLoggable = bl;
    }

    boolean isEOMSent() {
        return this.isEOMSent;
    }

    TDSWriter(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection) {
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
        this.traceID = "TDSWriter@" + Integer.toHexString(this.hashCode()) + " (" + sQLServerConnection.toString() + ")";
    }

    void preparePacket() throws SQLServerException {
        if (this.tdsChannel.isLoggingPackets()) {
            Arrays.fill(this.logBuffer.array(), (byte)-2);
            this.logBuffer.clear();
        }
        this.writeBytes(placeholderHeader);
    }

    void writeMessageHeader() throws SQLServerException {
        if (1 == this.tdsMessageType || 14 == this.tdsMessageType || 3 == this.tdsMessageType) {
            boolean bl = false;
            int n = 22;
            if ((1 == this.tdsMessageType || 3 == this.tdsMessageType) && this.con.isDenaliOrLater() && !ActivityCorrelator.getCurrent().IsSentToServer() && Util.IsActivityTraceOn()) {
                bl = true;
                n += 26;
            }
            this.writeInt(n);
            this.writeInt(18);
            this.writeShort((short)2);
            this.writeBytes(this.con.getTransactionDescriptor());
            this.writeInt(1);
            if (bl) {
                this.writeInt(26);
                this.writeTraceHeaderData();
                ActivityCorrelator.setCurrentActivityIdSentFlag();
            }
        }
    }

    void writeTraceHeaderData() throws SQLServerException {
        ActivityId activityId = ActivityCorrelator.getCurrent();
        byte[] byArray = Util.asGuidByteArray(activityId.getId());
        long l = activityId.getSequence();
        this.writeShort((short)3);
        this.writeBytes(byArray, 0, byArray.length);
        this.writeInt((int)l);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Send Trace Header - ActivityID: " + activityId.toString());
        }
    }

    void startMessage(TDSCommand tDSCommand, byte by) throws SQLServerException {
        this.command = tDSCommand;
        this.tdsMessageType = by;
        this.packetNum = 0;
        this.isEOMSent = false;
        this.dataIsLoggable = true;
        int n = this.con.getTDSPacketSize();
        if (this.currentPacketSize != n) {
            this.socketBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.stagingBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.logBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.currentPacketSize = n;
        }
        this.socketBuffer.position(this.socketBuffer.limit());
        this.stagingBuffer.clear();
        this.preparePacket();
        this.writeMessageHeader();
    }

    final void endMessage() throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Finishing TDS message");
        }
        this.writePacket(1);
    }

    final boolean ignoreMessage() throws SQLServerException {
        if (this.packetNum > 0) {
            assert (!this.isEOMSent);
            if (logger.isLoggable(Level.FINER)) {
                logger.finest(this.toString() + " Finishing TDS message by sending ignore bit and end of message");
            }
            this.writePacket(3);
            return true;
        }
        return false;
    }

    final void resetPooledConnection() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " resetPooledConnection");
        }
        this.sendResetConnection = 8;
    }

    void writeByte(byte by) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put(by);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(by);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = by;
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeChar(char c) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putChar(c);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putChar(c);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort((short)c, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeShort(short s) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putShort(s);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putShort(s);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort(s, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeInt(int n) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 4) {
            this.stagingBuffer.putInt(n);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putInt(n);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 4);
                }
            }
        } else {
            Util.writeInt(n, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 4);
        }
    }

    void writeReal(Float f) throws SQLServerException {
        this.writeInt(Float.floatToRawIntBits(f.floatValue()));
    }

    void writeDouble(double d) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 8) {
            this.stagingBuffer.putDouble(d);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putDouble(d);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 8);
                }
            }
        } else {
            long l = Double.doubleToLongBits(d);
            long l2 = 255L;
            int n = 0;
            for (int i = 0; i < 8; ++i) {
                this.writeByte((byte)((l & l2) >> n));
                n += 8;
                l2 <<= 8;
            }
        }
    }

    void writeBigDecimal(BigDecimal bigDecimal, int n, int n2) throws SQLServerException {
        boolean bl = bigDecimal.signum() < 0;
        BigInteger bigInteger = bigDecimal.unscaledValue();
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        if (9 >= n2) {
            this.writeByte((byte)5);
            this.writeByte((byte)(!bl ? 1 : 0));
            this.writeInt(bigInteger.intValue());
        } else if (19 >= n2) {
            this.writeByte((byte)9);
            this.writeByte((byte)(!bl ? 1 : 0));
            this.writeLong(bigInteger.longValue());
        } else {
            int n3 = 28 >= n2 ? 12 : 16;
            this.writeByte((byte)(n3 + 1));
            this.writeByte((byte)(!bl ? 1 : 0));
            byte[] byArray = bigInteger.toByteArray();
            if (byArray.length > n3) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
                Object[] objectArray = new Object[]{JDBCType.of(n)};
                throw new SQLServerException(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_LENGTH_MISMATCH, DriverError.NOT_SET, null);
            }
            byte[] byArray2 = new byte[n3];
            int n4 = n3 - byArray.length;
            int n5 = 0;
            int n6 = byArray.length - 1;
            while (n5 < byArray.length) {
                byArray2[n5++] = byArray[n6--];
            }
            while (n5 < n4) {
                byArray2[n5] = 0;
                ++n5;
            }
            this.writeBytes(byArray2);
        }
    }

    void writeSmalldatetime(String string) throws SQLServerException {
        GregorianCalendar gregorianCalendar = this.initializeCalender(TimeZone.getDefault());
        long l = 0L;
        Timestamp timestamp = Timestamp.valueOf(string);
        l = timestamp.getTime();
        gregorianCalendar.setTimeInMillis(l);
        int n = DDC.daysSinceBaseDate(gregorianCalendar.get(1), gregorianCalendar.get(6), 1900);
        int n2 = 1000 * gregorianCalendar.get(13) + 60000 * gregorianCalendar.get(12) + 3600000 * gregorianCalendar.get(11);
        if (86399999 <= n2) {
            ++n;
            n2 = 0;
        }
        this.writeShort((short)n);
        int n3 = n2 / 1000;
        int n4 = n3 / 60;
        n4 = (double)(n3 % 60) > 29.998 ? n4 + 1 : n4;
        this.writeShort((short)n4);
    }

    void writeDatetime(String string) throws SQLServerException {
        GregorianCalendar gregorianCalendar = this.initializeCalender(TimeZone.getDefault());
        long l = 0L;
        int n = 0;
        Timestamp timestamp = Timestamp.valueOf(string);
        l = timestamp.getTime();
        n = timestamp.getNanos();
        gregorianCalendar.setTimeInMillis(l);
        int n2 = DDC.daysSinceBaseDate(gregorianCalendar.get(1), gregorianCalendar.get(6), 1900);
        int n3 = (n + 500000) / 1000000 + 1000 * gregorianCalendar.get(13) + 60000 * gregorianCalendar.get(12) + 3600000 * gregorianCalendar.get(11);
        if (86399999 <= n3) {
            ++n2;
            n3 = 0;
        }
        if (n2 < DDC.daysSinceBaseDate(1753, 1, 1900) || n2 >= DDC.daysSinceBaseDate(10000, 1, 1900)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
            Object[] objectArray = new Object[]{SSType.DATETIME};
            throw new SQLServerException(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, DriverError.NOT_SET, null);
        }
        this.writeInt(n2);
        this.writeInt((3 * n3 + 5) / 10);
    }

    void writeDate(String string) throws SQLServerException {
        GregorianCalendar gregorianCalendar = this.initializeCalender(TimeZone.getDefault());
        long l = 0L;
        Date date = Date.valueOf(string);
        l = date.getTime();
        gregorianCalendar.setTimeInMillis(l);
        this.writeScaledTemporal(gregorianCalendar, 0, 0, SSType.DATE);
    }

    void writeTime(Timestamp timestamp, int n) throws SQLServerException {
        GregorianCalendar gregorianCalendar = this.initializeCalender(TimeZone.getDefault());
        long l = 0L;
        int n2 = 0;
        l = timestamp.getTime();
        n2 = timestamp.getNanos();
        gregorianCalendar.setTimeInMillis(l);
        this.writeScaledTemporal(gregorianCalendar, n2, n, SSType.TIME);
    }

    void writeDateTimeOffset(Object object, int n, SSType sSType) throws SQLServerException {
        GregorianCalendar gregorianCalendar = null;
        TimeZone timeZone = TimeZone.getDefault();
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        DateTimeOffset dateTimeOffset = (DateTimeOffset)object;
        l = dateTimeOffset.getTimestamp().getTime();
        n2 = dateTimeOffset.getTimestamp().getNanos();
        n3 = dateTimeOffset.getMinutesOffset();
        timeZone = SSType.DATETIMEOFFSET == sSType ? UTC.timeZone : new SimpleTimeZone(n3 * 60 * 1000, "");
        gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.setLenient(true);
        gregorianCalendar.clear();
        gregorianCalendar.setTimeInMillis(l);
        this.writeScaledTemporal(gregorianCalendar, n2, n, SSType.DATETIMEOFFSET);
        this.writeShort((short)n3);
    }

    void writeOffsetDateTimeWithTimezone(OffsetDateTime offsetDateTime, int n) throws SQLServerException {
        GregorianCalendar gregorianCalendar = null;
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = offsetDateTime.getOffset().getTotalSeconds() / 60;
        }
        catch (Exception exception) {
            throw new SQLServerException(SQLServerException.getErrString("R_zoneOffsetError"), null, 0, null);
        }
        n2 = offsetDateTime.getNano();
        for (int i = 9 - String.valueOf(n2).length(); i > 0; --i) {
            n2 *= 10;
        }
        TimeZone timeZone = UTC.timeZone;
        String string = String.format("%04d", offsetDateTime.getYear()) + '-' + offsetDateTime.getMonthValue() + '-' + offsetDateTime.getDayOfMonth() + ' ' + offsetDateTime.getHour() + ':' + offsetDateTime.getMinute() + ':' + offsetDateTime.getSecond();
        l = Timestamp.valueOf(string).getTime();
        gregorianCalendar = this.initializeCalender(timeZone);
        gregorianCalendar.setTimeInMillis(l);
        int n4 = TimeZone.getDefault().getRawOffset() / 60000;
        if (TimeZone.getDefault().inDaylightTime(gregorianCalendar.getTime())) {
            n4 += TimeZone.getDefault().getDSTSavings() / 60000;
        }
        gregorianCalendar.add(12, n4 += n4 < 0 ? n3 * -1 : n3);
        this.writeScaledTemporal(gregorianCalendar, n2, n, SSType.DATETIMEOFFSET);
        this.writeShort((short)n3);
    }

    void writeOffsetTimeWithTimezone(OffsetTime offsetTime, int n) throws SQLServerException {
        GregorianCalendar gregorianCalendar = null;
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = offsetTime.getOffset().getTotalSeconds() / 60;
        }
        catch (Exception exception) {
            throw new SQLServerException(SQLServerException.getErrString("R_zoneOffsetError"), null, 0, null);
        }
        n2 = offsetTime.getNano();
        for (int i = 9 - String.valueOf(n2).length(); i > 0; --i) {
            n2 *= 10;
        }
        TimeZone timeZone = UTC.timeZone;
        String string = "1900-01-01 " + offsetTime.getHour() + ':' + offsetTime.getMinute() + ':' + offsetTime.getSecond();
        l = Timestamp.valueOf(string).getTime();
        gregorianCalendar = this.initializeCalender(timeZone);
        gregorianCalendar.setTimeInMillis(l);
        int n4 = TimeZone.getDefault().getRawOffset() / 60000;
        if (TimeZone.getDefault().inDaylightTime(gregorianCalendar.getTime())) {
            n4 += TimeZone.getDefault().getDSTSavings() / 60000;
        }
        gregorianCalendar.add(12, n4 += n4 < 0 ? n3 * -1 : n3);
        this.writeScaledTemporal(gregorianCalendar, n2, n, SSType.DATETIMEOFFSET);
        this.writeShort((short)n3);
    }

    void writeLong(long l) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 8) {
            this.stagingBuffer.putLong(l);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putLong(l);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 8);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(l >> 0 & 0xFFL);
            this.valueBytes[1] = (byte)(l >> 8 & 0xFFL);
            this.valueBytes[2] = (byte)(l >> 16 & 0xFFL);
            this.valueBytes[3] = (byte)(l >> 24 & 0xFFL);
            this.valueBytes[4] = (byte)(l >> 32 & 0xFFL);
            this.valueBytes[5] = (byte)(l >> 40 & 0xFFL);
            this.valueBytes[6] = (byte)(l >> 48 & 0xFFL);
            this.valueBytes[7] = (byte)(l >> 56 & 0xFFL);
            this.writeWrappedBytes(this.valueBytes, 8);
        }
    }

    void writeBytes(byte[] byArray) throws SQLServerException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    void writeBytes(byte[] byArray, int n, int n2) throws SQLServerException {
        int n3;
        assert (n2 <= byArray.length);
        int n4 = 0;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Writing " + n2 + " bytes");
        }
        while ((n3 = n2 - n4) > 0) {
            if (0 == this.stagingBuffer.remaining()) {
                this.writePacket(0);
            }
            if (n3 > this.stagingBuffer.remaining()) {
                n3 = this.stagingBuffer.remaining();
            }
            this.stagingBuffer.put(byArray, n + n4, n3);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, n + n4, n3);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n3);
                }
            }
            n4 += n3;
        }
    }

    void writeWrappedBytes(byte[] byArray, int n) throws SQLServerException {
        assert (n <= byArray.length);
        assert (this.stagingBuffer.remaining() < n);
        assert (n <= this.stagingBuffer.capacity());
        int n2 = this.stagingBuffer.remaining();
        if (n2 > 0) {
            this.stagingBuffer.put(byArray, 0, n2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, 0, n2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n2);
                }
            }
        }
        this.writePacket(0);
        this.stagingBuffer.put(byArray, n2, n - n2);
        if (this.tdsChannel.isLoggingPackets()) {
            if (this.dataIsLoggable) {
                this.logBuffer.put(byArray, n2, n - n2);
            } else {
                this.logBuffer.position(this.logBuffer.position() + n2);
            }
        }
    }

    void writeString(String string) throws SQLServerException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = 2 * (n2 - n);
            if (n3 > this.valueBytes.length) {
                n3 = this.valueBytes.length;
            }
            int n4 = 0;
            while (n4 < n3) {
                char c = string.charAt(n++);
                this.valueBytes[n4++] = (byte)(c >> 0 & 0xFF);
                this.valueBytes[n4++] = (byte)(c >> 8 & 0xFF);
            }
            this.writeBytes(this.valueBytes, 0, n4);
        }
    }

    void writeStream(InputStream inputStream, long l, boolean bl) throws SQLServerException {
        MessageFormat messageFormat;
        Object[] objectArray;
        int n;
        assert (-1L == l || l >= 0L);
        long l2 = 0L;
        byte[] byArray = new byte[4 * this.currentPacketSize];
        int n2 = 0;
        do {
            for (n = 0; -1 != n2 && n < byArray.length; n += n2) {
                try {
                    n2 = inputStream.read(byArray, n, byArray.length - n);
                }
                catch (IOException iOException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray2 = new Object[]{iOException.toString()};
                    this.error(objectArray.format(objectArray2), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
                }
                if (-1 == n2) break;
                if (n2 >= 0 && n2 <= byArray.length - n) continue;
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
            }
            if (bl) {
                this.writeInt(n);
            }
            this.writeBytes(byArray, 0, n);
            l2 += (long)n;
        } while (-1 != n2 || n > 0);
        if (-1L != l && l2 != l) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            objectArray = new Object[]{l, l2};
            this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_LENGTH_MISMATCH, DriverError.NOT_SET);
        }
    }

    void writeNonUnicodeReader(Reader reader, long l, boolean bl, String string) throws SQLServerException {
        Object[] objectArray;
        int n;
        assert (-1L == l || l >= 0L);
        long l2 = 0L;
        char[] cArray = new char[this.currentPacketSize];
        byte[] byArray = new byte[this.currentPacketSize];
        int n2 = 0;
        do {
            for (n = 0; -1 != n2 && n < cArray.length; n += n2) {
                try {
                    n2 = reader.read(cArray, n, cArray.length - n);
                }
                catch (IOException iOException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray2 = new Object[]{iOException.toString()};
                    this.error(objectArray.format(objectArray2), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
                }
                if (-1 == n2) break;
                if (n2 >= 0 && n2 <= cArray.length - n) continue;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
            }
            if (!bl) {
                this.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        if (null == string) {
                            byArray[i] = (byte)(cArray[i] & 0xFF);
                            continue;
                        }
                        byArray[i] = new String(cArray[i] + "").getBytes(string)[0];
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_encodingErrorWritingTDS"), unsupportedEncodingException);
                    }
                }
                this.writeBytes(byArray, 0, n);
            } else {
                int n3 = n;
                if (0 != n) {
                    n3 = n / 2;
                }
                String string2 = new String(cArray);
                byte[] byArray2 = ParameterUtils.HexToBin(string2.trim());
                this.writeInt(n3);
                this.writeBytes(byArray2, 0, n3);
            }
            l2 += (long)n;
        } while (-1 != n2 || n > 0);
        if (-1L != l && l2 != l) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            objectArray = new Object[]{l, l2};
            this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_LENGTH_MISMATCH, DriverError.NOT_SET);
        }
    }

    void writeReader(Reader reader, long l, boolean bl) throws SQLServerException {
        Object[] objectArray;
        int n;
        assert (-1L == l || l >= 0L);
        long l2 = 0L;
        char[] cArray = new char[2 * this.currentPacketSize];
        byte[] byArray = new byte[4 * this.currentPacketSize];
        int n2 = 0;
        do {
            for (n = 0; -1 != n2 && n < cArray.length; n += n2) {
                try {
                    n2 = reader.read(cArray, n, cArray.length - n);
                }
                catch (IOException iOException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray2 = new Object[]{iOException.toString()};
                    this.error(objectArray.format(objectArray2), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
                }
                if (-1 == n2) break;
                if (n2 >= 0 && n2 <= cArray.length - n) continue;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET);
            }
            if (bl) {
                this.writeInt(2 * n);
            }
            for (int i = 0; i < n; ++i) {
                byArray[2 * i] = (byte)(cArray[i] >> 0 & 0xFF);
                byArray[2 * i + 1] = (byte)(cArray[i] >> 8 & 0xFF);
            }
            this.writeBytes(byArray, 0, 2 * n);
            l2 += (long)n;
        } while (-1 != n2 || n > 0);
        if (-1L != l && l2 != l) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            objectArray = new Object[]{l, l2};
            this.error(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_LENGTH_MISMATCH, DriverError.NOT_SET);
        }
    }

    GregorianCalendar initializeCalender(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = null;
        gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.setLenient(true);
        gregorianCalendar.clear();
        return gregorianCalendar;
    }

    final void error(String string, SQLState sQLState, DriverError driverError) throws SQLServerException {
        assert (null != this.command);
        this.command.interrupt(string);
        throw new SQLServerException(string, sQLState, driverError, null);
    }

    final boolean sendAttention() throws SQLServerException {
        if (this.packetNum > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": sending attention...");
            }
            ++this.tdsChannel.numMsgsSent;
            this.startMessage(this.command, (byte)6);
            this.endMessage();
            return true;
        }
        return false;
    }

    private final void writePacket(int n) throws SQLServerException {
        boolean bl;
        boolean bl2 = 1 == (1 & n);
        boolean bl3 = bl = 6 == this.tdsMessageType || (n & 2) == 2;
        if (null != this.command && !bl) {
            this.command.checkForInterrupt();
        }
        this.writePacketHeader(n | this.sendResetConnection);
        this.sendResetConnection = 0;
        this.flush(bl2);
        if (bl2) {
            this.flush(bl2);
            this.isEOMSent = true;
            ++this.tdsChannel.numMsgsSent;
        }
        if (16 == this.tdsMessageType && 1 == this.packetNum && 0 == this.con.getNegotiatedEncryptionLevel()) {
            this.tdsChannel.disableSSL();
        }
        if (null != this.command && !bl && bl2) {
            this.command.onRequestComplete();
        }
    }

    private final void writePacketHeader(int n) {
        int n2 = this.stagingBuffer.position();
        ++this.packetNum;
        this.stagingBuffer.put(0, this.tdsMessageType);
        this.stagingBuffer.put(1, (byte)n);
        this.stagingBuffer.put(2, (byte)(n2 >> 8 & 0xFF));
        this.stagingBuffer.put(3, (byte)(n2 >> 0 & 0xFF));
        this.stagingBuffer.put(4, (byte)(this.tdsChannel.getSPID() >> 8 & 0xFF));
        this.stagingBuffer.put(5, (byte)(this.tdsChannel.getSPID() >> 0 & 0xFF));
        this.stagingBuffer.put(6, (byte)(this.packetNum % 256));
        this.stagingBuffer.put(7, (byte)0);
        if (this.tdsChannel.isLoggingPackets()) {
            this.logBuffer.put(0, this.tdsMessageType);
            this.logBuffer.put(1, (byte)n);
            this.logBuffer.put(2, (byte)(n2 >> 8 & 0xFF));
            this.logBuffer.put(3, (byte)(n2 >> 0 & 0xFF));
            this.logBuffer.put(4, (byte)(this.tdsChannel.getSPID() >> 8 & 0xFF));
            this.logBuffer.put(5, (byte)(this.tdsChannel.getSPID() >> 0 & 0xFF));
            this.logBuffer.put(6, (byte)(this.packetNum % 256));
            this.logBuffer.put(7, (byte)0);
        }
    }

    void flush(boolean bl) throws SQLServerException {
        this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
        this.socketBuffer.position(this.socketBuffer.limit());
        if (this.stagingBuffer.position() >= 8) {
            ByteBuffer byteBuffer = this.stagingBuffer;
            this.stagingBuffer = this.socketBuffer;
            this.socketBuffer = byteBuffer;
            this.socketBuffer.flip();
            this.stagingBuffer.clear();
            if (this.tdsChannel.isLoggingPackets()) {
                this.tdsChannel.logPacket(this.logBuffer.array(), 0, this.socketBuffer.limit(), this.toString() + " sending packet (" + this.socketBuffer.limit() + " bytes)");
            }
            if (!bl) {
                this.preparePacket();
            }
            this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
            this.socketBuffer.position(this.socketBuffer.limit());
        }
    }

    void writeRPCNameValType(String string, boolean bl, TDSType tDSType) throws SQLServerException {
        int n = 0;
        if (null != string) {
            n = string.length() + 1;
        }
        this.writeByte((byte)n);
        if (n > 0) {
            this.writeChar('@');
            this.writeString(string);
        }
        if (null != this.cryptoMeta) {
            this.writeByte((byte)(bl ? 9 : 8));
        } else {
            this.writeByte((byte)(bl ? 1 : 0));
        }
        this.writeByte(tDSType.byteValue());
    }

    void writeRPCBit(String string, Boolean bl, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, TDSType.BITN);
        this.writeByte((byte)1);
        if (null == bl) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte((byte)(bl != false ? 1 : 0));
        }
    }

    void writeRPCByte(String string, Byte by, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)1);
        if (null == by) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte(by);
        }
    }

    void writeRPCShort(String string, Short s, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)2);
        if (null == s) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)2);
            this.writeShort(s);
        }
    }

    void writeRPCInt(String string, Integer n, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)4);
        if (null == n) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeInt(n);
        }
    }

    void writeRPCLong(String string, Long l, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)8);
        if (null == l) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            this.writeLong(l);
        }
    }

    void writeRPCReal(String string, Float f, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.FLOATN);
        if (null == f) {
            this.writeByte((byte)4);
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeByte((byte)4);
            this.writeInt(Float.floatToRawIntBits(f.floatValue()));
        }
    }

    void writeRPCDouble(String string, Double d, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.FLOATN);
        int n = 8;
        this.writeByte((byte)n);
        if (null == d) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)n);
            long l = Double.doubleToLongBits(d);
            long l2 = 255L;
            int n2 = 0;
            for (int i = 0; i < 8; ++i) {
                this.writeByte((byte)((l & l2) >> n2));
                n2 += 8;
                l2 <<= 8;
            }
        }
    }

    void writeRPCBigDecimal(String string, BigDecimal bigDecimal, int n, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DECIMALN);
        this.writeByte((byte)17);
        this.writeByte((byte)38);
        byte[] byArray = DDC.convertBigDecimalToBytes(bigDecimal, n);
        this.writeBytes(byArray, 0, byArray.length);
    }

    void writeVMaxHeader(long l, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        this.writeShort((short)-1);
        if (null != sQLCollation) {
            sQLCollation.writeCollation(this);
        }
        if (bl) {
            this.writeLong(-1L);
        } else if (-1L == l) {
            this.writeLong(-2L);
        } else {
            this.writeLong(l);
        }
    }

    void writeRPCStringUnicode(String string) throws SQLServerException {
        this.writeRPCStringUnicode(null, string, false, null);
    }

    void writeRPCStringUnicode(String string, String string2, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        boolean bl3;
        boolean bl4 = string2 == null;
        int n = bl4 ? 0 : 2 * string2.length();
        boolean bl5 = bl3 = n <= 8000;
        if (null == sQLCollation) {
            sQLCollation = this.con.getDatabaseCollation();
        }
        boolean bl6 = bl2 = !bl3 || bl;
        if (bl2) {
            this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
            this.writeVMaxHeader(n, bl4, sQLCollation);
            if (!bl4) {
                if (n > 0) {
                    this.writeInt(n);
                    this.writeString(string2);
                }
                this.writeInt(0);
            }
        } else {
            if (bl3) {
                this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
                this.writeShort((short)8000);
            } else {
                this.writeRPCNameValType(string, bl, TDSType.NTEXT);
                this.writeInt(Integer.MAX_VALUE);
            }
            sQLCollation.writeCollation(this);
            if (bl4) {
                this.writeShort((short)-1);
            } else {
                if (bl3) {
                    this.writeShort((short)n);
                } else {
                    this.writeInt(n);
                }
                if (0 != n) {
                    this.writeString(string2);
                }
            }
        }
    }

    void writeTVP(TVP tVP) throws SQLServerException {
        if (!tVP.isNull()) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)2);
        }
        this.writeByte((byte)-13);
        if (null != tVP.getDbNameTVP()) {
            this.writeByte((byte)tVP.getDbNameTVP().length());
            this.writeString(tVP.getDbNameTVP());
        } else {
            this.writeByte((byte)0);
        }
        if (null != tVP.getOwningSchemaNameTVP()) {
            this.writeByte((byte)tVP.getOwningSchemaNameTVP().length());
            this.writeString(tVP.getOwningSchemaNameTVP());
        } else {
            this.writeByte((byte)0);
        }
        if (null != tVP.getTVPName()) {
            this.writeByte((byte)tVP.getTVPName().length());
            this.writeString(tVP.getTVPName());
        } else {
            this.writeByte((byte)0);
        }
        if (!tVP.isNull()) {
            this.writeTVPColumnMetaData(tVP);
            this.writeTvpOrderUnique(tVP);
        } else {
            this.writeShort((short)-1);
        }
        this.writeByte((byte)0);
        try {
            this.writeTVPRows(tVP);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), numberFormatException);
        }
        catch (ClassCastException classCastException) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), classCastException);
        }
    }

    void writeTVPRows(TVP tVP) throws SQLServerException {
        if (!tVP.isNull()) {
            Map<Integer, SQLServerMetaData> map = tVP.getColumnMetadata();
            while (tVP.next()) {
                Object[] objectArray = tVP.getRowData();
                this.writeByte((byte)1);
                Iterator<Map.Entry<Integer, SQLServerMetaData>> iterator = map.entrySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Map.Entry<Integer, SQLServerMetaData> entry = iterator.next();
                    if (entry.getValue().useServerDefault) {
                        ++n;
                        continue;
                    }
                    JDBCType jDBCType = JDBCType.of(entry.getValue().javaSqlType);
                    String string = null;
                    Object object = null;
                    if (null != objectArray && objectArray.length > n && null != (object = objectArray[n])) {
                        string = String.valueOf(object);
                    }
                    switch (jDBCType) {
                        case BIGINT: {
                            if (null == string) {
                                this.writeByte((byte)0);
                                break;
                            }
                            this.writeByte((byte)8);
                            this.writeLong(Long.valueOf(string));
                            break;
                        }
                        case BIT: {
                            if (null == string) {
                                this.writeByte((byte)0);
                                break;
                            }
                            this.writeByte((byte)1);
                            this.writeByte((byte)(Boolean.valueOf(string) != false ? 1 : 0));
                            break;
                        }
                        case INTEGER: {
                            if (null == string) {
                                this.writeByte((byte)0);
                                break;
                            }
                            this.writeByte((byte)4);
                            this.writeInt(Integer.valueOf(string));
                            break;
                        }
                        case SMALLINT: 
                        case TINYINT: {
                            if (null == string) {
                                this.writeByte((byte)0);
                                break;
                            }
                            this.writeByte((byte)2);
                            this.writeShort(Short.valueOf(string));
                            break;
                        }
                        case DECIMAL: 
                        case NUMERIC: {
                            if (null == string) {
                                this.writeByte((byte)0);
                                break;
                            }
                            this.writeByte((byte)17);
                            BigDecimal bigDecimal = new BigDecimal(string);
                            bigDecimal = bigDecimal.setScale(entry.getValue().scale, RoundingMode.HALF_UP);
                            byte[] byArray = DDC.convertBigDecimalToBytes(bigDecimal, bigDecimal.scale());
                            byte[] byArray2 = new byte[17];
                            System.arraycopy(byArray, 2, byArray2, 0, byArray.length - 2);
                            this.writeBytes(byArray2);
                            break;
                        }
                        case DOUBLE: {
                            if (null == string) {
                                this.writeByte((byte)0);
                                break;
                            }
                            this.writeByte((byte)8);
                            long l = Double.doubleToLongBits(Double.valueOf(string));
                            long l2 = 255L;
                            int n2 = 0;
                            for (int i = 0; i < 8; ++i) {
                                this.writeByte((byte)((l & l2) >> n2));
                                n2 += 8;
                                l2 <<= 8;
                            }
                            break;
                        }
                        case FLOAT: 
                        case REAL: {
                            if (null == string) {
                                this.writeByte((byte)0);
                                break;
                            }
                            this.writeByte((byte)4);
                            this.writeInt(Float.floatToRawIntBits(Float.valueOf(string).floatValue()));
                            break;
                        }
                        case DATE: 
                        case TIME: 
                        case TIMESTAMP: 
                        case DATETIMEOFFSET: 
                        case TIMESTAMP_WITH_TIMEZONE: 
                        case TIME_WITH_TIMEZONE: 
                        case CHAR: 
                        case VARCHAR: 
                        case NCHAR: 
                        case NVARCHAR: {
                            int n3;
                            boolean bl = 2 * entry.getValue().precision <= 8000;
                            boolean bl2 = null == string;
                            int n4 = n3 = bl2 ? 0 : string.length() * 2;
                            if (!bl) {
                                if (bl2) {
                                    this.writeLong(-1L);
                                } else if (-1 == n3) {
                                    this.writeLong(-2L);
                                } else {
                                    this.writeLong(n3);
                                }
                                if (bl2) break;
                                if (n3 > 0) {
                                    this.writeInt(n3);
                                    this.writeString(string);
                                }
                                this.writeInt(0);
                                break;
                            }
                            if (bl2) {
                                this.writeShort((short)-1);
                                break;
                            }
                            this.writeShort((short)n3);
                            this.writeString(string);
                            break;
                        }
                        case BINARY: 
                        case VARBINARY: {
                            int n3;
                            boolean bl2;
                            boolean bl = entry.getValue().precision <= 8000;
                            boolean bl3 = bl2 = null == object;
                            if (object instanceof String) {
                                n3 = bl2 ? 0 : TDSWriter.toByteArray(object.toString()).length;
                            } else {
                                int n5 = n3 = bl2 ? 0 : ((byte[])object).length;
                            }
                            if (!bl) {
                                if (bl2) {
                                    this.writeLong(-1L);
                                } else if (-1 == n3) {
                                    this.writeLong(-2L);
                                } else {
                                    this.writeLong(n3);
                                }
                                if (bl2) break;
                                if (n3 > 0) {
                                    this.writeInt(n3);
                                    if (object instanceof String) {
                                        this.writeBytes(TDSWriter.toByteArray(object.toString()));
                                    } else {
                                        this.writeBytes((byte[])object);
                                    }
                                }
                                this.writeInt(0);
                                break;
                            }
                            if (bl2) {
                                this.writeShort((short)-1);
                                break;
                            }
                            this.writeShort((short)n3);
                            if (object instanceof String) {
                                this.writeBytes(TDSWriter.toByteArray(object.toString()));
                                break;
                            }
                            this.writeBytes((byte[])object);
                            break;
                        }
                        default: {
                            assert (false) : "Unexpected JDBC type " + jDBCType.toString();
                            break;
                        }
                    }
                    ++n;
                }
            }
        }
        this.writeByte((byte)0);
    }

    private static byte[] toByteArray(String string) {
        return DatatypeConverter.parseHexBinary((String)string);
    }

    void writeTVPColumnMetaData(TVP tVP) throws SQLServerException {
        this.writeShort((short)tVP.getTVPColumnCount());
        Map<Integer, SQLServerMetaData> map = tVP.getColumnMetadata();
        for (Map.Entry<Integer, SQLServerMetaData> entry : map.entrySet()) {
            JDBCType jDBCType = JDBCType.of(entry.getValue().javaSqlType);
            boolean bl = entry.getValue().useServerDefault;
            this.writeInt(0);
            short s = 1;
            if (bl) {
                s = (short)(s | 0x200);
            }
            this.writeShort(s);
            switch (jDBCType) {
                case BIGINT: {
                    this.writeByte(TDSType.INTN.byteValue());
                    this.writeByte((byte)8);
                    break;
                }
                case BIT: {
                    this.writeByte(TDSType.BITN.byteValue());
                    this.writeByte((byte)1);
                    break;
                }
                case INTEGER: {
                    this.writeByte(TDSType.INTN.byteValue());
                    this.writeByte((byte)4);
                    break;
                }
                case SMALLINT: 
                case TINYINT: {
                    this.writeByte(TDSType.INTN.byteValue());
                    this.writeByte((byte)2);
                    break;
                }
                case DECIMAL: 
                case NUMERIC: {
                    this.writeByte(TDSType.NUMERICN.byteValue());
                    this.writeByte((byte)17);
                    this.writeByte((byte)entry.getValue().precision);
                    this.writeByte((byte)entry.getValue().scale);
                    break;
                }
                case DOUBLE: {
                    this.writeByte(TDSType.FLOATN.byteValue());
                    this.writeByte((byte)8);
                    break;
                }
                case FLOAT: 
                case REAL: {
                    this.writeByte(TDSType.FLOATN.byteValue());
                    this.writeByte((byte)4);
                    break;
                }
                case DATE: 
                case TIME: 
                case TIMESTAMP: 
                case DATETIMEOFFSET: 
                case TIMESTAMP_WITH_TIMEZONE: 
                case TIME_WITH_TIMEZONE: 
                case CHAR: 
                case VARCHAR: 
                case NCHAR: 
                case NVARCHAR: {
                    boolean bl2;
                    this.writeByte(TDSType.NVARCHAR.byteValue());
                    boolean bl3 = bl2 = 2 * entry.getValue().precision <= 8000;
                    if (!bl2) {
                        this.writeShort((short)-1);
                        this.con.getDatabaseCollation().writeCollation(this);
                        break;
                    }
                    this.writeShort((short)8000);
                    this.con.getDatabaseCollation().writeCollation(this);
                    break;
                }
                case BINARY: 
                case VARBINARY: {
                    boolean bl2;
                    this.writeByte(TDSType.BIGVARBINARY.byteValue());
                    boolean bl4 = bl2 = entry.getValue().precision <= 8000;
                    if (!bl2) {
                        this.writeShort((short)-1);
                        break;
                    }
                    this.writeShort((short)8000);
                    break;
                }
                default: {
                    assert (false) : "Unexpected JDBC type " + jDBCType.toString();
                    break;
                }
            }
            this.writeByte((byte)0);
        }
    }

    void writeTvpOrderUnique(TVP tVP) throws SQLServerException {
        Map<Integer, SQLServerMetaData> map = tVP.getColumnMetadata();
        Iterator<Map.Entry<Integer, SQLServerMetaData>> iterator = map.entrySet().iterator();
        LinkedList<TdsOrderUnique> linkedList = new LinkedList<TdsOrderUnique>();
        while (iterator.hasNext()) {
            byte by = 0;
            Map.Entry<Integer, SQLServerMetaData> object = iterator.next();
            SQLServerMetaData sQLServerMetaData = object.getValue();
            if (SQLServerSortOrder.Ascending == sQLServerMetaData.sortOrder) {
                by = 1;
            } else if (SQLServerSortOrder.Descending == sQLServerMetaData.sortOrder) {
                by = 2;
            }
            if (sQLServerMetaData.isUniqueKey) {
                by = (byte)(by | 4);
            }
            if (0 == by) continue;
            linkedList.add(new TdsOrderUnique(object.getKey(), by));
        }
        if (!linkedList.isEmpty()) {
            this.writeByte((byte)16);
            this.writeShort((short)linkedList.size());
            for (TdsOrderUnique tdsOrderUnique : linkedList) {
                this.writeShort((short)(tdsOrderUnique.columnOrdinal + 1));
                this.writeByte(tdsOrderUnique.flags);
            }
        }
    }

    void setCryptoMetaData(CryptoMetadata cryptoMetadata) {
        this.cryptoMeta = cryptoMetadata;
    }

    CryptoMetadata getCryptoMetaData() {
        return this.cryptoMeta;
    }

    void writeEncryptedRPCByteArray(byte[] byArray) throws SQLServerException {
        boolean bl;
        boolean bl2 = byArray == null;
        long l = bl2 ? 0L : (long)byArray.length;
        boolean bl3 = l <= 8000L;
        boolean bl4 = bl = !bl3 && l <= Integer.MAX_VALUE;
        if (bl3) {
            this.writeShort((short)8000);
        } else if (bl) {
            this.writeShort((short)-1);
        } else {
            this.writeInt(Integer.MAX_VALUE);
        }
        if (bl2) {
            this.writeShort((short)-1);
        } else {
            if (bl3) {
                this.writeShort((short)l);
            } else if (bl) {
                this.writeLong(l);
            } else {
                this.writeInt((int)l);
            }
            if (0L != l) {
                if (bl) {
                    this.writeInt((int)l);
                }
                this.writeBytes(byArray);
            }
            if (bl) {
                this.writeInt(0);
            }
        }
    }

    void writeCryptoMetaData() throws SQLServerException {
        this.writeByte(this.cryptoMeta.cipherAlgorithmId);
        this.writeByte(this.cryptoMeta.encryptionType.getValue());
        this.writeInt(this.cryptoMeta.cekTableEntry.getColumnEncryptionKeyValues().get((int)0).databaseId);
        this.writeInt(this.cryptoMeta.cekTableEntry.getColumnEncryptionKeyValues().get((int)0).cekId);
        this.writeInt(this.cryptoMeta.cekTableEntry.getColumnEncryptionKeyValues().get((int)0).cekVersion);
        this.writeBytes(this.cryptoMeta.cekTableEntry.getColumnEncryptionKeyValues().get((int)0).cekMdVersion);
        this.writeByte(this.cryptoMeta.normalizationRuleVersion);
    }

    void writeRPCByteArray(String string, byte[] byArray, boolean bl, JDBCType jDBCType, SQLCollation sQLCollation) throws SQLServerException {
        TDSType tDSType;
        boolean bl2;
        boolean bl3 = byArray == null;
        int n = bl3 ? 0 : byArray.length;
        boolean bl4 = n <= 8000;
        boolean bl5 = bl2 = !bl4 || bl;
        if (null != this.cryptoMeta) {
            tDSType = bl4 || bl2 ? TDSType.BIGVARBINARY : TDSType.IMAGE;
            sQLCollation = null;
        } else {
            switch (jDBCType) {
                default: {
                    tDSType = bl4 || bl2 ? TDSType.BIGVARBINARY : TDSType.IMAGE;
                    sQLCollation = null;
                    break;
                }
                case CHAR: 
                case VARCHAR: 
                case LONGVARCHAR: 
                case CLOB: {
                    TDSType tDSType2 = tDSType = bl4 || bl2 ? TDSType.BIGVARCHAR : TDSType.TEXT;
                    if (null != sQLCollation) break;
                    sQLCollation = this.con.getDatabaseCollation();
                    break;
                }
                case NCHAR: 
                case NVARCHAR: 
                case LONGNVARCHAR: 
                case NCLOB: {
                    TDSType tDSType3 = tDSType = bl4 || bl2 ? TDSType.NVARCHAR : TDSType.NTEXT;
                    if (null != sQLCollation) break;
                    sQLCollation = this.con.getDatabaseCollation();
                }
            }
        }
        this.writeRPCNameValType(string, bl, tDSType);
        if (bl2) {
            this.writeVMaxHeader(n, bl3, sQLCollation);
            if (!bl3) {
                if (n > 0) {
                    this.writeInt(n);
                    this.writeBytes(byArray);
                }
                this.writeInt(0);
            }
        } else {
            if (bl4) {
                this.writeShort((short)8000);
            } else {
                this.writeInt(Integer.MAX_VALUE);
            }
            if (null != sQLCollation) {
                sQLCollation.writeCollation(this);
            }
            if (bl3) {
                this.writeShort((short)-1);
            } else {
                if (bl4) {
                    this.writeShort((short)n);
                } else {
                    this.writeInt(n);
                }
                if (0 != n) {
                    this.writeBytes(byArray);
                }
            }
        }
    }

    void writeRPCDateTime(String string, GregorianCalendar gregorianCalendar, int n, boolean bl) throws SQLServerException {
        assert (n >= 0 && n < 1000000000) : "Invalid subNanoSeconds value: " + n;
        assert (gregorianCalendar != null || gregorianCalendar == null && n == 0) : "Invalid subNanoSeconds value when calendar is null: " + n;
        this.writeRPCNameValType(string, bl, TDSType.DATETIMEN);
        this.writeByte((byte)8);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)8);
        int n2 = DDC.daysSinceBaseDate(gregorianCalendar.get(1), gregorianCalendar.get(6), 1900);
        int n3 = (n + 500000) / 1000000 + 1000 * gregorianCalendar.get(13) + 60000 * gregorianCalendar.get(12) + 3600000 * gregorianCalendar.get(11);
        if (n3 >= 86399999) {
            ++n2;
            n3 = 0;
        }
        if (n2 < DDC.daysSinceBaseDate(1753, 1, 1900) || n2 >= DDC.daysSinceBaseDate(10000, 1, 1900)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
            Object[] objectArray = new Object[]{SSType.DATETIME};
            throw new SQLServerException(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, DriverError.NOT_SET, null);
        }
        this.writeInt(n2);
        this.writeInt((3 * n3 + 5) / 10);
    }

    void writeRPCTime(String string, GregorianCalendar gregorianCalendar, int n, int n2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.TIMEN);
        this.writeByte((byte)n2);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)TDS.timeValueLength(n2));
        this.writeScaledTemporal(gregorianCalendar, n, n2, SSType.TIME);
    }

    void writeRPCDate(String string, GregorianCalendar gregorianCalendar, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DATEN);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)3);
        this.writeScaledTemporal(gregorianCalendar, 0, 0, SSType.DATE);
    }

    void writeEncryptedRPCTime(String string, GregorianCalendar gregorianCalendar, int n, int n2, boolean bl) throws SQLServerException {
        if (this.con.getSendTimeAsDatetime()) {
            throw new SQLServerException(SQLServerException.getErrString("R_sendTimeAsDateTimeForAE"), null);
        }
        this.writeRPCNameValType(string, bl, TDSType.BIGVARBINARY);
        if (null == gregorianCalendar) {
            this.writeEncryptedRPCByteArray(null);
        } else {
            this.writeEncryptedRPCByteArray(this.writeEncryptedScaledTemporal(gregorianCalendar, n, n2, SSType.TIME, (short)0));
        }
        this.writeByte(TDSType.TIMEN.byteValue());
        this.writeByte((byte)n2);
        this.writeCryptoMetaData();
    }

    void writeEncryptedRPCDate(String string, GregorianCalendar gregorianCalendar, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.BIGVARBINARY);
        if (null == gregorianCalendar) {
            this.writeEncryptedRPCByteArray(null);
        } else {
            this.writeEncryptedRPCByteArray(this.writeEncryptedScaledTemporal(gregorianCalendar, 0, 0, SSType.DATE, (short)0));
        }
        this.writeByte(TDSType.DATEN.byteValue());
        this.writeCryptoMetaData();
    }

    void writeEncryptedRPCDateTime(String string, GregorianCalendar gregorianCalendar, int n, boolean bl, JDBCType jDBCType) throws SQLServerException {
        assert (n >= 0 && n < 1000000000) : "Invalid subNanoSeconds value: " + n;
        assert (gregorianCalendar != null || gregorianCalendar == null && n == 0) : "Invalid subNanoSeconds value when calendar is null: " + n;
        this.writeRPCNameValType(string, bl, TDSType.BIGVARBINARY);
        if (null == gregorianCalendar) {
            this.writeEncryptedRPCByteArray(null);
        } else {
            this.writeEncryptedRPCByteArray(this.getEncryptedDateTimeAsBytes(gregorianCalendar, n, jDBCType));
        }
        if (JDBCType.SMALLDATETIME == jDBCType) {
            this.writeByte(TDSType.DATETIMEN.byteValue());
            this.writeByte((byte)4);
        } else {
            this.writeByte(TDSType.DATETIMEN.byteValue());
            this.writeByte((byte)8);
        }
        this.writeCryptoMetaData();
    }

    byte[] getEncryptedDateTimeAsBytes(GregorianCalendar gregorianCalendar, int n, JDBCType jDBCType) throws SQLServerException {
        int n2 = DDC.daysSinceBaseDate(gregorianCalendar.get(1), gregorianCalendar.get(6), 1900);
        int n3 = (n + 500000) / 1000000 + 1000 * gregorianCalendar.get(13) + 60000 * gregorianCalendar.get(12) + 3600000 * gregorianCalendar.get(11);
        if (n3 >= 86399999) {
            ++n2;
            n3 = 0;
        }
        if (n2 < DDC.daysSinceBaseDate(1753, 1, 1900) || n2 >= DDC.daysSinceBaseDate(10000, 1, 1900)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
            Object[] objectArray = new Object[]{SSType.DATETIME};
            throw new SQLServerException(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, DriverError.NOT_SET, null);
        }
        if (JDBCType.SMALLDATETIME == jDBCType) {
            int n4 = n3 / 1000;
            int n5 = n4 / 60;
            n5 = (double)(n4 % 60) > 29.998 ? n5 + 1 : n5;
            ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putShort((short)n2);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer2.putShort((short)n5);
            byte[] byArray = new byte[4];
            System.arraycopy(byteBuffer.array(), 0, byArray, 0, 2);
            System.arraycopy(byteBuffer2.array(), 0, byArray, 2, 2);
            return SQLServerSecurityUtility.encryptWithKey(byArray, this.cryptoMeta, this.con);
        }
        if (JDBCType.DATETIME == jDBCType) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(n2);
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer3.putInt((3 * n3 + 5) / 10);
            byte[] byArray = new byte[8];
            System.arraycopy(byteBuffer.array(), 0, byArray, 0, 4);
            System.arraycopy(byteBuffer3.array(), 0, byArray, 4, 4);
            return SQLServerSecurityUtility.encryptWithKey(byArray, this.cryptoMeta, this.con);
        }
        assert (false) : "Unexpected JDBCType type " + (Object)((Object)jDBCType);
        return null;
    }

    void writeEncryptedRPCDateTime2(String string, GregorianCalendar gregorianCalendar, int n, int n2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.BIGVARBINARY);
        if (null == gregorianCalendar) {
            this.writeEncryptedRPCByteArray(null);
        } else {
            this.writeEncryptedRPCByteArray(this.writeEncryptedScaledTemporal(gregorianCalendar, n, n2, SSType.DATETIME2, (short)0));
        }
        this.writeByte(TDSType.DATETIME2N.byteValue());
        this.writeByte((byte)n2);
        this.writeCryptoMetaData();
    }

    void writeEncryptedRPCDateTimeOffset(String string, GregorianCalendar gregorianCalendar, int n, int n2, int n3, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.BIGVARBINARY);
        if (null == gregorianCalendar) {
            this.writeEncryptedRPCByteArray(null);
        } else {
            assert (0 == gregorianCalendar.get(15));
            this.writeEncryptedRPCByteArray(this.writeEncryptedScaledTemporal(gregorianCalendar, n2, n3, SSType.DATETIMEOFFSET, (short)n));
        }
        this.writeByte(TDSType.DATETIMEOFFSETN.byteValue());
        this.writeByte((byte)n3);
        this.writeCryptoMetaData();
    }

    void writeRPCDateTime2(String string, GregorianCalendar gregorianCalendar, int n, int n2, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DATETIME2N);
        this.writeByte((byte)n2);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        this.writeByte((byte)TDS.datetime2ValueLength(n2));
        this.writeScaledTemporal(gregorianCalendar, n, n2, SSType.DATETIME2);
    }

    void writeRPCDateTimeOffset(String string, GregorianCalendar gregorianCalendar, int n, int n2, int n3, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DATETIMEOFFSETN);
        this.writeByte((byte)n3);
        if (null == gregorianCalendar) {
            this.writeByte((byte)0);
            return;
        }
        assert (0 == gregorianCalendar.get(15));
        this.writeByte((byte)TDS.datetimeoffsetValueLength(n3));
        this.writeScaledTemporal(gregorianCalendar, n2, n3, SSType.DATETIMEOFFSET);
        this.writeShort((short)n);
    }

    private int getRoundedSubSecondNanos(int n) {
        int n2 = (n + Nanos.PER_MAX_SCALE_INTERVAL / 2) / Nanos.PER_MAX_SCALE_INTERVAL * Nanos.PER_MAX_SCALE_INTERVAL;
        return n2;
    }

    private void writeScaledTemporal(GregorianCalendar gregorianCalendar, int n, int n2, SSType sSType) throws SQLServerException {
        int n3;
        assert (this.con.isKatmaiOrLater());
        assert (SSType.DATE == sSType || SSType.TIME == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) : "Unexpected SSType: " + (Object)((Object)sSType);
        if (SSType.TIME == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) {
            long l;
            assert (n >= 0);
            assert (n < 1000000000);
            assert (n2 >= 0);
            assert (n2 <= 7);
            n3 = gregorianCalendar.get(13) + 60 * gregorianCalendar.get(12) + 3600 * gregorianCalendar.get(11);
            long l2 = (long)Nanos.PER_MAX_SCALE_INTERVAL * (long)Math.pow(10.0, 7 - n2);
            if (86400000000000L / l2 == (l = (1000000000L * (long)n3 + (long)this.getRoundedSubSecondNanos(n) + l2 / 2L) / l2)) {
                if (SSType.TIME == sSType) {
                    --l;
                } else {
                    assert (SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) : "Unexpected SSType: " + (Object)((Object)sSType);
                    gregorianCalendar.add(13, 1);
                    if (gregorianCalendar.get(1) <= 9999) {
                        l = 0L;
                    } else {
                        gregorianCalendar.add(13, -1);
                        --l;
                    }
                }
            }
            int n4 = TDS.nanosSinceMidnightLength(n2);
            byte[] byArray = this.scaledNanosToEncodedBytes(l, n4);
            this.writeBytes(byArray);
        }
        if (SSType.DATE == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) {
            if (gregorianCalendar.getTimeInMillis() < GregorianChange.STANDARD_CHANGE_DATE.getTime() || gregorianCalendar.getActualMaximum(6) < 365) {
                n3 = gregorianCalendar.get(1);
                int n5 = gregorianCalendar.get(2);
                int n6 = gregorianCalendar.get(5);
                gregorianCalendar.setGregorianChange(GregorianChange.PURE_CHANGE_DATE);
                gregorianCalendar.set(n3, n5, n6);
            }
            if ((n3 = DDC.daysSinceBaseDate(gregorianCalendar.get(1), gregorianCalendar.get(6), 1)) < 0 || n3 >= DDC.daysSinceBaseDate(10000, 1, 1)) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
                Object[] objectArray = new Object[]{sSType};
                throw new SQLServerException(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, DriverError.NOT_SET, null);
            }
            byte[] byArray = new byte[]{(byte)(n3 >> 0 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 >> 16 & 0xFF)};
            this.writeBytes(byArray);
        }
    }

    byte[] writeEncryptedScaledTemporal(GregorianCalendar gregorianCalendar, int n, int n2, SSType sSType, short s) throws SQLServerException {
        Object object;
        int n3;
        assert (this.con.isKatmaiOrLater());
        assert (SSType.DATE == sSType || SSType.TIME == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) : "Unexpected SSType: " + (Object)((Object)sSType);
        byte[] byArray = null;
        int n4 = 0;
        long l = 0L;
        long l2 = 0L;
        if (SSType.TIME == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) {
            assert (n >= 0);
            assert (n < 1000000000);
            assert (n2 >= 0);
            assert (n2 <= 7);
            n4 = gregorianCalendar.get(13) + 60 * gregorianCalendar.get(12) + 3600 * gregorianCalendar.get(11);
            l = (long)Nanos.PER_MAX_SCALE_INTERVAL * (long)Math.pow(10.0, 7 - n2);
            l2 = (1000000000L * (long)n4 + (long)this.getRoundedSubSecondNanos(n) + l / 2L) / l * l / 100L;
            if (SSType.TIME == sSType && 864000000000L <= l2) {
                l2 = (1000000000L * (long)n4 + (long)this.getRoundedSubSecondNanos(n)) / l * l / 100L;
            }
            if (86400000000000L / l == l2) {
                if (SSType.TIME == sSType) {
                    --l2;
                } else {
                    assert (SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) : "Unexpected SSType: " + (Object)((Object)sSType);
                    gregorianCalendar.add(13, 1);
                    if (gregorianCalendar.get(1) <= 9999) {
                        l2 = 0L;
                    } else {
                        gregorianCalendar.add(13, -1);
                        --l2;
                    }
                }
            }
            n3 = TDS.nanosSinceMidnightLength(7);
            object = this.scaledNanosToEncodedBytes(l2, n3);
            if (SSType.TIME == sSType) {
                byte[] byArray2 = SQLServerSecurityUtility.encryptWithKey((byte[])object, this.cryptoMeta, this.con);
                return byArray2;
            }
            if (SSType.DATETIME2 == sSType) {
                byArray = new byte[n3 + 3];
                System.arraycopy(object, 0, byArray, 0, ((Object[])object).length);
            } else if (SSType.DATETIMEOFFSET == sSType) {
                byArray = new byte[n3 + 5];
                System.arraycopy(object, 0, byArray, 0, ((Object[])object).length);
            }
        }
        if (SSType.DATE == sSType || SSType.DATETIME2 == sSType || SSType.DATETIMEOFFSET == sSType) {
            byte[] byArray3;
            if (gregorianCalendar.getTimeInMillis() < GregorianChange.STANDARD_CHANGE_DATE.getTime() || gregorianCalendar.getActualMaximum(6) < 365) {
                n3 = gregorianCalendar.get(1);
                int n5 = gregorianCalendar.get(2);
                int n6 = gregorianCalendar.get(5);
                gregorianCalendar.setGregorianChange(GregorianChange.PURE_CHANGE_DATE);
                gregorianCalendar.set(n3, n5, n6);
            }
            if ((n3 = DDC.daysSinceBaseDate(gregorianCalendar.get(1), gregorianCalendar.get(6), 1)) < 0 || n3 >= DDC.daysSinceBaseDate(10000, 1, 1)) {
                object = new MessageFormat(SQLServerException.getErrString("R_valueOutOfRange"));
                Object[] objectArray = new Object[]{sSType};
                throw new SQLServerException(object.format(objectArray), SQLState.DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, DriverError.NOT_SET, null);
            }
            object = new byte[3];
            object[0] = (byte)(n3 >> 0 & 0xFF);
            object[1] = (byte)(n3 >> 8 & 0xFF);
            object[2] = (byte)(n3 >> 16 & 0xFF);
            if (SSType.DATE == sSType) {
                byArray3 = SQLServerSecurityUtility.encryptWithKey((byte[])object, this.cryptoMeta, this.con);
            } else if (SSType.DATETIME2 == sSType) {
                if (3652058 == n3 && 864000000000L == l2) {
                    l2 = (1000000000L * (long)n4 + (long)this.getRoundedSubSecondNanos(n)) / l * l / 100L;
                    int n7 = TDS.nanosSinceMidnightLength(7);
                    byte[] byArray4 = this.scaledNanosToEncodedBytes(l2, n7);
                    byArray = new byte[n7 + 3];
                    System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
                }
                System.arraycopy(object, 0, byArray, byArray.length - 3, 3);
                byArray3 = SQLServerSecurityUtility.encryptWithKey(byArray, this.cryptoMeta, this.con);
            } else {
                if (3652058 == n3 && 864000000000L == l2) {
                    l2 = (1000000000L * (long)n4 + (long)this.getRoundedSubSecondNanos(n)) / l * l / 100L;
                    int n8 = TDS.nanosSinceMidnightLength(7);
                    byte[] byArray5 = this.scaledNanosToEncodedBytes(l2, n8);
                    byArray = new byte[n8 + 5];
                    System.arraycopy(byArray5, 0, byArray, 0, byArray5.length);
                }
                System.arraycopy(object, 0, byArray, byArray.length - 5, 3);
                System.arraycopy(ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(s).array(), 0, byArray, byArray.length - 2, 2);
                byArray3 = SQLServerSecurityUtility.encryptWithKey(byArray, this.cryptoMeta, this.con);
            }
            return byArray3;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownSSType"));
        object = new Object[]{sSType};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(object), null, true);
        return null;
    }

    private byte[] scaledNanosToEncodedBytes(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(l >> 8 * i & 0xFFL);
        }
        return byArray;
    }

    void writeRPCInputStream(String string, InputStream inputStream, long l, boolean bl, JDBCType jDBCType, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        assert (null != inputStream);
        assert (-1L == l || l >= 0L);
        boolean bl3 = bl2 = -1L == l || l > 8000L;
        if (bl2) {
            assert (-1L == l || l <= Integer.MAX_VALUE);
            this.writeRPCNameValType(string, bl, jDBCType.isTextual() ? TDSType.BIGVARCHAR : TDSType.BIGVARBINARY);
            this.writeVMaxHeader(l, false, jDBCType.isTextual() ? sQLCollation : null);
        } else {
            boolean bl4;
            if (-1L == l) {
                Object object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8000);
                long l2 = 65535L * (long)this.con.getTDSPacketSize();
                try {
                    int n;
                    object = new byte[8000];
                    for (l = 0L; l < l2 && -1 != (n = inputStream.read((byte[])object, 0, ((byte[])object).length)); l += (long)n) {
                        byteArrayOutputStream.write((byte[])object);
                    }
                }
                catch (IOException iOException) {
                    throw new SQLServerException(iOException.getMessage(), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, (Throwable)iOException);
                }
                if (l >= l2) {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                    Object[] objectArray = new Object[]{l};
                    SQLServerException.makeFromDriverError(null, null, ((Format)object).format(objectArray), "", true);
                }
                assert (l <= Integer.MAX_VALUE);
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray(), 0, (int)l);
            }
            assert (0L <= l && l <= Integer.MAX_VALUE);
            boolean bl5 = bl4 = l <= 8000L;
            this.writeRPCNameValType(string, bl, jDBCType.isTextual() ? (bl4 ? TDSType.BIGVARCHAR : TDSType.TEXT) : (bl4 ? TDSType.BIGVARBINARY : TDSType.IMAGE));
            if (bl4) {
                this.writeShort((short)8000);
                if (jDBCType.isTextual()) {
                    sQLCollation.writeCollation(this);
                }
                this.writeShort((short)l);
            } else {
                this.writeInt(Integer.MAX_VALUE);
                if (jDBCType.isTextual()) {
                    sQLCollation.writeCollation(this);
                }
                this.writeInt((int)l);
            }
        }
        this.writeStream(inputStream, l, bl2);
    }

    void writeRPCXML(String string, InputStream inputStream, long l, boolean bl) throws SQLServerException {
        assert (-1L == l || l >= 0L);
        assert (-1L == l || l <= Integer.MAX_VALUE);
        this.writeRPCNameValType(string, bl, TDSType.XML);
        this.writeByte((byte)0);
        if (null == inputStream) {
            this.writeLong(-1L);
        } else if (-1L == l) {
            this.writeLong(-2L);
        } else {
            this.writeLong(l);
        }
        if (null != inputStream) {
            this.writeStream(inputStream, l, true);
        }
    }

    void writeRPCReaderUnicode(String string, Reader reader, long l, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        assert (null != reader);
        assert (-1L == l || l >= 0L);
        if (null == sQLCollation) {
            sQLCollation = this.con.getDatabaseCollation();
        }
        boolean bl3 = bl2 = -1L == l || l > 4000L;
        if (bl2) {
            assert (-1L == l || l <= 0x3FFFFFFFL);
            this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
            this.writeVMaxHeader(-1L == l ? -1L : 2L * l, false, sQLCollation);
        } else {
            assert (0L <= l && l <= 0x3FFFFFFFL);
            boolean bl4 = l <= 4000L;
            this.writeRPCNameValType(string, bl, bl4 ? TDSType.NVARCHAR : TDSType.NTEXT);
            if (bl4) {
                this.writeShort((short)8000);
                sQLCollation.writeCollation(this);
                this.writeShort((short)(2L * l));
            } else {
                this.writeInt(0x3FFFFFFF);
                sQLCollation.writeCollation(this);
                this.writeInt((int)(2L * l));
            }
        }
        this.writeReader(reader, l, bl2);
    }

    private class TdsOrderUnique {
        int columnOrdinal;
        byte flags;

        TdsOrderUnique(int n, byte by) {
            this.columnOrdinal = n;
            this.flags = by;
        }
    }
}

