/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.types.TableType;
import com.datapps.linkoopdb.jdbc.types.Type;

public class TableBase
extends TableType {
    public static final int INFO_SCHEMA_TABLE = 1;
    public static final int SYSTEM_SUBQUERY = 2;
    public static final int TEMP_TABLE = 3;
    public static final int BASE_TABLE = 4;
    public static final int CACHED_TABLE = 5;
    public static final int TEMP_TEXT_TABLE = 6;
    public static final int TEXT_TABLE = 7;
    public static final int VIEW_TABLE = 8;
    public static final int RESULT_TABLE = 9;
    public static final int TRANSITION_TABLE = 10;
    public static final int FUNCTION_TABLE = 11;
    public static final int SYSTEM_TABLE = 12;
    public static final int CHANGE_SET_TABLE = 13;
    public static final int MODULE_TABLE = 14;
    public static final int EXTERNAL_TABLE = 15;
    public static final int DBLINK_TABLE = 16;
    public static final int DBLINK_VIEW = 17;
    public static final int MODEL = 18;
    public static final int PIPELINE = 31;
    public static final int SYNONYM = 19;
    public static final int GRAPH = 30;
    public static final int SYNC_LINK_TABLE = 32;
    public static final int SCOPE_ROUTINE = 20;
    public static final int SCOPE_STATEMENT = 21;
    public static final int SCOPE_TRANSACTION = 22;
    public static final int SCOPE_SESSION = 23;
    public static final int SCOPE_FULL = 24;
    public static final int STREAM_TABLE = 25;
    public boolean isSessionBased;
    public int columnCount;
    public boolean isTemp;
    public int tableType;
    public boolean isView;
    public boolean isExternal;
    public boolean hasLobColumn;
    protected int storageEngine = -1;
    protected int structureType = -1;
    protected boolean isReadOnly;
    protected boolean isCached;
    protected boolean isText;
    protected boolean isWithDataSource;
    protected boolean isSchemaBased;
    protected boolean isLogged;
    protected boolean isTransactional = true;
    protected boolean[] colNotNull;
    protected boolean[] emptyColumnCheckList;

    public final Type[] getColumnTypes() {
        return this.colTypes;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public final int getDataColumnCount() {
        return this.colTypes.length;
    }

    public int getStorageEngine() {
        return this.storageEngine;
    }

    public void setStorageEngine(int storageEngine) {
        this.storageEngine = storageEngine;
    }

    public int getStructureType() {
        return this.structureType;
    }

    public void setStructureType(int structureType) {
        this.structureType = structureType;
    }

    public String getTableTypeString() {
        switch (this.tableType) {
            case 4: {
                if (this.isDFS()) {
                    return "NORMAL_DFS";
                }
                if (this.isPallas()) {
                    return "NORMAL_PALLAS";
                }
                return "MEMORY";
            }
            case 16: 
            case 17: {
                return "LINK";
            }
            case 25: {
                if (this.isDFS()) {
                    return "STREAM_DFS";
                }
                if (this.isPallas()) {
                    return "STREAM_PALLAS";
                }
                return "STREAM";
            }
            case 5: {
                return "CACHED";
            }
            case 7: {
                return "TEXT";
            }
            case 14: {
                return "MODULE";
            }
            case 11: {
                return "FUNCTION";
            }
            case 1: 
            case 8: {
                return "VIEW";
            }
            case 3: {
                return "TEMP";
            }
            case 15: {
                return "EXTERNAL";
            }
        }
        return "SUBQUERY";
    }

    public final boolean isSchemaBaseTable() {
        switch (this.tableType) {
            case 4: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public final boolean isWithDataSource() {
        return this.isWithDataSource;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final boolean isView() {
        return this.isView;
    }

    public final boolean isExternal() {
        return this.isExternal;
    }

    public final boolean isModel() {
        return this.tableType == 18;
    }

    public final boolean isGraph() {
        return this.tableType == 30;
    }

    public final boolean isPipeline() {
        return this.tableType == 31;
    }

    public final boolean isBaseTable() {
        return this.tableType == 4;
    }

    public final boolean isDBLink() {
        return this.tableType == 17 || this.tableType == 16;
    }

    public final boolean isPallas() {
        return this.getStructureType() == 1;
    }

    public final boolean isStream() {
        return this.tableType == 25;
    }

    public final boolean isSync() {
        return this.tableType == 32;
    }

    public final boolean isDFS() {
        return this.getStructureType() == 0;
    }

    public final boolean isMem() {
        return this.getStructureType() == 2;
    }

    public boolean isQueryBased() {
        return false;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public boolean isDataReadOnly() {
        return this.isReadOnly;
    }
}

