/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.lib.FileAccess;
import com.datapps.linkoopdb.jdbc.lib.java.JavaSystem;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class FileArchiver {
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_ZIP = 1;
    public static final int COMPRESSION_GZIP = 2;
    private static final int COPY_BLOCK_SIZE = 65536;

    public static void copyFile(String infilename, String outfilename, FileAccess storage) throws IOException {
        FileArchiver.archive(infilename, outfilename, storage, 0);
    }

    public static void archive(String infilename, String outfilename, FileAccess storage, int compressionType) throws IOException {
        InputStream in = null;
        OutputStream f = null;
        OutputStream fOut = null;
        DeflaterOutputStream deflater = null;
        boolean completed = false;
        if (!storage.isStreamElement(infilename)) {
            return;
        }
        try {
            int l;
            byte[] b = new byte[65536];
            in = storage.openInputStreamElement(infilename);
            fOut = f = storage.openOutputStreamElement(outfilename);
            switch (compressionType) {
                case 1: {
                    deflater = new DeflaterOutputStream(f, new Deflater(1), b.length);
                    f = deflater;
                    break;
                }
                case 2: {
                    deflater = new GZIPOutputStream(f, b.length);
                    f = deflater;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("FileArchiver" + compressionType);
                }
            }
            while ((l = in.read(b, 0, b.length)) != -1) {
                f.write(b, 0, l);
            }
            completed = true;
        }
        catch (Throwable e) {
            throw JavaSystem.toIOException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (f != null) {
                    if (deflater != null) {
                        deflater.finish();
                    }
                    if (fOut instanceof FileOutputStream) {
                        storage.getFileSync(fOut).sync();
                    }
                    f.close();
                }
                if (!completed && storage.isStreamElement(outfilename)) {
                    storage.removeElement(outfilename);
                }
            }
            catch (Throwable e) {
                throw JavaSystem.toIOException(e);
            }
        }
    }

    public static void unarchive(String infilename, String outfilename, FileAccess storage, int compressionType) throws IOException {
        InputStream f = null;
        OutputStream outstream = null;
        boolean completed = false;
        try {
            int l;
            if (!storage.isStreamElement(infilename)) {
                return;
            }
            storage.removeElement(outfilename);
            byte[] b = new byte[65536];
            f = storage.openInputStreamElement(infilename);
            switch (compressionType) {
                case 1: {
                    f = new InflaterInputStream(f, new Inflater());
                    break;
                }
                case 2: {
                    f = new GZIPInputStream(f, b.length);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("FileArchiver: " + compressionType);
                }
            }
            outstream = storage.openOutputStreamElement(outfilename);
            while ((l = f.read(b, 0, b.length)) != -1) {
                outstream.write(b, 0, l);
            }
            completed = true;
        }
        catch (Throwable e) {
            throw JavaSystem.toIOException(e);
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
                if (outstream != null) {
                    outstream.flush();
                    if (outstream instanceof FileOutputStream) {
                        storage.getFileSync(outstream).sync();
                    }
                    outstream.close();
                }
                if (!completed && storage.isStreamElement(outfilename)) {
                    storage.removeElement(outfilename);
                }
            }
            catch (Throwable e) {
                throw JavaSystem.toIOException(e);
            }
        }
    }
}

