/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class Result {
    public static final boolean EXECUTE_FAILURE = true;
    public static final boolean EXECUTE_SUCCESS = false;
    public static final int UPDATE_COUNT = 1;
    public static final int RS = 2;
    public static final int RS_AND_UPDATE = 3;
    private long m_nLargeUpdateCount;
    private TDResultSet rs;
    private int type;

    public Result(boolean bl, long l) {
        this.m_nLargeUpdateCount = bl ? -3L : (l < 0L ? Long.MAX_VALUE : l);
        this.type = 1;
    }

    public Result(TDResultSet tDResultSet) {
        this.rs = tDResultSet;
        this.type = 2;
    }

    public Result(long l, TDResultSet tDResultSet) {
        this.m_nLargeUpdateCount = l < 0L ? Long.MAX_VALUE : l;
        this.rs = tDResultSet;
        this.type = 3;
    }

    public int getType() {
        return this.type;
    }

    public int getSmallUpdateCount() throws SQLException {
        long l = this.getLargeUpdateCount();
        return l <= Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE;
    }

    public long getLargeUpdateCount() throws SQLException {
        if (this.type == 1 || this.type == 3) {
            return this.m_nLargeUpdateCount;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ191");
    }

    public long getBatchIndexLargeUpdateCount() {
        if (this.type == 1 || this.type == 3) {
            return this.m_nLargeUpdateCount;
        }
        return -3L;
    }

    public TDResultSet getResultSet() throws SQLException {
        if (this.type == 2 || this.type == 3) {
            return this.rs;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ192");
    }

    public String toString() {
        return super.toString() + "(" + (this.type == 1 || this.type == 3 ? "updc=" + this.m_nLargeUpdateCount : "") + (this.type == 3 ? " " : "") + (this.type == 2 || this.type == 3 ? "rs=" + String.valueOf(this.rs) : "") + ")";
    }
}

