#include <ROL_DynamicConstraint.hpp>
#include <ROL_DynamicConstraint_CheckInterface.hpp>
#include <ROL_Elementwise_Function.hpp>
#include <ROL_Elementwise_Reduce.hpp>
#include <ROL_TimeStamp.hpp>
#include <ROL_Vector.hpp>
#include <Teuchos_ParameterList.hpp>
#include <Teuchos_RCPDecl.hpp>
#include <functional>
#include <memory>
#include <ostream>
#include <sstream> // __str__
#include <string>
#include <vector>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <Teuchos_RCP.hpp>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, Teuchos::RCP<T>, false)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*, false)
	PYBIND11_MAKE_OPAQUE(Teuchos::RCP<void>)
#endif

void bind_pyrol_44(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // ROL::details::DynamicConstraint_CheckInterface file:ROL_DynamicConstraint_CheckInterface.hpp line:21
		pybind11::class_<ROL::details::DynamicConstraint_CheckInterface<double>, Teuchos::RCP<ROL::details::DynamicConstraint_CheckInterface<double>>> cl(M("ROL::details"), "DynamicConstraint_CheckInterface_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<class ROL::DynamicConstraint<double> &>(), pybind11::arg("con") );

		cl.def( pybind11::init<class ROL::DynamicConstraint<double> &, struct ROL::TimeStamp<double> &>(), pybind11::arg("con"), pybind11::arg("ts") );

		cl.def( pybind11::init( [](ROL::details::DynamicConstraint_CheckInterface<double> const &o){ return new ROL::details::DynamicConstraint_CheckInterface<double>(o); } ) );
		cl.def("update_uo", (class std::function<void (const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::update_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::update_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("update_un", (class std::function<void (const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::update_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::update_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("update_z", (class std::function<void (const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::update_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::update_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("value_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::value_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::value_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("value_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::value_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::value_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("value_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::value_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::value_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("solve_un", (class std::function<void (class ROL::Vector<double> &, class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::solve_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::solve_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("jacobian_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::jacobian_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::jacobian_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("jacobian_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::jacobian_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::jacobian_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("inverseJacobian_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::inverseJacobian_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::inverseJacobian_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("jacobian_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::jacobian_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::jacobian_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("adjointJacobian_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("adjointJacobian_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("inverseAdjointJacobian_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::inverseAdjointJacobian_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::inverseAdjointJacobian_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("adjointJacobian_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("adjointJacobian_uo_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_uo_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_uo_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("adjointJacobian_uo_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_uo_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_uo_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("adjointJacobian_uo_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_uo_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_uo_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("adjointJacobian_un_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_un_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_un_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("adjointJacobian_un_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_un_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_un_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("adjointJacobian_un_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_un_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_un_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("adjointJacobian_z_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_z_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_z_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("adjointJacobian_z_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_z_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_z_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("adjointJacobian_z_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_z_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointJacobian_z_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("adjointHessian_un_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_un_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_un_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"), pybind11::arg("l"));
		cl.def("adjointHessian_un_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_un_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_un_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"), pybind11::arg("l"));
		cl.def("adjointHessian_un_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_un_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_un_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"), pybind11::arg("l"));
		cl.def("adjointHessian_uo_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_uo_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_uo_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"), pybind11::arg("l"));
		cl.def("adjointHessian_uo_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_uo_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_uo_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"), pybind11::arg("l"));
		cl.def("adjointHessian_uo_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_uo_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_uo_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"), pybind11::arg("l"));
		cl.def("adjointHessian_z_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_z_un, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_z_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"), pybind11::arg("l"));
		cl.def("adjointHessian_z_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_z_uo, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_z_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"), pybind11::arg("l"));
		cl.def("adjointHessian_z_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicConstraint_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_z_z, "C++: ROL::details::DynamicConstraint_CheckInterface<double>::adjointHessian_z_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"), pybind11::arg("l"));
	}
}
