#include <ROL_BatchManager.hpp>
#include <ROL_BoundConstraint.hpp>
#include <ROL_Constraint.hpp>
#include <ROL_Constraint_SimOpt.hpp>
#include <ROL_DynamicConstraint.hpp>
#include <ROL_DynamicObjective.hpp>
#include <ROL_Elementwise_Function.hpp>
#include <ROL_Elementwise_Reduce.hpp>
#include <ROL_Objective.hpp>
#include <ROL_Objective_SimOpt.hpp>
#include <ROL_PD_BPOE.hpp>
#include <ROL_PD_CVaR.hpp>
#include <ROL_PD_HMCR2.hpp>
#include <ROL_PD_MeanSemiDeviation.hpp>
#include <ROL_PD_MeanSemiDeviationFromTarget.hpp>
#include <ROL_PD_RandVarFunctional.hpp>
#include <ROL_PolyhedralProjection.hpp>
#include <ROL_Problem.hpp>
#include <ROL_RandVarFunctional.hpp>
#include <ROL_SampleGenerator.hpp>
#include <ROL_ScalarController.hpp>
#include <ROL_SerialConstraint.hpp>
#include <ROL_SerialObjective.hpp>
#include <ROL_Sketch.hpp>
#include <ROL_StochasticProblem.hpp>
#include <ROL_TimeStamp.hpp>
#include <ROL_Types.hpp>
#include <ROL_UpdateType.hpp>
#include <ROL_UserInputGenerator.hpp>
#include <ROL_Vector.hpp>
#include <ROL_VectorController.hpp>
#include <Teuchos_ENull.hpp>
#include <Teuchos_FilteredIterator.hpp>
#include <Teuchos_ParameterEntry.hpp>
#include <Teuchos_ParameterEntryValidator.hpp>
#include <Teuchos_ParameterList.hpp>
#include <Teuchos_ParameterListModifier.hpp>
#include <Teuchos_PtrDecl.hpp>
#include <Teuchos_RCPDecl.hpp>
#include <Teuchos_RCPNode.hpp>
#include <Teuchos_StringIndexedOrderedValueObjectContainer.hpp>
#include <Teuchos_any.hpp>
#include <deque>
#include <ios>
#include <iterator>
#include <locale>
#include <memory>
#include <ostream>
#include <sstream> // __str__
#include <streambuf>
#include <string>
#include <vector>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <Teuchos_RCP.hpp>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, Teuchos::RCP<T>, false)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*, false)
	PYBIND11_MAKE_OPAQUE(Teuchos::RCP<void>)
#endif

// ROL::PD_RandVarFunctional file:ROL_PD_RandVarFunctional.hpp line:18
struct PyCallBack_ROL_PD_RandVarFunctional_double_t : public ROL::PD_RandVarFunctional<double> {
	using ROL::PD_RandVarFunctional<double>::PD_RandVarFunctional;

	double computeDual(class ROL::SampleGenerator<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "computeDual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_RandVarFunctional::computeDual(a0);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_RandVarFunctional::initialize(a0);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_RandVarFunctional<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
};

// ROL::PD_MeanSemiDeviation file:ROL_PD_MeanSemiDeviation.hpp line:18
struct PyCallBack_ROL_PD_MeanSemiDeviation_double_t : public ROL::PD_MeanSemiDeviation<double> {
	using ROL::PD_MeanSemiDeviation<double>::PD_MeanSemiDeviation;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviation::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviation::setHessVecStorage(a0, a1);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviation::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviation::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_MeanSemiDeviation::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviation::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviation::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviation::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviation::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	double computeDual(class ROL::SampleGenerator<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "computeDual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_RandVarFunctional::computeDual(a0);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviation<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::PD_MeanSemiDeviationFromTarget file:ROL_PD_MeanSemiDeviationFromTarget.hpp line:18
struct PyCallBack_ROL_PD_MeanSemiDeviationFromTarget_double_t : public ROL::PD_MeanSemiDeviationFromTarget<double> {
	using ROL::PD_MeanSemiDeviationFromTarget<double>::PD_MeanSemiDeviationFromTarget;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::setHessVecStorage(a0, a1);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_MeanSemiDeviationFromTarget::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	double computeDual(class ROL::SampleGenerator<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "computeDual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_RandVarFunctional::computeDual(a0);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_MeanSemiDeviationFromTarget<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::PD_CVaR file:ROL_PD_CVaR.hpp line:19
struct PyCallBack_ROL_PD_CVaR_double_t : public ROL::PD_CVaR<double> {
	using ROL::PD_CVaR<double>::PD_CVaR;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_CVaR::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_CVaR::setHessVecStorage(a0, a1);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_CVaR::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_CVaR::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_CVaR::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_CVaR::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_CVaR::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_CVaR::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_CVaR::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	double computeDual(class ROL::SampleGenerator<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "computeDual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_RandVarFunctional::computeDual(a0);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_CVaR<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::PD_BPOE file:ROL_PD_BPOE.hpp line:19
struct PyCallBack_ROL_PD_BPOE_double_t : public ROL::PD_BPOE<double> {
	using ROL::PD_BPOE<double>::PD_BPOE;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_BPOE::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_BPOE::setHessVecStorage(a0, a1);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_BPOE::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_BPOE::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_BPOE::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_BPOE::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_BPOE::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_BPOE::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_BPOE::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	double computeDual(class ROL::SampleGenerator<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "computeDual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_RandVarFunctional::computeDual(a0);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_BPOE<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::PD_HMCR2 file:ROL_PD_HMCR2.hpp line:19
struct PyCallBack_ROL_PD_HMCR2_double_t : public ROL::PD_HMCR2<double> {
	using ROL::PD_HMCR2<double>::PD_HMCR2;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_HMCR2::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_HMCR2::setHessVecStorage(a0, a1);
	}
	double computeDual(class ROL::SampleGenerator<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "computeDual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_HMCR2::computeDual(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_HMCR2::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_HMCR2::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PD_HMCR2::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_HMCR2::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_HMCR2::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_HMCR2::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return PD_HMCR2::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PD_HMCR2<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::SerialConstraint file: line:62
struct PyCallBack_ROL_SerialConstraint_double_t : public ROL::SerialConstraint<double> {
	using ROL::SerialConstraint<double>::SerialConstraint;

	void solve(class ROL::Vector<double> & a0, class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "solve");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::solve(a0, a1, a2, a3);
	}
	void update(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, bool a2, int a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::update(a0, a1, a2, a3);
	}
	void value(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::value(a0, a1, a2, a3);
	}
	void applyJacobian_1(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyJacobian_1(a0, a1, a2, a3, a4);
	}
	void applyInverseJacobian_1(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyInverseJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyInverseJacobian_1(a0, a1, a2, a3, a4);
	}
	void applyAdjointJacobian_1(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyAdjointJacobian_1(a0, a1, a2, a3, a4, a5);
	}
	void applyInverseAdjointJacobian_1(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyInverseAdjointJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyInverseAdjointJacobian_1(a0, a1, a2, a3, a4);
	}
	void applyJacobian_2(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyJacobian_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyJacobian_2(a0, a1, a2, a3, a4);
	}
	void applyAdjointJacobian_2(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointJacobian_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyAdjointJacobian_2(a0, a1, a2, a3, a4);
	}
	void applyAdjointHessian_11(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointHessian_11");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyAdjointHessian_11(a0, a1, a2, a3, a4, a5);
	}
	void applyAdjointHessian_12(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointHessian_12");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyAdjointHessian_12(a0, a1, a2, a3, a4, a5);
	}
	void applyAdjointHessian_21(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointHessian_21");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyAdjointHessian_21(a0, a1, a2, a3, a4, a5);
	}
	void applyAdjointHessian_22(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointHessian_22");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialConstraint::applyAdjointHessian_22(a0, a1, a2, a3, a4, a5);
	}
	void update(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, enum ROL::UpdateType a2, int a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::update(a0, a1, a2, a3);
	}
	void update_1(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "update_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::update_1(a0, a1, a2);
	}
	void update_1(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "update_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::update_1(a0, a1, a2);
	}
	void update_2(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "update_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::update_2(a0, a1, a2);
	}
	void update_2(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "update_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::update_2(a0, a1, a2);
	}
	void solve_update(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, enum ROL::UpdateType a2, int a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "solve_update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::solve_update(a0, a1, a2, a3);
	}
	void setSolveParameters(class Teuchos::ParameterList & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "setSolveParameters");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::setSolveParameters(a0);
	}
	void applyAdjointJacobian_1(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::applyAdjointJacobian_1(a0, a1, a2, a3, a4);
	}
	void applyAdjointJacobian_2(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointJacobian_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::applyAdjointJacobian_2(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<double> solveAugmentedSystem(class ROL::Vector<double> & a0, class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "solveAugmentedSystem");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Constraint_SimOpt::solveAugmentedSystem(a0, a1, a2, a3, a4, a5);
	}
	void applyPreconditioner(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyPreconditioner");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::applyPreconditioner(a0, a1, a2, a3, a4);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::update(a0, a1, a2);
	}
	void value(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::value(a0, a1, a2);
	}
	void applyJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::applyJacobian(a0, a1, a2, a3);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::applyAdjointJacobian(a0, a1, a2, a3);
	}
	void applyAdjointHessian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint_SimOpt::applyAdjointHessian(a0, a1, a2, a3, a4);
	}
	double checkSolve(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkSolve");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint_SimOpt::checkSolve(a0, a1, a2, a3, a4);
	}
	double checkAdjointConsistencyJacobian_1(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkAdjointConsistencyJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint_SimOpt::checkAdjointConsistencyJacobian_1(a0, a1, a2, a3, a4, a5);
	}
	double checkAdjointConsistencyJacobian_1(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class ROL::Vector<double> & a5, const bool a6, std::ostream & a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkAdjointConsistencyJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint_SimOpt::checkAdjointConsistencyJacobian_1(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	double checkAdjointConsistencyJacobian_2(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkAdjointConsistencyJacobian_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint_SimOpt::checkAdjointConsistencyJacobian_2(a0, a1, a2, a3, a4, a5);
	}
	double checkAdjointConsistencyJacobian_2(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class ROL::Vector<double> & a5, const bool a6, std::ostream & a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkAdjointConsistencyJacobian_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint_SimOpt::checkAdjointConsistencyJacobian_2(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	double checkInverseJacobian_1(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkInverseJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint_SimOpt::checkInverseJacobian_1(a0, a1, a2, a3, a4, a5);
	}
	double checkInverseAdjointJacobian_1(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkInverseAdjointJacobian_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint_SimOpt::checkInverseAdjointJacobian_1(a0, a1, a2, a3, a4, a5);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyAdjointJacobian(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkApplyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool a5, std::ostream & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool a5, std::ostream & a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialConstraint<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::setParameter(a0);
	}
};

// ROL::SerialObjective file: line:63
struct PyCallBack_ROL_SerialObjective_double_t : public ROL::SerialObjective<double> {
	using ROL::SerialObjective<double>::SerialObjective;

	double value(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SerialObjective::value(a0, a1, a2);
	}
	void gradient_1(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "gradient_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialObjective::gradient_1(a0, a1, a2, a3);
	}
	void gradient_2(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "gradient_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialObjective::gradient_2(a0, a1, a2, a3);
	}
	void hessVec_11(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "hessVec_11");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialObjective::hessVec_11(a0, a1, a2, a3, a4);
	}
	void hessVec_12(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "hessVec_12");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialObjective::hessVec_12(a0, a1, a2, a3, a4);
	}
	void hessVec_21(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "hessVec_21");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialObjective::hessVec_21(a0, a1, a2, a3, a4);
	}
	void hessVec_22(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "hessVec_22");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SerialObjective::hessVec_22(a0, a1, a2, a3, a4);
	}
	void update(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, bool a2, int a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::update(a0, a1, a2, a3);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, enum ROL::UpdateType a2, int a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::update(a0, a1, a2, a3);
	}
	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::update(a0, a1, a2);
	}
	double value(const class ROL::Vector<double> & a0, double & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Objective_SimOpt::value(a0, a1);
	}
	void gradient(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "gradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::gradient(a0, a1, a2);
	}
	void hessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "hessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::hessVec(a0, a1, a2, a3);
	}
	double dirDeriv(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "dirDeriv");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Objective::dirDeriv(a0, a1, a2);
	}
	void invHessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "invHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::invHessVec(a0, a1, a2, a3);
	}
	void precond(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "precond");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::precond(a0, a1, a2, a3);
	}
	void prox(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "prox");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::prox(a0, a1, a2, a3);
	}
	void proxJacVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "proxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::proxJacVec(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkProxJacVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, bool a3, std::ostream & a4, int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "checkProxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkProxJacVec(a0, a1, a2, a3, a4, a5);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SerialObjective<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::setParameter(a0);
	}
};

// ROL::SampleGenerator file: line:72
struct PyCallBack_ROL_SampleGenerator_double_t : public ROL::SampleGenerator<double> {
	using ROL::SampleGenerator<double>::SampleGenerator;

	void update(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SampleGenerator::update(a0);
	}
	int start() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "start");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return SampleGenerator::start();
	}
	double computeError(class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "computeError");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SampleGenerator::computeError(a0);
	}
	void refine() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "refine");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SampleGenerator::refine();
	}
	void setSamples(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "setSamples");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SampleGenerator::setSamples(a0);
	}
	int numGlobalSamples() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "numGlobalSamples");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return SampleGenerator::numGlobalSamples();
	}
	int numMySamples() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "numMySamples");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return SampleGenerator::numMySamples();
	}
	class std::vector<double> getMyPoint(const int a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "getMyPoint");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return SampleGenerator::getMyPoint(a0);
	}
	double getMyWeight(const int a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SampleGenerator<double> *>(this), "getMyWeight");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SampleGenerator::getMyWeight(a0);
	}
};

// ROL::StochasticProblem file: line:73
struct PyCallBack_ROL_StochasticProblem_double_t : public ROL::StochasticProblem<double> {
	using ROL::StochasticProblem<double>::StochasticProblem;

	void finalize(bool a0, bool a1, std::ostream & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticProblem<double> *>(this), "finalize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticProblem::finalize(a0, a1, a2);
	}
	void edit() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticProblem<double> *>(this), "edit");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticProblem::edit();
	}
};

// ROL::UserInputGenerator file: line:74
struct PyCallBack_ROL_UserInputGenerator_double_t : public ROL::UserInputGenerator<double> {
	using ROL::UserInputGenerator<double>::UserInputGenerator;

	void refine() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "refine");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return UserInputGenerator::refine();
	}
	int numGlobalSamples() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "numGlobalSamples");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return UserInputGenerator::numGlobalSamples();
	}
	void update(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SampleGenerator::update(a0);
	}
	int start() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "start");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return SampleGenerator::start();
	}
	double computeError(class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "computeError");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SampleGenerator::computeError(a0);
	}
	void setSamples(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "setSamples");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SampleGenerator::setSamples(a0);
	}
	int numMySamples() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "numMySamples");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return SampleGenerator::numMySamples();
	}
	class std::vector<double> getMyPoint(const int a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "getMyPoint");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return SampleGenerator::getMyPoint(a0);
	}
	double getMyWeight(const int a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::UserInputGenerator<double> *>(this), "getMyWeight");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SampleGenerator::getMyWeight(a0);
	}
};

void bind_pyrol_75(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // ROL::PD_RandVarFunctional file:ROL_PD_RandVarFunctional.hpp line:18
		pybind11::class_<ROL::PD_RandVarFunctional<double>, Teuchos::RCP<ROL::PD_RandVarFunctional<double>>, PyCallBack_ROL_PD_RandVarFunctional_double_t, ROL::RandVarFunctional<double>> cl(M("ROL"), "PD_RandVarFunctional_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::PD_RandVarFunctional<double>(); }, [](){ return new PyCallBack_ROL_PD_RandVarFunctional_double_t(); } ) );
		cl.def( pybind11::init( [](PyCallBack_ROL_PD_RandVarFunctional_double_t const &o){ return new PyCallBack_ROL_PD_RandVarFunctional_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::PD_RandVarFunctional<double> const &o){ return new ROL::PD_RandVarFunctional<double>(o); } ) );
		cl.def("setData", [](ROL::PD_RandVarFunctional<double> &o, class ROL::SampleGenerator<double> & a0, const double & a1) -> void { return o.setData(a0, a1); }, "", pybind11::arg("sampler"), pybind11::arg("pen"));
		cl.def("setData", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &, const double, const double)) &ROL::PD_RandVarFunctional<double>::setData, "C++: ROL::PD_RandVarFunctional<double>::setData(class ROL::SampleGenerator<double> &, const double, const double) --> void", pybind11::arg("sampler"), pybind11::arg("pen"), pybind11::arg("lam"));
		cl.def("computeDual", (double (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::computeDual, "C++: ROL::PD_RandVarFunctional<double>::computeDual(class ROL::SampleGenerator<double> &) --> double", pybind11::arg("sampler"));
		cl.def("updateDual", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::updateDual, "C++: ROL::PD_RandVarFunctional<double>::updateDual(class ROL::SampleGenerator<double> &) --> void", pybind11::arg("sampler"));
		cl.def("updatePenalty", (void (ROL::PD_RandVarFunctional<double>::*)(const double)) &ROL::PD_RandVarFunctional<double>::updatePenalty, "C++: ROL::PD_RandVarFunctional<double>::updatePenalty(const double) --> void", pybind11::arg("pen"));
		cl.def("setStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setStorage, "C++: ROL::PD_RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setHessVecStorage, "C++: ROL::PD_RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_RandVarFunctional<double>::initialize, "C++: ROL::PD_RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("assign", (class ROL::PD_RandVarFunctional<double> & (ROL::PD_RandVarFunctional<double>::*)(const class ROL::PD_RandVarFunctional<double> &)) &ROL::PD_RandVarFunctional<double>::operator=, "C++: ROL::PD_RandVarFunctional<double>::operator=(const class ROL::PD_RandVarFunctional<double> &) --> class ROL::PD_RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::PD_MeanSemiDeviation file:ROL_PD_MeanSemiDeviation.hpp line:18
		pybind11::class_<ROL::PD_MeanSemiDeviation<double>, Teuchos::RCP<ROL::PD_MeanSemiDeviation<double>>, PyCallBack_ROL_PD_MeanSemiDeviation_double_t, ROL::PD_RandVarFunctional<double>> cl(M("ROL"), "PD_MeanSemiDeviation_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const double>(), pybind11::arg("coeff") );

		cl.def( pybind11::init( [](PyCallBack_ROL_PD_MeanSemiDeviation_double_t const &o){ return new PyCallBack_ROL_PD_MeanSemiDeviation_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::PD_MeanSemiDeviation<double> const &o){ return new ROL::PD_MeanSemiDeviation<double>(o); } ) );
		cl.def("setStorage", (void (ROL::PD_MeanSemiDeviation<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_MeanSemiDeviation<double>::setStorage, "C++: ROL::PD_MeanSemiDeviation<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_MeanSemiDeviation<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_MeanSemiDeviation<double>::setHessVecStorage, "C++: ROL::PD_MeanSemiDeviation<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_MeanSemiDeviation<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_MeanSemiDeviation<double>::initialize, "C++: ROL::PD_MeanSemiDeviation<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("updateValue", (void (ROL::PD_MeanSemiDeviation<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_MeanSemiDeviation<double>::updateValue, "C++: ROL::PD_MeanSemiDeviation<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::PD_MeanSemiDeviation<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_MeanSemiDeviation<double>::getValue, "C++: ROL::PD_MeanSemiDeviation<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateGradient", (void (ROL::PD_MeanSemiDeviation<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_MeanSemiDeviation<double>::updateGradient, "C++: ROL::PD_MeanSemiDeviation<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getGradient", (void (ROL::PD_MeanSemiDeviation<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_MeanSemiDeviation<double>::getGradient, "C++: ROL::PD_MeanSemiDeviation<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateHessVec", (void (ROL::PD_MeanSemiDeviation<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_MeanSemiDeviation<double>::updateHessVec, "C++: ROL::PD_MeanSemiDeviation<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getHessVec", (void (ROL::PD_MeanSemiDeviation<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_MeanSemiDeviation<double>::getHessVec, "C++: ROL::PD_MeanSemiDeviation<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::PD_MeanSemiDeviation<double> & (ROL::PD_MeanSemiDeviation<double>::*)(const class ROL::PD_MeanSemiDeviation<double> &)) &ROL::PD_MeanSemiDeviation<double>::operator=, "C++: ROL::PD_MeanSemiDeviation<double>::operator=(const class ROL::PD_MeanSemiDeviation<double> &) --> class ROL::PD_MeanSemiDeviation<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("setData", [](ROL::PD_RandVarFunctional<double> &o, class ROL::SampleGenerator<double> & a0, const double & a1) -> void { return o.setData(a0, a1); }, "", pybind11::arg("sampler"), pybind11::arg("pen"));
		cl.def("setData", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &, const double, const double)) &ROL::PD_RandVarFunctional<double>::setData, "C++: ROL::PD_RandVarFunctional<double>::setData(class ROL::SampleGenerator<double> &, const double, const double) --> void", pybind11::arg("sampler"), pybind11::arg("pen"), pybind11::arg("lam"));
		cl.def("computeDual", (double (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::computeDual, "C++: ROL::PD_RandVarFunctional<double>::computeDual(class ROL::SampleGenerator<double> &) --> double", pybind11::arg("sampler"));
		cl.def("updateDual", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::updateDual, "C++: ROL::PD_RandVarFunctional<double>::updateDual(class ROL::SampleGenerator<double> &) --> void", pybind11::arg("sampler"));
		cl.def("updatePenalty", (void (ROL::PD_RandVarFunctional<double>::*)(const double)) &ROL::PD_RandVarFunctional<double>::updatePenalty, "C++: ROL::PD_RandVarFunctional<double>::updatePenalty(const double) --> void", pybind11::arg("pen"));
		cl.def("setStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setStorage, "C++: ROL::PD_RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setHessVecStorage, "C++: ROL::PD_RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_RandVarFunctional<double>::initialize, "C++: ROL::PD_RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("assign", (class ROL::PD_RandVarFunctional<double> & (ROL::PD_RandVarFunctional<double>::*)(const class ROL::PD_RandVarFunctional<double> &)) &ROL::PD_RandVarFunctional<double>::operator=, "C++: ROL::PD_RandVarFunctional<double>::operator=(const class ROL::PD_RandVarFunctional<double> &) --> class ROL::PD_RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::PD_MeanSemiDeviationFromTarget file:ROL_PD_MeanSemiDeviationFromTarget.hpp line:18
		pybind11::class_<ROL::PD_MeanSemiDeviationFromTarget<double>, Teuchos::RCP<ROL::PD_MeanSemiDeviationFromTarget<double>>, PyCallBack_ROL_PD_MeanSemiDeviationFromTarget_double_t, ROL::PD_RandVarFunctional<double>> cl(M("ROL"), "PD_MeanSemiDeviationFromTarget_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("coeff"), pybind11::arg("target") );

		cl.def( pybind11::init( [](PyCallBack_ROL_PD_MeanSemiDeviationFromTarget_double_t const &o){ return new PyCallBack_ROL_PD_MeanSemiDeviationFromTarget_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::PD_MeanSemiDeviationFromTarget<double> const &o){ return new ROL::PD_MeanSemiDeviationFromTarget<double>(o); } ) );
		cl.def("setStorage", (void (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::setStorage, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::setHessVecStorage, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::initialize, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("updateValue", (void (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::updateValue, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::getValue, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateGradient", (void (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::updateGradient, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getGradient", (void (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::getGradient, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateHessVec", (void (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::updateHessVec, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getHessVec", (void (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::getHessVec, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::PD_MeanSemiDeviationFromTarget<double> & (ROL::PD_MeanSemiDeviationFromTarget<double>::*)(const class ROL::PD_MeanSemiDeviationFromTarget<double> &)) &ROL::PD_MeanSemiDeviationFromTarget<double>::operator=, "C++: ROL::PD_MeanSemiDeviationFromTarget<double>::operator=(const class ROL::PD_MeanSemiDeviationFromTarget<double> &) --> class ROL::PD_MeanSemiDeviationFromTarget<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("setData", [](ROL::PD_RandVarFunctional<double> &o, class ROL::SampleGenerator<double> & a0, const double & a1) -> void { return o.setData(a0, a1); }, "", pybind11::arg("sampler"), pybind11::arg("pen"));
		cl.def("setData", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &, const double, const double)) &ROL::PD_RandVarFunctional<double>::setData, "C++: ROL::PD_RandVarFunctional<double>::setData(class ROL::SampleGenerator<double> &, const double, const double) --> void", pybind11::arg("sampler"), pybind11::arg("pen"), pybind11::arg("lam"));
		cl.def("computeDual", (double (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::computeDual, "C++: ROL::PD_RandVarFunctional<double>::computeDual(class ROL::SampleGenerator<double> &) --> double", pybind11::arg("sampler"));
		cl.def("updateDual", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::updateDual, "C++: ROL::PD_RandVarFunctional<double>::updateDual(class ROL::SampleGenerator<double> &) --> void", pybind11::arg("sampler"));
		cl.def("updatePenalty", (void (ROL::PD_RandVarFunctional<double>::*)(const double)) &ROL::PD_RandVarFunctional<double>::updatePenalty, "C++: ROL::PD_RandVarFunctional<double>::updatePenalty(const double) --> void", pybind11::arg("pen"));
		cl.def("setStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setStorage, "C++: ROL::PD_RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setHessVecStorage, "C++: ROL::PD_RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_RandVarFunctional<double>::initialize, "C++: ROL::PD_RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("assign", (class ROL::PD_RandVarFunctional<double> & (ROL::PD_RandVarFunctional<double>::*)(const class ROL::PD_RandVarFunctional<double> &)) &ROL::PD_RandVarFunctional<double>::operator=, "C++: ROL::PD_RandVarFunctional<double>::operator=(const class ROL::PD_RandVarFunctional<double> &) --> class ROL::PD_RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::PD_CVaR file:ROL_PD_CVaR.hpp line:19
		pybind11::class_<ROL::PD_CVaR<double>, Teuchos::RCP<ROL::PD_CVaR<double>>, PyCallBack_ROL_PD_CVaR_double_t, ROL::PD_RandVarFunctional<double>> cl(M("ROL"), "PD_CVaR_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("alpha"), pybind11::arg("beta") );

		cl.def( pybind11::init( [](PyCallBack_ROL_PD_CVaR_double_t const &o){ return new PyCallBack_ROL_PD_CVaR_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::PD_CVaR<double> const &o){ return new ROL::PD_CVaR<double>(o); } ) );
		cl.def("setStorage", (void (ROL::PD_CVaR<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_CVaR<double>::setStorage, "C++: ROL::PD_CVaR<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_CVaR<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_CVaR<double>::setHessVecStorage, "C++: ROL::PD_CVaR<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_CVaR<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_CVaR<double>::initialize, "C++: ROL::PD_CVaR<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("updateValue", (void (ROL::PD_CVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_CVaR<double>::updateValue, "C++: ROL::PD_CVaR<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::PD_CVaR<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_CVaR<double>::getValue, "C++: ROL::PD_CVaR<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateGradient", (void (ROL::PD_CVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_CVaR<double>::updateGradient, "C++: ROL::PD_CVaR<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getGradient", (void (ROL::PD_CVaR<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_CVaR<double>::getGradient, "C++: ROL::PD_CVaR<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateHessVec", (void (ROL::PD_CVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_CVaR<double>::updateHessVec, "C++: ROL::PD_CVaR<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getHessVec", (void (ROL::PD_CVaR<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_CVaR<double>::getHessVec, "C++: ROL::PD_CVaR<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::PD_CVaR<double> & (ROL::PD_CVaR<double>::*)(const class ROL::PD_CVaR<double> &)) &ROL::PD_CVaR<double>::operator=, "C++: ROL::PD_CVaR<double>::operator=(const class ROL::PD_CVaR<double> &) --> class ROL::PD_CVaR<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("setData", [](ROL::PD_RandVarFunctional<double> &o, class ROL::SampleGenerator<double> & a0, const double & a1) -> void { return o.setData(a0, a1); }, "", pybind11::arg("sampler"), pybind11::arg("pen"));
		cl.def("setData", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &, const double, const double)) &ROL::PD_RandVarFunctional<double>::setData, "C++: ROL::PD_RandVarFunctional<double>::setData(class ROL::SampleGenerator<double> &, const double, const double) --> void", pybind11::arg("sampler"), pybind11::arg("pen"), pybind11::arg("lam"));
		cl.def("computeDual", (double (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::computeDual, "C++: ROL::PD_RandVarFunctional<double>::computeDual(class ROL::SampleGenerator<double> &) --> double", pybind11::arg("sampler"));
		cl.def("updateDual", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::updateDual, "C++: ROL::PD_RandVarFunctional<double>::updateDual(class ROL::SampleGenerator<double> &) --> void", pybind11::arg("sampler"));
		cl.def("updatePenalty", (void (ROL::PD_RandVarFunctional<double>::*)(const double)) &ROL::PD_RandVarFunctional<double>::updatePenalty, "C++: ROL::PD_RandVarFunctional<double>::updatePenalty(const double) --> void", pybind11::arg("pen"));
		cl.def("setStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setStorage, "C++: ROL::PD_RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setHessVecStorage, "C++: ROL::PD_RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_RandVarFunctional<double>::initialize, "C++: ROL::PD_RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("assign", (class ROL::PD_RandVarFunctional<double> & (ROL::PD_RandVarFunctional<double>::*)(const class ROL::PD_RandVarFunctional<double> &)) &ROL::PD_RandVarFunctional<double>::operator=, "C++: ROL::PD_RandVarFunctional<double>::operator=(const class ROL::PD_RandVarFunctional<double> &) --> class ROL::PD_RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::PD_BPOE file:ROL_PD_BPOE.hpp line:19
		pybind11::class_<ROL::PD_BPOE<double>, Teuchos::RCP<ROL::PD_BPOE<double>>, PyCallBack_ROL_PD_BPOE_double_t, ROL::PD_RandVarFunctional<double>> cl(M("ROL"), "PD_BPOE_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const double>(), pybind11::arg("thresh") );

		cl.def( pybind11::init( [](PyCallBack_ROL_PD_BPOE_double_t const &o){ return new PyCallBack_ROL_PD_BPOE_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::PD_BPOE<double> const &o){ return new ROL::PD_BPOE<double>(o); } ) );
		cl.def("setStorage", (void (ROL::PD_BPOE<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_BPOE<double>::setStorage, "C++: ROL::PD_BPOE<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_BPOE<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_BPOE<double>::setHessVecStorage, "C++: ROL::PD_BPOE<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_BPOE<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_BPOE<double>::initialize, "C++: ROL::PD_BPOE<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("updateValue", (void (ROL::PD_BPOE<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_BPOE<double>::updateValue, "C++: ROL::PD_BPOE<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::PD_BPOE<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_BPOE<double>::getValue, "C++: ROL::PD_BPOE<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateGradient", (void (ROL::PD_BPOE<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_BPOE<double>::updateGradient, "C++: ROL::PD_BPOE<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getGradient", (void (ROL::PD_BPOE<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_BPOE<double>::getGradient, "C++: ROL::PD_BPOE<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateHessVec", (void (ROL::PD_BPOE<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_BPOE<double>::updateHessVec, "C++: ROL::PD_BPOE<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getHessVec", (void (ROL::PD_BPOE<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_BPOE<double>::getHessVec, "C++: ROL::PD_BPOE<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::PD_BPOE<double> & (ROL::PD_BPOE<double>::*)(const class ROL::PD_BPOE<double> &)) &ROL::PD_BPOE<double>::operator=, "C++: ROL::PD_BPOE<double>::operator=(const class ROL::PD_BPOE<double> &) --> class ROL::PD_BPOE<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("setData", [](ROL::PD_RandVarFunctional<double> &o, class ROL::SampleGenerator<double> & a0, const double & a1) -> void { return o.setData(a0, a1); }, "", pybind11::arg("sampler"), pybind11::arg("pen"));
		cl.def("setData", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &, const double, const double)) &ROL::PD_RandVarFunctional<double>::setData, "C++: ROL::PD_RandVarFunctional<double>::setData(class ROL::SampleGenerator<double> &, const double, const double) --> void", pybind11::arg("sampler"), pybind11::arg("pen"), pybind11::arg("lam"));
		cl.def("computeDual", (double (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::computeDual, "C++: ROL::PD_RandVarFunctional<double>::computeDual(class ROL::SampleGenerator<double> &) --> double", pybind11::arg("sampler"));
		cl.def("updateDual", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::updateDual, "C++: ROL::PD_RandVarFunctional<double>::updateDual(class ROL::SampleGenerator<double> &) --> void", pybind11::arg("sampler"));
		cl.def("updatePenalty", (void (ROL::PD_RandVarFunctional<double>::*)(const double)) &ROL::PD_RandVarFunctional<double>::updatePenalty, "C++: ROL::PD_RandVarFunctional<double>::updatePenalty(const double) --> void", pybind11::arg("pen"));
		cl.def("setStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setStorage, "C++: ROL::PD_RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setHessVecStorage, "C++: ROL::PD_RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_RandVarFunctional<double>::initialize, "C++: ROL::PD_RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("assign", (class ROL::PD_RandVarFunctional<double> & (ROL::PD_RandVarFunctional<double>::*)(const class ROL::PD_RandVarFunctional<double> &)) &ROL::PD_RandVarFunctional<double>::operator=, "C++: ROL::PD_RandVarFunctional<double>::operator=(const class ROL::PD_RandVarFunctional<double> &) --> class ROL::PD_RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::PD_HMCR2 file:ROL_PD_HMCR2.hpp line:19
		pybind11::class_<ROL::PD_HMCR2<double>, Teuchos::RCP<ROL::PD_HMCR2<double>>, PyCallBack_ROL_PD_HMCR2_double_t, ROL::PD_RandVarFunctional<double>> cl(M("ROL"), "PD_HMCR2_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const double>(), pybind11::arg("beta") );

		cl.def( pybind11::init( [](PyCallBack_ROL_PD_HMCR2_double_t const &o){ return new PyCallBack_ROL_PD_HMCR2_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::PD_HMCR2<double> const &o){ return new ROL::PD_HMCR2<double>(o); } ) );
		cl.def("setStorage", (void (ROL::PD_HMCR2<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_HMCR2<double>::setStorage, "C++: ROL::PD_HMCR2<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_HMCR2<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_HMCR2<double>::setHessVecStorage, "C++: ROL::PD_HMCR2<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("computeDual", (double (ROL::PD_HMCR2<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_HMCR2<double>::computeDual, "C++: ROL::PD_HMCR2<double>::computeDual(class ROL::SampleGenerator<double> &) --> double", pybind11::arg("sampler"));
		cl.def("initialize", (void (ROL::PD_HMCR2<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_HMCR2<double>::initialize, "C++: ROL::PD_HMCR2<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("updateValue", (void (ROL::PD_HMCR2<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_HMCR2<double>::updateValue, "C++: ROL::PD_HMCR2<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::PD_HMCR2<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_HMCR2<double>::getValue, "C++: ROL::PD_HMCR2<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateGradient", (void (ROL::PD_HMCR2<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_HMCR2<double>::updateGradient, "C++: ROL::PD_HMCR2<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getGradient", (void (ROL::PD_HMCR2<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_HMCR2<double>::getGradient, "C++: ROL::PD_HMCR2<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateHessVec", (void (ROL::PD_HMCR2<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::PD_HMCR2<double>::updateHessVec, "C++: ROL::PD_HMCR2<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getHessVec", (void (ROL::PD_HMCR2<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::PD_HMCR2<double>::getHessVec, "C++: ROL::PD_HMCR2<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::PD_HMCR2<double> & (ROL::PD_HMCR2<double>::*)(const class ROL::PD_HMCR2<double> &)) &ROL::PD_HMCR2<double>::operator=, "C++: ROL::PD_HMCR2<double>::operator=(const class ROL::PD_HMCR2<double> &) --> class ROL::PD_HMCR2<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("setData", [](ROL::PD_RandVarFunctional<double> &o, class ROL::SampleGenerator<double> & a0, const double & a1) -> void { return o.setData(a0, a1); }, "", pybind11::arg("sampler"), pybind11::arg("pen"));
		cl.def("setData", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &, const double, const double)) &ROL::PD_RandVarFunctional<double>::setData, "C++: ROL::PD_RandVarFunctional<double>::setData(class ROL::SampleGenerator<double> &, const double, const double) --> void", pybind11::arg("sampler"), pybind11::arg("pen"), pybind11::arg("lam"));
		cl.def("computeDual", (double (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::computeDual, "C++: ROL::PD_RandVarFunctional<double>::computeDual(class ROL::SampleGenerator<double> &) --> double", pybind11::arg("sampler"));
		cl.def("updateDual", (void (ROL::PD_RandVarFunctional<double>::*)(class ROL::SampleGenerator<double> &)) &ROL::PD_RandVarFunctional<double>::updateDual, "C++: ROL::PD_RandVarFunctional<double>::updateDual(class ROL::SampleGenerator<double> &) --> void", pybind11::arg("sampler"));
		cl.def("updatePenalty", (void (ROL::PD_RandVarFunctional<double>::*)(const double)) &ROL::PD_RandVarFunctional<double>::updatePenalty, "C++: ROL::PD_RandVarFunctional<double>::updatePenalty(const double) --> void", pybind11::arg("pen"));
		cl.def("setStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setStorage, "C++: ROL::PD_RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::PD_RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::PD_RandVarFunctional<double>::setHessVecStorage, "C++: ROL::PD_RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("initialize", (void (ROL::PD_RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::PD_RandVarFunctional<double>::initialize, "C++: ROL::PD_RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("assign", (class ROL::PD_RandVarFunctional<double> & (ROL::PD_RandVarFunctional<double>::*)(const class ROL::PD_RandVarFunctional<double> &)) &ROL::PD_RandVarFunctional<double>::operator=, "C++: ROL::PD_RandVarFunctional<double>::operator=(const class ROL::PD_RandVarFunctional<double> &) --> class ROL::PD_RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Sketch file:ROL_Sketch.hpp line:31
		pybind11::class_<ROL::Sketch<double>, Teuchos::RCP<ROL::Sketch<double>>> cl(M("ROL"), "Sketch_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](const class ROL::Vector<double> & a0, int const & a1, int const & a2){ return new ROL::Sketch<double>(a0, a1, a2); } ), "doc" , pybind11::arg("x"), pybind11::arg("ncol"), pybind11::arg("rank"));
		cl.def( pybind11::init( [](const class ROL::Vector<double> & a0, int const & a1, int const & a2, double const & a3){ return new ROL::Sketch<double>(a0, a1, a2, a3); } ), "doc" , pybind11::arg("x"), pybind11::arg("ncol"), pybind11::arg("rank"), pybind11::arg("orthTol"));
		cl.def( pybind11::init( [](const class ROL::Vector<double> & a0, int const & a1, int const & a2, double const & a3, int const & a4){ return new ROL::Sketch<double>(a0, a1, a2, a3, a4); } ), "doc" , pybind11::arg("x"), pybind11::arg("ncol"), pybind11::arg("rank"), pybind11::arg("orthTol"), pybind11::arg("orthIt"));
		cl.def( pybind11::init( [](const class ROL::Vector<double> & a0, int const & a1, int const & a2, double const & a3, int const & a4, bool const & a5){ return new ROL::Sketch<double>(a0, a1, a2, a3, a4, a5); } ), "doc" , pybind11::arg("x"), pybind11::arg("ncol"), pybind11::arg("rank"), pybind11::arg("orthTol"), pybind11::arg("orthIt"), pybind11::arg("truncate"));
		cl.def( pybind11::init( [](const class ROL::Vector<double> & a0, int const & a1, int const & a2, double const & a3, int const & a4, bool const & a5, unsigned int const & a6){ return new ROL::Sketch<double>(a0, a1, a2, a3, a4, a5, a6); } ), "doc" , pybind11::arg("x"), pybind11::arg("ncol"), pybind11::arg("rank"), pybind11::arg("orthTol"), pybind11::arg("orthIt"), pybind11::arg("truncate"), pybind11::arg("dom_seed"));
		cl.def( pybind11::init<const class ROL::Vector<double> &, int, int, double, int, bool, unsigned int, unsigned int>(), pybind11::arg("x"), pybind11::arg("ncol"), pybind11::arg("rank"), pybind11::arg("orthTol"), pybind11::arg("orthIt"), pybind11::arg("truncate"), pybind11::arg("dom_seed"), pybind11::arg("rng_seed") );

		cl.def( pybind11::init( [](ROL::Sketch<double> const &o){ return new ROL::Sketch<double>(o); } ) );
		cl.def("setStream", (void (ROL::Sketch<double>::*)(class Teuchos::RCP<std::ostream > &)) &ROL::Sketch<double>::setStream, "C++: ROL::Sketch<double>::setStream(class Teuchos::RCP<std::ostream > &) --> void", pybind11::arg("out"));
		cl.def("reset", [](ROL::Sketch<double> &o) -> void { return o.reset(); }, "");
		cl.def("reset", (void (ROL::Sketch<double>::*)(bool)) &ROL::Sketch<double>::reset, "C++: ROL::Sketch<double>::reset(bool) --> void", pybind11::arg("randomize"));
		cl.def("setRank", (void (ROL::Sketch<double>::*)(int)) &ROL::Sketch<double>::setRank, "C++: ROL::Sketch<double>::setRank(int) --> void", pybind11::arg("rank"));
		cl.def("update", (void (ROL::Sketch<double>::*)()) &ROL::Sketch<double>::update, "C++: ROL::Sketch<double>::update() --> void");
		cl.def("advance", [](ROL::Sketch<double> &o, double const & a0, const class ROL::Vector<double> & a1, int const & a2) -> int { return o.advance(a0, a1, a2); }, "", pybind11::arg("nu"), pybind11::arg("h"), pybind11::arg("col"));
		cl.def("advance", (int (ROL::Sketch<double>::*)(double, const class ROL::Vector<double> &, int, double)) &ROL::Sketch<double>::advance, "C++: ROL::Sketch<double>::advance(double, const class ROL::Vector<double> &, int, double) --> int", pybind11::arg("nu"), pybind11::arg("h"), pybind11::arg("col"), pybind11::arg("eta"));
		cl.def("reconstruct", (int (ROL::Sketch<double>::*)(class ROL::Vector<double> &, const int)) &ROL::Sketch<double>::reconstruct, "C++: ROL::Sketch<double>::reconstruct(class ROL::Vector<double> &, const int) --> int", pybind11::arg("a"), pybind11::arg("col"));
		cl.def("test", [](ROL::Sketch<double> &o, const int & a0) -> bool { return o.test(a0); }, "", pybind11::arg("rank"));
		cl.def("test", [](ROL::Sketch<double> &o, const int & a0, std::ostream & a1) -> bool { return o.test(a0, a1); }, "", pybind11::arg("rank"), pybind11::arg("outStream"));
		cl.def("test", (bool (ROL::Sketch<double>::*)(const int, std::ostream &, const int)) &ROL::Sketch<double>::test, "C++: ROL::Sketch<double>::test(const int, std::ostream &, const int) --> bool", pybind11::arg("rank"), pybind11::arg("outStream"), pybind11::arg("verbosity"));
	}
	{ // ROL::SerialConstraint file: line:62
		PYBIND11_TYPE_CASTER_BASE_HOLDER(ROL::SerialConstraint<double> , Teuchos::RCP<ROL::SerialConstraint<double>>)
		pybind11::class_<ROL::SerialConstraint<double>, Teuchos::RCP<ROL::SerialConstraint<double>>, PyCallBack_ROL_SerialConstraint_double_t, ROL::Constraint_SimOpt<double>, ROL::SerialFunction<double>> cl(M("ROL"), "SerialConstraint_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const class Teuchos::RCP<class ROL::DynamicConstraint<double> > &, const class ROL::Vector<double> &, const class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > > &>(), pybind11::arg("con"), pybind11::arg("u_initial"), pybind11::arg("timeStampsPtr") );

		cl.def( pybind11::init( [](PyCallBack_ROL_SerialConstraint_double_t const &o){ return new PyCallBack_ROL_SerialConstraint_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::SerialConstraint<double> const &o){ return new ROL::SerialConstraint<double>(o); } ) );
		cl.def("numTimeSteps", [](ROL::SerialConstraint<double> const &o) -> unsigned long { return o.numTimeSteps(); }, "");
		cl.def("getZeroState", [](ROL::SerialConstraint<double> const &o) -> const ROL::Vector<double> & { return o.getZeroState(); }, "", pybind11::return_value_policy::automatic);
		cl.def("getInitialCondition", [](ROL::SerialConstraint<double> const &o) -> const ROL::Vector<double> & { return o.getInitialCondition(); }, "", pybind11::return_value_policy::automatic);
		cl.def("getSkipInitialCondition", [](ROL::SerialConstraint<double> const &o) -> bool { return o.getSkipInitialCondition(); }, "");
		cl.def("value", [](ROL::SerialConstraint<double> &o, class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) -> void { return o.value(a0, a1, a2); }, "", pybind11::arg("c"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian_1", [](ROL::SerialConstraint<double> &o, class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) -> void { return o.applyAdjointJacobian_1(a0, a1, a2, a3, a4); }, "", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian_2", [](ROL::SerialConstraint<double> &o, class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) -> void { return o.applyAdjointJacobian_2(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualv"), pybind11::arg("tol"));
		cl.def("solve", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::solve, "C++: ROL::SerialConstraint<double>::solve(class ROL::Vector<double> &, class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("c"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("update", [](ROL::SerialConstraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("u"), pybind11::arg("z"));
		cl.def("update", [](ROL::SerialConstraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, bool const & a2) -> void { return o.update(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::SerialConstraint<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, bool, int)) &ROL::SerialConstraint<double>::update, "C++: ROL::SerialConstraint<double>::update(const class ROL::Vector<double> &, const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("value", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::value, "C++: ROL::SerialConstraint<double>::value(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("c"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyJacobian_1", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyJacobian_1, "C++: ROL::SerialConstraint<double>::applyJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyInverseJacobian_1", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyInverseJacobian_1, "C++: ROL::SerialConstraint<double>::applyInverseJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ijv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian_1", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyAdjointJacobian_1, "C++: ROL::SerialConstraint<double>::applyAdjointJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualv"), pybind11::arg("tol"));
		cl.def("applyInverseAdjointJacobian_1", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyInverseAdjointJacobian_1, "C++: ROL::SerialConstraint<double>::applyInverseAdjointJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("iajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyJacobian_2", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyJacobian_2, "C++: ROL::SerialConstraint<double>::applyJacobian_2(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian_2", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyAdjointJacobian_2, "C++: ROL::SerialConstraint<double>::applyAdjointJacobian_2(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian_11", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyAdjointHessian_11, "C++: ROL::SerialConstraint<double>::applyAdjointHessian_11(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian_12", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyAdjointHessian_12, "C++: ROL::SerialConstraint<double>::applyAdjointHessian_12(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian_21", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyAdjointHessian_21, "C++: ROL::SerialConstraint<double>::applyAdjointHessian_21(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian_22", (void (ROL::SerialConstraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialConstraint<double>::applyAdjointHessian_22, "C++: ROL::SerialConstraint<double>::applyAdjointHessian_22(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian", [](ROL::Constraint_SimOpt<double> &o, class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) -> void { return o.applyAdjointJacobian(a0, a1, a2, a3, a4); }, "", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("dualv"), pybind11::arg("tol"));
		cl.def("update", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("u"), pybind11::arg("z"));
		cl.def("update", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, bool const & a2) -> void { return o.update(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, bool, int)) &ROL::Constraint_SimOpt<double>::update, "C++: ROL::Constraint_SimOpt<double>::update(const class ROL::Vector<double> &, const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, enum ROL::UpdateType const & a2) -> void { return o.update(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Constraint_SimOpt<double>::update, "C++: ROL::Constraint_SimOpt<double>::update(const class ROL::Vector<double> &, const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update_1(a0); }, "", pybind11::arg("u"));
		cl.def("update_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update_1(a0, a1); }, "", pybind11::arg("u"), pybind11::arg("flag"));
		cl.def("update_1", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Constraint_SimOpt<double>::update_1, "C++: ROL::Constraint_SimOpt<double>::update_1(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("u"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("update_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update_1(a0, a1); }, "", pybind11::arg("u"), pybind11::arg("type"));
		cl.def("update_1", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Constraint_SimOpt<double>::update_1, "C++: ROL::Constraint_SimOpt<double>::update_1(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("u"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update_2(a0); }, "", pybind11::arg("z"));
		cl.def("update_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update_2(a0, a1); }, "", pybind11::arg("z"), pybind11::arg("flag"));
		cl.def("update_2", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Constraint_SimOpt<double>::update_2, "C++: ROL::Constraint_SimOpt<double>::update_2(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("z"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("update_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update_2(a0, a1); }, "", pybind11::arg("z"), pybind11::arg("type"));
		cl.def("update_2", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Constraint_SimOpt<double>::update_2, "C++: ROL::Constraint_SimOpt<double>::update_2(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("z"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("solve_update", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, enum ROL::UpdateType const & a2) -> void { return o.solve_update(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("type"));
		cl.def("solve_update", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Constraint_SimOpt<double>::solve_update, "C++: ROL::Constraint_SimOpt<double>::solve_update(const class ROL::Vector<double> &, const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("value", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::value, "C++: ROL::Constraint_SimOpt<double>::value(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("c"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("solve", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::solve, "C++: ROL::Constraint_SimOpt<double>::solve(class ROL::Vector<double> &, class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("c"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("setSolveParameters", (void (ROL::Constraint_SimOpt<double>::*)(class Teuchos::ParameterList &)) &ROL::Constraint_SimOpt<double>::setSolveParameters, "C++: ROL::Constraint_SimOpt<double>::setSolveParameters(class Teuchos::ParameterList &) --> void", pybind11::arg("parlist"));
		cl.def("applyJacobian_1", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyJacobian_1, "C++: ROL::Constraint_SimOpt<double>::applyJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyJacobian_2", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyJacobian_2, "C++: ROL::Constraint_SimOpt<double>::applyJacobian_2(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyInverseJacobian_1", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyInverseJacobian_1, "C++: ROL::Constraint_SimOpt<double>::applyInverseJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ijv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian_1", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointJacobian_1, "C++: ROL::Constraint_SimOpt<double>::applyAdjointJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian_1", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointJacobian_1, "C++: ROL::Constraint_SimOpt<double>::applyAdjointJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualv"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian_2", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointJacobian_2, "C++: ROL::Constraint_SimOpt<double>::applyAdjointJacobian_2(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian_2", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointJacobian_2, "C++: ROL::Constraint_SimOpt<double>::applyAdjointJacobian_2(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualv"), pybind11::arg("tol"));
		cl.def("applyInverseAdjointJacobian_1", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyInverseAdjointJacobian_1, "C++: ROL::Constraint_SimOpt<double>::applyInverseAdjointJacobian_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("iajv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian_11", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointHessian_11, "C++: ROL::Constraint_SimOpt<double>::applyAdjointHessian_11(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian_12", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointHessian_12, "C++: ROL::Constraint_SimOpt<double>::applyAdjointHessian_12(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian_21", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointHessian_21, "C++: ROL::Constraint_SimOpt<double>::applyAdjointHessian_21(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian_22", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointHessian_22, "C++: ROL::Constraint_SimOpt<double>::applyAdjointHessian_22(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("solveAugmentedSystem", (class std::vector<double> (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::solveAugmentedSystem, "C++: ROL::Constraint_SimOpt<double>::solveAugmentedSystem(class ROL::Vector<double> &, class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> class std::vector<double>", pybind11::arg("v1"), pybind11::arg("v2"), pybind11::arg("b1"), pybind11::arg("b2"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyPreconditioner", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyPreconditioner, "C++: ROL::Constraint_SimOpt<double>::applyPreconditioner(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("pv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("tol"));
		cl.def("update", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update(a0); }, "", pybind11::arg("x"));
		cl.def("update", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Constraint_SimOpt<double>::update, "C++: ROL::Constraint_SimOpt<double>::update(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("x"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Constraint_SimOpt<double>::update, "C++: ROL::Constraint_SimOpt<double>::update(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("x"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("value", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::value, "C++: ROL::Constraint_SimOpt<double>::value(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("c"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyJacobian", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyJacobian, "C++: ROL::Constraint_SimOpt<double>::applyJacobian(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointJacobian, "C++: ROL::Constraint_SimOpt<double>::applyAdjointJacobian(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian", (void (ROL::Constraint_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint_SimOpt<double>::applyAdjointHessian, "C++: ROL::Constraint_SimOpt<double>::applyAdjointHessian(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ahwv"), pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("checkSolve", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> double { return o.checkSolve(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("c"));
		cl.def("checkSolve", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> double { return o.checkSolve(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("c"), pybind11::arg("printToStream"));
		cl.def("checkSolve", (double (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint_SimOpt<double>::checkSolve, "C++: ROL::Constraint_SimOpt<double>::checkSolve(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("c"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkAdjointConsistencyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> double { return o.checkAdjointConsistencyJacobian_1(a0, a1, a2, a3); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"));
		cl.def("checkAdjointConsistencyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> double { return o.checkAdjointConsistencyJacobian_1(a0, a1, a2, a3, a4); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("printToStream"));
		cl.def("checkAdjointConsistencyJacobian_1", (double (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint_SimOpt<double>::checkAdjointConsistencyJacobian_1, "C++: ROL::Constraint_SimOpt<double>::checkAdjointConsistencyJacobian_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkAdjointConsistencyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class ROL::Vector<double> & a5) -> double { return o.checkAdjointConsistencyJacobian_1(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualw"), pybind11::arg("dualv"));
		cl.def("checkAdjointConsistencyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class ROL::Vector<double> & a5, const bool & a6) -> double { return o.checkAdjointConsistencyJacobian_1(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualw"), pybind11::arg("dualv"), pybind11::arg("printToStream"));
		cl.def("checkAdjointConsistencyJacobian_1", (double (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint_SimOpt<double>::checkAdjointConsistencyJacobian_1, "C++: ROL::Constraint_SimOpt<double>::checkAdjointConsistencyJacobian_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualw"), pybind11::arg("dualv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkAdjointConsistencyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> double { return o.checkAdjointConsistencyJacobian_2(a0, a1, a2, a3); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"));
		cl.def("checkAdjointConsistencyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> double { return o.checkAdjointConsistencyJacobian_2(a0, a1, a2, a3, a4); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("printToStream"));
		cl.def("checkAdjointConsistencyJacobian_2", (double (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint_SimOpt<double>::checkAdjointConsistencyJacobian_2, "C++: ROL::Constraint_SimOpt<double>::checkAdjointConsistencyJacobian_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkAdjointConsistencyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class ROL::Vector<double> & a5) -> double { return o.checkAdjointConsistencyJacobian_2(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualw"), pybind11::arg("dualv"));
		cl.def("checkAdjointConsistencyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class ROL::Vector<double> & a5, const bool & a6) -> double { return o.checkAdjointConsistencyJacobian_2(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualw"), pybind11::arg("dualv"), pybind11::arg("printToStream"));
		cl.def("checkAdjointConsistencyJacobian_2", (double (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint_SimOpt<double>::checkAdjointConsistencyJacobian_2, "C++: ROL::Constraint_SimOpt<double>::checkAdjointConsistencyJacobian_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("dualw"), pybind11::arg("dualv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkInverseJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> double { return o.checkInverseJacobian_1(a0, a1, a2, a3); }, "", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"));
		cl.def("checkInverseJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> double { return o.checkInverseJacobian_1(a0, a1, a2, a3, a4); }, "", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("printToStream"));
		cl.def("checkInverseJacobian_1", (double (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint_SimOpt<double>::checkInverseJacobian_1, "C++: ROL::Constraint_SimOpt<double>::checkInverseJacobian_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkInverseAdjointJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> double { return o.checkInverseAdjointJacobian_1(a0, a1, a2, a3); }, "", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"));
		cl.def("checkInverseAdjointJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> double { return o.checkInverseAdjointJacobian_1(a0, a1, a2, a3, a4); }, "", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("printToStream"));
		cl.def("checkInverseAdjointJacobian_1", (double (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint_SimOpt<double>::checkInverseAdjointJacobian_1, "C++: ROL::Constraint_SimOpt<double>::checkInverseAdjointJacobian_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_1(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"));
		cl.def("checkApplyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_1(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"));
		cl.def("checkApplyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_1(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4, std::ostream & a5, const int & a6) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_1(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkApplyJacobian_1", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Constraint_SimOpt<double>::checkApplyJacobian_1, "C++: ROL::Constraint_SimOpt<double>::checkApplyJacobian_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkApplyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_1(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"));
		cl.def("checkApplyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool & a5) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_1(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkApplyJacobian_1", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool & a5, std::ostream & a6) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_1(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyJacobian_1", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint_SimOpt<double>::checkApplyJacobian_1, "C++: ROL::Constraint_SimOpt<double>::checkApplyJacobian_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkApplyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_2(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"));
		cl.def("checkApplyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_2(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"));
		cl.def("checkApplyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_2(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4, std::ostream & a5, const int & a6) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_2(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkApplyJacobian_2", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Constraint_SimOpt<double>::checkApplyJacobian_2, "C++: ROL::Constraint_SimOpt<double>::checkApplyJacobian_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkApplyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_2(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"));
		cl.def("checkApplyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool & a5) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_2(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkApplyJacobian_2", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool & a5, std::ostream & a6) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian_2(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyJacobian_2", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint_SimOpt<double>::checkApplyJacobian_2, "C++: ROL::Constraint_SimOpt<double>::checkApplyJacobian_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian_11", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_11(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"));
		cl.def("checkApplyAdjointHessian_11", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_11(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian_11", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5, std::ostream & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_11(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian_11", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5, std::ostream & a6, const int & a7) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_11(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkApplyAdjointHessian_11", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_11, "C++: ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian_11", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_11(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"));
		cl.def("checkApplyAdjointHessian_11", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, const bool & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_11(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian_11", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, const bool & a6, std::ostream & a7) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_11(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian_11", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_11, "C++: ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian_21", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_21(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"));
		cl.def("checkApplyAdjointHessian_21", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_21(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian_21", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5, std::ostream & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_21(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian_21", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5, std::ostream & a6, const int & a7) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_21(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkApplyAdjointHessian_21", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_21, "C++: ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian_21", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_21(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"));
		cl.def("checkApplyAdjointHessian_21", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, const bool & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_21(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian_21", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, const bool & a6, std::ostream & a7) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_21(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian_21", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_21, "C++: ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian_12", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_12(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"));
		cl.def("checkApplyAdjointHessian_12", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_12(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian_12", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5, std::ostream & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_12(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian_12", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5, std::ostream & a6, const int & a7) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_12(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkApplyAdjointHessian_12", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_12, "C++: ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian_12", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_12(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"));
		cl.def("checkApplyAdjointHessian_12", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, const bool & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_12(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian_12", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, const bool & a6, std::ostream & a7) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_12(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian_12", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_12, "C++: ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian_22", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_22(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"));
		cl.def("checkApplyAdjointHessian_22", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_22(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian_22", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5, std::ostream & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_22(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian_22", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5, std::ostream & a6, const int & a7) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_22(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkApplyAdjointHessian_22", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_22, "C++: ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian_22", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_22(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"));
		cl.def("checkApplyAdjointHessian_22", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, const bool & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_22(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian_22", [](ROL::Constraint_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, const bool & a6, std::ostream & a7) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian_22(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian_22", (class std::vector<class std::vector<double> > (ROL::Constraint_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_22, "C++: ROL::Constraint_SimOpt<double>::checkApplyAdjointHessian_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("p"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("update", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Constraint<double>::update, "Update constraint function. \n\n      This function updates the constraint function at new iterations. \n      \n\n      is the new iterate. \n      \n\n   is the type of update requested.\n      \n\n   is the outer algorithm iterations count.\n\nC++: ROL::Constraint<double>::update(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("x"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update(a0); }, "", pybind11::arg("x"));
		cl.def("update", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Constraint<double>::update, "Update constraint functions.  \n                x is the optimization variable, \n                flag = true if optimization variable is changed,\n                iter is the outer algorithm iterations count.\n\nC++: ROL::Constraint<double>::update(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("x"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("value", (void (ROL::Constraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint<double>::value, "C++: ROL::Constraint<double>::value(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("c"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyJacobian", (void (ROL::Constraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint<double>::applyJacobian, "Apply the constraint Jacobian at \n, \n,\n             to vector \n\n.\n\n             \n  is the result of applying the constraint Jacobian to  at  a constraint-space vector\n             \n\n   is an optimization-space vector\n             \n\n   is the constraint argument; an optimization-space vector\n             \n\n is a tolerance for inexact evaluations; currently unused\n\n             On return, \n, where\n             \n\n, \n. \n             The default implementation is a finite-difference approximation.\n\n             ---\n\nC++: ROL::Constraint<double>::applyJacobian(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("jv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian", (void (ROL::Constraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint<double>::applyAdjointJacobian, "Apply the adjoint of the the constraint Jacobian at \n, \n,\n             to vector \n\n.\n\n             \n is the result of applying the adjoint of the constraint Jacobian to  at  a dual optimization-space vector\n             \n\n   is a dual constraint-space vector\n             \n\n   is the constraint argument; an optimization-space vector\n             \n\n is a tolerance for inexact evaluations; currently unused\n\n             On return, \n, where\n             \n\n, \n. \n             The default implementation is a finite-difference approximation.\n\n             ---\n\nC++: ROL::Constraint<double>::applyAdjointJacobian(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyAdjointJacobian", (void (ROL::Constraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint<double>::applyAdjointJacobian, "Apply the adjoint of the the constraint Jacobian at \n, \n,\n             to vector \n\n.\n\n             \n is the result of applying the adjoint of the constraint Jacobian to  at  a dual optimization-space vector\n             \n\n   is a dual constraint-space vector\n             \n\n   is the constraint argument; an optimization-space vector\n             \n\n  is a vector used for temporary variables; a constraint-space vector\n             \n\n is a tolerance for inexact evaluations; currently unused\n\n             On return, \n, where\n             \n\n, \n. \n             The default implementation is a finite-difference approximation.\n\n             ---\n\nC++: ROL::Constraint<double>::applyAdjointJacobian(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("ajv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("dualv"), pybind11::arg("tol"));
		cl.def("applyAdjointHessian", (void (ROL::Constraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint<double>::applyAdjointHessian, "Apply the derivative of the adjoint of the constraint Jacobian at \n\n             to vector \n in direction \n,\n             according to \n\n.\n\n             \n is the result of applying the derivative of the adjoint of the constraint Jacobian at  to vector  in direction  a dual optimization-space vector\n             \n\n    is the direction vector; a dual constraint-space vector\n             \n\n    is an optimization-space vector\n             \n\n    is the constraint argument; an optimization-space vector\n             \n\n  is a tolerance for inexact evaluations; currently unused\n\n             On return, \n, where\n             \n\n, \n, and \n. \n             The default implementation is a finite-difference approximation based on the adjoint Jacobian.\n\n             ---\n\nC++: ROL::Constraint<double>::applyAdjointHessian(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("huv"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("solveAugmentedSystem", (class std::vector<double> (ROL::Constraint<double>::*)(class ROL::Vector<double> &, class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint<double>::solveAugmentedSystem, "Approximately solves the  augmented system \n             \n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n             where \n, \n,\n             \n\n, \n,\n             \n\n is an identity or Riesz\n             operator, and \n\n\n             is a zero operator.\n\n             \n  is the optimization-space component of the result\n             \n\n  is the dual constraint-space component of the result\n             \n\n  is the dual optimization-space component of the right-hand side\n             \n\n  is the constraint-space component of the right-hand side\n             \n\n   is the constraint argument; an optimization-space vector\n             \n\n is the nominal relative residual tolerance\n\n             On return, \n approximately\n             solves the augmented system, where the size of the residual is\n             governed by special stopping conditions. \n             The default implementation is the preconditioned generalized\n             minimal residual (GMRES) method, which enables the use of\n             nonsymmetric preconditioners.\n\n             ---\n\nC++: ROL::Constraint<double>::solveAugmentedSystem(class ROL::Vector<double> &, class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> class std::vector<double>", pybind11::arg("v1"), pybind11::arg("v2"), pybind11::arg("b1"), pybind11::arg("b2"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("applyPreconditioner", (void (ROL::Constraint<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Constraint<double>::applyPreconditioner, "Apply a constraint preconditioner at \n, \n,\n             to vector \n\n.  Ideally, this preconditioner satisfies the following relationship:\n             \n\n\n\n             where R is the appropriate Riesz map in \n.  It is used by the #solveAugmentedSystem method.\n\n             \n  is the result of applying the constraint preconditioner to  at  a dual constraint-space vector\n             \n\n   is a constraint-space vector\n             \n\n   is the preconditioner argument; an optimization-space vector\n             \n\n   is the preconditioner argument; a dual optimization-space vector, unused\n             \n\n is a tolerance for inexact evaluations\n\n             On return, \n, where\n             \n\n, \n. \n             The default implementation is the Riesz map in \n\n.\n\n             ---\n\nC++: ROL::Constraint<double>::applyPreconditioner(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("pv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("tol"));
		cl.def("activate", (void (ROL::Constraint<double>::*)()) &ROL::Constraint<double>::activate, "Turn on constraints \n\nC++: ROL::Constraint<double>::activate() --> void");
		cl.def("deactivate", (void (ROL::Constraint<double>::*)()) &ROL::Constraint<double>::deactivate, "Turn off constraints\n\nC++: ROL::Constraint<double>::deactivate() --> void");
		cl.def("isActivated", (bool (ROL::Constraint<double>::*)()) &ROL::Constraint<double>::isActivated, "Check if constraints are on\n\nC++: ROL::Constraint<double>::isActivated() --> bool");
		cl.def("checkApplyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"));
		cl.def("checkApplyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkApplyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyJacobian", (class std::vector<class std::vector<double> > (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint<double>::checkApplyJacobian, "Finite-difference check for the constraint Jacobian application.\n\n      Details here.\n\nC++: ROL::Constraint<double>::checkApplyJacobian(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkApplyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"));
		cl.def("checkApplyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"));
		cl.def("checkApplyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkApplyJacobian(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkApplyJacobian", (class std::vector<class std::vector<double> > (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Constraint<double>::checkApplyJacobian, "Finite-difference check for the constraint Jacobian application.\n\n      Details here.\n\n  \n\nC++: ROL::Constraint<double>::checkApplyJacobian(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("jv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkApplyAdjointJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointJacobian(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("c"), pybind11::arg("ajv"));
		cl.def("checkApplyAdjointJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointJacobian(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("c"), pybind11::arg("ajv"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointJacobian(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("c"), pybind11::arg("ajv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointJacobian", (class std::vector<class std::vector<double> > (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint<double>::checkApplyAdjointJacobian, "Finite-difference check for the application of the adjoint of constraint Jacobian.\n\n      Details here. (This function should be deprecated)\n\n  \n\nC++: ROL::Constraint<double>::checkApplyAdjointJacobian(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("c"), pybind11::arg("ajv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkAdjointConsistencyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> double { return o.checkAdjointConsistencyJacobian(a0, a1, a2); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("x"));
		cl.def("checkAdjointConsistencyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> double { return o.checkAdjointConsistencyJacobian(a0, a1, a2, a3); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("printToStream"));
		cl.def("checkAdjointConsistencyJacobian", (double (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint<double>::checkAdjointConsistencyJacobian, "C++: ROL::Constraint<double>::checkAdjointConsistencyJacobian(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkAdjointConsistencyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4) -> double { return o.checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("dualw"), pybind11::arg("dualv"));
		cl.def("checkAdjointConsistencyJacobian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool & a5) -> double { return o.checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("dualw"), pybind11::arg("dualv"), pybind11::arg("printToStream"));
		cl.def("checkAdjointConsistencyJacobian", (double (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Constraint<double>::checkAdjointConsistencyJacobian, "C++: ROL::Constraint<double>::checkAdjointConsistencyJacobian(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> double", pybind11::arg("w"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("dualw"), pybind11::arg("dualv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"));
		cl.def("checkApplyAdjointHessian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool & a5, std::ostream & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian", (class std::vector<class std::vector<double> > (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Constraint<double>::checkApplyAdjointHessian, "Finite-difference check for the application of the adjoint of constraint Hessian.\n\n      Details here.\n\n  \n\nC++: ROL::Constraint<double>::checkApplyAdjointHessian(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkApplyAdjointHessian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"));
		cl.def("checkApplyAdjointHessian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"));
		cl.def("checkApplyAdjointHessian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkApplyAdjointHessian", [](ROL::Constraint<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4, std::ostream & a5, const int & a6) -> std::vector<class std::vector<double> > { return o.checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkApplyAdjointHessian", (class std::vector<class std::vector<double> > (ROL::Constraint<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Constraint<double>::checkApplyAdjointHessian, "Finite-difference check for the application of the adjoint of constraint Hessian.\n\n      Details here.\n\n  \n\nC++: ROL::Constraint<double>::checkApplyAdjointHessian(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("u"), pybind11::arg("v"), pybind11::arg("hv"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("setParameter", (void (ROL::Constraint<double>::*)(const class std::vector<double> &)) &ROL::Constraint<double>::setParameter, "C++: ROL::Constraint<double>::setParameter(const class std::vector<double> &) --> void", pybind11::arg("param"));
		cl.def("assign", (class ROL::Constraint<double> & (ROL::Constraint<double>::*)(const class ROL::Constraint<double> &)) &ROL::Constraint<double>::operator=, "C++: ROL::Constraint<double>::operator=(const class ROL::Constraint<double> &) --> class ROL::Constraint<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("numTimeSteps", (unsigned long (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::numTimeSteps, "C++: ROL::SerialFunction<double>::numTimeSteps() const --> unsigned long");
		cl.def("getInitialCondition", (const class ROL::Vector<double> & (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::getInitialCondition, "C++: ROL::SerialFunction<double>::getInitialCondition() const --> const class ROL::Vector<double> &", pybind11::return_value_policy::automatic);
		cl.def("setInitialCondition", (void (ROL::SerialFunction<double>::*)(const class ROL::Vector<double> &)) &ROL::SerialFunction<double>::setInitialCondition, "C++: ROL::SerialFunction<double>::setInitialCondition(const class ROL::Vector<double> &) --> void", pybind11::arg("u_initial"));
		cl.def("getZeroState", (const class ROL::Vector<double> & (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::getZeroState, "C++: ROL::SerialFunction<double>::getZeroState() const --> const class ROL::Vector<double> &", pybind11::return_value_policy::automatic);
		cl.def("getSkipInitialCondition", (bool (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::getSkipInitialCondition, "C++: ROL::SerialFunction<double>::getSkipInitialCondition() const --> bool");
		cl.def("setSkipInitialCondition", (void (ROL::SerialFunction<double>::*)(bool)) &ROL::SerialFunction<double>::setSkipInitialCondition, "C++: ROL::SerialFunction<double>::setSkipInitialCondition(bool) --> void", pybind11::arg("skip"));
		cl.def("getTimeStampsPtr", (class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > > (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::getTimeStampsPtr, "C++: ROL::SerialFunction<double>::getTimeStampsPtr() const --> class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > >");
		cl.def("setTimeStampsPtr", (void (ROL::SerialFunction<double>::*)(const class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > > &)) &ROL::SerialFunction<double>::setTimeStampsPtr, "C++: ROL::SerialFunction<double>::setTimeStampsPtr(const class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > > &) --> void", pybind11::arg("timeStampsPtr"));
		cl.def("getTimeStamp", (struct ROL::TimeStamp<double> & (ROL::SerialFunction<double>::*)(unsigned long)) &ROL::SerialFunction<double>::getTimeStamp, "C++: ROL::SerialFunction<double>::getTimeStamp(unsigned long) --> struct ROL::TimeStamp<double> &", pybind11::return_value_policy::automatic, pybind11::arg("i"));
		cl.def("setTimeStamp", (void (ROL::SerialFunction<double>::*)(unsigned long, const struct ROL::TimeStamp<double> &)) &ROL::SerialFunction<double>::setTimeStamp, "C++: ROL::SerialFunction<double>::setTimeStamp(unsigned long, const struct ROL::TimeStamp<double> &) --> void", pybind11::arg("i"), pybind11::arg("timeStamp"));
		cl.def("assign", (class ROL::SerialFunction<double> & (ROL::SerialFunction<double>::*)(const class ROL::SerialFunction<double> &)) &ROL::SerialFunction<double>::operator=, "C++: ROL::SerialFunction<double>::operator=(const class ROL::SerialFunction<double> &) --> class ROL::SerialFunction<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::SerialObjective file: line:63
		pybind11::class_<ROL::SerialObjective<double>, Teuchos::RCP<ROL::SerialObjective<double>>, PyCallBack_ROL_SerialObjective_double_t, ROL::Objective_SimOpt<double>, ROL::SerialFunction<double>> cl(M("ROL"), "SerialObjective_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const class Teuchos::RCP<class ROL::DynamicObjective<double> > &, const class ROL::Vector<double> &, const class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > >>(), pybind11::arg("obj"), pybind11::arg("u_initial"), pybind11::arg("timeStampsPtr") );

		cl.def( pybind11::init( [](PyCallBack_ROL_SerialObjective_double_t const &o){ return new PyCallBack_ROL_SerialObjective_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::SerialObjective<double> const &o){ return new ROL::SerialObjective<double>(o); } ) );
		cl.def("numTimeSteps", [](ROL::SerialObjective<double> const &o) -> unsigned long { return o.numTimeSteps(); }, "");
		cl.def("getZeroState", [](ROL::SerialObjective<double> const &o) -> const ROL::Vector<double> & { return o.getZeroState(); }, "", pybind11::return_value_policy::automatic);
		cl.def("getInitialCondition", [](ROL::SerialObjective<double> const &o) -> const ROL::Vector<double> & { return o.getInitialCondition(); }, "", pybind11::return_value_policy::automatic);
		cl.def("getSkipInitialCondition", [](ROL::SerialObjective<double> const &o) -> bool { return o.getSkipInitialCondition(); }, "");
		cl.def("value", [](ROL::SerialObjective<double> &o, const class ROL::Vector<double> & a0, double & a1) -> double { return o.value(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("value", (double (ROL::SerialObjective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialObjective<double>::value, "C++: ROL::SerialObjective<double>::value(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> double", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("gradient_1", (void (ROL::SerialObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialObjective<double>::gradient_1, "C++: ROL::SerialObjective<double>::gradient_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("gradient_2", (void (ROL::SerialObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialObjective<double>::gradient_2, "C++: ROL::SerialObjective<double>::gradient_2(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_11", (void (ROL::SerialObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialObjective<double>::hessVec_11, "C++: ROL::SerialObjective<double>::hessVec_11(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_12", (void (ROL::SerialObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialObjective<double>::hessVec_12, "C++: ROL::SerialObjective<double>::hessVec_12(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_21", (void (ROL::SerialObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialObjective<double>::hessVec_21, "C++: ROL::SerialObjective<double>::hessVec_21(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_22", (void (ROL::SerialObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::SerialObjective<double>::hessVec_22, "C++: ROL::SerialObjective<double>::hessVec_22(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("assign", (class ROL::SerialObjective<double> & (ROL::SerialObjective<double>::*)(const class ROL::SerialObjective<double> &)) &ROL::SerialObjective<double>::operator=, "C++: ROL::SerialObjective<double>::operator=(const class ROL::SerialObjective<double> &) --> class ROL::SerialObjective<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("u"), pybind11::arg("z"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, bool const & a2) -> void { return o.update(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, bool, int)) &ROL::Objective_SimOpt<double>::update, "C++: ROL::Objective_SimOpt<double>::update(const class ROL::Vector<double> &, const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update(a0); }, "", pybind11::arg("x"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Objective_SimOpt<double>::update, "C++: ROL::Objective_SimOpt<double>::update(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("x"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, enum ROL::UpdateType const & a2) -> void { return o.update(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Objective_SimOpt<double>::update, "C++: ROL::Objective_SimOpt<double>::update(const class ROL::Vector<double> &, const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Objective_SimOpt<double>::update, "C++: ROL::Objective_SimOpt<double>::update(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("x"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("value", (double (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::value, "C++: ROL::Objective_SimOpt<double>::value(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> double", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("value", (double (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::value, "C++: ROL::Objective_SimOpt<double>::value(const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("gradient_1", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::gradient_1, "C++: ROL::Objective_SimOpt<double>::gradient_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("gradient_2", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::gradient_2, "C++: ROL::Objective_SimOpt<double>::gradient_2(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("gradient", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::gradient, "C++: ROL::Objective_SimOpt<double>::gradient(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("hessVec_11", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec_11, "C++: ROL::Objective_SimOpt<double>::hessVec_11(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_12", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec_12, "C++: ROL::Objective_SimOpt<double>::hessVec_12(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_21", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec_21, "C++: ROL::Objective_SimOpt<double>::hessVec_21(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_22", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec_22, "C++: ROL::Objective_SimOpt<double>::hessVec_22(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec, "C++: ROL::Objective_SimOpt<double>::hessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("checkGradient_1", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient_1(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"));
		cl.def("checkGradient_1", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient_1(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient_1", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient_1(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient_1", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkGradient_1(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient_1", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkGradient_1, "C++: ROL::Objective_SimOpt<double>::checkGradient_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient_1", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkGradient_1, "C++: ROL::Objective_SimOpt<double>::checkGradient_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient_1", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkGradient_1, "C++: ROL::Objective_SimOpt<double>::checkGradient_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkGradient_2", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient_2(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"));
		cl.def("checkGradient_2", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient_2(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient_2", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient_2(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient_2", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkGradient_2(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient_2", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkGradient_2, "C++: ROL::Objective_SimOpt<double>::checkGradient_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient_2", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkGradient_2, "C++: ROL::Objective_SimOpt<double>::checkGradient_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient_2", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkGradient_2, "C++: ROL::Objective_SimOpt<double>::checkGradient_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec_11", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_11, "C++: ROL::Objective_SimOpt<double>::checkHessVec_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_11", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_11, "C++: ROL::Objective_SimOpt<double>::checkHessVec_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_11", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_11, "C++: ROL::Objective_SimOpt<double>::checkHessVec_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_11", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_11, "C++: ROL::Objective_SimOpt<double>::checkHessVec_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec_12", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_12, "C++: ROL::Objective_SimOpt<double>::checkHessVec_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_12", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_12, "C++: ROL::Objective_SimOpt<double>::checkHessVec_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_12", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_12, "C++: ROL::Objective_SimOpt<double>::checkHessVec_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_12", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_12, "C++: ROL::Objective_SimOpt<double>::checkHessVec_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec_21", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_21, "C++: ROL::Objective_SimOpt<double>::checkHessVec_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_21", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_21, "C++: ROL::Objective_SimOpt<double>::checkHessVec_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_21", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_21, "C++: ROL::Objective_SimOpt<double>::checkHessVec_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_21", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_21, "C++: ROL::Objective_SimOpt<double>::checkHessVec_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec_22", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_22, "C++: ROL::Objective_SimOpt<double>::checkHessVec_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_22", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_22, "C++: ROL::Objective_SimOpt<double>::checkHessVec_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_22", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_22, "C++: ROL::Objective_SimOpt<double>::checkHessVec_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_22", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_22, "C++: ROL::Objective_SimOpt<double>::checkHessVec_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("assign", (class ROL::Objective_SimOpt<double> & (ROL::Objective_SimOpt<double>::*)(const class ROL::Objective_SimOpt<double> &)) &ROL::Objective_SimOpt<double>::operator=, "C++: ROL::Objective_SimOpt<double>::operator=(const class ROL::Objective_SimOpt<double> &) --> class ROL::Objective_SimOpt<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Objective<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Objective<double>::update, "Update objective function. \n\n      This function updates the objective function at new iterations. \n      \n\n      is the new iterate. \n      \n\n   is the type of update requested.\n      \n\n   is the outer algorithm iterations count.\n\nC++: ROL::Objective<double>::update(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("x"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update(a0); }, "", pybind11::arg("x"));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Objective<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Objective<double>::update, "Update objective function. \n\n      This function updates the objective function at new iterations. \n      \n\n      is the new iterate. \n      \n\n   is true if the iterate has changed.\n      \n\n   is the outer algorithm iterations count.\n\nC++: ROL::Objective<double>::update(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("x"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("value", (double (ROL::Objective<double>::*)(const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::value, "C++: ROL::Objective<double>::value(const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("gradient", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::gradient, "Compute gradient.\n\n      This function returns the objective function gradient.\n      \n\n   is the gradient.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\n      The default implementation is a finite-difference approximation based on the function value.\n      This requires the definition of a basis \n\n for the optimization vectors x and\n      the definition of a basis \n\n for the dual optimization vectors (gradient vectors g).\n      The bases must be related through the Riesz map, i.e., \n\n,\n      and this must be reflected in the implementation of the ROL::Vector::dual() method.\n\nC++: ROL::Objective<double>::gradient(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("dirDeriv", (double (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::dirDeriv, "Compute directional derivative.\n\n      This function returns the directional derivative of the objective function in the \n direction.\n      \n\n   is the current iterate.\n      \n\n   is the direction.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::dirDeriv(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("tol"));
		cl.def("hessVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::hessVec, "Apply Hessian approximation to vector.\n\n      This function applies the Hessian of the objective function to the vector \n.\n      \n\n  is the the action of the Hessian on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::hessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("invHessVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::invHessVec, "Apply inverse Hessian approximation to vector.\n\n      This function applies the inverse Hessian of the objective function to the vector \n.\n      \n\n  is the action of the inverse Hessian on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::invHessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("precond", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::precond, "Apply preconditioner to vector.\n\n      This function applies a preconditioner for the Hessian of the objective function to the vector \n.\n      \n\n  is the action of the Hessian preconditioner on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::precond(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("Pv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("prox", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &)) &ROL::Objective<double>::prox, "Compute the proximity operator.\n\n      This function returns the proximity operator.\n      \n\n  is the proximity operator applied to \n (primal optimization vector).\n      \n\n   is the input to the proximity operator (primal optimization vector).\n      \n\n   is the proximity operator parameter (positive scalar).\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::prox(class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &) --> void", pybind11::arg("Pv"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("tol"));
		cl.def("proxJacVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &)) &ROL::Objective<double>::proxJacVec, "Apply the Jacobian of the proximity operator.\n\n      This function applies the Jacobian of the proximity operator.\n      \n\n  is the Jacobian of the proximity operator at \n applied to \n (primal optimization vector).\n      \n\n   is the direction vector (primal optimization vector).\n      \n\n   is the input to the proximity operator (primal optimization vector).\n      \n\n   is the proximity operator parameter (positive scalar).\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::proxJacVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &) --> void", pybind11::arg("Jv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("t"), pybind11::arg("tol"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("d"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3, const int & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n\n      \n             is an optimization variable.\n      \n\n             is used to create a temporary gradient vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n\n      \n             is an optimization variable.\n      \n\n             is used to create a temporary gradient vector.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("v"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3, const int & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n            is used to create temporary gradient and Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n            is used to create temporary gradient and Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<double> { return o.checkHessSym(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"));
		cl.def("checkHessSym", (class std::vector<double> (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Objective<double>::checkHessSym, "Hessian symmetry check.\n\n      This function checks the symmetry of the Hessian by comparing \n      \n\n\n\n\n\n      \n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n\nC++: ROL::Objective<double>::checkHessSym(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> class std::vector<double>", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"));
		cl.def("checkHessSym", (class std::vector<double> (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Objective<double>::checkHessSym, "Hessian symmetry check.\n\n      This function checks the symmetry of the Hessian by comparing \n      \n\n\n\n\n\n      \n             is an optimization variable.\n      \n\n            is used to create temporary Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n\nC++: ROL::Objective<double>::checkHessSym(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> class std::vector<double>", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("v"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2, bool const & a3) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2, bool const & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkProxJacVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, bool, std::ostream &, int)) &ROL::Objective<double>::checkProxJacVec, "Finite-difference proximity operator Jacobian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the proximity\n      operator Jacobian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order.  Note that in some cases the proximity operator\n      is semismooth, which motivates the evaluation of \n\n at \n.\n      \n\n             is an optimization vector.\n      \n\n             is a direction vector.\n      \n\n             is the proximity operator parameter.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n\nC++: ROL::Objective<double>::checkProxJacVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, bool, std::ostream &, int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("setParameter", (void (ROL::Objective<double>::*)(const class std::vector<double> &)) &ROL::Objective<double>::setParameter, "C++: ROL::Objective<double>::setParameter(const class std::vector<double> &) --> void", pybind11::arg("param"));
		cl.def("assign", (class ROL::Objective<double> & (ROL::Objective<double>::*)(const class ROL::Objective<double> &)) &ROL::Objective<double>::operator=, "C++: ROL::Objective<double>::operator=(const class ROL::Objective<double> &) --> class ROL::Objective<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("numTimeSteps", (unsigned long (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::numTimeSteps, "C++: ROL::SerialFunction<double>::numTimeSteps() const --> unsigned long");
		cl.def("getInitialCondition", (const class ROL::Vector<double> & (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::getInitialCondition, "C++: ROL::SerialFunction<double>::getInitialCondition() const --> const class ROL::Vector<double> &", pybind11::return_value_policy::automatic);
		cl.def("setInitialCondition", (void (ROL::SerialFunction<double>::*)(const class ROL::Vector<double> &)) &ROL::SerialFunction<double>::setInitialCondition, "C++: ROL::SerialFunction<double>::setInitialCondition(const class ROL::Vector<double> &) --> void", pybind11::arg("u_initial"));
		cl.def("getZeroState", (const class ROL::Vector<double> & (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::getZeroState, "C++: ROL::SerialFunction<double>::getZeroState() const --> const class ROL::Vector<double> &", pybind11::return_value_policy::automatic);
		cl.def("getSkipInitialCondition", (bool (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::getSkipInitialCondition, "C++: ROL::SerialFunction<double>::getSkipInitialCondition() const --> bool");
		cl.def("setSkipInitialCondition", (void (ROL::SerialFunction<double>::*)(bool)) &ROL::SerialFunction<double>::setSkipInitialCondition, "C++: ROL::SerialFunction<double>::setSkipInitialCondition(bool) --> void", pybind11::arg("skip"));
		cl.def("getTimeStampsPtr", (class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > > (ROL::SerialFunction<double>::*)() const) &ROL::SerialFunction<double>::getTimeStampsPtr, "C++: ROL::SerialFunction<double>::getTimeStampsPtr() const --> class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > >");
		cl.def("setTimeStampsPtr", (void (ROL::SerialFunction<double>::*)(const class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > > &)) &ROL::SerialFunction<double>::setTimeStampsPtr, "C++: ROL::SerialFunction<double>::setTimeStampsPtr(const class Teuchos::RCP<class std::vector<struct ROL::TimeStamp<double> > > &) --> void", pybind11::arg("timeStampsPtr"));
		cl.def("getTimeStamp", (struct ROL::TimeStamp<double> & (ROL::SerialFunction<double>::*)(unsigned long)) &ROL::SerialFunction<double>::getTimeStamp, "C++: ROL::SerialFunction<double>::getTimeStamp(unsigned long) --> struct ROL::TimeStamp<double> &", pybind11::return_value_policy::automatic, pybind11::arg("i"));
		cl.def("setTimeStamp", (void (ROL::SerialFunction<double>::*)(unsigned long, const struct ROL::TimeStamp<double> &)) &ROL::SerialFunction<double>::setTimeStamp, "C++: ROL::SerialFunction<double>::setTimeStamp(unsigned long, const struct ROL::TimeStamp<double> &) --> void", pybind11::arg("i"), pybind11::arg("timeStamp"));
		cl.def("assign", (class ROL::SerialFunction<double> & (ROL::SerialFunction<double>::*)(const class ROL::SerialFunction<double> &)) &ROL::SerialFunction<double>::operator=, "C++: ROL::SerialFunction<double>::operator=(const class ROL::SerialFunction<double> &) --> class ROL::SerialFunction<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::SampleGenerator file: line:72
		pybind11::class_<ROL::SampleGenerator<double>, Teuchos::RCP<ROL::SampleGenerator<double>>, PyCallBack_ROL_SampleGenerator_double_t> cl(M("ROL"), "SampleGenerator_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const class Teuchos::RCP<class ROL::BatchManager<double> > &>(), pybind11::arg("bman") );

		cl.def( pybind11::init( [](PyCallBack_ROL_SampleGenerator_double_t const &o){ return new PyCallBack_ROL_SampleGenerator_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::SampleGenerator<double> const &o){ return new ROL::SampleGenerator<double>(o); } ) );
		cl.def("update", (void (ROL::SampleGenerator<double>::*)(const class ROL::Vector<double> &)) &ROL::SampleGenerator<double>::update, "C++: ROL::SampleGenerator<double>::update(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("start", (int (ROL::SampleGenerator<double>::*)()) &ROL::SampleGenerator<double>::start, "C++: ROL::SampleGenerator<double>::start() --> int");
		cl.def("computeError", (double (ROL::SampleGenerator<double>::*)(class std::vector<double> &)) &ROL::SampleGenerator<double>::computeError, "C++: ROL::SampleGenerator<double>::computeError(class std::vector<double> &) --> double", pybind11::arg("vals"));
		cl.def("refine", (void (ROL::SampleGenerator<double>::*)()) &ROL::SampleGenerator<double>::refine, "C++: ROL::SampleGenerator<double>::refine() --> void");
		cl.def("setSamples", [](ROL::SampleGenerator<double> &o) -> void { return o.setSamples(); }, "");
		cl.def("setSamples", (void (ROL::SampleGenerator<double>::*)(bool)) &ROL::SampleGenerator<double>::setSamples, "C++: ROL::SampleGenerator<double>::setSamples(bool) --> void", pybind11::arg("inConstructor"));
		cl.def("numGlobalSamples", (int (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::numGlobalSamples, "C++: ROL::SampleGenerator<double>::numGlobalSamples() const --> int");
		cl.def("numMySamples", (int (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::numMySamples, "C++: ROL::SampleGenerator<double>::numMySamples() const --> int");
		cl.def("getMyPoint", (class std::vector<double> (ROL::SampleGenerator<double>::*)(const int) const) &ROL::SampleGenerator<double>::getMyPoint, "C++: ROL::SampleGenerator<double>::getMyPoint(const int) const --> class std::vector<double>", pybind11::arg("i"));
		cl.def("getMyWeight", (double (ROL::SampleGenerator<double>::*)(const int) const) &ROL::SampleGenerator<double>::getMyWeight, "C++: ROL::SampleGenerator<double>::getMyWeight(const int) const --> double", pybind11::arg("i"));
		cl.def("batchID", (int (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::batchID, "C++: ROL::SampleGenerator<double>::batchID() const --> int");
		cl.def("numBatches", (int (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::numBatches, "C++: ROL::SampleGenerator<double>::numBatches() const --> int");
		cl.def("sumAll", (void (ROL::SampleGenerator<double>::*)(double *, double *, int) const) &ROL::SampleGenerator<double>::sumAll, "C++: ROL::SampleGenerator<double>::sumAll(double *, double *, int) const --> void", pybind11::arg("input"), pybind11::arg("output"), pybind11::arg("dim"));
		cl.def("sumAll", (void (ROL::SampleGenerator<double>::*)(class ROL::Vector<double> &, class ROL::Vector<double> &) const) &ROL::SampleGenerator<double>::sumAll, "C++: ROL::SampleGenerator<double>::sumAll(class ROL::Vector<double> &, class ROL::Vector<double> &) const --> void", pybind11::arg("input"), pybind11::arg("output"));
		cl.def("broadcast", (void (ROL::SampleGenerator<double>::*)(double *, int, int) const) &ROL::SampleGenerator<double>::broadcast, "C++: ROL::SampleGenerator<double>::broadcast(double *, int, int) const --> void", pybind11::arg("input"), pybind11::arg("cnt"), pybind11::arg("root"));
		cl.def("barrier", (void (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::barrier, "C++: ROL::SampleGenerator<double>::barrier() const --> void");
		cl.def("getBatchManager", (const class Teuchos::RCP<class ROL::BatchManager<double> > (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::getBatchManager, "C++: ROL::SampleGenerator<double>::getBatchManager() const --> const class Teuchos::RCP<class ROL::BatchManager<double> >");
		cl.def("print", [](ROL::SampleGenerator<double> const &o) -> void { return o.print(); }, "");
		cl.def("print", [](ROL::SampleGenerator<double> const &o, const std::string & a0) -> void { return o.print(a0); }, "", pybind11::arg("filename"));
		cl.def("print", (void (ROL::SampleGenerator<double>::*)(const std::string &, const int) const) &ROL::SampleGenerator<double>::print, "C++: ROL::SampleGenerator<double>::print(const std::string &, const int) const --> void", pybind11::arg("filename"), pybind11::arg("prec"));
		cl.def("assign", (class ROL::SampleGenerator<double> & (ROL::SampleGenerator<double>::*)(const class ROL::SampleGenerator<double> &)) &ROL::SampleGenerator<double>::operator=, "C++: ROL::SampleGenerator<double>::operator=(const class ROL::SampleGenerator<double> &) --> class ROL::SampleGenerator<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::StochasticProblem file: line:73
		pybind11::class_<ROL::StochasticProblem<double>, Teuchos::RCP<ROL::StochasticProblem<double>>, PyCallBack_ROL_StochasticProblem_double_t, ROL::Problem<double>> cl(M("ROL"), "StochasticProblem_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](const class Teuchos::RCP<class ROL::Objective<double> > & a0, const class Teuchos::RCP<class ROL::Vector<double> > & a1){ return new ROL::StochasticProblem<double>(a0, a1); }, [](const class Teuchos::RCP<class ROL::Objective<double> > & a0, const class Teuchos::RCP<class ROL::Vector<double> > & a1){ return new PyCallBack_ROL_StochasticProblem_double_t(a0, a1); } ), "doc");
		cl.def( pybind11::init<const class Teuchos::RCP<class ROL::Objective<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &>(), pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("g") );

		cl.def( pybind11::init<const class ROL::Problem<double> &>(), pybind11::arg("problem") );

		cl.def( pybind11::init( [](PyCallBack_ROL_StochasticProblem_double_t const &o){ return new PyCallBack_ROL_StochasticProblem_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::StochasticProblem<double> const &o){ return new ROL::StochasticProblem<double>(o); } ) );
		cl.def("makeObjectiveStochastic", [](ROL::StochasticProblem<double> &o, class Teuchos::ParameterList & a0, const class Teuchos::RCP<class ROL::SampleGenerator<double> > & a1) -> void { return o.makeObjectiveStochastic(a0, a1); }, "", pybind11::arg("list"), pybind11::arg("fsampler"));
		cl.def("makeObjectiveStochastic", [](ROL::StochasticProblem<double> &o, class Teuchos::ParameterList & a0, const class Teuchos::RCP<class ROL::SampleGenerator<double> > & a1, const class Teuchos::RCP<class ROL::SampleGenerator<double> > & a2) -> void { return o.makeObjectiveStochastic(a0, a1, a2); }, "", pybind11::arg("list"), pybind11::arg("fsampler"), pybind11::arg("gsampler"));
		cl.def("makeObjectiveStochastic", (void (ROL::StochasticProblem<double>::*)(class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &)) &ROL::StochasticProblem<double>::makeObjectiveStochastic, "************************************************************************\n\n* Set and remove methods for constraints *******************************\n\n************************************************************************\n\nC++: ROL::StochasticProblem<double>::makeObjectiveStochastic(class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &) --> void", pybind11::arg("list"), pybind11::arg("fsampler"), pybind11::arg("gsampler"), pybind11::arg("hsampler"));
		cl.def("makeObjectiveStochastic", [](ROL::StochasticProblem<double> &o, const class Teuchos::RCP<class ROL::RandVarFunctional<double> > & a0, class Teuchos::ParameterList & a1, const class Teuchos::RCP<class ROL::SampleGenerator<double> > & a2) -> void { return o.makeObjectiveStochastic(a0, a1, a2); }, "", pybind11::arg("rvf"), pybind11::arg("list"), pybind11::arg("fsampler"));
		cl.def("makeObjectiveStochastic", [](ROL::StochasticProblem<double> &o, const class Teuchos::RCP<class ROL::RandVarFunctional<double> > & a0, class Teuchos::ParameterList & a1, const class Teuchos::RCP<class ROL::SampleGenerator<double> > & a2, const class Teuchos::RCP<class ROL::SampleGenerator<double> > & a3) -> void { return o.makeObjectiveStochastic(a0, a1, a2, a3); }, "", pybind11::arg("rvf"), pybind11::arg("list"), pybind11::arg("fsampler"), pybind11::arg("gsampler"));
		cl.def("makeObjectiveStochastic", (void (ROL::StochasticProblem<double>::*)(const class Teuchos::RCP<class ROL::RandVarFunctional<double> > &, class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &)) &ROL::StochasticProblem<double>::makeObjectiveStochastic, "C++: ROL::StochasticProblem<double>::makeObjectiveStochastic(const class Teuchos::RCP<class ROL::RandVarFunctional<double> > &, class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &) --> void", pybind11::arg("rvf"), pybind11::arg("list"), pybind11::arg("fsampler"), pybind11::arg("gsampler"), pybind11::arg("hsampler"));
		cl.def("makeConstraintStochastic", [](ROL::StochasticProblem<double> &o, std::string const & a0, class Teuchos::ParameterList & a1, const class Teuchos::RCP<class ROL::SampleGenerator<double> > & a2) -> void { return o.makeConstraintStochastic(a0, a1, a2); }, "", pybind11::arg("name"), pybind11::arg("list"), pybind11::arg("sampler"));
		cl.def("makeConstraintStochastic", (void (ROL::StochasticProblem<double>::*)(std::string, class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::BatchManager<double> > &)) &ROL::StochasticProblem<double>::makeConstraintStochastic, "C++: ROL::StochasticProblem<double>::makeConstraintStochastic(std::string, class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::BatchManager<double> > &) --> void", pybind11::arg("name"), pybind11::arg("list"), pybind11::arg("sampler"), pybind11::arg("bman"));
		cl.def("makeLinearConstraintStochastic", [](ROL::StochasticProblem<double> &o, std::string const & a0, class Teuchos::ParameterList & a1, const class Teuchos::RCP<class ROL::SampleGenerator<double> > & a2) -> void { return o.makeLinearConstraintStochastic(a0, a1, a2); }, "", pybind11::arg("name"), pybind11::arg("list"), pybind11::arg("sampler"));
		cl.def("makeLinearConstraintStochastic", (void (ROL::StochasticProblem<double>::*)(std::string, class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::BatchManager<double> > &)) &ROL::StochasticProblem<double>::makeLinearConstraintStochastic, "C++: ROL::StochasticProblem<double>::makeLinearConstraintStochastic(std::string, class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &, const class Teuchos::RCP<class ROL::BatchManager<double> > &) --> void", pybind11::arg("name"), pybind11::arg("list"), pybind11::arg("sampler"), pybind11::arg("bman"));
		cl.def("resetStochasticObjective", (void (ROL::StochasticProblem<double>::*)()) &ROL::StochasticProblem<double>::resetStochasticObjective, "C++: ROL::StochasticProblem<double>::resetStochasticObjective() --> void");
		cl.def("resetStochasticConstraint", (void (ROL::StochasticProblem<double>::*)(std::string)) &ROL::StochasticProblem<double>::resetStochasticConstraint, "C++: ROL::StochasticProblem<double>::resetStochasticConstraint(std::string) --> void", pybind11::arg("name"));
		cl.def("resetStochasticLinearConstraint", (void (ROL::StochasticProblem<double>::*)(std::string)) &ROL::StochasticProblem<double>::resetStochasticLinearConstraint, "C++: ROL::StochasticProblem<double>::resetStochasticLinearConstraint(std::string) --> void", pybind11::arg("name"));
		cl.def("resetStochastic", (void (ROL::StochasticProblem<double>::*)()) &ROL::StochasticProblem<double>::resetStochastic, "C++: ROL::StochasticProblem<double>::resetStochastic() --> void");
		cl.def("getObjectiveStatistic", (class std::vector<double> (ROL::StochasticProblem<double>::*)() const) &ROL::StochasticProblem<double>::getObjectiveStatistic, "C++: ROL::StochasticProblem<double>::getObjectiveStatistic() const --> class std::vector<double>");
		cl.def("getConstraintStatistic", (class std::vector<double> (ROL::StochasticProblem<double>::*)(std::string) const) &ROL::StochasticProblem<double>::getConstraintStatistic, "C++: ROL::StochasticProblem<double>::getConstraintStatistic(std::string) const --> class std::vector<double>", pybind11::arg("name"));
		cl.def("getSolutionStatistic", [](ROL::StochasticProblem<double> const &o) -> double { return o.getSolutionStatistic(); }, "");
		cl.def("getSolutionStatistic", [](ROL::StochasticProblem<double> const &o, int const & a0) -> double { return o.getSolutionStatistic(a0); }, "", pybind11::arg("comp"));
		cl.def("getSolutionStatistic", (double (ROL::StochasticProblem<double>::*)(int, std::string) const) &ROL::StochasticProblem<double>::getSolutionStatistic, "C++: ROL::StochasticProblem<double>::getSolutionStatistic(int, std::string) const --> double", pybind11::arg("comp"), pybind11::arg("name"));
		cl.def("finalize", [](ROL::StochasticProblem<double> &o) -> void { return o.finalize(); }, "");
		cl.def("finalize", [](ROL::StochasticProblem<double> &o, bool const & a0) -> void { return o.finalize(a0); }, "", pybind11::arg("lumpConstraints"));
		cl.def("finalize", [](ROL::StochasticProblem<double> &o, bool const & a0, bool const & a1) -> void { return o.finalize(a0, a1); }, "", pybind11::arg("lumpConstraints"), pybind11::arg("printToStream"));
		cl.def("finalize", (void (ROL::StochasticProblem<double>::*)(bool, bool, std::ostream &)) &ROL::StochasticProblem<double>::finalize, "************************************************************************\n\n* Finalize and edit methods ********************************************\n\n************************************************************************\n\nC++: ROL::StochasticProblem<double>::finalize(bool, bool, std::ostream &) --> void", pybind11::arg("lumpConstraints"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("edit", (void (ROL::StochasticProblem<double>::*)()) &ROL::StochasticProblem<double>::edit, "C++: ROL::StochasticProblem<double>::edit() --> void");
		cl.def("assign", (class ROL::StochasticProblem<double> & (ROL::StochasticProblem<double>::*)(const class ROL::StochasticProblem<double> &)) &ROL::StochasticProblem<double>::operator=, "C++: ROL::StochasticProblem<double>::operator=(const class ROL::StochasticProblem<double> &) --> class ROL::StochasticProblem<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("addBoundConstraint", (void (ROL::Problem<double>::*)(const class Teuchos::RCP<class ROL::BoundConstraint<double> > &)) &ROL::Problem<double>::addBoundConstraint, "Add a bound constraint.\n\n      \n  bound constraint object\n\nC++: ROL::Problem<double>::addBoundConstraint(const class Teuchos::RCP<class ROL::BoundConstraint<double> > &) --> void", pybind11::arg("bnd"));
		cl.def("removeBoundConstraint", (void (ROL::Problem<double>::*)()) &ROL::Problem<double>::removeBoundConstraint, "Remove an existing bound constraint.\n\nC++: ROL::Problem<double>::removeBoundConstraint() --> void");
		cl.def("addConstraint", [](ROL::Problem<double> &o, std::string const & a0, const class Teuchos::RCP<class ROL::Constraint<double> > & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2) -> void { return o.addConstraint(a0, a1, a2); }, "", pybind11::arg("name"), pybind11::arg("econ"), pybind11::arg("emul"));
		cl.def("addConstraint", [](ROL::Problem<double> &o, std::string const & a0, const class Teuchos::RCP<class ROL::Constraint<double> > & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2, const class Teuchos::RCP<class ROL::Vector<double> > & a3) -> void { return o.addConstraint(a0, a1, a2, a3); }, "", pybind11::arg("name"), pybind11::arg("econ"), pybind11::arg("emul"), pybind11::arg("eres"));
		cl.def("addConstraint", (void (ROL::Problem<double>::*)(std::string, const class Teuchos::RCP<class ROL::Constraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, bool)) &ROL::Problem<double>::addConstraint, "Add an equality constraint.\n\n      \n   the unique constraint identifier\n      \n\n   constraint object\n      \n\n   dual constraint space vector\n      \n\n   primal constraint space vector\n      \n\n  whether or not to clear constraint container\n\nC++: ROL::Problem<double>::addConstraint(std::string, const class Teuchos::RCP<class ROL::Constraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, bool) --> void", pybind11::arg("name"), pybind11::arg("econ"), pybind11::arg("emul"), pybind11::arg("eres"), pybind11::arg("reset"));
		cl.def("addConstraint", [](ROL::Problem<double> &o, std::string const & a0, const class Teuchos::RCP<class ROL::Constraint<double> > & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2, const class Teuchos::RCP<class ROL::BoundConstraint<double> > & a3) -> void { return o.addConstraint(a0, a1, a2, a3); }, "", pybind11::arg("name"), pybind11::arg("icon"), pybind11::arg("imul"), pybind11::arg("ibnd"));
		cl.def("addConstraint", [](ROL::Problem<double> &o, std::string const & a0, const class Teuchos::RCP<class ROL::Constraint<double> > & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2, const class Teuchos::RCP<class ROL::BoundConstraint<double> > & a3, const class Teuchos::RCP<class ROL::Vector<double> > & a4) -> void { return o.addConstraint(a0, a1, a2, a3, a4); }, "", pybind11::arg("name"), pybind11::arg("icon"), pybind11::arg("imul"), pybind11::arg("ibnd"), pybind11::arg("ires"));
		cl.def("addConstraint", (void (ROL::Problem<double>::*)(std::string, const class Teuchos::RCP<class ROL::Constraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::BoundConstraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, bool)) &ROL::Problem<double>::addConstraint, "Add an inequality constraint.\n\n      \n   the unique constraint identifier\n      \n\n   constraint object\n      \n\n   dual constraint space vector\n      \n\n   bound constraint\n      \n\n   primal constraint space vector\n      \n\n  whether or not to clear constraint container\n\nC++: ROL::Problem<double>::addConstraint(std::string, const class Teuchos::RCP<class ROL::Constraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::BoundConstraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, bool) --> void", pybind11::arg("name"), pybind11::arg("icon"), pybind11::arg("imul"), pybind11::arg("ibnd"), pybind11::arg("ires"), pybind11::arg("reset"));
		cl.def("removeConstraint", (void (ROL::Problem<double>::*)(std::string)) &ROL::Problem<double>::removeConstraint, "Remove an existing constraint.\n\n      \n  the unique constraint identifier\n\nC++: ROL::Problem<double>::removeConstraint(std::string) --> void", pybind11::arg("name"));
		cl.def("addLinearConstraint", [](ROL::Problem<double> &o, std::string const & a0, const class Teuchos::RCP<class ROL::Constraint<double> > & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2) -> void { return o.addLinearConstraint(a0, a1, a2); }, "", pybind11::arg("name"), pybind11::arg("linear_econ"), pybind11::arg("linear_emul"));
		cl.def("addLinearConstraint", [](ROL::Problem<double> &o, std::string const & a0, const class Teuchos::RCP<class ROL::Constraint<double> > & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2, const class Teuchos::RCP<class ROL::Vector<double> > & a3) -> void { return o.addLinearConstraint(a0, a1, a2, a3); }, "", pybind11::arg("name"), pybind11::arg("linear_econ"), pybind11::arg("linear_emul"), pybind11::arg("linear_eres"));
		cl.def("addLinearConstraint", (void (ROL::Problem<double>::*)(std::string, const class Teuchos::RCP<class ROL::Constraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, bool)) &ROL::Problem<double>::addLinearConstraint, "Add a linear equality constraint.\n\n      \n         the unique constraint identifier\n      \n\n  constraint object\n      \n\n  dual constraint space vector\n      \n\n  primal constraint space vector\n      \n\n        whether or not to clear linear constraint container\n\nC++: ROL::Problem<double>::addLinearConstraint(std::string, const class Teuchos::RCP<class ROL::Constraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, bool) --> void", pybind11::arg("name"), pybind11::arg("linear_econ"), pybind11::arg("linear_emul"), pybind11::arg("linear_eres"), pybind11::arg("reset"));
		cl.def("addLinearConstraint", [](ROL::Problem<double> &o, std::string const & a0, const class Teuchos::RCP<class ROL::Constraint<double> > & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2, const class Teuchos::RCP<class ROL::BoundConstraint<double> > & a3) -> void { return o.addLinearConstraint(a0, a1, a2, a3); }, "", pybind11::arg("name"), pybind11::arg("linear_icon"), pybind11::arg("linear_imul"), pybind11::arg("linear_ibnd"));
		cl.def("addLinearConstraint", [](ROL::Problem<double> &o, std::string const & a0, const class Teuchos::RCP<class ROL::Constraint<double> > & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2, const class Teuchos::RCP<class ROL::BoundConstraint<double> > & a3, const class Teuchos::RCP<class ROL::Vector<double> > & a4) -> void { return o.addLinearConstraint(a0, a1, a2, a3, a4); }, "", pybind11::arg("name"), pybind11::arg("linear_icon"), pybind11::arg("linear_imul"), pybind11::arg("linear_ibnd"), pybind11::arg("linear_ires"));
		cl.def("addLinearConstraint", (void (ROL::Problem<double>::*)(std::string, const class Teuchos::RCP<class ROL::Constraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::BoundConstraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, bool)) &ROL::Problem<double>::addLinearConstraint, "Add a linear inequality constraint.\n\n      \n         the unique constraint identifier\n      \n\n  constraint object\n      \n\n  dual constraint space vector\n      \n\n  bound constraint\n      \n\n  primal constraint space vector\n      \n\n        whether or not to clear linear constraint container\n\nC++: ROL::Problem<double>::addLinearConstraint(std::string, const class Teuchos::RCP<class ROL::Constraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, const class Teuchos::RCP<class ROL::BoundConstraint<double> > &, const class Teuchos::RCP<class ROL::Vector<double> > &, bool) --> void", pybind11::arg("name"), pybind11::arg("linear_icon"), pybind11::arg("linear_imul"), pybind11::arg("linear_ibnd"), pybind11::arg("linear_ires"), pybind11::arg("reset"));
		cl.def("removeLinearConstraint", (void (ROL::Problem<double>::*)(std::string)) &ROL::Problem<double>::removeLinearConstraint, "Remove an existing linear constraint.\n\n      \n  the unique constraint identifier\n\nC++: ROL::Problem<double>::removeLinearConstraint(std::string) --> void", pybind11::arg("name"));
		cl.def("setProjectionAlgorithm", (void (ROL::Problem<double>::*)(class Teuchos::ParameterList &)) &ROL::Problem<double>::setProjectionAlgorithm, "Set polyhedral projection algorithm.\n\n      \n  polyhedral projection algorithm\n\nC++: ROL::Problem<double>::setProjectionAlgorithm(class Teuchos::ParameterList &) --> void", pybind11::arg("list"));
		cl.def("addProximableObjective", (void (ROL::Problem<double>::*)(const class Teuchos::RCP<class ROL::Objective<double> > &)) &ROL::Problem<double>::addProximableObjective, "Set Proximable objective function\n\nC++: ROL::Problem<double>::addProximableObjective(const class Teuchos::RCP<class ROL::Objective<double> > &) --> void", pybind11::arg("nobj"));
		cl.def("removeProximableObjective", (void (ROL::Problem<double>::*)()) &ROL::Problem<double>::removeProximableObjective, "Remove Proximable objective function\n\nC++: ROL::Problem<double>::removeProximableObjective() --> void");
		cl.def("getObjective", (const class Teuchos::RCP<class ROL::Objective<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getObjective, "Get the objective function.\n\nC++: ROL::Problem<double>::getObjective() --> const class Teuchos::RCP<class ROL::Objective<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getProximableObjective", (const class Teuchos::RCP<class ROL::Objective<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getProximableObjective, "Get proximable objective\n\nC++: ROL::Problem<double>::getProximableObjective() --> const class Teuchos::RCP<class ROL::Objective<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getPrimalOptimizationVector", (const class Teuchos::RCP<class ROL::Vector<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getPrimalOptimizationVector, "Get the primal optimization space vector.\n\nC++: ROL::Problem<double>::getPrimalOptimizationVector() --> const class Teuchos::RCP<class ROL::Vector<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getDualOptimizationVector", (const class Teuchos::RCP<class ROL::Vector<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getDualOptimizationVector, "Get the dual optimization space vector.\n\nC++: ROL::Problem<double>::getDualOptimizationVector() --> const class Teuchos::RCP<class ROL::Vector<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getBoundConstraint", (const class Teuchos::RCP<class ROL::BoundConstraint<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getBoundConstraint, "Get the bound constraint.\n\nC++: ROL::Problem<double>::getBoundConstraint() --> const class Teuchos::RCP<class ROL::BoundConstraint<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getConstraint", (const class Teuchos::RCP<class ROL::Constraint<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getConstraint, "Get the equality constraint.\n\nC++: ROL::Problem<double>::getConstraint() --> const class Teuchos::RCP<class ROL::Constraint<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getMultiplierVector", (const class Teuchos::RCP<class ROL::Vector<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getMultiplierVector, "Get the dual constraint space vector.\n\nC++: ROL::Problem<double>::getMultiplierVector() --> const class Teuchos::RCP<class ROL::Vector<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getResidualVector", (const class Teuchos::RCP<class ROL::Vector<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getResidualVector, "Get the primal constraint space vector.\n\nC++: ROL::Problem<double>::getResidualVector() --> const class Teuchos::RCP<class ROL::Vector<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getPolyhedralProjection", (const class Teuchos::RCP<class ROL::PolyhedralProjection<double> > & (ROL::Problem<double>::*)()) &ROL::Problem<double>::getPolyhedralProjection, "Get the polyhedral projection object.  This is a null pointer if\n             no linear constraints and/or bounds are present.\n\nC++: ROL::Problem<double>::getPolyhedralProjection() --> const class Teuchos::RCP<class ROL::PolyhedralProjection<double> > &", pybind11::return_value_policy::automatic);
		cl.def("getProblemType", (enum ROL::EProblem (ROL::Problem<double>::*)()) &ROL::Problem<double>::getProblemType, "Get the optimization problem type (U, B, E, G, or P).\n\nC++: ROL::Problem<double>::getProblemType() --> enum ROL::EProblem");
		cl.def("checkLinearity", [](ROL::Problem<double> const &o) -> double { return o.checkLinearity(); }, "");
		cl.def("checkLinearity", [](ROL::Problem<double> const &o, bool const & a0) -> double { return o.checkLinearity(a0); }, "", pybind11::arg("printToStream"));
		cl.def("checkLinearity", (double (ROL::Problem<double>::*)(bool, std::ostream &) const) &ROL::Problem<double>::checkLinearity, "Check if user-supplied linear constraints are affine.\n\n      This function computes the error\n      \n\n\n\n      for each user-supplied linear constraint and returns the maximum.\n      \n\n   determines whether to print to the supplied std::ostream\n      \n\n       user supplied std::ostream\n\nC++: ROL::Problem<double>::checkLinearity(bool, std::ostream &) const --> double", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkVectors", [](ROL::Problem<double> const &o) -> void { return o.checkVectors(); }, "");
		cl.def("checkVectors", [](ROL::Problem<double> const &o, bool const & a0) -> void { return o.checkVectors(a0); }, "", pybind11::arg("printToStream"));
		cl.def("checkVectors", (void (ROL::Problem<double>::*)(bool, std::ostream &) const) &ROL::Problem<double>::checkVectors, "Run vector checks for user-supplied vectors.\n\n      \n   determines whether to print to the supplied std::ostream\n      \n\n       user supplied std::ostream\n\nC++: ROL::Problem<double>::checkVectors(bool, std::ostream &) const --> void", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkDerivatives", [](ROL::Problem<double> const &o) -> void { return o.checkDerivatives(); }, "");
		cl.def("checkDerivatives", [](ROL::Problem<double> const &o, bool const & a0) -> void { return o.checkDerivatives(a0); }, "", pybind11::arg("printToStream"));
		cl.def("checkDerivatives", [](ROL::Problem<double> const &o, bool const & a0, std::ostream & a1) -> void { return o.checkDerivatives(a0, a1); }, "", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkDerivatives", [](ROL::Problem<double> const &o, bool const & a0, std::ostream & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2) -> void { return o.checkDerivatives(a0, a1, a2); }, "", pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("x0"));
		cl.def("checkDerivatives", (void (ROL::Problem<double>::*)(bool, std::ostream &, const class Teuchos::RCP<class ROL::Vector<double> > &, double) const) &ROL::Problem<double>::checkDerivatives, "Run derivative checks for user-supplied objective function and constraints.\n\n      \n   determines whether to print to the supplied std::ostream\n      \n\n       user supplied std::ostream\n\nC++: ROL::Problem<double>::checkDerivatives(bool, std::ostream &, const class Teuchos::RCP<class ROL::Vector<double> > &, double) const --> void", pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("x0"), pybind11::arg("scale"));
		cl.def("check", [](ROL::Problem<double> const &o) -> void { return o.check(); }, "");
		cl.def("check", [](ROL::Problem<double> const &o, bool const & a0) -> void { return o.check(a0); }, "", pybind11::arg("printToStream"));
		cl.def("check", [](ROL::Problem<double> const &o, bool const & a0, std::ostream & a1) -> void { return o.check(a0, a1); }, "", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("check", [](ROL::Problem<double> const &o, bool const & a0, std::ostream & a1, const class Teuchos::RCP<class ROL::Vector<double> > & a2) -> void { return o.check(a0, a1, a2); }, "", pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("x0"));
		cl.def("check", (void (ROL::Problem<double>::*)(bool, std::ostream &, const class Teuchos::RCP<class ROL::Vector<double> > &, double) const) &ROL::Problem<double>::check, "Run vector, linearity and derivative checks for user-supplied\n             vectors, objective function and constraints.\n\n      \n   determines whether to print to the supplied std::ostream\n      \n\n       user supplied std::ostream\n\nC++: ROL::Problem<double>::check(bool, std::ostream &, const class Teuchos::RCP<class ROL::Vector<double> > &, double) const --> void", pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("x0"), pybind11::arg("scale"));
		cl.def("finalize", [](ROL::Problem<double> &o) -> void { return o.finalize(); }, "");
		cl.def("finalize", [](ROL::Problem<double> &o, bool const & a0) -> void { return o.finalize(a0); }, "", pybind11::arg("lumpConstraints"));
		cl.def("finalize", [](ROL::Problem<double> &o, bool const & a0, bool const & a1) -> void { return o.finalize(a0, a1); }, "", pybind11::arg("lumpConstraints"), pybind11::arg("printToStream"));
		cl.def("finalize", (void (ROL::Problem<double>::*)(bool, bool, std::ostream &)) &ROL::Problem<double>::finalize, "Tranform user-supplied constraints to consist of only bounds\n             and equalities.  Optimization problem cannot be modified after\n             finalize has been called without calling the edit function.\n\n      \n combine both linear and nonlinear constraints\n      \n\n   determines whether to print to the supplied std::ostream\n      \n\n       user supplied std::ostream\n\nC++: ROL::Problem<double>::finalize(bool, bool, std::ostream &) --> void", pybind11::arg("lumpConstraints"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("isFinalized", (bool (ROL::Problem<double>::*)() const) &ROL::Problem<double>::isFinalized, "Indicate whether or no finalize has been called.\n\nC++: ROL::Problem<double>::isFinalized() const --> bool");
		cl.def("edit", (void (ROL::Problem<double>::*)()) &ROL::Problem<double>::edit, "Resume editting optimization problem after finalize has been called.\n\nC++: ROL::Problem<double>::edit() --> void");
		cl.def("finalizeIteration", (void (ROL::Problem<double>::*)()) &ROL::Problem<double>::finalizeIteration, "Transform the optimization variables to the native\n             parameterization after an optimization algorithm has finished.\n\nC++: ROL::Problem<double>::finalizeIteration() --> void");
		cl.def("assign", (class ROL::Problem<double> & (ROL::Problem<double>::*)(const class ROL::Problem<double> &)) &ROL::Problem<double>::operator=, "C++: ROL::Problem<double>::operator=(const class ROL::Problem<double> &) --> class ROL::Problem<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::UserInputGenerator file: line:74
		pybind11::class_<ROL::UserInputGenerator<double>, Teuchos::RCP<ROL::UserInputGenerator<double>>, PyCallBack_ROL_UserInputGenerator_double_t, ROL::SampleGenerator<double>> cl(M("ROL"), "UserInputGenerator_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<class Teuchos::ParameterList &, const class Teuchos::RCP<class ROL::BatchManager<double> > &>(), pybind11::arg("parlist"), pybind11::arg("bman") );

		cl.def( pybind11::init<std::string, std::string, int, int, const class Teuchos::RCP<class ROL::BatchManager<double> > &>(), pybind11::arg("file_pt"), pybind11::arg("file_wt"), pybind11::arg("n"), pybind11::arg("dim"), pybind11::arg("bman") );

		cl.def( pybind11::init( [](PyCallBack_ROL_UserInputGenerator_double_t const &o){ return new PyCallBack_ROL_UserInputGenerator_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::UserInputGenerator<double> const &o){ return new ROL::UserInputGenerator<double>(o); } ) );
		cl.def("refine", (void (ROL::UserInputGenerator<double>::*)()) &ROL::UserInputGenerator<double>::refine, "C++: ROL::UserInputGenerator<double>::refine() --> void");
		cl.def("numGlobalSamples", (int (ROL::UserInputGenerator<double>::*)() const) &ROL::UserInputGenerator<double>::numGlobalSamples, "C++: ROL::UserInputGenerator<double>::numGlobalSamples() const --> int");
		cl.def("assign", (class ROL::UserInputGenerator<double> & (ROL::UserInputGenerator<double>::*)(const class ROL::UserInputGenerator<double> &)) &ROL::UserInputGenerator<double>::operator=, "C++: ROL::UserInputGenerator<double>::operator=(const class ROL::UserInputGenerator<double> &) --> class ROL::UserInputGenerator<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("update", (void (ROL::SampleGenerator<double>::*)(const class ROL::Vector<double> &)) &ROL::SampleGenerator<double>::update, "C++: ROL::SampleGenerator<double>::update(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("start", (int (ROL::SampleGenerator<double>::*)()) &ROL::SampleGenerator<double>::start, "C++: ROL::SampleGenerator<double>::start() --> int");
		cl.def("computeError", (double (ROL::SampleGenerator<double>::*)(class std::vector<double> &)) &ROL::SampleGenerator<double>::computeError, "C++: ROL::SampleGenerator<double>::computeError(class std::vector<double> &) --> double", pybind11::arg("vals"));
		cl.def("refine", (void (ROL::SampleGenerator<double>::*)()) &ROL::SampleGenerator<double>::refine, "C++: ROL::SampleGenerator<double>::refine() --> void");
		cl.def("setSamples", [](ROL::SampleGenerator<double> &o) -> void { return o.setSamples(); }, "");
		cl.def("setSamples", (void (ROL::SampleGenerator<double>::*)(bool)) &ROL::SampleGenerator<double>::setSamples, "C++: ROL::SampleGenerator<double>::setSamples(bool) --> void", pybind11::arg("inConstructor"));
		cl.def("numGlobalSamples", (int (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::numGlobalSamples, "C++: ROL::SampleGenerator<double>::numGlobalSamples() const --> int");
		cl.def("numMySamples", (int (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::numMySamples, "C++: ROL::SampleGenerator<double>::numMySamples() const --> int");
		cl.def("getMyPoint", (class std::vector<double> (ROL::SampleGenerator<double>::*)(const int) const) &ROL::SampleGenerator<double>::getMyPoint, "C++: ROL::SampleGenerator<double>::getMyPoint(const int) const --> class std::vector<double>", pybind11::arg("i"));
		cl.def("getMyWeight", (double (ROL::SampleGenerator<double>::*)(const int) const) &ROL::SampleGenerator<double>::getMyWeight, "C++: ROL::SampleGenerator<double>::getMyWeight(const int) const --> double", pybind11::arg("i"));
		cl.def("batchID", (int (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::batchID, "C++: ROL::SampleGenerator<double>::batchID() const --> int");
		cl.def("numBatches", (int (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::numBatches, "C++: ROL::SampleGenerator<double>::numBatches() const --> int");
		cl.def("sumAll", (void (ROL::SampleGenerator<double>::*)(double *, double *, int) const) &ROL::SampleGenerator<double>::sumAll, "C++: ROL::SampleGenerator<double>::sumAll(double *, double *, int) const --> void", pybind11::arg("input"), pybind11::arg("output"), pybind11::arg("dim"));
		cl.def("sumAll", (void (ROL::SampleGenerator<double>::*)(class ROL::Vector<double> &, class ROL::Vector<double> &) const) &ROL::SampleGenerator<double>::sumAll, "C++: ROL::SampleGenerator<double>::sumAll(class ROL::Vector<double> &, class ROL::Vector<double> &) const --> void", pybind11::arg("input"), pybind11::arg("output"));
		cl.def("broadcast", (void (ROL::SampleGenerator<double>::*)(double *, int, int) const) &ROL::SampleGenerator<double>::broadcast, "C++: ROL::SampleGenerator<double>::broadcast(double *, int, int) const --> void", pybind11::arg("input"), pybind11::arg("cnt"), pybind11::arg("root"));
		cl.def("barrier", (void (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::barrier, "C++: ROL::SampleGenerator<double>::barrier() const --> void");
		cl.def("getBatchManager", (const class Teuchos::RCP<class ROL::BatchManager<double> > (ROL::SampleGenerator<double>::*)() const) &ROL::SampleGenerator<double>::getBatchManager, "C++: ROL::SampleGenerator<double>::getBatchManager() const --> const class Teuchos::RCP<class ROL::BatchManager<double> >");
		cl.def("print", [](ROL::SampleGenerator<double> const &o) -> void { return o.print(); }, "");
		cl.def("print", [](ROL::SampleGenerator<double> const &o, const std::string & a0) -> void { return o.print(a0); }, "", pybind11::arg("filename"));
		cl.def("print", (void (ROL::SampleGenerator<double>::*)(const std::string &, const int) const) &ROL::SampleGenerator<double>::print, "C++: ROL::SampleGenerator<double>::print(const std::string &, const int) const --> void", pybind11::arg("filename"), pybind11::arg("prec"));
		cl.def("assign", (class ROL::SampleGenerator<double> & (ROL::SampleGenerator<double>::*)(const class ROL::SampleGenerator<double> &)) &ROL::SampleGenerator<double>::operator=, "C++: ROL::SampleGenerator<double>::operator=(const class ROL::SampleGenerator<double> &) --> class ROL::SampleGenerator<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
}
