import rowan

# Set ROWAN_API_KEY environment variable to your API key or set rowan.api_key directly
# rowan.api_key = "rowan-sk..."

oseltamivir_SMILES = "C1CCOC(=O)C1=C[C@@H](OC(CC)CC)[C@H](NC(C)=O)[C@@H]([NH3+])C1CCC1"

workflow = rowan.submit_solubility_workflow(
    initial_smiles=oseltamivir_SMILES,
    solubility_method="kingfisher",
    solvents=["O"],
    temperatures=[298.15],
    name="Oseltamivir aqueous solubility",
)

print(f"View workflow privately at: https://labs.rowansci.com/workflow/{workflow.uuid}")
workflow.wait_for_result().fetch_latest(in_place=True)
print(workflow)  # Solubility in log(mol/L), temperature in kelvin
