from stjames import Molecule

import rowan

# Set ROWAN_API_KEY environment variable to your API key or set rowan.api_key directly
# rowan.api_key = "rowan-sk..."

# ordinarily, we'd try a 3D conformer and see what the strain is.
# here we'll investigate the strain of the autogenerated hexane conformer
workflow = rowan.submit_strain_workflow(
    initial_molecule=Molecule.from_smiles("CCCCCC"),
    name="test autogen hexane strain",
)

print(f"View workflow privately at: https://labs.rowansci.com/strain/{workflow.uuid}")
workflow.wait_for_result().fetch_latest(in_place=True)
print(workflow)
