# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Optional
from typing_extensions import Literal

from .._models import BaseModel

__all__ = ["DevboxAsyncExecutionDetailView"]


class DevboxAsyncExecutionDetailView(BaseModel):
    devbox_id: str
    """Devbox id where command was executed."""

    execution_id: str
    """Ephemeral id of the execution in progress."""

    status: Literal["queued", "running", "completed"]
    """Current status of the execution."""

    exit_status: Optional[int] = None
    """Exit code of command execution.

    This field will remain unset until the execution has completed.
    """

    shell_name: Optional[str] = None
    """Shell name."""

    stderr: Optional[str] = None
    """Standard error generated by command.

    This field will remain unset until the execution has completed.
    """

    stdout: Optional[str] = None
    """Standard out generated by command.

    This field will remain unset until the execution has completed.
    """
