# Rusted Graphs
A native Graph DB written in Rust

### Publish to [crates.io](https://crates.io/crates)
- dry run
    ```shell
    cargo publish --dry-run --allow-dirty
    ```
- publish
    ```shell
    cargo publish --allow-dirty
    ```

### Implement Functionality
```text
> tree -I 'target|build|node_modules|gradle|test'

.
├── Cargo.lock
├── Cargo.toml (workspace config)
├── crates
│   ├── core
│   │   ├── Cargo.toml
│   │   └── src
│   │       └── lib.rs (implement functionality here)
│   ├── java
│   │   ├── Cargo.toml
│   │   └── src
│   │       └── lib.rs (language wrapper with core as dependency)
│   ├── js
│   │   ├── Cargo.toml
│   │   ├── package-lock.json
│   │   ├── package.json
│   │   └── src
│   │       └── lib.rs (language wrapper with core as dependency)
│   └── python
│       ├── Cargo.toml
│       ├── pyproject.toml
│       ├── requirements.txt
│       ├── rgffi_python.pyi
│       └── src
│           ├── bin
│           │   └── stub_gen.rs
│           └── lib.rs (language wrapper with core as dependency)
├── dist
│   ├── java
│   │   ├── build.gradle
│   │   ├── gradlew
│   │   ├── gradlew.bat
│   │   ├── settings.gradle
│   │   └── src
│   │       └── main
│   │           ├── java
│   │           │   └── org
│   │           │       └── rgffi
│   │           │           ├── NativeLib.java
│   │           │           └── RgFfi.java
│   │           └── resources
│   │               └── native
│   │                   └── librgffi_java.dylib
│   ├── js
│   │   ├── index.d.ts
│   │   ├── index.darwin-arm64.node
│   │   ├── index.js
│   │   └── package.json
│   └── python
│       └── rgffi_python-0.0.1-cp312-cp312-macosx_11_0_arm64.whl
├── readme.md
└── src
    └── lib.rs (unused)
```

### Generate Bindings
If needed. Can be useful for other languages (intellisense)
```shell
cargo install cbindgen
cbindgen --lang c --crate rgffi --output rgffi.h
```

## Python
### Build
```shell
cd ./crates/python/
# venv here
pip install requirements.txt
# generate stubs
cargo run --bin stub_gen
# generate .whl
maturin build --release --out ../../dist/python
```

### Usage
```shell
pip install /Users/janyajoshi/projects/rusted-graphs/dist/python/rusted_graphs_python-0.0.0.5-cp39-abi3-macosx_11_0_arm64.whl --force-reinstall
```
```python
import rgffi_python
print(rgffi_python.py_add(1, 5))
rgffi_python.py_greet()
```

## Javascript
### Build
```shell
cd ./crates/js/
npm i
npm run build
```

### Usage
```json
{
   "dependencies": {
      "rgffi": "file:/Users/janyajoshi/projects/rgffi/dist/js"
   }
}
```
```js
const rgffi = require("rgffi");
rgffi.systemInfo();
console.debug(rgffi.add(4, 8));
```

## Java
### Build
```shell
cargo clean
cargo build --release
cp ./target/release/librgffi_java.dylib ./dist/java/src/main/resources/native/librgffi_java.dylib
cd ./dist/java/
# increment the version in build .gradle
./gradlew clean build publishToMavenLocal
```

Usage
```groovy
repositories {
    mavenLocal()
    mavenCentral()
}

dependencies {
    implementation "org.rgffi:rgffi:0.0.0.20"
    implementation 'com.fasterxml.jackson.core:jackson-databind:2.15.2'
}
```

```java
package org.example;

import org.rgffi.RgFfi;

public class Main {
    public static void main(String[] args) {
        System.out.println(RgFfi.add(1,2));
        RgFfi.systemInfo();
    }
}
```