# generated by datamodel-codegen:
#   filename:  openapi.yml
#   timestamp: 2025-07-29T10:12:16+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Literal, Optional

from pydantic import AwareDatetime, BaseModel, ConfigDict, Field, RootModel, conint, constr


class Duration(RootModel[conint(ge=0)]):
    root: conint(ge=0) = Field(..., description="Duration in milliseconds")


class ID(RootModel[constr(pattern=r"[a-zA-Z0-9\-_:]{2,64}")]):
    root: constr(pattern=r"[a-zA-Z0-9\-_:]{2,64}") = Field(..., description="UUID")


class Currency(Enum):
    AED = "AED"
    ANG = "ANG"
    AUD = "AUD"
    CHE = "CHE"
    CHF = "CHF"
    CHW = "CHW"
    EUR = "EUR"
    GBP = "GBP"
    LBP = "LBP"
    LKR = "LKR"
    LRD = "LRD"
    LSL = "LSL"
    LYD = "LYD"
    MAD = "MAD"
    MDL = "MDL"
    MGA = "MGA"
    MKD = "MKD"
    MMK = "MMK"
    MNT = "MNT"
    MOP = "MOP"
    MRO = "MRO"
    MUR = "MUR"
    MVR = "MVR"
    MWK = "MWK"
    MXN = "MXN"
    MXV = "MXV"
    MYR = "MYR"
    MZN = "MZN"
    NAD = "NAD"
    NGN = "NGN"
    NIO = "NIO"
    NOK = "NOK"
    NPR = "NPR"
    NZD = "NZD"
    OMR = "OMR"
    PAB = "PAB"
    PEN = "PEN"
    PGK = "PGK"
    PHP = "PHP"
    PKR = "PKR"
    PLN = "PLN"
    PYG = "PYG"
    QAR = "QAR"
    RON = "RON"
    RSD = "RSD"
    RUB = "RUB"
    RWF = "RWF"
    SAR = "SAR"
    SBD = "SBD"
    SCR = "SCR"
    SDG = "SDG"
    SEK = "SEK"
    SGD = "SGD"
    SHP = "SHP"
    SLL = "SLL"
    SOS = "SOS"
    SRD = "SRD"
    SSP = "SSP"
    STD = "STD"
    SYP = "SYP"
    SZL = "SZL"
    THB = "THB"
    TJS = "TJS"
    TMT = "TMT"
    TND = "TND"
    TOP = "TOP"
    TRY = "TRY"
    TTD = "TTD"
    TWD = "TWD"
    TZS = "TZS"
    UAH = "UAH"
    UGX = "UGX"
    USD = "USD"
    USN = "USN"
    UYI = "UYI"
    UYU = "UYU"
    UZS = "UZS"
    VEF = "VEF"
    VND = "VND"
    VUV = "VUV"
    WST = "WST"
    XAG = "XAG"
    XAU = "XAU"
    XBA = "XBA"
    XBB = "XBB"
    XBC = "XBC"
    XBD = "XBD"
    XCD = "XCD"
    XOF = "XOF"
    XPD = "XPD"
    XPF = "XPF"
    XPT = "XPT"
    XSU = "XSU"
    XTS = "XTS"
    XUA = "XUA"
    XXX = "XXX"
    YER = "YER"
    ZAR = "ZAR"
    ZMW = "ZMW"
    ZWL = "ZWL"


class SessionRequestType(str, Enum):
    RECONNECT = "RECONNECT"
    TERMINATE = "TERMINATE"


class RevokableObjects(str, Enum):
    PEBC_PowerConstraints = "PEBC.PowerConstraints"
    PEBC_EnergyConstraint = "PEBC.EnergyConstraint"
    PEBC_Instruction = "PEBC.Instruction"
    PPBC_PowerProfileDefinition = "PPBC.PowerProfileDefinition"
    PPBC_ScheduleInstruction = "PPBC.ScheduleInstruction"
    PPBC_StartInterruptionInstruction = "PPBC.StartInterruptionInstruction"
    PPBC_EndInterruptionInstruction = "PPBC.EndInterruptionInstruction"
    OMBC_SystemDescription = "OMBC.SystemDescription"
    OMBC_Instruction = "OMBC.Instruction"
    FRBC_SystemDescription = "FRBC.SystemDescription"
    FRBC_Instruction = "FRBC.Instruction"
    DDBC_SystemDescription = "DDBC.SystemDescription"
    DDBC_Instruction = "DDBC.Instruction"


class EnergyManagementRole(str, Enum):
    CEM = "CEM"
    RM = "RM"


class ReceptionStatusValues(str, Enum):
    INVALID_DATA = "INVALID_DATA"
    INVALID_MESSAGE = "INVALID_MESSAGE"
    INVALID_CONTENT = "INVALID_CONTENT"
    TEMPORARY_ERROR = "TEMPORARY_ERROR"
    PERMANENT_ERROR = "PERMANENT_ERROR"
    OK = "OK"


class NumberRange(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    start_of_range: float = Field(..., description="Number that defines the start of the range")
    end_of_range: float = Field(..., description="Number that defines the end of the range")


class Transition(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True
    )
    id: ID = Field(
        ...,
        description="ID of the Transition. Must be unique in the scope of the OMBC.SystemDescription, FRBC.ActuatorDescription or DDBC.ActuatorDescription in which it is used.",
    )
    from_: ID = Field(
        ...,
        alias="from",
        description="ID of the OperationMode (exact type differs per ControlType) that should be switched from.",
    )
    to: ID = Field(
        ...,
        description="ID of the OperationMode (exact type differs per ControlType) that will be switched to.",
    )
    start_timers: List[ID] = Field(
        ...,
        description="List of IDs of Timers that will be (re)started when this transition is initiated",
        max_length=1000,
        min_length=0,
    )
    blocking_timers: List[ID] = Field(
        ...,
        description="List of IDs of Timers that block this Transition from initiating while at least one of these Timers is not yet finished",
        max_length=1000,
        min_length=0,
    )
    transition_costs: Optional[float] = Field(
        None,
        description="Absolute costs for going through this Transition in the currency as described in the ResourceManagerDetails.",
    )
    transition_duration: Optional[Duration] = Field(
        None,
        description="Indicates the time between the initiation of this Transition, and the time at which the device behaves according to the Operation Mode which is defined in the ‘to’ data element. When no value is provided it is assumed the transition duration is negligible.",
    )
    abnormal_condition_only: bool = Field(
        ...,
        description="Indicates if this Transition may only be used during an abnormal condition (see Clause )",
    )


class Timer(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: ID = Field(
        ...,
        description="ID of the Timer. Must be unique in the scope of the OMBC.SystemDescription, FRBC.ActuatorDescription or DDBC.ActuatorDescription in which it is used.",
    )
    diagnostic_label: Optional[str] = Field(
        None,
        description="Human readable name/description of the Timer. This element is only intended for diagnostic purposes and not for HMI applications.",
    )
    duration: Duration = Field(
        ..., description="The time it takes for the Timer to finish after it has been started"
    )


class PEBCPowerEnvelopeElement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    duration: Duration = Field(..., description="The duration of the element")
    upper_limit: float = Field(
        ...,
        description="Upper power limit according to the commodity_quantity of the containing PEBC.PowerEnvelope. The lower_limit must be smaller or equal to the upper_limit. The Resource Manager is requested to keep the power values for the given commodity quantity equal to or below the upper_limit. The upper_limit shall be in accordance with the constraints provided by the Resource Manager through any PEBC.AllowedLimitRange with limit_type UPPER_LIMIT.",
    )
    lower_limit: float = Field(
        ...,
        description="Lower power limit according to the commodity_quantity of the containing PEBC.PowerEnvelope. The lower_limit must be smaller or equal to the upper_limit. The Resource Manager is requested to keep the power values for the given commodity quantity equal to or above the lower_limit. The lower_limit shall be in accordance with the constraints provided by the Resource Manager through any PEBC.AllowedLimitRange with limit_type LOWER_LIMIT.",
    )


class FRBCStorageDescription(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    diagnostic_label: Optional[str] = Field(
        None,
        description="Human readable name/description of the storage (e.g. hot water buffer or battery). This element is only intended for diagnostic purposes and not for HMI applications.",
    )
    fill_level_label: Optional[str] = Field(
        None,
        description="Human readable description of the (physical) units associated with the fill_level (e.g. degrees Celsius or percentage state of charge). This element is only intended for diagnostic purposes and not for HMI applications.",
    )
    provides_leakage_behaviour: bool = Field(
        ...,
        description="Indicates whether the Storage could provide details of power leakage behaviour through the FRBC.LeakageBehaviour.",
    )
    provides_fill_level_target_profile: bool = Field(
        ...,
        description="Indicates whether the Storage could provide a target profile for the fill level through the FRBC.FillLevelTargetProfile.",
    )
    provides_usage_forecast: bool = Field(
        ...,
        description="Indicates whether the Storage could provide a UsageForecast through the FRBC.UsageForecast.",
    )
    fill_level_range: NumberRange = Field(
        ...,
        description="The range in which the fill_level should remain. It is expected of the CEM to keep the fill_level within this range. When the fill_level is not within this range, the Resource Manager can ignore instructions from the CEM (except during abnormal conditions). ",
    )


class FRBCLeakageBehaviourElement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    fill_level_range: NumberRange = Field(
        ...,
        description="The fill level range for which this FRBC.LeakageBehaviourElement applies. The start of the range must be less than the end of the range.",
    )
    leakage_rate: float = Field(
        ...,
        description="Indicates how fast the momentary fill level will decrease per second due to leakage within the given range of the fill level. A positive value indicates that the fill level decreases over time due to leakage.",
    )


class FRBCUsageForecastElement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    duration: Duration = Field(
        ..., description="Indicator for how long the given usage_rate is valid."
    )
    usage_rate_upper_limit: Optional[float] = Field(
        None,
        description="The upper limit of the range with a 100 % probability that the usage rate is within that range. A positive value indicates that the fill level will decrease due to usage.",
    )
    usage_rate_upper_95PPR: Optional[float] = Field(
        None,
        description="The upper limit of the range with a 95 % probability that the usage rate is within that range. A positive value indicates that the fill level will decrease due to usage.",
    )
    usage_rate_upper_68PPR: Optional[float] = Field(
        None,
        description="The upper limit of the range with a 68 % probability that the usage rate is within that range. A positive value indicates that the fill level will decrease due to usage.",
    )
    usage_rate_expected: float = Field(
        ...,
        description="The most likely value for the usage rate; the expected increase or decrease of the fill_level per second. A positive value indicates that the fill level will decrease due to usage.",
    )
    usage_rate_lower_68PPR: Optional[float] = Field(
        None,
        description="The lower limit of the range with a 68 % probability that the usage rate is within that range. A positive value indicates that the fill level will decrease due to usage.",
    )
    usage_rate_lower_95PPR: Optional[float] = Field(
        None,
        description="The lower limit of the range with a 95 % probability that the usage rate is within that range. A positive value indicates that the fill level will decrease due to usage.",
    )
    usage_rate_lower_limit: Optional[float] = Field(
        None,
        description="The lower limit of the range with a 100 % probability that the usage rate is within that range. A positive value indicates that the fill level will decrease due to usage.",
    )


class FRBCFillLevelTargetProfileElement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    duration: Duration = Field(..., description="The duration of the element.")
    fill_level_range: NumberRange = Field(
        ...,
        description="The target range in which the fill_level must be for the time period during which the element is active. The start of the range must be smaller or equal to the end of the range. The CEM must take best-effort actions to proactively achieve this target.",
    )


class DDBCAverageDemandRateForecastElement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    duration: Duration = Field(..., description="Duration of the element")
    demand_rate_upper_limit: Optional[float] = Field(
        None,
        description="The upper limit of the range with a 100 % probability that the demand rate is within that range",
    )
    demand_rate_upper_95PPR: Optional[float] = Field(
        None,
        description="The upper limit of the range with a 95 % probability that the demand rate is within that range",
    )
    demand_rate_upper_68PPR: Optional[float] = Field(
        None,
        description="The upper limit of the range with a 68 % probability that the demand rate is within that range",
    )
    demand_rate_expected: float = Field(
        ...,
        description="The most likely value for the demand rate; the expected increase or decrease of the fill_level per second",
    )
    demand_rate_lower_68PPR: Optional[float] = Field(
        None,
        description="The lower limit of the range with a 68 % probability that the demand rate is within that range",
    )
    demand_rate_lower_95PPR: Optional[float] = Field(
        None,
        description="The lower limit of the range with a 95 % probability that the demand rate is within that range",
    )
    demand_rate_lower_limit: Optional[float] = Field(
        None,
        description="The lower limit of the range with a 100 % probability that the demand rate is within that range",
    )


class RoleType(str, Enum):
    ENERGY_PRODUCER = "ENERGY_PRODUCER"
    ENERGY_CONSUMER = "ENERGY_CONSUMER"
    ENERGY_STORAGE = "ENERGY_STORAGE"


class Commodity(str, Enum):
    GAS = "GAS"
    HEAT = "HEAT"
    ELECTRICITY = "ELECTRICITY"
    OIL = "OIL"


class CommodityQuantity(str, Enum):
    ELECTRIC_POWER_L1 = "ELECTRIC.POWER.L1"
    ELECTRIC_POWER_L2 = "ELECTRIC.POWER.L2"
    ELECTRIC_POWER_L3 = "ELECTRIC.POWER.L3"
    ELECTRIC_POWER_3_PHASE_SYMMETRIC = "ELECTRIC.POWER.3_PHASE_SYMMETRIC"
    NATURAL_GAS_FLOW_RATE = "NATURAL_GAS.FLOW_RATE"
    HYDROGEN_FLOW_RATE = "HYDROGEN.FLOW_RATE"
    HEAT_TEMPERATURE = "HEAT.TEMPERATURE"
    HEAT_FLOW_RATE = "HEAT.FLOW_RATE"
    HEAT_THERMAL_POWER = "HEAT.THERMAL_POWER"
    OIL_FLOW_RATE = "OIL.FLOW_RATE"


class InstructionStatus(str, Enum):
    NEW = "NEW"
    ACCEPTED = "ACCEPTED"
    REJECTED = "REJECTED"
    REVOKED = "REVOKED"
    STARTED = "STARTED"
    SUCCEEDED = "SUCCEEDED"
    ABORTED = "ABORTED"


class ControlType(str, Enum):
    POWER_ENVELOPE_BASED_CONTROL = "POWER_ENVELOPE_BASED_CONTROL"
    POWER_PROFILE_BASED_CONTROL = "POWER_PROFILE_BASED_CONTROL"
    OPERATION_MODE_BASED_CONTROL = "OPERATION_MODE_BASED_CONTROL"
    FILL_RATE_BASED_CONTROL = "FILL_RATE_BASED_CONTROL"
    DEMAND_DRIVEN_BASED_CONTROL = "DEMAND_DRIVEN_BASED_CONTROL"
    NOT_CONTROLABLE = "NOT_CONTROLABLE"
    NO_SELECTION = "NO_SELECTION"


class PEBCPowerEnvelopeLimitType(str, Enum):
    UPPER_LIMIT = "UPPER_LIMIT"
    LOWER_LIMIT = "LOWER_LIMIT"


class PEBCPowerEnvelopeConsequenceType(str, Enum):
    VANISH = "VANISH"
    DEFER = "DEFER"


class PPBCPowerSequenceStatus(str, Enum):
    NOT_SCHEDULED = "NOT_SCHEDULED"
    SCHEDULED = "SCHEDULED"
    EXECUTING = "EXECUTING"
    INTERRUPTED = "INTERRUPTED"
    FINISHED = "FINISHED"
    ABORTED = "ABORTED"


class OMBCTimerStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["OMBC.TimerStatus"] = "OMBC.TimerStatus"
    message_id: ID
    timer_id: ID = Field(..., description="The ID of the timer this message refers to")
    finished_at: AwareDatetime = Field(
        ...,
        description="Indicates when the Timer will be finished. If the DateTimeStamp is in the future, the timer is not yet finished. If the DateTimeStamp is in the past, the timer is finished. If the timer was never started, the value can be an arbitrary DateTimeStamp in the past.",
    )


class FRBCTimerStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["FRBC.TimerStatus"] = "FRBC.TimerStatus"
    message_id: ID
    timer_id: ID = Field(..., description="The ID of the timer this message refers to")
    actuator_id: ID = Field(..., description="The ID of the actuator the timer belongs to")
    finished_at: AwareDatetime = Field(
        ...,
        description="Indicates when the Timer will be finished. If the DateTimeStamp is in the future, the timer is not yet finished. If the DateTimeStamp is in the past, the timer is finished. If the timer was never started, the value can be an arbitrary DateTimeStamp in the past.",
    )


class DDBCTimerStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["DDBC.TimerStatus"] = "DDBC.TimerStatus"
    message_id: ID
    timer_id: ID = Field(..., description="The ID of the timer this message refers to")
    actuator_id: ID = Field(..., description="The ID of the actuator the timer belongs to")
    finished_at: AwareDatetime = Field(
        ...,
        description="Indicates when the Timer will be finished. If the DateTimeStamp is in the future, the timer is not yet finished. If the DateTimeStamp is in the past, the timer is finished. If the timer was never started, the value can be an arbitrary DateTimeStamp in the past.",
    )


class SelectControlType(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["SelectControlType"] = "SelectControlType"
    message_id: ID
    control_type: ControlType = Field(
        ...,
        description="The ControlType to activate. Must be one of the available ControlTypes as defined in the ResourceManagerDetails",
    )


class SessionRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["SessionRequest"] = "SessionRequest"
    message_id: ID
    request: SessionRequestType = Field(..., description="The type of request")
    diagnostic_label: Optional[str] = Field(
        None, description="Optional field for a human readible descirption for debugging purposes"
    )


class RevokeObject(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["RevokeObject"] = "RevokeObject"
    message_id: ID
    object_type: RevokableObjects = Field(
        ..., description="The type of object that needs to be revoked"
    )
    object_id: ID = Field(..., description="The ID of object that needs to be revoked")


class Handshake(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["Handshake"] = "Handshake"
    message_id: ID
    role: EnergyManagementRole = Field(..., description="The role of the sender of this message")
    supported_protocol_versions: Optional[List[str]] = Field(
        None,
        description="Protocol versions supported by the sender of this message. This field is mandatory for the RM, but optional for the CEM.",
        min_length=1,
    )


class HandshakeResponse(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["HandshakeResponse"] = "HandshakeResponse"
    message_id: ID
    selected_protocol_version: str = Field(
        ..., description="The protocol version the CEM selected for this session"
    )


class ReceptionStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["ReceptionStatus"] = "ReceptionStatus"
    subject_message_id: ID = Field(..., description="The message this ReceptionStatus refers to")
    status: ReceptionStatusValues = Field(..., description="Enumeration of status values")
    diagnostic_label: Optional[str] = Field(
        None,
        description="Diagnostic label that can be used to provide additional information for debugging. However, not for HMI purposes.",
    )


class InstructionStatusUpdate(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["InstructionStatusUpdate"] = "InstructionStatusUpdate"
    message_id: ID
    instruction_id: ID = Field(..., description="ID of this instruction (as provided by the CEM) ")
    status_type: InstructionStatus = Field(..., description="Present status of this instruction.")
    timestamp: AwareDatetime = Field(
        ..., description="Timestamp when status_type has changed the last time."
    )


class PEBCEnergyConstraint(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PEBC.EnergyConstraint"] = "PEBC.EnergyConstraint"
    message_id: ID
    id: ID = Field(
        ...,
        description="Identifier of this PEBC.EnergyConstraints. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    valid_from: AwareDatetime = Field(
        ..., description="Moment this PEBC.EnergyConstraints information starts to be valid"
    )
    valid_until: AwareDatetime = Field(
        ..., description="Moment until this PEBC.EnergyConstraints information is valid."
    )
    upper_average_power: float = Field(
        ...,
        description="Upper average power within the time period given by valid_from and valid_until. If the duration is multiplied with this power value, then the associated upper energy content can be derived. This is the highest amount of energy the resource will consume during that period of time. The Power Envelope created by the CEM must allow at least this much energy consumption (in case the number is positive). Must be greater than or equal to lower_average_power, and can be negative in case of energy production.",
    )
    lower_average_power: float = Field(
        ...,
        description="Lower average power within the time period given by valid_from and valid_until. If the duration is multiplied with this power value, then the associated lower energy content can be derived. This is the lowest amount of energy the resource will consume during that period of time. The Power Envelope created by the CEM must allow at least this much energy production (in case the number is negative). Must be greater than or equal to lower_average_power, and can be negative in case of energy production.",
    )
    commodity_quantity: CommodityQuantity = Field(
        ...,
        description="Type of power quantity which applies to upper_average_power and lower_average_power",
    )


class PPBCScheduleInstruction(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PPBC.ScheduleInstruction"] = "PPBC.ScheduleInstruction"
    message_id: ID
    id: ID = Field(
        ...,
        description="ID of the Instruction. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    power_profile_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerProfileDefinition of which the PPBC.PowerSequence is being selected and scheduled by the CEM.",
    )
    sequence_container_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerSequnceContainer of which the PPBC.PowerSequence is being selected and scheduled by the CEM.",
    )
    power_sequence_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerSequence that is being selected and scheduled by the CEM.",
    )
    execution_time: AwareDatetime = Field(
        ...,
        description="Indicates the moment the PPBC.PowerSequence shall start. When the specified execution time is in the past, execution must start as soon as possible.",
    )
    abnormal_condition: bool = Field(
        ..., description="Indicates if this is an instruction during an abnormal condition"
    )


class PPBCStartInterruptionInstruction(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PPBC.StartInterruptionInstruction"] = "PPBC.StartInterruptionInstruction"
    message_id: ID
    id: ID = Field(
        ...,
        description="ID of the Instruction. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    power_profile_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerProfileDefinition of which the PPBC.PowerSequence is being interrupted by the CEM.",
    )
    sequence_container_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerSequnceContainer of which the PPBC.PowerSequence is being interrupted by the CEM.",
    )
    power_sequence_id: ID = Field(
        ..., description="ID of the PPBC.PowerSequence that the CEM wants to interrupt."
    )
    execution_time: AwareDatetime = Field(
        ...,
        description="Indicates the moment the PPBC.PowerSequence shall be interrupted. When the specified execution time is in the past, execution must start as soon as possible.",
    )
    abnormal_condition: bool = Field(
        ..., description="Indicates if this is an instruction during an abnormal condition"
    )


class PPBCEndInterruptionInstruction(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PPBC.EndInterruptionInstruction"] = "PPBC.EndInterruptionInstruction"
    message_id: ID
    id: ID = Field(
        ...,
        description="ID of the Instruction. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    power_profile_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerProfileDefinition of which the PPBC.PowerSequence interruption is being ended by the CEM.",
    )
    sequence_container_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerSequnceContainer of which the PPBC.PowerSequence interruption is being ended by the CEM.",
    )
    power_sequence_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerSequence for which the CEM wants to end the interruption.",
    )
    execution_time: AwareDatetime = Field(
        ...,
        description="Indicates the moment PPBC.PowerSequence interruption shall end. When the specified execution time is in the past, execution must start as soon as possible.",
    )
    abnormal_condition: bool = Field(
        ..., description="Indicates if this is an instruction during an abnormal condition"
    )


class OMBCStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["OMBC.Status"] = "OMBC.Status"
    message_id: ID
    active_operation_mode_id: ID = Field(..., description="ID of the active OMBC.OperationMode.")
    operation_mode_factor: float = Field(
        ...,
        description="The number indicates the factor with which the OMBC.OperationMode should be configured. The factor should be greater than or equal than 0 and less or equal to 1.",
    )
    previous_operation_mode_id: Optional[ID] = Field(
        None,
        description="ID of the OMBC.OperationMode that was previously active. This value shall always be provided, unless the active OMBC.OperationMode is the first OMBC.OperationMode the Resource Manager is aware of.",
    )
    transition_timestamp: Optional[AwareDatetime] = Field(
        None,
        description="Time at which the transition from the previous OMBC.OperationMode to the active OMBC.OperationMode was initiated. This value shall always be provided, unless the active OMBC.OperationMode is the first OMBC.OperationMode the Resource Manager is aware of.",
    )


class OMBCInstruction(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["OMBC.Instruction"] = "OMBC.Instruction"
    message_id: ID
    id: ID = Field(
        ...,
        description="ID of the instruction. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    execution_time: AwareDatetime = Field(
        ...,
        description="Indicates the moment the execution of the instruction shall start. When the specified execution time is in the past, execution must start as soon as possible.",
    )
    operation_mode_id: ID = Field(
        ..., description="ID of the OMBC.OperationMode that should be activated"
    )
    operation_mode_factor: float = Field(
        ...,
        description="The number indicates the factor with which the OMBC.OperationMode should be configured. The factor should be greater than or equal than 0 and less or equal to 1.",
    )
    abnormal_condition: bool = Field(
        ..., description="Indicates if this is an instruction during an abnormal condition"
    )


class FRBCActuatorStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["FRBC.ActuatorStatus"] = "FRBC.ActuatorStatus"
    message_id: ID
    actuator_id: ID = Field(..., description="ID of the actuator this messages refers to")
    active_operation_mode_id: ID = Field(
        ..., description="ID of the FRBC.OperationMode that is presently active."
    )
    operation_mode_factor: float = Field(
        ...,
        description="The number indicates the factor with which the FRBC.OperationMode is configured. The factor should be greater than or equal than 0 and less or equal to 1.",
    )
    previous_operation_mode_id: Optional[ID] = Field(
        None,
        description="ID of the FRBC.OperationMode that was active before the present one. This value shall always be provided, unless the active FRBC.OperationMode is the first FRBC.OperationMode the Resource Manager is aware of.",
    )
    transition_timestamp: Optional[AwareDatetime] = Field(
        None,
        description="Time at which the transition from the previous FRBC.OperationMode to the active FRBC.OperationMode was initiated. This value shall always be provided, unless the active FRBC.OperationMode is the first FRBC.OperationMode the Resource Manager is aware of.",
    )


class FRBCStorageStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["FRBC.StorageStatus"] = "FRBC.StorageStatus"
    message_id: ID
    present_fill_level: float = Field(..., description="Present fill level of the Storage")


class FRBCLeakageBehaviour(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["FRBC.LeakageBehaviour"] = "FRBC.LeakageBehaviour"
    message_id: ID
    valid_from: AwareDatetime = Field(
        ...,
        description="Moment this FRBC.LeakageBehaviour starts to be valid. If the FRBC.LeakageBehaviour is immediately valid, the DateTimeStamp should be now or in the past.",
    )
    elements: List[FRBCLeakageBehaviourElement] = Field(
        ...,
        description="List of elements that model the leakage behaviour of the buffer. The fill_level_ranges of the elements must be contiguous.",
        max_length=288,
        min_length=1,
    )


class FRBCInstruction(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["FRBC.Instruction"] = "FRBC.Instruction"
    message_id: ID
    id: ID = Field(
        ...,
        description="ID of the instruction. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    actuator_id: ID = Field(..., description="ID of the actuator this instruction belongs to.")
    operation_mode: ID = Field(
        ..., description="ID of the FRBC.OperationMode that should be activated."
    )
    operation_mode_factor: float = Field(
        ...,
        description="The number indicates the factor with which the FRBC.OperationMode should be configured. The factor should be greater than or equal to 0 and less or equal to 1.",
    )
    execution_time: AwareDatetime = Field(
        ...,
        description="Indicates the moment the execution of the instruction shall start. When the specified execution time is in the past, execution must start as soon as possible.",
    )
    abnormal_condition: bool = Field(
        ..., description="Indicates if this is an instruction during an abnormal condition."
    )


class FRBCUsageForecast(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["FRBC.UsageForecast"] = "FRBC.UsageForecast"
    message_id: ID
    start_time: AwareDatetime = Field(
        ..., description="Time at which the FRBC.UsageForecast starts."
    )
    elements: List[FRBCUsageForecastElement] = Field(
        ...,
        description="Further elements that model the profile. There shall be at least one element. Elements must be placed in chronological order.",
        max_length=288,
        min_length=1,
    )


class FRBCFillLevelTargetProfile(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["FRBC.FillLevelTargetProfile"] = "FRBC.FillLevelTargetProfile"
    message_id: ID
    start_time: AwareDatetime = Field(
        ..., description="Time at which the FRBC.FillLevelTargetProfile starts."
    )
    elements: List[FRBCFillLevelTargetProfileElement] = Field(
        ...,
        description="List of different fill levels that have to be targeted within a given duration. There shall be at least one element. Elements must be placed in chronological order.",
        max_length=288,
        min_length=1,
    )


class DDBCActuatorStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["DDBC.ActuatorStatus"] = "DDBC.ActuatorStatus"
    message_id: ID
    actuator_id: ID = Field(..., description="ID of the actuator this messages refers to")
    active_operation_mode_id: ID = Field(
        ..., description="The operation mode that is presently active for this actuator."
    )
    operation_mode_factor: float = Field(
        ...,
        description="The number indicates the factor with which the DDBC.OperationMode is configured. The factor should be greater than or equal to 0 and less or equal to 1.",
    )
    previous_operation_mode_id: Optional[ID] = Field(
        None,
        description="ID of the DDBC,OperationMode that was active before the present one. This value shall always be provided, unless the active DDBC.OperationMode is the first DDBC.OperationMode the Resource Manager is aware of.",
    )
    transition_timestamp: Optional[AwareDatetime] = Field(
        None,
        description="Time at which the transition from the previous DDBC.OperationMode to the active DDBC.OperationMode was initiated. This value shall always be provided, unless the active DDBC.OperationMode is the first DDBC.OperationMode the Resource Manager is aware of.",
    )


class DDBCInstruction(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["DDBC.Instruction"] = "DDBC.Instruction"
    message_id: ID
    id: ID = Field(
        ...,
        description="Identifier of this DDBC.Instruction. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    execution_time: AwareDatetime = Field(
        ...,
        description="Indicates the moment the execution of the instruction shall start. When the specified execution time is in the past, execution must start as soon as possible.",
    )
    abnormal_condition: bool = Field(
        ..., description="Indicates if this is an instruction during an abnormal condition"
    )
    actuator_id: ID = Field(..., description="ID of the actuator this Instruction belongs to.")
    operation_mode_id: ID = Field(..., description="ID of the DDBC.OperationMode")
    operation_mode_factor: float = Field(
        ...,
        description="The number indicates the factor with which the OMBC.OperationMode should be configured. The factor should be greater than or equal to 0 and less or equal to 1.",
    )


class DDBCAverageDemandRateForecast(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["DDBC.AverageDemandRateForecast"] = "DDBC.AverageDemandRateForecast"
    message_id: ID
    start_time: AwareDatetime = Field(..., description="Start time of the profile.")
    elements: List[DDBCAverageDemandRateForecastElement] = Field(
        ...,
        description="Elements of the profile. Elements must be placed in chronological order.",
        max_length=288,
        min_length=1,
    )


class PowerValue(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    commodity_quantity: CommodityQuantity = Field(
        ..., description="The power quantity the value refers to"
    )
    value: float = Field(
        ..., description="Power value expressed in the unit associated with the CommodityQuantity"
    )


class PowerForecastValue(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    value_upper_limit: Optional[float] = Field(
        None,
        description="The upper boundary of the range with 100 % certainty the power value is in it",
    )
    value_upper_95PPR: Optional[float] = Field(
        None,
        description="The upper boundary of the range with 95 % certainty the power value is in it",
    )
    value_upper_68PPR: Optional[float] = Field(
        None,
        description="The upper boundary of the range with 68 % certainty the power value is in it",
    )
    value_expected: float = Field(..., description="The expected power value.")
    value_lower_68PPR: Optional[float] = Field(
        None,
        description="The lower boundary of the range with 68 % certainty the power value is in it",
    )
    value_lower_95PPR: Optional[float] = Field(
        None,
        description="The lower boundary of the range with 95 % certainty the power value is in it",
    )
    value_lower_limit: Optional[float] = Field(
        None,
        description="The lower boundary of the range with 100 % certainty the power value is in it",
    )
    commodity_quantity: CommodityQuantity = Field(
        ..., description="The power quantity the value refers to"
    )


class PowerRange(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    start_of_range: float = Field(
        ..., description="Power value that defines the start of the range."
    )
    end_of_range: float = Field(..., description="Power value that defines the end of the range.")
    commodity_quantity: CommodityQuantity = Field(
        ..., description="The power quantity the values refer to"
    )


class Role(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    role: RoleType = Field(
        ..., description="Role type of the Resource Manager for the given commodity"
    )
    commodity: Commodity = Field(..., description="Commodity the role refers to.")


class PowerForecastElement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    duration: Duration = Field(..., description="Duration of the PowerForecastElement")
    power_values: List[PowerForecastValue] = Field(
        ...,
        description="The values of power that are expected for the given period of time. There shall be at least one PowerForecastValue, and at most one PowerForecastValue per CommodityQuantity.",
        max_length=10,
        min_length=1,
    )


class PEBCAllowedLimitRange(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    commodity_quantity: CommodityQuantity = Field(
        ..., description="Type of power quantity this PEBC.AllowedLimitRange applies to"
    )
    limit_type: PEBCPowerEnvelopeLimitType = Field(
        ..., description="Indicates if this ranges applies to the upper limit or the lower limit"
    )
    range_boundary: NumberRange = Field(
        ...,
        description="Boundaries of the power range of this PEBC.AllowedLimitRange. The CEM is allowed to choose values within this range for the power envelope for the limit as described in limit_type. The start of the range shall be smaller or equal than the end of the range. ",
    )
    abnormal_condition_only: bool = Field(
        ...,
        description="Indicates if this PEBC.AllowedLimitRange may only be used during an abnormal condition",
    )


class PEBCPowerEnvelope(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: ID = Field(
        ...,
        description="Identifier of this PEBC.PowerEnvelope. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    commodity_quantity: CommodityQuantity = Field(
        ..., description="Type of power quantity this PEBC.PowerEnvelope applies to"
    )
    power_envelope_elements: List[PEBCPowerEnvelopeElement] = Field(
        ...,
        description="The elements of this PEBC.PowerEnvelope. Shall contain at least one element. Elements must be placed in chronological order.",
        max_length=288,
        min_length=1,
    )


class PPBCPowerSequenceElement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    duration: Duration = Field(..., description="Duration of the PPBC.PowerSequenceElement.")
    power_values: List[PowerForecastValue] = Field(
        ...,
        description="The value of power and deviations for the given duration. The array should contain at least one PowerForecastValue and at most one PowerForecastValue per CommodityQuantity.",
        max_length=10,
        min_length=1,
    )


class PPBCPowerSequenceContainerStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    power_profile_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerProfileDefinition of which the data element ‘sequence_container_id’ refers to. ",
    )
    sequence_container_id: ID = Field(
        ...,
        description="ID of the PPBC.PowerSequenceContainer this PPBC.PowerSequenceContainerStatus provides information about.",
    )
    selected_sequence_id: Optional[ID] = Field(
        None,
        description="ID of selected PPBC.PowerSequence. When no ID is given, no sequence was selected yet.",
    )
    progress: Optional[Duration] = Field(
        None,
        description="Time that has passed since the selected sequence has started. A value must be provided, unless no sequence has been selected or the selected sequence hasn’t started yet.",
    )
    status: PPBCPowerSequenceStatus = Field(
        ..., description="Status of the selected PPBC.PowerSequence"
    )


class OMBCOperationMode(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: ID = Field(
        ...,
        description="ID of the OBMC.OperationMode. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    diagnostic_label: Optional[str] = Field(
        None,
        description="Human readable name/description of the OMBC.OperationMode. This element is only intended for diagnostic purposes and not for HMI applications.",
    )
    power_ranges: List[PowerRange] = Field(
        ...,
        description="The power produced or consumed by this operation mode. The start of each PowerRange is associated with an operation_mode_factor of 0, the end is associated with an operation_mode_factor of 1. In the array there must be at least one PowerRange, and at most one PowerRange per CommodityQuantity.",
        max_length=10,
        min_length=1,
    )
    running_costs: Optional[NumberRange] = Field(
        None,
        description="Additional costs per second (e.g. wear, services) associated with this operation mode in the currency defined by the ResourceManagerDetails , excluding the commodity cost. The range is expressing uncertainty and is not linked to the operation_mode_factor.",
    )
    abnormal_condition_only: bool = Field(
        ...,
        description="Indicates if this OMBC.OperationMode may only be used during an abnormal condition.",
    )


class FRBCOperationModeElement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    fill_level_range: NumberRange = Field(
        ...,
        description="The range of the fill level for which this FRBC.OperationModeElement applies. The start of the NumberRange shall be smaller than the end of the NumberRange.",
    )
    fill_rate: NumberRange = Field(
        ...,
        description="Indicates the change in fill_level per second. The lower_boundary of the NumberRange is associated with an operation_mode_factor of 0, the upper_boundary is associated with an operation_mode_factor of 1. ",
    )
    power_ranges: List[PowerRange] = Field(
        ...,
        description="The power produced or consumed by this operation mode. The start of each PowerRange is associated with an operation_mode_factor of 0, the end is associated with an operation_mode_factor of 1. In the array there must be at least one PowerRange, and at most one PowerRange per CommodityQuantity.",
        max_length=10,
        min_length=1,
    )
    running_costs: Optional[NumberRange] = Field(
        None,
        description="Additional costs per second (e.g. wear, services) associated with this operation mode in the currency defined by the ResourceManagerDetails, excluding the commodity cost. The range is expressing uncertainty and is not linked to the operation_mode_factor.",
    )


class DDBCOperationMode(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    Id: ID = Field(
        ...,
        description="ID of this operation mode. Must be unique in the scope of the DDBC.ActuatorDescription in which it is used.",
    )
    diagnostic_label: Optional[str] = Field(
        None,
        description="Human readable name/description of the DDBC.OperationMode. This element is only intended for diagnostic purposes and not for HMI applications.",
    )
    power_ranges: List[PowerRange] = Field(
        ...,
        description="The power produced or consumed by this operation mode. The start of each PowerRange is associated with an operation_mode_factor of 0, the end is associated with an operation_mode_factor of 1. In the array there must be at least one PowerRange, and at most one PowerRange per CommodityQuantity.",
        max_length=10,
        min_length=1,
    )
    supply_range: NumberRange = Field(
        ...,
        description="The supply rate this DDBC.OperationMode can deliver for the CEM to match the demand rate. The start of the NumberRange is associated with an operation_mode_factor of 0, the end is associated with an operation_mode_factor of 1.",
    )
    running_costs: Optional[NumberRange] = Field(
        None,
        description="Additional costs per second (e.g. wear, services) associated with this operation mode in the currency defined by the ResourceManagerDetails, excluding the commodity cost. The range is expressing uncertainty and is not linked to the operation_mode_factor.",
    )
    abnormal_condition_only: bool = Field(
        ...,
        description="Indicates if this DDBC.OperationMode may only be used during an abnormal condition.",
    )


class ResourceManagerDetails(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["ResourceManagerDetails"] = "ResourceManagerDetails"
    message_id: ID
    resource_id: ID = Field(
        ...,
        description="Identifier of the Resource Manager. Must be unique within the scope of the CEM.",
    )
    name: Optional[str] = Field(None, description="Human readable name given by user")
    roles: List[Role] = Field(
        ...,
        description="Each Resource Manager provides one or more energy Roles",
        max_length=3,
        min_length=1,
    )
    manufacturer: Optional[str] = Field(None, description="Name of Manufacturer")
    model: Optional[str] = Field(
        None, description="Name of the model of the device (provided by the manufacturer)"
    )
    serial_number: Optional[str] = Field(
        None, description="Serial number of the device (provided by the manufacturer)"
    )
    firmware_version: Optional[str] = Field(
        None,
        description="Version identifier of the firmware used in the device (provided by the manufacturer)",
    )
    instruction_processing_delay: Duration = Field(
        ...,
        description="The average time the combination of Resource Manager and HBES/BACS/SASS or (Smart) device needs to process and execute an instruction",
    )
    available_control_types: List[ControlType] = Field(
        ...,
        description="The control types supported by this Resource Manager.",
        max_length=5,
        min_length=1,
    )
    currency: Optional[Currency] = Field(
        None,
        description="Currency to be used for all information regarding costs. Mandatory if cost information is published.",
    )
    provides_forecast: bool = Field(
        ..., description="Indicates whether the ResourceManager is able to provide PowerForecasts"
    )
    provides_power_measurement_types: List[CommodityQuantity] = Field(
        ...,
        description="Array of all CommodityQuantities that this Resource Manager can provide measurements for. ",
        max_length=10,
        min_length=1,
    )


class PowerMeasurement(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PowerMeasurement"] = "PowerMeasurement"
    message_id: ID
    measurement_timestamp: AwareDatetime = Field(
        ..., description="Timestamp when PowerValues were measured."
    )
    values: List[PowerValue] = Field(
        ...,
        description="Array of measured PowerValues. Must contain at least one item and at most one item per ‘commodity_quantity’ (defined inside the PowerValue).",
        max_length=10,
        min_length=1,
    )


class PowerForecast(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PowerForecast"] = "PowerForecast"
    message_id: ID
    start_time: AwareDatetime = Field(
        ..., description="Start time of time period that is covered by the profile."
    )
    elements: List[PowerForecastElement] = Field(
        ...,
        description="Elements of which this forecast consists. Contains at least one element. Elements must be placed in chronological order.",
        max_length=288,
        min_length=1,
    )


class PEBCPowerConstraints(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PEBC.PowerConstraints"] = "PEBC.PowerConstraints"
    message_id: ID
    id: ID = Field(
        ...,
        description="Identifier of this PEBC.PowerConstraints. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    valid_from: AwareDatetime = Field(
        ..., description="Moment this PEBC.PowerConstraints start to be valid"
    )
    valid_until: Optional[AwareDatetime] = Field(
        None,
        description="Moment until this PEBC.PowerConstraints is valid. If valid_until is not present, there is no determined end time of this PEBC.PowerConstraints.",
    )
    consequence_type: PEBCPowerEnvelopeConsequenceType = Field(
        ..., description="Type of consequence of limiting power"
    )
    allowed_limit_ranges: List[PEBCAllowedLimitRange] = Field(
        ...,
        description="The actual constraints. There shall be at least one PEBC.AllowedLimitRange for the UPPER_LIMIT and at least one AllowedLimitRange for the LOWER_LIMIT. It is allowed to have multiple PEBC.AllowedLimitRange objects with identical CommodityQuantities and LimitTypes.",
        max_length=100,
        min_length=2,
    )


class PEBCInstruction(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PEBC.Instruction"] = "PEBC.Instruction"
    message_id: ID
    id: ID = Field(
        ...,
        description="Identifier of this PEBC.Instruction. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    execution_time: AwareDatetime = Field(
        ...,
        description="Indicates the moment the execution of the instruction shall start. When the specified execution time is in the past, execution must start as soon as possible.",
    )
    abnormal_condition: bool = Field(
        ..., description="Indicates if this is an instruction during an abnormal condition."
    )
    power_constraints_id: ID = Field(
        ...,
        description="Identifier of the PEBC.PowerConstraints this PEBC.Instruction was based on.",
    )
    power_envelopes: List[PEBCPowerEnvelope] = Field(
        ...,
        description="The PEBC.PowerEnvelope(s) that should be followed by the Resource Manager. There shall be at least one PEBC.PowerEnvelope, but at most one PEBC.PowerEnvelope for each CommodityQuantity.",
        max_length=10,
        min_length=1,
    )


class PPBCPowerProfileStatus(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PPBC.PowerProfileStatus"] = "PPBC.PowerProfileStatus"
    message_id: ID
    sequence_container_status: List[PPBCPowerSequenceContainerStatus] = Field(
        ...,
        description="Array with status information for all PPBC.PowerSequenceContainers in the PPBC.PowerProfileDefinition.",
        max_length=1000,
        min_length=1,
    )


class OMBCSystemDescription(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["OMBC.SystemDescription"] = "OMBC.SystemDescription"
    message_id: ID
    valid_from: AwareDatetime = Field(
        ...,
        description="Moment this OMBC.SystemDescription starts to be valid. If the system description is immediately valid, the DateTimeStamp should be now or in the past.",
    )
    operation_modes: List[OMBCOperationMode] = Field(
        ...,
        description="OMBC.OperationModes available for the CEM in order to coordinate the device behaviour.",
        max_length=100,
        min_length=1,
    )
    transitions: List[Transition] = Field(
        ...,
        description="Possible transitions to switch from one OMBC.OperationMode to another.",
        max_length=1000,
        min_length=0,
    )
    timers: List[Timer] = Field(
        ...,
        description="Timers that control when certain transitions can be made.",
        max_length=1000,
        min_length=0,
    )


class PPBCPowerSequence(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: ID = Field(
        ...,
        description="ID of the PPBC.PowerSequence. Must be unique in the scope of the PPBC.PowerSequnceContainer in which it is used.",
    )
    elements: List[PPBCPowerSequenceElement] = Field(
        ...,
        description="List of PPBC.PowerSequenceElements. Shall contain at least one element. Elements must be placed in chronological order.",
        max_length=288,
        min_length=1,
    )
    is_interruptible: bool = Field(
        ..., description="Indicates whether the option of pausing a sequence is available."
    )
    max_pause_before: Optional[Duration] = Field(
        None,
        description="The maximum duration for which a device can be paused between the end of the previous running sequence and the start of this one",
    )
    abnormal_condition_only: bool = Field(
        ...,
        description="Indicates if this PPBC.PowerSequence may only be used during an abnormal condition",
    )


class FRBCOperationMode(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: ID = Field(
        ...,
        description="ID of the FRBC.OperationMode. Must be unique in the scope of the FRBC.ActuatorDescription in which it is used.",
    )
    diagnostic_label: Optional[str] = Field(
        None,
        description="Human readable name/description of the FRBC.OperationMode. This element is only intended for diagnostic purposes and not for HMI applications.",
    )
    elements: List[FRBCOperationModeElement] = Field(
        ...,
        description="List of FRBC.OperationModeElements, which describe the properties of this FRBC.OperationMode depending on the fill_level. The fill_level_ranges of the items in the Array must be contiguous.",
        max_length=100,
        min_length=1,
    )
    abnormal_condition_only: bool = Field(
        ...,
        description="Indicates if this FRBC.OperationMode may only be used during an abnormal condition",
    )


class DDBCActuatorDescription(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: ID = Field(
        ...,
        description="ID of this DDBC.ActuatorDescription. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    diagnostic_label: Optional[str] = Field(
        None,
        description="Human readable name/description of the actuator. This element is only intended for diagnostic purposes and not for HMI applications.",
    )
    supported_commodites: List[Commodity] = Field(
        ...,
        description="Commodities supported by the operation modes of this actuator. There shall be at least one commodity",
        max_length=4,
        min_length=1,
    )
    operation_modes: List[DDBCOperationMode] = Field(
        ...,
        description="List of all Operation Modes that are available for this actuator. There shall be at least one DDBC.OperationMode.",
        max_length=100,
        min_length=1,
    )
    transitions: List[Transition] = Field(
        ...,
        description="List of Transitions between Operation Modes. Shall contain at least one Transition.",
        max_length=1000,
        min_length=0,
    )
    timers: List[Timer] = Field(
        ...,
        description="List of Timers associated with Transitions for this Actuator. Can be empty.",
        max_length=1000,
        min_length=0,
    )


class DDBCSystemDescription(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["DDBC.SystemDescription"] = "DDBC.SystemDescription"
    message_id: ID
    valid_from: AwareDatetime = Field(
        ...,
        description="Moment this DDBC.SystemDescription starts to be valid. If the system description is immediately valid, the DateTimeStamp should be now or in the past.",
    )
    actuators: List[DDBCActuatorDescription] = Field(
        ...,
        description="List of all available actuators in the system. Must contain at least one DDBC.ActuatorAggregated.",
        max_length=10,
        min_length=1,
    )
    present_demand_rate: NumberRange = Field(
        ..., description="Present demand rate that needs to be satisfied by the system"
    )
    provides_average_demand_rate_forecast: bool = Field(
        ...,
        description="Indicates whether the Resource Manager could provide a demand rate forecast through the DDBC.AverageDemandRateForecast.",
    )


class PPBCPowerSequenceContainer(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: ID = Field(
        ...,
        description="ID of the PPBC.PowerSequenceContainer. Must be unique in the scope of the PPBC.PowerProfileDefinition in which it is used.",
    )
    power_sequences: List[PPBCPowerSequence] = Field(
        ...,
        description="List of alternative Sequences where one could be chosen by the CEM",
        max_length=288,
        min_length=1,
    )


class FRBCActuatorDescription(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    id: ID = Field(
        ...,
        description="ID of the Actuator. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    diagnostic_label: Optional[str] = Field(
        None,
        description="Human readable name/description for the actuator. This element is only intended for diagnostic purposes and not for HMI applications.",
    )
    supported_commodities: List[Commodity] = Field(
        ..., description="List of all supported Commodities.", max_length=4, min_length=1
    )
    operation_modes: List[FRBCOperationMode] = Field(
        ...,
        description="Provided FRBC.OperationModes associated with this actuator",
        max_length=100,
        min_length=1,
    )
    transitions: List[Transition] = Field(
        ...,
        description="Possible transitions between FRBC.OperationModes associated with this actuator.",
        max_length=1000,
        min_length=0,
    )
    timers: List[Timer] = Field(
        ...,
        description="List of Timers associated with this actuator",
        max_length=1000,
        min_length=0,
    )


class PPBCPowerProfileDefinition(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["PPBC.PowerProfileDefinition"] = "PPBC.PowerProfileDefinition"
    message_id: ID
    id: ID = Field(
        ...,
        description="ID of the PPBC.PowerProfileDefinition. Must be unique in the scope of the Resource Manager, for at least the duration of the session between Resource Manager and CEM.",
    )
    start_time: AwareDatetime = Field(
        ...,
        description="Indicates the first possible time the first PPBC.PowerSequence could start",
    )
    end_time: AwareDatetime = Field(
        ...,
        description="Indicates when the last PPBC.PowerSequence shall be finished at the latest",
    )
    power_sequences_containers: List[PPBCPowerSequenceContainer] = Field(
        ...,
        description="The PPBC.PowerSequenceContainers that make up this PPBC.PowerProfileDefinition. There shall be at least one PPBC.PowerSequenceContainer that includes at least one PPBC.PowerSequence. PPBC.PowerSequenceContainers must be placed in chronological order.",
        max_length=1000,
        min_length=1,
    )


class FRBCSystemDescription(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    message_type: Literal["FRBC.SystemDescription"] = "FRBC.SystemDescription"
    message_id: ID
    valid_from: AwareDatetime = Field(
        ...,
        description="Moment this FRBC.SystemDescription starts to be valid. If the system description is immediately valid, the DateTimeStamp should be now or in the past.",
    )
    actuators: List[FRBCActuatorDescription] = Field(
        ..., description="Details of all Actuators.", max_length=10, min_length=1
    )
    storage: FRBCStorageDescription = Field(..., description="Details of the storage.")
