# ex: set ro:
# DO NOT EDIT.
# generated by smc (http://smc.sourceforge.net/)
# from file : client.sm

import satori.rtm.generated.statemap as statemap


class ClientState(statemap.State):

    def Entry(self, fsm):
        pass

    def Exit(self, fsm):
        pass

    def ChannelError(self, fsm, channel, payload):
        self.Default(fsm)

    def ConnectingComplete(self, fsm):
        self.Default(fsm)

    def ConnectingFailed(self, fsm):
        self.Default(fsm)

    def ConnectionClosed(self, fsm):
        self.Default(fsm)

    def Dispose(self, fsm):
        self.Default(fsm)

    def InternalError(self, fsm, payload):
        self.Default(fsm)

    def Start(self, fsm):
        self.Default(fsm)

    def Stop(self, fsm):
        self.Default(fsm)

    def Tick(self, fsm):
        self.Default(fsm)

    def Default(self, fsm):
        msg = "\n\tState: %s\n\tTransition: %s" % (
            fsm.getState().getName(), fsm.getTransition())
        raise statemap.TransitionUndefinedException(msg)

class S_Default(ClientState):
    pass

class S_Stopped(S_Default):

    def Entry(self, fsm):
        ctxt = fsm.getOwner()
        ctxt._forget_connection()
        ctxt._reset_fail_count()
        ctxt.on_enter_stopped()

    def Exit(self, fsm):
        ctxt = fsm.getOwner()
        ctxt.on_leave_stopped()

    def ConnectingComplete(self, fsm):
        # No actions.
        pass

    def ConnectingFailed(self, fsm):
        # No actions.
        pass

    def ConnectionClosed(self, fsm):
        # No actions.
        pass

    def Dispose(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Disposed)
        fsm.getState().Entry(fsm)

    def InternalError(self, fsm, payload):
        ctxt = fsm.getOwner()
        endState = fsm.getState()
        fsm.clearState()
        try:
            ctxt._on_internal_error(payload)
        finally:
            fsm.setState(endState)

    def Start(self, fsm):
        ctxt = fsm.getOwner()
        fsm.getState().Exit(fsm)
        fsm.clearState()
        try:
            ctxt._set_fail_count_to_critical()
        finally:
            fsm.setState(S.Connecting)
            fsm.getState().Entry(fsm)

    def Stop(self, fsm):
        # No actions.
        pass

    def Tick(self, fsm):
        # No actions.
        pass

class S_Connecting(S_Default):

    def Entry(self, fsm):
        ctxt = fsm.getOwner()
        ctxt._connect()
        ctxt.on_enter_connecting()

    def Exit(self, fsm):
        ctxt = fsm.getOwner()
        ctxt.on_leave_connecting()

    def ConnectingComplete(self, fsm):
        ctxt = fsm.getOwner()
        if ctxt._restore_auth_and_return_true_if_failed() :
            fsm.getState().Exit(fsm)
            fsm.clearState()
            try:
                ctxt._increment_fail_count()
            finally:
                fsm.setState(S.Awaiting)
                fsm.getState().Entry(fsm)
        else:
            fsm.getState().Exit(fsm)
            fsm.clearState()
            try:
                ctxt._connect_subscriptions()
                ctxt._reset_fail_count()
            finally:
                fsm.setState(S.Connected)
                fsm.getState().Entry(fsm)


    def ConnectingFailed(self, fsm):
        ctxt = fsm.getOwner()
        if ctxt._fail_count_is_small() :
            fsm.getState().Exit(fsm)
            fsm.clearState()
            try:
                ctxt._increment_fail_count()
            finally:
                fsm.setState(S.Awaiting)
                fsm.getState().Entry(fsm)
        else:
            fsm.getState().Exit(fsm)
            # No actions.
            pass
            fsm.setState(S.Stopped)
            fsm.getState().Entry(fsm)


    def ConnectionClosed(self, fsm):
        # No actions.
        pass

    def Dispose(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Disposed)
        fsm.getState().Entry(fsm)

    def InternalError(self, fsm, payload):
        ctxt = fsm.getOwner()
        if ctxt._fail_count_is_small() :
            fsm.getState().Exit(fsm)
            fsm.clearState()
            try:
                ctxt._on_internal_error(payload)
                ctxt._increment_fail_count()
            finally:
                fsm.setState(S.Awaiting)
                fsm.getState().Entry(fsm)
        else:
            fsm.getState().Exit(fsm)
            fsm.clearState()
            try:
                ctxt._on_internal_error(payload)
            finally:
                fsm.setState(S.Stopped)
                fsm.getState().Entry(fsm)


    def Start(self, fsm):
        # No actions.
        pass

    def Stop(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Stopped)
        fsm.getState().Entry(fsm)

    def Tick(self, fsm):
        # No actions.
        pass

class S_Connected(S_Default):

    def Entry(self, fsm):
        ctxt = fsm.getOwner()
        ctxt._drain_offline_queue()
        ctxt.on_enter_connected()

    def Exit(self, fsm):
        ctxt = fsm.getOwner()
        ctxt.on_leave_connected()

    def ChannelError(self, fsm, channel, payload):
        ctxt = fsm.getOwner()
        endState = fsm.getState()
        fsm.clearState()
        try:
            ctxt._on_subscription_error(channel, payload)
        finally:
            fsm.setState(endState)

    def ConnectingComplete(self, fsm):
        # No actions.
        pass

    def ConnectingFailed(self, fsm):
        # No actions.
        pass

    def ConnectionClosed(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Awaiting)
        fsm.getState().Entry(fsm)

    def Dispose(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Disposed)
        fsm.getState().Entry(fsm)

    def InternalError(self, fsm, payload):
        ctxt = fsm.getOwner()
        fsm.getState().Exit(fsm)
        fsm.clearState()
        try:
            ctxt._on_internal_error(payload)
        finally:
            fsm.setState(S.Awaiting)
            fsm.getState().Entry(fsm)

    def Start(self, fsm):
        # No actions.
        pass

    def Stop(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Stopping)
        fsm.getState().Entry(fsm)

    def Tick(self, fsm):
        # No actions.
        pass

class S_Stopping(S_Default):

    def Entry(self, fsm):
        ctxt = fsm.getOwner()
        ctxt._start_disconnecting()
        ctxt.on_enter_stopping()

    def Exit(self, fsm):
        ctxt = fsm.getOwner()
        ctxt.on_leave_stopping()

    def ConnectingComplete(self, fsm):
        # No actions.
        pass

    def ConnectingFailed(self, fsm):
        # No actions.
        pass

    def ConnectionClosed(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Stopped)
        fsm.getState().Entry(fsm)

    def Dispose(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Disposed)
        fsm.getState().Entry(fsm)

    def InternalError(self, fsm, payload):
        ctxt = fsm.getOwner()
        fsm.getState().Exit(fsm)
        fsm.clearState()
        try:
            ctxt._on_internal_error(payload)
        finally:
            fsm.setState(S.Stopped)
            fsm.getState().Entry(fsm)

    def Start(self, fsm):
        ctxt = fsm.getOwner()
        fsm.getState().Exit(fsm)
        fsm.clearState()
        try:
            ctxt._forget_connection()
        finally:
            fsm.setState(S.Connecting)
            fsm.getState().Entry(fsm)

    def Stop(self, fsm):
        # No actions.
        pass

    def Tick(self, fsm):
        # No actions.
        pass

class S_Awaiting(S_Default):

    def Entry(self, fsm):
        ctxt = fsm.getOwner()
        ctxt._forget_connection()
        ctxt._schedule_reconnect()
        ctxt.on_enter_awaiting()

    def Exit(self, fsm):
        ctxt = fsm.getOwner()
        ctxt._cancel_reconnect()
        ctxt.on_leave_awaiting()

    def ConnectingComplete(self, fsm):
        # No actions.
        pass

    def ConnectingFailed(self, fsm):
        # No actions.
        pass

    def ConnectionClosed(self, fsm):
        # No actions.
        pass

    def Dispose(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Disposed)
        fsm.getState().Entry(fsm)

    def InternalError(self, fsm, payload):
        ctxt = fsm.getOwner()
        endState = fsm.getState()
        fsm.clearState()
        try:
            ctxt._on_internal_error(payload)
        finally:
            fsm.setState(endState)

    def Start(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Connecting)
        fsm.getState().Entry(fsm)

    def Stop(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Stopped)
        fsm.getState().Entry(fsm)

    def Tick(self, fsm):
        fsm.getState().Exit(fsm)
        fsm.setState(S.Connecting)
        fsm.getState().Entry(fsm)

class S_Disposed(S_Default):

    def Entry(self, fsm):
        ctxt = fsm.getOwner()
        ctxt._forget_connection()
        ctxt.on_enter_disposed()

    def ConnectingComplete(self, fsm):
        # No actions.
        pass

    def ConnectingFailed(self, fsm):
        # No actions.
        pass

    def ConnectionClosed(self, fsm):
        # No actions.
        pass

    def Dispose(self, fsm):
        # No actions.
        pass

    def InternalError(self, fsm, payload):
        ctxt = fsm.getOwner()
        endState = fsm.getState()
        fsm.clearState()
        try:
            ctxt._on_internal_error(payload)
        finally:
            fsm.setState(endState)

    def Start(self, fsm):
        # No actions.
        pass

    def Stop(self, fsm):
        # No actions.
        pass

    def Tick(self, fsm):
        # No actions.
        pass

class S(object):

    Stopped = S_Stopped('S.Stopped', 0)
    Connecting = S_Connecting('S.Connecting', 1)
    Connected = S_Connected('S.Connected', 2)
    Stopping = S_Stopping('S.Stopping', 3)
    Awaiting = S_Awaiting('S.Awaiting', 4)
    Disposed = S_Disposed('S.Disposed', 5)
    Default = S_Default('S.Default', -1)

class Client_sm(statemap.FSMContext):

    def __init__(self, owner):
        statemap.FSMContext.__init__(self, S.Stopped)
        self._owner = owner

    def __getattr__(self, attrib):
        def trans_sm(*arglist):
            self._transition = attrib
            getattr(self.getState(), attrib)(self, *arglist)
            self._transition = None
        return trans_sm

    def enterStartState(self):
        self._state.Entry(self)

    def getOwner(self):
        return self._owner

# Local variables:
#  buffer-read-only: t
# End:
