# coding: utf-8

"""
    Satstream API

    Satstream API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: team@satstream.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from satstream_python_sdk.api_client import ApiClient


class RunesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_runes_holders(self, rune_id, **kwargs):  # noqa: E501
        """Get rune holders  # noqa: E501

        Get a list of addresses holding a specific rune  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_runes_holders(rune_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rune_id: Rune ID (required)
        :return: ResponsesGetRuneHolders
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_runes_holders_with_http_info(rune_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_runes_holders_with_http_info(rune_id, **kwargs)  # noqa: E501
            return data

    def get_runes_holders_with_http_info(self, rune_id, **kwargs):  # noqa: E501
        """Get rune holders  # noqa: E501

        Get a list of addresses holding a specific rune  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_runes_holders_with_http_info(rune_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rune_id: Rune ID (required)
        :return: ResponsesGetRuneHolders
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rune_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_runes_holders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rune_id' is set
        if ('rune_id' not in params or
                params['rune_id'] is None):
            raise ValueError("Missing the required parameter `rune_id` when calling `get_runes_holders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rune_id' in params:
            path_params['runeId'] = params['rune_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/runes/{runeId}/holders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetRuneHolders',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_runes_info(self, rune_id, **kwargs):  # noqa: E501
        """Get rune info  # noqa: E501

        Get detailed information about a specific rune  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_runes_info(rune_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rune_id: Rune ID (required)
        :return: ResponsesGetRuneInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_runes_info_with_http_info(rune_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_runes_info_with_http_info(rune_id, **kwargs)  # noqa: E501
            return data

    def get_runes_info_with_http_info(self, rune_id, **kwargs):  # noqa: E501
        """Get rune info  # noqa: E501

        Get detailed information about a specific rune  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_runes_info_with_http_info(rune_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rune_id: Rune ID (required)
        :return: ResponsesGetRuneInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rune_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_runes_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rune_id' is set
        if ('rune_id' not in params or
                params['rune_id'] is None):
            raise ValueError("Missing the required parameter `rune_id` when calling `get_runes_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rune_id' in params:
            path_params['runeId'] = params['rune_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/runes/{runeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetRuneInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_runes_info_list(self, **kwargs):  # noqa: E501
        """Get runes info list  # noqa: E501

        Get information about all runes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_runes_info_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number (default: 1)
        :param int per_page: Items per page (default: 10)
        :return: ResponsesGetRunesInfoList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_runes_info_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_runes_info_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_runes_info_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get runes info list  # noqa: E501

        Get information about all runes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_runes_info_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number (default: 1)
        :param int per_page: Items per page (default: 10)
        :return: ResponsesGetRunesInfoList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_runes_info_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/runes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetRunesInfoList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
