# satstream_python_sdk
Satstream API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 1.0.19
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
For more information, please visit [https://satstream.io](https://satstream.io)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import satstream_python_sdk 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import satstream_python_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import satstream_python_sdk
from satstream_python_sdk.rest import ApiException
from pprint import pprint

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsAnalyzePSBTRequest() # RequestsAnalyzePSBTRequest | PSBT to analyze

try:
    # Analyze PSBT
    api_response = api_instance.analyze_psbt(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->analyze_psbt: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsCombinePSBTRequest() # RequestsCombinePSBTRequest | Array of PSBTs to combine

try:
    # Combine PSBTs
    api_response = api_instance.combine_psbt(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->combine_psbt: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsCombineRawTransactionRequest() # RequestsCombineRawTransactionRequest | Array of hex-encoded raw transactions

try:
    # Combine Raw Transactions
    api_response = api_instance.combine_raw_transaction(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->combine_raw_transaction: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsConvertToPSBTRequest() # RequestsConvertToPSBTRequest | Raw transaction conversion parameters

try:
    # Convert Raw Transaction to PSBT
    api_response = api_instance.convert_to_psbt(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->convert_to_psbt: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTRequest() # GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTRequest | Transaction parameters

try:
    # Create PSBT
    api_response = api_instance.create_psbt(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->create_psbt: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTRequest() # GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTRequest | Transaction parameters

try:
    # Create Raw Transaction
    api_response = api_instance.create_raw_transaction(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->create_raw_transaction: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsAnalyzePSBTRequest() # RequestsAnalyzePSBTRequest | PSBT to decode

try:
    # Decode PSBT
    api_response = api_instance.decode_psbt(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->decode_psbt: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsDecodeScriptRequest() # RequestsDecodeScriptRequest | Script to decode

try:
    # Decode Script
    api_response = api_instance.decode_script(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->decode_script: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsEstimateRawFeeRequest() # RequestsEstimateRawFeeRequest | Fee estimation parameters

try:
    # Estimate Raw Fee
    api_response = api_instance.estimate_raw_fee(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->estimate_raw_fee: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsEstimateSmartFeeRequest() # RequestsEstimateSmartFeeRequest | Fee estimation parameters

try:
    # Estimate smart fee
    api_response = api_instance.estimate_smart_fee(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->estimate_smart_fee: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
hash = 'hash_example' # str | Block hash

try:
    # Get block by hash (verbosity 2)
    api_response = api_instance.get_block_by_hash_decoded(hash)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_by_hash_decoded: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
hash = 'hash_example' # str | Block hash

try:
    # Get block by hash (verbosity 0)
    api_response = api_instance.get_block_by_hash_hex(hash)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_by_hash_hex: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
hash = 'hash_example' # str | Block hash

try:
    # Get block by hash (verbosity 3)
    api_response = api_instance.get_block_by_hash_prevout(hash)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_by_hash_prevout: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
hash = 'hash_example' # str | Block hash

try:
    # Get block by hash (verbosity 1)
    api_response = api_instance.get_block_by_hash_summary(hash)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_by_hash_summary: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
height = 56 # int | Block height

try:
    # Get block by height (verbosity 2)
    api_response = api_instance.get_block_by_height_decoded(height)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_by_height_decoded: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
height = 56 # int | Block height

try:
    # Get block by height (verbosity 0)
    api_response = api_instance.get_block_by_height_hex(height)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_by_height_hex: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
height = 56 # int | Block height

try:
    # Get block by height (verbosity 3)
    api_response = api_instance.get_block_by_height_prevout(height)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_by_height_prevout: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
height = 56 # int | Block height

try:
    # Get block by height (verbosity 1)
    api_response = api_instance.get_block_by_height_summary(height)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_by_height_summary: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetBlockStatsRequest() # RequestsGetBlockStatsRequest | Block stats request parameters

try:
    # Get block stats
    api_response = api_instance.get_block_stats(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_block_stats: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))

try:
    # Get blockchain information
    api_response = api_instance.get_blockchain_info()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_blockchain_info: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetChainTxStatsRequest() # RequestsGetChainTxStatsRequest | Chain tx stats request parameters

try:
    # Get chain tx stats
    api_response = api_instance.get_chain_tx_stats(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_chain_tx_stats: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))

try:
    # Get difficulty
    api_response = api_instance.get_difficulty()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_difficulty: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetMempoolAncestorsRequest() # RequestsGetMempoolAncestorsRequest | Mempool ancestors request parameters

try:
    # Get mempool ancestors
    api_response = api_instance.get_mempool_ancestors(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_mempool_ancestors: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetMempoolDescendantsRequest() # RequestsGetMempoolDescendantsRequest | Mempool descendants request parameters

try:
    # Get mempool descendants
    api_response = api_instance.get_mempool_descendants(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_mempool_descendants: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))

try:
    # Get mempool information
    api_response = api_instance.get_mempool_info()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_mempool_info: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))

try:
    # Get mining information
    api_response = api_instance.get_mining_info()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_mining_info: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetNetworkHashPSRequest() # RequestsGetNetworkHashPSRequest | Network hash rate parameters

try:
    # Get network hash per second
    api_response = api_instance.get_network_hashps(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_network_hashps: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetRawMempoolRequest() # RequestsGetRawMempoolRequest | Raw mempool request parameters

try:
    # Get raw mempool
    api_response = api_instance.get_raw_mempool(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_raw_mempool: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
txid = 'txid_example' # str | Transaction ID

try:
    # Get raw transaction (verbosity 1)
    api_response = api_instance.get_raw_transaction_decoded(txid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_raw_transaction_decoded: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
txid = 'txid_example' # str | Transaction ID

try:
    # Get raw transaction (verbosity 0)
    api_response = api_instance.get_raw_transaction_hex(txid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_raw_transaction_hex: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
txid = 'txid_example' # str | Transaction ID

try:
    # Get raw transaction (verbosity 2)
    api_response = api_instance.get_raw_transaction_prevout(txid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_raw_transaction_prevout: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetTxOutRequest() # RequestsGetTxOutRequest | Transaction output request parameters

try:
    # Get transaction output
    api_response = api_instance.get_tx_out(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_tx_out: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetTxOutProofRequest() # RequestsGetTxOutProofRequest | Transaction proof request parameters

try:
    # Get transaction output proof
    api_response = api_instance.get_tx_out_proof(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_tx_out_proof: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetTxOutSetInfoRequest() # RequestsGetTxOutSetInfoRequest | UTXO set info request parameters

try:
    # Get transaction output set information
    api_response = api_instance.get_tx_out_set_info(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_tx_out_set_info: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsGetTxSpendingPrevoutRequest() # RequestsGetTxSpendingPrevoutRequest | Transaction spending prevout request

try:
    # Get transaction spending prevout
    api_response = api_instance.get_tx_spending_prevout(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->get_tx_spending_prevout: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsJoinPSBTsRequest() # RequestsJoinPSBTsRequest | PSBTs to join

try:
    # Join PSBTs
    api_response = api_instance.join_psbts(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->join_psbts: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsSendRawTransactionRequest() # RequestsSendRawTransactionRequest | Raw transaction to send

try:
    # Send raw transaction
    api_response = api_instance.send_raw_transaction(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->send_raw_transaction: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsTestMempoolAcceptRequest() # RequestsTestMempoolAcceptRequest | Raw transactions to test

try:
    # Test mempool accept
    api_response = api_instance.test_mempool_accept(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->test_mempool_accept: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
address = 'address_example' # str | Bitcoin address to validate

try:
    # Validate address
    api_response = api_instance.validate_address(address)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->validate_address: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsVerifyMessageRequest() # RequestsVerifyMessageRequest | Message verification parameters

try:
    # Verify message
    api_response = api_instance.verify_message(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->verify_message: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = satstream_python_sdk.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = satstream_python_sdk.BitcoinApi(satstream_python_sdk.ApiClient(configuration))
body = satstream_python_sdk.RequestsVerifyTxOutProofRequest() # RequestsVerifyTxOutProofRequest | Proof to verify

try:
    # Verify transaction output proof
    api_response = api_instance.verify_tx_out_proof(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BitcoinApi->verify_tx_out_proof: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.satstream.io/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BitcoinApi* | [**analyze_psbt**](docs/BitcoinApi.md#analyze_psbt) | **POST** /psbt/analyze | Analyze PSBT
*BitcoinApi* | [**combine_psbt**](docs/BitcoinApi.md#combine_psbt) | **POST** /psbt/combine | Combine PSBTs
*BitcoinApi* | [**combine_raw_transaction**](docs/BitcoinApi.md#combine_raw_transaction) | **POST** /tx/combine | Combine Raw Transactions
*BitcoinApi* | [**convert_to_psbt**](docs/BitcoinApi.md#convert_to_psbt) | **POST** /tx/convert-to-psbt | Convert Raw Transaction to PSBT
*BitcoinApi* | [**create_psbt**](docs/BitcoinApi.md#create_psbt) | **POST** /psbt/create | Create PSBT
*BitcoinApi* | [**create_raw_transaction**](docs/BitcoinApi.md#create_raw_transaction) | **POST** /tx/create | Create Raw Transaction
*BitcoinApi* | [**decode_psbt**](docs/BitcoinApi.md#decode_psbt) | **POST** /psbt/decode | Decode PSBT
*BitcoinApi* | [**decode_script**](docs/BitcoinApi.md#decode_script) | **POST** /script/decode | Decode Script
*BitcoinApi* | [**estimate_raw_fee**](docs/BitcoinApi.md#estimate_raw_fee) | **POST** /fee/estimate-raw | Estimate Raw Fee
*BitcoinApi* | [**estimate_smart_fee**](docs/BitcoinApi.md#estimate_smart_fee) | **POST** /fee/estimate-smart | Estimate smart fee
*BitcoinApi* | [**get_block_by_hash_decoded**](docs/BitcoinApi.md#get_block_by_hash_decoded) | **GET** /block/hash/{hash}/decoded | Get block by hash (verbosity 2)
*BitcoinApi* | [**get_block_by_hash_hex**](docs/BitcoinApi.md#get_block_by_hash_hex) | **GET** /block/hash/{hash}/hex | Get block by hash (verbosity 0)
*BitcoinApi* | [**get_block_by_hash_prevout**](docs/BitcoinApi.md#get_block_by_hash_prevout) | **GET** /block/hash/{hash}/prevout | Get block by hash (verbosity 3)
*BitcoinApi* | [**get_block_by_hash_summary**](docs/BitcoinApi.md#get_block_by_hash_summary) | **GET** /block/hash/{hash}/summary | Get block by hash (verbosity 1)
*BitcoinApi* | [**get_block_by_height_decoded**](docs/BitcoinApi.md#get_block_by_height_decoded) | **GET** /block/height/{height}/decoded | Get block by height (verbosity 2)
*BitcoinApi* | [**get_block_by_height_hex**](docs/BitcoinApi.md#get_block_by_height_hex) | **GET** /block/height/{height}/hex | Get block by height (verbosity 0)
*BitcoinApi* | [**get_block_by_height_prevout**](docs/BitcoinApi.md#get_block_by_height_prevout) | **GET** /block/height/{height}/prevout | Get block by height (verbosity 3)
*BitcoinApi* | [**get_block_by_height_summary**](docs/BitcoinApi.md#get_block_by_height_summary) | **GET** /block/height/{height}/summary | Get block by height (verbosity 1)
*BitcoinApi* | [**get_block_stats**](docs/BitcoinApi.md#get_block_stats) | **POST** /block/stats | Get block stats
*BitcoinApi* | [**get_blockchain_info**](docs/BitcoinApi.md#get_blockchain_info) | **GET** /blockchain/info | Get blockchain information
*BitcoinApi* | [**get_chain_tx_stats**](docs/BitcoinApi.md#get_chain_tx_stats) | **POST** /chain/txstats | Get chain tx stats
*BitcoinApi* | [**get_difficulty**](docs/BitcoinApi.md#get_difficulty) | **GET** /difficulty | Get difficulty
*BitcoinApi* | [**get_mempool_ancestors**](docs/BitcoinApi.md#get_mempool_ancestors) | **POST** /mempool/ancestors | Get mempool ancestors
*BitcoinApi* | [**get_mempool_descendants**](docs/BitcoinApi.md#get_mempool_descendants) | **POST** /mempool/descendants | Get mempool descendants
*BitcoinApi* | [**get_mempool_info**](docs/BitcoinApi.md#get_mempool_info) | **GET** /mempool/info | Get mempool information
*BitcoinApi* | [**get_mining_info**](docs/BitcoinApi.md#get_mining_info) | **GET** /mining/info | Get mining information
*BitcoinApi* | [**get_network_hashps**](docs/BitcoinApi.md#get_network_hashps) | **POST** /network/hashps | Get network hash per second
*BitcoinApi* | [**get_raw_mempool**](docs/BitcoinApi.md#get_raw_mempool) | **POST** /mempool/raw | Get raw mempool
*BitcoinApi* | [**get_raw_transaction_decoded**](docs/BitcoinApi.md#get_raw_transaction_decoded) | **GET** /tx/{txid}/decoded | Get raw transaction (verbosity 1)
*BitcoinApi* | [**get_raw_transaction_hex**](docs/BitcoinApi.md#get_raw_transaction_hex) | **GET** /tx/{txid}/hex | Get raw transaction (verbosity 0)
*BitcoinApi* | [**get_raw_transaction_prevout**](docs/BitcoinApi.md#get_raw_transaction_prevout) | **GET** /tx/{txid}/prevout | Get raw transaction (verbosity 2)
*BitcoinApi* | [**get_tx_out**](docs/BitcoinApi.md#get_tx_out) | **POST** /tx/out | Get transaction output
*BitcoinApi* | [**get_tx_out_proof**](docs/BitcoinApi.md#get_tx_out_proof) | **POST** /tx/out/proof | Get transaction output proof
*BitcoinApi* | [**get_tx_out_set_info**](docs/BitcoinApi.md#get_tx_out_set_info) | **POST** /tx/out/set/info | Get transaction output set information
*BitcoinApi* | [**get_tx_spending_prevout**](docs/BitcoinApi.md#get_tx_spending_prevout) | **POST** /tx/spending/prevout | Get transaction spending prevout
*BitcoinApi* | [**join_psbts**](docs/BitcoinApi.md#join_psbts) | **POST** /psbt/join | Join PSBTs
*BitcoinApi* | [**send_raw_transaction**](docs/BitcoinApi.md#send_raw_transaction) | **POST** /tx/send | Send raw transaction
*BitcoinApi* | [**test_mempool_accept**](docs/BitcoinApi.md#test_mempool_accept) | **POST** /mempool/test-accept | Test mempool accept
*BitcoinApi* | [**validate_address**](docs/BitcoinApi.md#validate_address) | **GET** /address/{address}/validate | Validate address
*BitcoinApi* | [**verify_message**](docs/BitcoinApi.md#verify_message) | **POST** /address/verify-message | Verify message
*BitcoinApi* | [**verify_tx_out_proof**](docs/BitcoinApi.md#verify_tx_out_proof) | **POST** /tx/out/proof/verify | Verify transaction output proof
*BlocksApi* | [**get_block_by_hash**](docs/BlocksApi.md#get_block_by_hash) | **GET** /block/hash/{block_hash} | Get block info by hash
*InscriptionsApi* | [**decode_tx**](docs/InscriptionsApi.md#decode_tx) | **GET** /decode/{txid} | Decode a transaction
*InscriptionsApi* | [**fetch_inscription_child**](docs/InscriptionsApi.md#fetch_inscription_child) | **GET** /inscription/{inscription_id}/child/{child_index} | Get inscription child info
*InscriptionsApi* | [**fetch_inscriptions**](docs/InscriptionsApi.md#fetch_inscriptions) | **POST** /inscriptions | Fetch multiple inscriptions
*InscriptionsApi* | [**get_address**](docs/InscriptionsApi.md#get_address) | **GET** /address/{address} | Get address info
*InscriptionsApi* | [**get_address_utxos**](docs/InscriptionsApi.md#get_address_utxos) | **GET** /address/{address}/outputs | Get UTXOs for an address
*InscriptionsApi* | [**get_block_by_height**](docs/InscriptionsApi.md#get_block_by_height) | **GET** /block/height/{block_height} | Get block info by height
*InscriptionsApi* | [**get_block_count**](docs/InscriptionsApi.md#get_block_count) | **GET** /blockcount | Get the height of the latest block
*InscriptionsApi* | [**get_block_hash_by_height**](docs/InscriptionsApi.md#get_block_hash_by_height) | **GET** /blockhash/{block_height} | Returns blockhash of specified block.
*InscriptionsApi* | [**get_block_inscriptions**](docs/InscriptionsApi.md#get_block_inscriptions) | **GET** /inscriptions/block/{block_height} | Get inscriptions in a specific block
*InscriptionsApi* | [**get_blocks**](docs/InscriptionsApi.md#get_blocks) | **GET** /blocks | Returns the latest block height, last 100 block hashes, and featured inscriptions
*InscriptionsApi* | [**get_inscription**](docs/InscriptionsApi.md#get_inscription) | **GET** /inscription/{inscription_id} | Get inscription info
*InscriptionsApi* | [**get_latest_block_height**](docs/InscriptionsApi.md#get_latest_block_height) | **GET** /latestblockheight | Returns the height of the latest block.
*InscriptionsApi* | [**get_latest_blockhash**](docs/InscriptionsApi.md#get_latest_blockhash) | **GET** /latestblockhash | Returns blockhash for the latest block.
*InscriptionsApi* | [**get_latest_blocktime**](docs/InscriptionsApi.md#get_latest_blocktime) | **GET** /blocktime | Get the timestamp of the latest block
*InscriptionsApi* | [**get_latest_inscriptions**](docs/InscriptionsApi.md#get_latest_inscriptions) | **GET** /inscriptions/latest | Get latest inscriptions
*InscriptionsApi* | [**get_latest_inscriptions_page**](docs/InscriptionsApi.md#get_latest_inscriptions_page) | **GET** /inscriptions/page/{page} | Get latest inscriptions page
*InscriptionsApi* | [**get_latest_runes**](docs/InscriptionsApi.md#get_latest_runes) | **GET** /runes/latest | Get latest runes
*InscriptionsApi* | [**get_latest_runes_page**](docs/InscriptionsApi.md#get_latest_runes_page) | **GET** /runes/page/{page} | Get latest runes page
*InscriptionsApi* | [**get_output_by_outpoint**](docs/InscriptionsApi.md#get_output_by_outpoint) | **GET** /output/outpoint/{outpoint} | Get output info by outpoint
*InscriptionsApi* | [**get_outputs**](docs/InscriptionsApi.md#get_outputs) | **POST** /outputs | Get multiple outputs
*InscriptionsApi* | [**get_rune**](docs/InscriptionsApi.md#get_rune) | **GET** /rune/{rune_name} | Get rune info
*InscriptionsApi* | [**get_satoshi**](docs/InscriptionsApi.md#get_satoshi) | **GET** /sat/{number} | Get satoshi info
*InscriptionsApi* | [**get_status**](docs/InscriptionsApi.md#get_status) | **GET** /status | Get server status
*InscriptionsApi* | [**get_transaction**](docs/InscriptionsApi.md#get_transaction) | **GET** /tx/{txid} | Get transaction info

## Documentation For Models

 - [AllOfgithubComSatstreamSsUtilsBitcoinCliBlockVin2ScriptSig](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliBlockVin2ScriptSig.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliBlockVin3Prevout](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliBlockVin3Prevout.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputFinalScriptsig](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputFinalScriptsig.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputNonWitnessUtxo](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputNonWitnessUtxo.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputRedeemScript](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputRedeemScript.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputWitnessScript](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputWitnessScript.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputWitnessUtxo](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInputWitnessUtxo.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTOutputRedeemScript](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTOutputRedeemScript.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTOutputWitnessScript](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTOutputWitnessScript.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTTx](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedPSBTTx.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedScriptSegwit](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliDecodedScriptSegwit.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliEstimateRawFeeLong](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliEstimateRawFeeLong.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliEstimateRawFeeMedium](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliEstimateRawFeeMedium.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliEstimateRawFeeShort](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliEstimateRawFeeShort.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliFeeHorizonEstimateFail](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliFeeHorizonEstimateFail.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliFeeHorizonEstimatePass](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliFeeHorizonEstimatePass.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliPSBTWitnessUtxoScriptPubKey](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliPSBTWitnessUtxoScriptPubKey.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliTestMempoolAcceptResultFees](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliTestMempoolAcceptResultFees.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliTxOutScriptPubKey](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliTxOutScriptPubKey.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliUTXOBlockInfoUnspendables](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliUTXOBlockInfoUnspendables.md)
 - [AllOfgithubComSatstreamSsUtilsBitcoinCliUTXOSetInfoBlockInfo](docs/AllOfgithubComSatstreamSsUtilsBitcoinCliUTXOSetInfoBlockInfo.md)
 - [AllOfgithubComSatstreamSsUtilsOrdServerResponsesRuneListEntry1](docs/AllOfgithubComSatstreamSsUtilsOrdServerResponsesRuneListEntry1.md)
 - [AllOfresponsesDecodePSBTResponseData](docs/AllOfresponsesDecodePSBTResponseData.md)
 - [AllOfresponsesDecodeScriptResponseData](docs/AllOfresponsesDecodeScriptResponseData.md)
 - [AllOfresponsesEstimateRawFeeResponseData](docs/AllOfresponsesEstimateRawFeeResponseData.md)
 - [AllOfresponsesEstimateSmartFeeResponseData](docs/AllOfresponsesEstimateSmartFeeResponseData.md)
 - [AllOfresponsesGetBlockStatsResponseData](docs/AllOfresponsesGetBlockStatsResponseData.md)
 - [AllOfresponsesGetBlockchainInfoResponseData](docs/AllOfresponsesGetBlockchainInfoResponseData.md)
 - [AllOfresponsesGetChainTxStatsResponseData](docs/AllOfresponsesGetChainTxStatsResponseData.md)
 - [AllOfresponsesGetMempoolInfoResponseData](docs/AllOfresponsesGetMempoolInfoResponseData.md)
 - [AllOfresponsesGetMiningInfoResponseData](docs/AllOfresponsesGetMiningInfoResponseData.md)
 - [AllOfresponsesGetTxOutResponseData](docs/AllOfresponsesGetTxOutResponseData.md)
 - [AllOfresponsesGetTxOutSetInfoResponseData](docs/AllOfresponsesGetTxOutSetInfoResponseData.md)
 - [AllOfresponsesValidateAddressResponseData](docs/AllOfresponsesValidateAddressResponseData.md)
 - [GithubComSatstreamSsApiServerApiAddressResponsesAddressResponse](docs/GithubComSatstreamSsApiServerApiAddressResponsesAddressResponse.md)
 - [GithubComSatstreamSsApiServerApiAddressResponsesError](docs/GithubComSatstreamSsApiServerApiAddressResponsesError.md)
 - [GithubComSatstreamSsApiServerApiAddressResponsesOutputResponse](docs/GithubComSatstreamSsApiServerApiAddressResponsesOutputResponse.md)
 - [GithubComSatstreamSsApiServerApiBlockResponsesBlockCountResponse](docs/GithubComSatstreamSsApiServerApiBlockResponsesBlockCountResponse.md)
 - [GithubComSatstreamSsApiServerApiBlockResponsesBlockHashResponse](docs/GithubComSatstreamSsApiServerApiBlockResponsesBlockHashResponse.md)
 - [GithubComSatstreamSsApiServerApiBlockResponsesBlockResponse](docs/GithubComSatstreamSsApiServerApiBlockResponsesBlockResponse.md)
 - [GithubComSatstreamSsApiServerApiBlockResponsesBlocksResponse](docs/GithubComSatstreamSsApiServerApiBlockResponsesBlocksResponse.md)
 - [GithubComSatstreamSsApiServerApiBlockResponsesError](docs/GithubComSatstreamSsApiServerApiBlockResponsesError.md)
 - [GithubComSatstreamSsApiServerApiFeeResponsesError](docs/GithubComSatstreamSsApiServerApiFeeResponsesError.md)
 - [GithubComSatstreamSsApiServerApiInscriptionResponsesError](docs/GithubComSatstreamSsApiServerApiInscriptionResponsesError.md)
 - [GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse](docs/GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse.md)
 - [GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse](docs/GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse.md)
 - [GithubComSatstreamSsApiServerApiMempoolResponsesError](docs/GithubComSatstreamSsApiServerApiMempoolResponsesError.md)
 - [GithubComSatstreamSsApiServerApiMiningResponsesError](docs/GithubComSatstreamSsApiServerApiMiningResponsesError.md)
 - [GithubComSatstreamSsApiServerApiNetworkResponsesError](docs/GithubComSatstreamSsApiServerApiNetworkResponsesError.md)
 - [GithubComSatstreamSsApiServerApiOutputResponsesError](docs/GithubComSatstreamSsApiServerApiOutputResponsesError.md)
 - [GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTInput](docs/GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTInput.md)
 - [GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTOutput](docs/GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTOutput.md)
 - [GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTRequest](docs/GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTRequest.md)
 - [GithubComSatstreamSsApiServerApiPsbtResponsesError](docs/GithubComSatstreamSsApiServerApiPsbtResponsesError.md)
 - [GithubComSatstreamSsApiServerApiRuneResponsesError](docs/GithubComSatstreamSsApiServerApiRuneResponsesError.md)
 - [GithubComSatstreamSsApiServerApiRuneResponsesRuneResponse](docs/GithubComSatstreamSsApiServerApiRuneResponsesRuneResponse.md)
 - [GithubComSatstreamSsApiServerApiRuneResponsesRunesListResponse](docs/GithubComSatstreamSsApiServerApiRuneResponsesRunesListResponse.md)
 - [GithubComSatstreamSsApiServerApiSatoshiResponsesError](docs/GithubComSatstreamSsApiServerApiSatoshiResponsesError.md)
 - [GithubComSatstreamSsApiServerApiSatoshiResponsesSatoshiResponse](docs/GithubComSatstreamSsApiServerApiSatoshiResponsesSatoshiResponse.md)
 - [GithubComSatstreamSsApiServerApiScriptResponsesError](docs/GithubComSatstreamSsApiServerApiScriptResponsesError.md)
 - [GithubComSatstreamSsApiServerApiStatusResponsesError](docs/GithubComSatstreamSsApiServerApiStatusResponsesError.md)
 - [GithubComSatstreamSsApiServerApiStatusResponsesStatusResponse](docs/GithubComSatstreamSsApiServerApiStatusResponsesStatusResponse.md)
 - [GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTInput](docs/GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTInput.md)
 - [GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTOutput](docs/GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTOutput.md)
 - [GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTRequest](docs/GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTRequest.md)
 - [GithubComSatstreamSsApiServerApiTransactionResponsesDecodeResponse](docs/GithubComSatstreamSsApiServerApiTransactionResponsesDecodeResponse.md)
 - [GithubComSatstreamSsApiServerApiTransactionResponsesError](docs/GithubComSatstreamSsApiServerApiTransactionResponsesError.md)
 - [GithubComSatstreamSsApiServerApiTransactionResponsesTransactionResponse](docs/GithubComSatstreamSsApiServerApiTransactionResponsesTransactionResponse.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBip32Deriv](docs/GithubComSatstreamSsUtilsBitcoinCliBip32Deriv.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBlock1](docs/GithubComSatstreamSsUtilsBitcoinCliBlock1.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBlock2](docs/GithubComSatstreamSsUtilsBitcoinCliBlock2.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBlock3](docs/GithubComSatstreamSsUtilsBitcoinCliBlock3.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBlockStats](docs/GithubComSatstreamSsUtilsBitcoinCliBlockStats.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBlockVin2](docs/GithubComSatstreamSsUtilsBitcoinCliBlockVin2.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBlockVin3](docs/GithubComSatstreamSsUtilsBitcoinCliBlockVin3.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBlockchainInfo](docs/GithubComSatstreamSsUtilsBitcoinCliBlockchainInfo.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBtcTx2](docs/GithubComSatstreamSsUtilsBitcoinCliBtcTx2.md)
 - [GithubComSatstreamSsUtilsBitcoinCliBtcTx3](docs/GithubComSatstreamSsUtilsBitcoinCliBtcTx3.md)
 - [GithubComSatstreamSsUtilsBitcoinCliChainTxStats](docs/GithubComSatstreamSsUtilsBitcoinCliChainTxStats.md)
 - [GithubComSatstreamSsUtilsBitcoinCliDecodedPSBT](docs/GithubComSatstreamSsUtilsBitcoinCliDecodedPSBT.md)
 - [GithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInput](docs/GithubComSatstreamSsUtilsBitcoinCliDecodedPSBTInput.md)
 - [GithubComSatstreamSsUtilsBitcoinCliDecodedPSBTOutput](docs/GithubComSatstreamSsUtilsBitcoinCliDecodedPSBTOutput.md)
 - [GithubComSatstreamSsUtilsBitcoinCliDecodedScript](docs/GithubComSatstreamSsUtilsBitcoinCliDecodedScript.md)
 - [GithubComSatstreamSsUtilsBitcoinCliEstimateRawFee](docs/GithubComSatstreamSsUtilsBitcoinCliEstimateRawFee.md)
 - [GithubComSatstreamSsUtilsBitcoinCliFeeHorizonEstimate](docs/GithubComSatstreamSsUtilsBitcoinCliFeeHorizonEstimate.md)
 - [GithubComSatstreamSsUtilsBitcoinCliFeeRange](docs/GithubComSatstreamSsUtilsBitcoinCliFeeRange.md)
 - [GithubComSatstreamSsUtilsBitcoinCliMempoolInfo](docs/GithubComSatstreamSsUtilsBitcoinCliMempoolInfo.md)
 - [GithubComSatstreamSsUtilsBitcoinCliMiningInfo](docs/GithubComSatstreamSsUtilsBitcoinCliMiningInfo.md)
 - [GithubComSatstreamSsUtilsBitcoinCliPSBTAnalysis](docs/GithubComSatstreamSsUtilsBitcoinCliPSBTAnalysis.md)
 - [GithubComSatstreamSsUtilsBitcoinCliPSBTBip32Deriv](docs/GithubComSatstreamSsUtilsBitcoinCliPSBTBip32Deriv.md)
 - [GithubComSatstreamSsUtilsBitcoinCliPSBTInputAnalysis](docs/GithubComSatstreamSsUtilsBitcoinCliPSBTInputAnalysis.md)
 - [GithubComSatstreamSsUtilsBitcoinCliPSBTMissingData](docs/GithubComSatstreamSsUtilsBitcoinCliPSBTMissingData.md)
 - [GithubComSatstreamSsUtilsBitcoinCliPSBTWitnessUtxo](docs/GithubComSatstreamSsUtilsBitcoinCliPSBTWitnessUtxo.md)
 - [GithubComSatstreamSsUtilsBitcoinCliPrevOut](docs/GithubComSatstreamSsUtilsBitcoinCliPrevOut.md)
 - [GithubComSatstreamSsUtilsBitcoinCliRawTx1](docs/GithubComSatstreamSsUtilsBitcoinCliRawTx1.md)
 - [GithubComSatstreamSsUtilsBitcoinCliRawTx2](docs/GithubComSatstreamSsUtilsBitcoinCliRawTx2.md)
 - [GithubComSatstreamSsUtilsBitcoinCliScript](docs/GithubComSatstreamSsUtilsBitcoinCliScript.md)
 - [GithubComSatstreamSsUtilsBitcoinCliScriptPubKey](docs/GithubComSatstreamSsUtilsBitcoinCliScriptPubKey.md)
 - [GithubComSatstreamSsUtilsBitcoinCliScriptSig](docs/GithubComSatstreamSsUtilsBitcoinCliScriptSig.md)
 - [GithubComSatstreamSsUtilsBitcoinCliSegwitDetails](docs/GithubComSatstreamSsUtilsBitcoinCliSegwitDetails.md)
 - [GithubComSatstreamSsUtilsBitcoinCliSmartFeeEstimate](docs/GithubComSatstreamSsUtilsBitcoinCliSmartFeeEstimate.md)
 - [GithubComSatstreamSsUtilsBitcoinCliTestMempoolAcceptResult](docs/GithubComSatstreamSsUtilsBitcoinCliTestMempoolAcceptResult.md)
 - [GithubComSatstreamSsUtilsBitcoinCliTestMempoolFees](docs/GithubComSatstreamSsUtilsBitcoinCliTestMempoolFees.md)
 - [GithubComSatstreamSsUtilsBitcoinCliTxOut](docs/GithubComSatstreamSsUtilsBitcoinCliTxOut.md)
 - [GithubComSatstreamSsUtilsBitcoinCliTxSpendingPrevoutInput](docs/GithubComSatstreamSsUtilsBitcoinCliTxSpendingPrevoutInput.md)
 - [GithubComSatstreamSsUtilsBitcoinCliTxSpendingPrevoutResult](docs/GithubComSatstreamSsUtilsBitcoinCliTxSpendingPrevoutResult.md)
 - [GithubComSatstreamSsUtilsBitcoinCliTxVin1](docs/GithubComSatstreamSsUtilsBitcoinCliTxVin1.md)
 - [GithubComSatstreamSsUtilsBitcoinCliTxVin2](docs/GithubComSatstreamSsUtilsBitcoinCliTxVin2.md)
 - [GithubComSatstreamSsUtilsBitcoinCliUTXOBlockInfo](docs/GithubComSatstreamSsUtilsBitcoinCliUTXOBlockInfo.md)
 - [GithubComSatstreamSsUtilsBitcoinCliUTXOSetInfo](docs/GithubComSatstreamSsUtilsBitcoinCliUTXOSetInfo.md)
 - [GithubComSatstreamSsUtilsBitcoinCliUTXOUnspendables](docs/GithubComSatstreamSsUtilsBitcoinCliUTXOUnspendables.md)
 - [GithubComSatstreamSsUtilsBitcoinCliValidateAddressResult](docs/GithubComSatstreamSsUtilsBitcoinCliValidateAddressResult.md)
 - [GithubComSatstreamSsUtilsBitcoinCliVout](docs/GithubComSatstreamSsUtilsBitcoinCliVout.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesAddressResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesAddressResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesBlockResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesBlockResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesBlocksResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesBlocksResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesDecodeResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesDecodeResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesDecodedInscription](docs/GithubComSatstreamSsUtilsOrdServerResponsesDecodedInscription.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesDuration](docs/GithubComSatstreamSsUtilsOrdServerResponsesDuration.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesInput](docs/GithubComSatstreamSsUtilsOrdServerResponsesInput.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesInscriptionData](docs/GithubComSatstreamSsUtilsOrdServerResponsesInscriptionData.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesInscriptionResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesInscriptionResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesLatestInscriptionsResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesLatestInscriptionsResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesOutput](docs/GithubComSatstreamSsUtilsOrdServerResponsesOutput.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesOutputResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesOutputResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRuneEntry](docs/GithubComSatstreamSsUtilsOrdServerResponsesRuneEntry.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRuneListEntry](docs/GithubComSatstreamSsUtilsOrdServerResponsesRuneListEntry.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRuneResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesRuneResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRuneTerms](docs/GithubComSatstreamSsUtilsOrdServerResponsesRuneTerms.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRunesBalance](docs/GithubComSatstreamSsUtilsOrdServerResponsesRunesBalance.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRunesListResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesRunesListResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesRunestoneData](docs/GithubComSatstreamSsUtilsOrdServerResponsesRunestoneData.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesSatoshiResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesSatoshiResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesStatusResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesStatusResponse.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesTransaction](docs/GithubComSatstreamSsUtilsOrdServerResponsesTransaction.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesTransactionDetails](docs/GithubComSatstreamSsUtilsOrdServerResponsesTransactionDetails.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesTransactionInput](docs/GithubComSatstreamSsUtilsOrdServerResponsesTransactionInput.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesTransactionOutput](docs/GithubComSatstreamSsUtilsOrdServerResponsesTransactionOutput.md)
 - [GithubComSatstreamSsUtilsOrdServerResponsesTransactionResponse](docs/GithubComSatstreamSsUtilsOrdServerResponsesTransactionResponse.md)
 - [RequestsAnalyzePSBTRequest](docs/RequestsAnalyzePSBTRequest.md)
 - [RequestsCombinePSBTRequest](docs/RequestsCombinePSBTRequest.md)
 - [RequestsCombineRawTransactionRequest](docs/RequestsCombineRawTransactionRequest.md)
 - [RequestsConvertToPSBTRequest](docs/RequestsConvertToPSBTRequest.md)
 - [RequestsDecodeScriptRequest](docs/RequestsDecodeScriptRequest.md)
 - [RequestsEstimateRawFeeRequest](docs/RequestsEstimateRawFeeRequest.md)
 - [RequestsEstimateSmartFeeRequest](docs/RequestsEstimateSmartFeeRequest.md)
 - [RequestsGetBlockStatsRequest](docs/RequestsGetBlockStatsRequest.md)
 - [RequestsGetChainTxStatsRequest](docs/RequestsGetChainTxStatsRequest.md)
 - [RequestsGetMempoolAncestorsRequest](docs/RequestsGetMempoolAncestorsRequest.md)
 - [RequestsGetMempoolDescendantsRequest](docs/RequestsGetMempoolDescendantsRequest.md)
 - [RequestsGetNetworkHashPSRequest](docs/RequestsGetNetworkHashPSRequest.md)
 - [RequestsGetRawMempoolRequest](docs/RequestsGetRawMempoolRequest.md)
 - [RequestsGetTxOutProofRequest](docs/RequestsGetTxOutProofRequest.md)
 - [RequestsGetTxOutRequest](docs/RequestsGetTxOutRequest.md)
 - [RequestsGetTxOutSetInfoRequest](docs/RequestsGetTxOutSetInfoRequest.md)
 - [RequestsGetTxSpendingPrevoutRequest](docs/RequestsGetTxSpendingPrevoutRequest.md)
 - [RequestsJoinPSBTsRequest](docs/RequestsJoinPSBTsRequest.md)
 - [RequestsSendRawTransactionRequest](docs/RequestsSendRawTransactionRequest.md)
 - [RequestsTestMempoolAcceptRequest](docs/RequestsTestMempoolAcceptRequest.md)
 - [RequestsVerifyMessageRequest](docs/RequestsVerifyMessageRequest.md)
 - [RequestsVerifyTxOutProofRequest](docs/RequestsVerifyTxOutProofRequest.md)
 - [ResponsesAnalyzePSBTResponse](docs/ResponsesAnalyzePSBTResponse.md)
 - [ResponsesCombinePSBTResponse](docs/ResponsesCombinePSBTResponse.md)
 - [ResponsesCombineRawTransactionResponse](docs/ResponsesCombineRawTransactionResponse.md)
 - [ResponsesConvertToPSBTResponse](docs/ResponsesConvertToPSBTResponse.md)
 - [ResponsesCreatePSBTResponse](docs/ResponsesCreatePSBTResponse.md)
 - [ResponsesCreateRawTransactionResponse](docs/ResponsesCreateRawTransactionResponse.md)
 - [ResponsesDecodePSBTResponse](docs/ResponsesDecodePSBTResponse.md)
 - [ResponsesDecodeScriptResponse](docs/ResponsesDecodeScriptResponse.md)
 - [ResponsesEstimateRawFeeResponse](docs/ResponsesEstimateRawFeeResponse.md)
 - [ResponsesEstimateSmartFeeResponse](docs/ResponsesEstimateSmartFeeResponse.md)
 - [ResponsesGetBlockDecodedResponse](docs/ResponsesGetBlockDecodedResponse.md)
 - [ResponsesGetBlockHexResponse](docs/ResponsesGetBlockHexResponse.md)
 - [ResponsesGetBlockPrevoutResponse](docs/ResponsesGetBlockPrevoutResponse.md)
 - [ResponsesGetBlockStatsResponse](docs/ResponsesGetBlockStatsResponse.md)
 - [ResponsesGetBlockSummaryResponse](docs/ResponsesGetBlockSummaryResponse.md)
 - [ResponsesGetBlockchainInfoResponse](docs/ResponsesGetBlockchainInfoResponse.md)
 - [ResponsesGetChainTxStatsResponse](docs/ResponsesGetChainTxStatsResponse.md)
 - [ResponsesGetDifficultyResponse](docs/ResponsesGetDifficultyResponse.md)
 - [ResponsesGetMempoolAncestorsResponse](docs/ResponsesGetMempoolAncestorsResponse.md)
 - [ResponsesGetMempoolDescendantsResponse](docs/ResponsesGetMempoolDescendantsResponse.md)
 - [ResponsesGetMempoolInfoResponse](docs/ResponsesGetMempoolInfoResponse.md)
 - [ResponsesGetMiningInfoResponse](docs/ResponsesGetMiningInfoResponse.md)
 - [ResponsesGetNetworkHashPSResponse](docs/ResponsesGetNetworkHashPSResponse.md)
 - [ResponsesGetOutputByOutpointResponse](docs/ResponsesGetOutputByOutpointResponse.md)
 - [ResponsesGetOutputsResponse](docs/ResponsesGetOutputsResponse.md)
 - [ResponsesGetRawMempoolResponse](docs/ResponsesGetRawMempoolResponse.md)
 - [ResponsesGetRawTransactionDecodedResponse](docs/ResponsesGetRawTransactionDecodedResponse.md)
 - [ResponsesGetRawTransactionHexResponse](docs/ResponsesGetRawTransactionHexResponse.md)
 - [ResponsesGetRawTransactionPrevoutResponse](docs/ResponsesGetRawTransactionPrevoutResponse.md)
 - [ResponsesGetTxOutProofResponse](docs/ResponsesGetTxOutProofResponse.md)
 - [ResponsesGetTxOutResponse](docs/ResponsesGetTxOutResponse.md)
 - [ResponsesGetTxOutSetInfoResponse](docs/ResponsesGetTxOutSetInfoResponse.md)
 - [ResponsesGetTxSpendingPrevoutResponse](docs/ResponsesGetTxSpendingPrevoutResponse.md)
 - [ResponsesJoinPSBTsResponse](docs/ResponsesJoinPSBTsResponse.md)
 - [ResponsesLatestBlockHashResponse](docs/ResponsesLatestBlockHashResponse.md)
 - [ResponsesLatestBlockHeightResponse](docs/ResponsesLatestBlockHeightResponse.md)
 - [ResponsesLatestBlockTimeResponse](docs/ResponsesLatestBlockTimeResponse.md)
 - [ResponsesSendRawTransactionResponse](docs/ResponsesSendRawTransactionResponse.md)
 - [ResponsesTestMempoolAcceptResponse](docs/ResponsesTestMempoolAcceptResponse.md)
 - [ResponsesValidateAddressResponse](docs/ResponsesValidateAddressResponse.md)
 - [ResponsesVerifyMessageResponse](docs/ResponsesVerifyMessageResponse.md)
 - [ResponsesVerifyTxOutProofResponse](docs/ResponsesVerifyTxOutProofResponse.md)

## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author

team@satstream.io
