# coding: utf-8

"""
    Satstream API

    Satstream API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: team@satstream.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from satstream_python_sdk.api_client import ApiClient


class BitcoinApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def analyze_psbt(self, body, **kwargs):  # noqa: E501
        """Analyze PSBT  # noqa: E501

        Analyzes and provides information about the current status of a PSBT and its inputs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.analyze_psbt(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsAnalyzePSBTRequest body: PSBT to analyze (required)
        :return: ResponsesAnalyzePSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.analyze_psbt_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.analyze_psbt_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def analyze_psbt_with_http_info(self, body, **kwargs):  # noqa: E501
        """Analyze PSBT  # noqa: E501

        Analyzes and provides information about the current status of a PSBT and its inputs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.analyze_psbt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsAnalyzePSBTRequest body: PSBT to analyze (required)
        :return: ResponsesAnalyzePSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method analyze_psbt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `analyze_psbt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/psbt/analyze', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesAnalyzePSBTResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def combine_psbt(self, body, **kwargs):  # noqa: E501
        """Combine PSBTs  # noqa: E501

        Combines multiple partially signed Bitcoin transactions into one transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.combine_psbt(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsCombinePSBTRequest body: Array of PSBTs to combine (required)
        :return: ResponsesCombinePSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.combine_psbt_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.combine_psbt_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def combine_psbt_with_http_info(self, body, **kwargs):  # noqa: E501
        """Combine PSBTs  # noqa: E501

        Combines multiple partially signed Bitcoin transactions into one transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.combine_psbt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsCombinePSBTRequest body: Array of PSBTs to combine (required)
        :return: ResponsesCombinePSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method combine_psbt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `combine_psbt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/psbt/combine', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesCombinePSBTResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def combine_raw_transaction(self, body, **kwargs):  # noqa: E501
        """Combine Raw Transactions  # noqa: E501

        Combines multiple partially signed transactions into one transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.combine_raw_transaction(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsCombineRawTransactionRequest body: Array of hex-encoded raw transactions (required)
        :return: ResponsesCombineRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.combine_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.combine_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def combine_raw_transaction_with_http_info(self, body, **kwargs):  # noqa: E501
        """Combine Raw Transactions  # noqa: E501

        Combines multiple partially signed transactions into one transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.combine_raw_transaction_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsCombineRawTransactionRequest body: Array of hex-encoded raw transactions (required)
        :return: ResponsesCombineRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method combine_raw_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `combine_raw_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/combine', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesCombineRawTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_to_psbt(self, body, **kwargs):  # noqa: E501
        """Convert Raw Transaction to PSBT  # noqa: E501

        Converts a network serialized transaction to a PSBT. This should be used only with createrawtransaction and fundrawtransaction. createpsbt and walletcreatefundedpsbt should be used for new applications.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_to_psbt(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsConvertToPSBTRequest body: Raw transaction conversion parameters (required)
        :return: ResponsesConvertToPSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_to_psbt_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.convert_to_psbt_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def convert_to_psbt_with_http_info(self, body, **kwargs):  # noqa: E501
        """Convert Raw Transaction to PSBT  # noqa: E501

        Converts a network serialized transaction to a PSBT. This should be used only with createrawtransaction and fundrawtransaction. createpsbt and walletcreatefundedpsbt should be used for new applications.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_to_psbt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsConvertToPSBTRequest body: Raw transaction conversion parameters (required)
        :return: ResponsesConvertToPSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_to_psbt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `convert_to_psbt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/convert-to-psbt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesConvertToPSBTResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_psbt(self, body, **kwargs):  # noqa: E501
        """Create PSBT  # noqa: E501

        Creates a transaction in the Partially Signed Transaction format. Implements the Creator role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_psbt(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTRequest body: Transaction parameters (required)
        :return: ResponsesCreatePSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_psbt_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_psbt_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_psbt_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create PSBT  # noqa: E501

        Creates a transaction in the Partially Signed Transaction format. Implements the Creator role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_psbt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GithubComSatstreamSsApiServerApiPsbtRequestsCreatePSBTRequest body: Transaction parameters (required)
        :return: ResponsesCreatePSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_psbt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_psbt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/psbt/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesCreatePSBTResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_raw_transaction(self, body, **kwargs):  # noqa: E501
        """Create Raw Transaction  # noqa: E501

        Creates a raw transaction spending the given inputs and creating new outputs. Note that the transaction's inputs are not signed, and it is not stored in the wallet or transmitted to the network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_raw_transaction(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTRequest body: Transaction parameters (required)
        :return: ResponsesCreateRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_raw_transaction_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create Raw Transaction  # noqa: E501

        Creates a raw transaction spending the given inputs and creating new outputs. Note that the transaction's inputs are not signed, and it is not stored in the wallet or transmitted to the network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_raw_transaction_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GithubComSatstreamSsApiServerApiTransactionRequestsCreatePSBTRequest body: Transaction parameters (required)
        :return: ResponsesCreateRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_raw_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_raw_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesCreateRawTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def decode_psbt(self, body, **kwargs):  # noqa: E501
        """Decode PSBT  # noqa: E501

        Return a JSON object representing the serialized, base64-encoded partially signed Bitcoin transaction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decode_psbt(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsAnalyzePSBTRequest body: PSBT to decode (required)
        :return: ResponsesDecodePSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.decode_psbt_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.decode_psbt_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def decode_psbt_with_http_info(self, body, **kwargs):  # noqa: E501
        """Decode PSBT  # noqa: E501

        Return a JSON object representing the serialized, base64-encoded partially signed Bitcoin transaction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decode_psbt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsAnalyzePSBTRequest body: PSBT to decode (required)
        :return: ResponsesDecodePSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method decode_psbt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `decode_psbt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/psbt/decode', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesDecodePSBTResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def decode_script(self, body, **kwargs):  # noqa: E501
        """Decode Script  # noqa: E501

        Decode a hex-encoded script and return detailed information about it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decode_script(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsDecodeScriptRequest body: Script to decode (required)
        :return: ResponsesDecodeScriptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.decode_script_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.decode_script_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def decode_script_with_http_info(self, body, **kwargs):  # noqa: E501
        """Decode Script  # noqa: E501

        Decode a hex-encoded script and return detailed information about it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decode_script_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsDecodeScriptRequest body: Script to decode (required)
        :return: ResponsesDecodeScriptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method decode_script" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `decode_script`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/script/decode', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesDecodeScriptResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def estimate_raw_fee(self, body, **kwargs):  # noqa: E501
        """Estimate Raw Fee  # noqa: E501

        Estimates the approximate fee per kilobyte needed for a transaction to begin confirmation within conf_target blocks if possible.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.estimate_raw_fee(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsEstimateRawFeeRequest body: Fee estimation parameters (required)
        :return: ResponsesEstimateRawFeeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.estimate_raw_fee_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.estimate_raw_fee_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def estimate_raw_fee_with_http_info(self, body, **kwargs):  # noqa: E501
        """Estimate Raw Fee  # noqa: E501

        Estimates the approximate fee per kilobyte needed for a transaction to begin confirmation within conf_target blocks if possible.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.estimate_raw_fee_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsEstimateRawFeeRequest body: Fee estimation parameters (required)
        :return: ResponsesEstimateRawFeeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method estimate_raw_fee" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `estimate_raw_fee`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/fee/estimate-raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesEstimateRawFeeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def estimate_smart_fee(self, body, **kwargs):  # noqa: E501
        """Estimate smart fee  # noqa: E501

        Estimates the approximate fee per kilobyte needed for a transaction to begin confirmation within conf_target blocks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.estimate_smart_fee(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsEstimateSmartFeeRequest body: Fee estimation parameters (required)
        :return: ResponsesEstimateSmartFeeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.estimate_smart_fee_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.estimate_smart_fee_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def estimate_smart_fee_with_http_info(self, body, **kwargs):  # noqa: E501
        """Estimate smart fee  # noqa: E501

        Estimates the approximate fee per kilobyte needed for a transaction to begin confirmation within conf_target blocks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.estimate_smart_fee_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsEstimateSmartFeeRequest body: Fee estimation parameters (required)
        :return: ResponsesEstimateSmartFeeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method estimate_smart_fee" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `estimate_smart_fee`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/fee/estimate-smart', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesEstimateSmartFeeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_hash_decoded(self, hash, **kwargs):  # noqa: E501
        """Get block by hash (verbosity 2)  # noqa: E501

        Get block by hash as a decoded object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_hash_decoded(hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hash: Block hash (required)
        :return: ResponsesGetBlockDecodedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_hash_decoded_with_http_info(hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_hash_decoded_with_http_info(hash, **kwargs)  # noqa: E501
            return data

    def get_block_by_hash_decoded_with_http_info(self, hash, **kwargs):  # noqa: E501
        """Get block by hash (verbosity 2)  # noqa: E501

        Get block by hash as a decoded object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_hash_decoded_with_http_info(hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hash: Block hash (required)
        :return: ResponsesGetBlockDecodedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_hash_decoded" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hash' is set
        if ('hash' not in params or
                params['hash'] is None):
            raise ValueError("Missing the required parameter `hash` when calling `get_block_by_hash_decoded`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hash' in params:
            path_params['hash'] = params['hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/hash/{hash}/decoded', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockDecodedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_hash_hex(self, hash, **kwargs):  # noqa: E501
        """Get block by hash (verbosity 0)  # noqa: E501

        Get block by hash as a raw hex string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_hash_hex(hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hash: Block hash (required)
        :return: ResponsesGetBlockHexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_hash_hex_with_http_info(hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_hash_hex_with_http_info(hash, **kwargs)  # noqa: E501
            return data

    def get_block_by_hash_hex_with_http_info(self, hash, **kwargs):  # noqa: E501
        """Get block by hash (verbosity 0)  # noqa: E501

        Get block by hash as a raw hex string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_hash_hex_with_http_info(hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hash: Block hash (required)
        :return: ResponsesGetBlockHexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_hash_hex" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hash' is set
        if ('hash' not in params or
                params['hash'] is None):
            raise ValueError("Missing the required parameter `hash` when calling `get_block_by_hash_hex`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hash' in params:
            path_params['hash'] = params['hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/hash/{hash}/hex', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockHexResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_hash_prevout(self, hash, **kwargs):  # noqa: E501
        """Get block by hash (verbosity 3)  # noqa: E501

        Get block by hash with prevout information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_hash_prevout(hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hash: Block hash (required)
        :return: ResponsesGetBlockPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_hash_prevout_with_http_info(hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_hash_prevout_with_http_info(hash, **kwargs)  # noqa: E501
            return data

    def get_block_by_hash_prevout_with_http_info(self, hash, **kwargs):  # noqa: E501
        """Get block by hash (verbosity 3)  # noqa: E501

        Get block by hash with prevout information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_hash_prevout_with_http_info(hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hash: Block hash (required)
        :return: ResponsesGetBlockPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_hash_prevout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hash' is set
        if ('hash' not in params or
                params['hash'] is None):
            raise ValueError("Missing the required parameter `hash` when calling `get_block_by_hash_prevout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hash' in params:
            path_params['hash'] = params['hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/hash/{hash}/prevout', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockPrevoutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_hash_summary(self, hash, **kwargs):  # noqa: E501
        """Get block by hash (verbosity 1)  # noqa: E501

        Get block by hash as a summary object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_hash_summary(hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hash: Block hash (required)
        :return: ResponsesGetBlockSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_hash_summary_with_http_info(hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_hash_summary_with_http_info(hash, **kwargs)  # noqa: E501
            return data

    def get_block_by_hash_summary_with_http_info(self, hash, **kwargs):  # noqa: E501
        """Get block by hash (verbosity 1)  # noqa: E501

        Get block by hash as a summary object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_hash_summary_with_http_info(hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hash: Block hash (required)
        :return: ResponsesGetBlockSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_hash_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hash' is set
        if ('hash' not in params or
                params['hash'] is None):
            raise ValueError("Missing the required parameter `hash` when calling `get_block_by_hash_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hash' in params:
            path_params['hash'] = params['hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/hash/{hash}/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockSummaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_height_decoded(self, height, **kwargs):  # noqa: E501
        """Get block by height (verbosity 2)  # noqa: E501

        Get block by height as a decoded object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_decoded(height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int height: Block height (required)
        :return: ResponsesGetBlockDecodedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_height_decoded_with_http_info(height, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_height_decoded_with_http_info(height, **kwargs)  # noqa: E501
            return data

    def get_block_by_height_decoded_with_http_info(self, height, **kwargs):  # noqa: E501
        """Get block by height (verbosity 2)  # noqa: E501

        Get block by height as a decoded object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_decoded_with_http_info(height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int height: Block height (required)
        :return: ResponsesGetBlockDecodedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['height']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_height_decoded" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'height' is set
        if ('height' not in params or
                params['height'] is None):
            raise ValueError("Missing the required parameter `height` when calling `get_block_by_height_decoded`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'height' in params:
            path_params['height'] = params['height']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/height/{height}/decoded', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockDecodedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_height_hex(self, height, **kwargs):  # noqa: E501
        """Get block by height (verbosity 0)  # noqa: E501

        Get block by height as a raw hex string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_hex(height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int height: Block height (required)
        :return: ResponsesGetBlockHexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_height_hex_with_http_info(height, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_height_hex_with_http_info(height, **kwargs)  # noqa: E501
            return data

    def get_block_by_height_hex_with_http_info(self, height, **kwargs):  # noqa: E501
        """Get block by height (verbosity 0)  # noqa: E501

        Get block by height as a raw hex string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_hex_with_http_info(height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int height: Block height (required)
        :return: ResponsesGetBlockHexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['height']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_height_hex" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'height' is set
        if ('height' not in params or
                params['height'] is None):
            raise ValueError("Missing the required parameter `height` when calling `get_block_by_height_hex`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'height' in params:
            path_params['height'] = params['height']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/height/{height}/hex', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockHexResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_height_prevout(self, height, **kwargs):  # noqa: E501
        """Get block by height (verbosity 3)  # noqa: E501

        Get block by height with prevout information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_prevout(height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int height: Block height (required)
        :return: ResponsesGetBlockPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_height_prevout_with_http_info(height, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_height_prevout_with_http_info(height, **kwargs)  # noqa: E501
            return data

    def get_block_by_height_prevout_with_http_info(self, height, **kwargs):  # noqa: E501
        """Get block by height (verbosity 3)  # noqa: E501

        Get block by height with prevout information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_prevout_with_http_info(height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int height: Block height (required)
        :return: ResponsesGetBlockPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['height']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_height_prevout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'height' is set
        if ('height' not in params or
                params['height'] is None):
            raise ValueError("Missing the required parameter `height` when calling `get_block_by_height_prevout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'height' in params:
            path_params['height'] = params['height']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/height/{height}/prevout', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockPrevoutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_height_summary(self, height, **kwargs):  # noqa: E501
        """Get block by height (verbosity 1)  # noqa: E501

        Get block by height as a summary object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_summary(height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int height: Block height (required)
        :return: ResponsesGetBlockSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_height_summary_with_http_info(height, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_height_summary_with_http_info(height, **kwargs)  # noqa: E501
            return data

    def get_block_by_height_summary_with_http_info(self, height, **kwargs):  # noqa: E501
        """Get block by height (verbosity 1)  # noqa: E501

        Get block by height as a summary object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_summary_with_http_info(height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int height: Block height (required)
        :return: ResponsesGetBlockSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['height']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_height_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'height' is set
        if ('height' not in params or
                params['height'] is None):
            raise ValueError("Missing the required parameter `height` when calling `get_block_by_height_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'height' in params:
            path_params['height'] = params['height']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/height/{height}/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockSummaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_stats(self, body, **kwargs):  # noqa: E501
        """Get block stats  # noqa: E501

        Computes per block statistics for a given window  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_stats(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetBlockStatsRequest body: Block stats request parameters (required)
        :return: ResponsesGetBlockStatsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_stats_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_stats_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_block_stats_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get block stats  # noqa: E501

        Computes per block statistics for a given window  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_stats_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetBlockStatsRequest body: Block stats request parameters (required)
        :return: ResponsesGetBlockStatsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_block_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/stats', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockStatsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_blockchain_info(self, **kwargs):  # noqa: E501
        """Get blockchain information  # noqa: E501

        Returns an object containing various state info regarding blockchain processing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blockchain_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetBlockchainInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_blockchain_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_blockchain_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_blockchain_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get blockchain information  # noqa: E501

        Returns an object containing various state info regarding blockchain processing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blockchain_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetBlockchainInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_blockchain_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blockchain/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetBlockchainInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_chain_tx_stats(self, body, **kwargs):  # noqa: E501
        """Get chain tx stats  # noqa: E501

        Computes statistics about the total number and rate of transactions in the chain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_chain_tx_stats(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetChainTxStatsRequest body: Chain tx stats request parameters (required)
        :return: ResponsesGetChainTxStatsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_chain_tx_stats_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_chain_tx_stats_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_chain_tx_stats_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get chain tx stats  # noqa: E501

        Computes statistics about the total number and rate of transactions in the chain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_chain_tx_stats_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetChainTxStatsRequest body: Chain tx stats request parameters (required)
        :return: ResponsesGetChainTxStatsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chain_tx_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_chain_tx_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/chain/txstats', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetChainTxStatsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_difficulty(self, **kwargs):  # noqa: E501
        """Get difficulty  # noqa: E501

        Returns the proof-of-work difficulty as a multiple of the minimum difficulty  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_difficulty(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetDifficultyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_difficulty_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_difficulty_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_difficulty_with_http_info(self, **kwargs):  # noqa: E501
        """Get difficulty  # noqa: E501

        Returns the proof-of-work difficulty as a multiple of the minimum difficulty  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_difficulty_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetDifficultyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_difficulty" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/difficulty', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetDifficultyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mempool_ancestors(self, body, **kwargs):  # noqa: E501
        """Get mempool ancestors  # noqa: E501

        Returns all in-mempool ancestors for a transaction in the mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_ancestors(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetMempoolAncestorsRequest body: Mempool ancestors request parameters (required)
        :return: ResponsesGetMempoolAncestorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mempool_ancestors_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mempool_ancestors_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_mempool_ancestors_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get mempool ancestors  # noqa: E501

        Returns all in-mempool ancestors for a transaction in the mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_ancestors_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetMempoolAncestorsRequest body: Mempool ancestors request parameters (required)
        :return: ResponsesGetMempoolAncestorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mempool_ancestors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_mempool_ancestors`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mempool/ancestors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetMempoolAncestorsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mempool_descendants(self, body, **kwargs):  # noqa: E501
        """Get mempool descendants  # noqa: E501

        Returns all in-mempool descendants for a transaction in the mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_descendants(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetMempoolDescendantsRequest body: Mempool descendants request parameters (required)
        :return: ResponsesGetMempoolDescendantsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mempool_descendants_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mempool_descendants_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_mempool_descendants_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get mempool descendants  # noqa: E501

        Returns all in-mempool descendants for a transaction in the mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_descendants_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetMempoolDescendantsRequest body: Mempool descendants request parameters (required)
        :return: ResponsesGetMempoolDescendantsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mempool_descendants" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_mempool_descendants`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mempool/descendants', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetMempoolDescendantsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mempool_info(self, **kwargs):  # noqa: E501
        """Get mempool information  # noqa: E501

        Returns details on the active state of the TX memory pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetMempoolInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mempool_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_mempool_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_mempool_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get mempool information  # noqa: E501

        Returns details on the active state of the TX memory pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mempool_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetMempoolInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mempool_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mempool/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetMempoolInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mining_info(self, **kwargs):  # noqa: E501
        """Get mining information  # noqa: E501

        Returns a json object containing mining-related information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mining_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetMiningInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mining_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_mining_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_mining_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get mining information  # noqa: E501

        Returns a json object containing mining-related information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mining_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesGetMiningInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mining_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mining/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetMiningInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_hashps(self, body, **kwargs):  # noqa: E501
        """Get network hash per second  # noqa: E501

        Returns the estimated network hashes per second based on the last n blocks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_hashps(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetNetworkHashPSRequest body: Network hash rate parameters (required)
        :return: ResponsesGetNetworkHashPSResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_hashps_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_network_hashps_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_network_hashps_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get network hash per second  # noqa: E501

        Returns the estimated network hashes per second based on the last n blocks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_hashps_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetNetworkHashPSRequest body: Network hash rate parameters (required)
        :return: ResponsesGetNetworkHashPSResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_hashps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_network_hashps`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/network/hashps', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetNetworkHashPSResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_raw_mempool(self, body, **kwargs):  # noqa: E501
        """Get raw mempool  # noqa: E501

        Returns all transaction ids in memory pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_mempool(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetRawMempoolRequest body: Raw mempool request parameters (required)
        :return: ResponsesGetRawMempoolResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_raw_mempool_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_raw_mempool_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_raw_mempool_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get raw mempool  # noqa: E501

        Returns all transaction ids in memory pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_mempool_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetRawMempoolRequest body: Raw mempool request parameters (required)
        :return: ResponsesGetRawMempoolResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_raw_mempool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_raw_mempool`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mempool/raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetRawMempoolResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_raw_transaction_decoded(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 1)  # noqa: E501

        Get raw transaction as a decoded object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_decoded(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: ResponsesGetRawTransactionDecodedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_raw_transaction_decoded_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_raw_transaction_decoded_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_raw_transaction_decoded_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 1)  # noqa: E501

        Get raw transaction as a decoded object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_decoded_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: ResponsesGetRawTransactionDecodedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_raw_transaction_decoded" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_raw_transaction_decoded`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}/decoded', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetRawTransactionDecodedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_raw_transaction_hex(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 0)  # noqa: E501

        Get raw transaction as a raw hex string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_hex(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: ResponsesGetRawTransactionHexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_raw_transaction_hex_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_raw_transaction_hex_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_raw_transaction_hex_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 0)  # noqa: E501

        Get raw transaction as a raw hex string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_hex_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: ResponsesGetRawTransactionHexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_raw_transaction_hex" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_raw_transaction_hex`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}/hex', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetRawTransactionHexResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_raw_transaction_prevout(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 2)  # noqa: E501

        Get raw transaction with prevout information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_prevout(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: ResponsesGetRawTransactionPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_raw_transaction_prevout_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_raw_transaction_prevout_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_raw_transaction_prevout_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 2)  # noqa: E501

        Get raw transaction with prevout information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_prevout_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: ResponsesGetRawTransactionPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_raw_transaction_prevout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_raw_transaction_prevout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}/prevout', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetRawTransactionPrevoutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tx_out(self, body, **kwargs):  # noqa: E501
        """Get transaction output  # noqa: E501

        Returns details about an unspent transaction output  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetTxOutRequest body: Transaction output request parameters (required)
        :return: ResponsesGetTxOutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tx_out_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tx_out_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_tx_out_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get transaction output  # noqa: E501

        Returns details about an unspent transaction output  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetTxOutRequest body: Transaction output request parameters (required)
        :return: ResponsesGetTxOutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tx_out" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_tx_out`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/out', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetTxOutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tx_out_proof(self, body, **kwargs):  # noqa: E501
        """Get transaction output proof  # noqa: E501

        Returns a hex-encoded proof that one or more specified transactions were included in a block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_proof(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetTxOutProofRequest body: Transaction proof request parameters (required)
        :return: ResponsesGetTxOutProofResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tx_out_proof_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tx_out_proof_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_tx_out_proof_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get transaction output proof  # noqa: E501

        Returns a hex-encoded proof that one or more specified transactions were included in a block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_proof_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetTxOutProofRequest body: Transaction proof request parameters (required)
        :return: ResponsesGetTxOutProofResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tx_out_proof" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_tx_out_proof`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/out/proof', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetTxOutProofResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tx_out_set_info(self, body, **kwargs):  # noqa: E501
        """Get transaction output set information  # noqa: E501

        Returns statistics about the unspent transaction output set  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_set_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetTxOutSetInfoRequest body: UTXO set info request parameters (required)
        :return: ResponsesGetTxOutSetInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tx_out_set_info_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tx_out_set_info_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_tx_out_set_info_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get transaction output set information  # noqa: E501

        Returns statistics about the unspent transaction output set  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_set_info_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetTxOutSetInfoRequest body: UTXO set info request parameters (required)
        :return: ResponsesGetTxOutSetInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tx_out_set_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_tx_out_set_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/out/set/info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetTxOutSetInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tx_spending_prevout(self, body, **kwargs):  # noqa: E501
        """Get transaction spending prevout  # noqa: E501

        Scans the mempool to find transactions spending any of the given outputs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_spending_prevout(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetTxSpendingPrevoutRequest body: Transaction spending prevout request (required)
        :return: ResponsesGetTxSpendingPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tx_spending_prevout_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tx_spending_prevout_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_tx_spending_prevout_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get transaction spending prevout  # noqa: E501

        Scans the mempool to find transactions spending any of the given outputs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_spending_prevout_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsGetTxSpendingPrevoutRequest body: Transaction spending prevout request (required)
        :return: ResponsesGetTxSpendingPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tx_spending_prevout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_tx_spending_prevout`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/spending/prevout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetTxSpendingPrevoutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def join_psbts(self, body, **kwargs):  # noqa: E501
        """Join PSBTs  # noqa: E501

        Joins multiple distinct PSBTs with different inputs and outputs into one PSBT  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.join_psbts(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsJoinPSBTsRequest body: PSBTs to join (required)
        :return: ResponsesJoinPSBTsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.join_psbts_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.join_psbts_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def join_psbts_with_http_info(self, body, **kwargs):  # noqa: E501
        """Join PSBTs  # noqa: E501

        Joins multiple distinct PSBTs with different inputs and outputs into one PSBT  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.join_psbts_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsJoinPSBTsRequest body: PSBTs to join (required)
        :return: ResponsesJoinPSBTsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method join_psbts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `join_psbts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/psbt/join', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesJoinPSBTsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_raw_transaction(self, body, **kwargs):  # noqa: E501
        """Send raw transaction  # noqa: E501

        Submits a raw transaction to local node and network  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_raw_transaction(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsSendRawTransactionRequest body: Raw transaction to send (required)
        :return: ResponsesSendRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.send_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def send_raw_transaction_with_http_info(self, body, **kwargs):  # noqa: E501
        """Send raw transaction  # noqa: E501

        Submits a raw transaction to local node and network  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_raw_transaction_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsSendRawTransactionRequest body: Raw transaction to send (required)
        :return: ResponsesSendRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_raw_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `send_raw_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesSendRawTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def test_mempool_accept(self, body, **kwargs):  # noqa: E501
        """Test mempool accept  # noqa: E501

        Tests whether raw transactions would be accepted by mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_mempool_accept(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsTestMempoolAcceptRequest body: Raw transactions to test (required)
        :return: ResponsesTestMempoolAcceptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.test_mempool_accept_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.test_mempool_accept_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def test_mempool_accept_with_http_info(self, body, **kwargs):  # noqa: E501
        """Test mempool accept  # noqa: E501

        Tests whether raw transactions would be accepted by mempool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_mempool_accept_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsTestMempoolAcceptRequest body: Raw transactions to test (required)
        :return: ResponsesTestMempoolAcceptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_mempool_accept" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `test_mempool_accept`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mempool/test-accept', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesTestMempoolAcceptResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_address(self, address, **kwargs):  # noqa: E501
        """Validate address  # noqa: E501

        Returns information about the given Bitcoin address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_address(address, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: Bitcoin address to validate (required)
        :return: ResponsesValidateAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_address_with_http_info(address, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_address_with_http_info(address, **kwargs)  # noqa: E501
            return data

    def validate_address_with_http_info(self, address, **kwargs):  # noqa: E501
        """Validate address  # noqa: E501

        Returns information about the given Bitcoin address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_address_with_http_info(address, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: Bitcoin address to validate (required)
        :return: ResponsesValidateAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address' is set
        if ('address' not in params or
                params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `validate_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address' in params:
            path_params['address'] = params['address']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/address/{address}/validate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesValidateAddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def verify_message(self, body, **kwargs):  # noqa: E501
        """Verify message  # noqa: E501

        Verifies a signed message  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_message(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsVerifyMessageRequest body: Message verification parameters (required)
        :return: ResponsesVerifyMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.verify_message_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.verify_message_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def verify_message_with_http_info(self, body, **kwargs):  # noqa: E501
        """Verify message  # noqa: E501

        Verifies a signed message  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_message_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsVerifyMessageRequest body: Message verification parameters (required)
        :return: ResponsesVerifyMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_message" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `verify_message`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/address/verify-message', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesVerifyMessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def verify_tx_out_proof(self, body, **kwargs):  # noqa: E501
        """Verify transaction output proof  # noqa: E501

        Verifies that a proof points to a transaction in a block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_tx_out_proof(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsVerifyTxOutProofRequest body: Proof to verify (required)
        :return: ResponsesVerifyTxOutProofResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.verify_tx_out_proof_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.verify_tx_out_proof_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def verify_tx_out_proof_with_http_info(self, body, **kwargs):  # noqa: E501
        """Verify transaction output proof  # noqa: E501

        Verifies that a proof points to a transaction in a block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_tx_out_proof_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestsVerifyTxOutProofRequest body: Proof to verify (required)
        :return: ResponsesVerifyTxOutProofResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_tx_out_proof" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `verify_tx_out_proof`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/out/proof/verify', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesVerifyTxOutProofResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
