# coding: utf-8

"""
    Satstream API

    Satstream API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: team@satstream.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from satstream_python_sdk.api_client import ApiClient


class InscriptionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def decode_tx(self, txid, **kwargs):  # noqa: E501
        """Decode a transaction  # noqa: E501

        Decodes a transaction and returns its inscriptions and runestone data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decode_tx(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GithubComSatstreamSsApiServerApiTransactionResponsesDecodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.decode_tx_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.decode_tx_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def decode_tx_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Decode a transaction  # noqa: E501

        Decodes a transaction and returns its inscriptions and runestone data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decode_tx_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GithubComSatstreamSsApiServerApiTransactionResponsesDecodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method decode_tx" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `decode_tx`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/decode/{txid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiTransactionResponsesDecodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fetch_inscription_child(self, inscription_id, child_index, **kwargs):  # noqa: E501
        """Get inscription child info  # noqa: E501

        Retrieve information about a specific child of an inscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_inscription_child(inscription_id, child_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str inscription_id: Inscription ID (required)
        :param int child_index: Child Index (required)
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fetch_inscription_child_with_http_info(inscription_id, child_index, **kwargs)  # noqa: E501
        else:
            (data) = self.fetch_inscription_child_with_http_info(inscription_id, child_index, **kwargs)  # noqa: E501
            return data

    def fetch_inscription_child_with_http_info(self, inscription_id, child_index, **kwargs):  # noqa: E501
        """Get inscription child info  # noqa: E501

        Retrieve information about a specific child of an inscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_inscription_child_with_http_info(inscription_id, child_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str inscription_id: Inscription ID (required)
        :param int child_index: Child Index (required)
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inscription_id', 'child_index']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch_inscription_child" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'inscription_id' is set
        if ('inscription_id' not in params or
                params['inscription_id'] is None):
            raise ValueError("Missing the required parameter `inscription_id` when calling `fetch_inscription_child`")  # noqa: E501
        # verify the required parameter 'child_index' is set
        if ('child_index' not in params or
                params['child_index'] is None):
            raise ValueError("Missing the required parameter `child_index` when calling `fetch_inscription_child`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inscription_id' in params:
            path_params['inscription_id'] = params['inscription_id']  # noqa: E501
        if 'child_index' in params:
            path_params['child_index'] = params['child_index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/inscription/{inscription_id}/child/{child_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fetch_inscriptions(self, body, **kwargs):  # noqa: E501
        """Fetch multiple inscriptions  # noqa: E501

        Retrieve information about multiple inscriptions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_inscriptions(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Inscription IDs (required)
        :return: list[GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fetch_inscriptions_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.fetch_inscriptions_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def fetch_inscriptions_with_http_info(self, body, **kwargs):  # noqa: E501
        """Fetch multiple inscriptions  # noqa: E501

        Retrieve information about multiple inscriptions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_inscriptions_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Inscription IDs (required)
        :return: list[GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch_inscriptions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `fetch_inscriptions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/inscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_address(self, address, **kwargs):  # noqa: E501
        """Get address info  # noqa: E501

        Get detailed information about a specific address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address(address, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: Address (required)
        :return: GithubComSatstreamSsApiServerApiAddressResponsesAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_address_with_http_info(address, **kwargs)  # noqa: E501
        else:
            (data) = self.get_address_with_http_info(address, **kwargs)  # noqa: E501
            return data

    def get_address_with_http_info(self, address, **kwargs):  # noqa: E501
        """Get address info  # noqa: E501

        Get detailed information about a specific address  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_with_http_info(address, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: Address (required)
        :return: GithubComSatstreamSsApiServerApiAddressResponsesAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address' is set
        if ('address' not in params or
                params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `get_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address' in params:
            path_params['address'] = params['address']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/address/{address}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiAddressResponsesAddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_address_utxos(self, address, **kwargs):  # noqa: E501
        """Get UTXOs for an address  # noqa: E501

        Retrieve UTXOs held by a specific address with optional type filtering  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_utxos(address, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: Address (required)
        :param str type: UTXO Type
        :return: list[GithubComSatstreamSsApiServerApiAddressResponsesOutputResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_address_utxos_with_http_info(address, **kwargs)  # noqa: E501
        else:
            (data) = self.get_address_utxos_with_http_info(address, **kwargs)  # noqa: E501
            return data

    def get_address_utxos_with_http_info(self, address, **kwargs):  # noqa: E501
        """Get UTXOs for an address  # noqa: E501

        Retrieve UTXOs held by a specific address with optional type filtering  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_utxos_with_http_info(address, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: Address (required)
        :param str type: UTXO Type
        :return: list[GithubComSatstreamSsApiServerApiAddressResponsesOutputResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_address_utxos" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address' is set
        if ('address' not in params or
                params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `get_address_utxos`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address' in params:
            path_params['address'] = params['address']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/address/{address}/outputs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GithubComSatstreamSsApiServerApiAddressResponsesOutputResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_by_height(self, block_height, **kwargs):  # noqa: E501
        """Get block info by height  # noqa: E501

        Get detailed information about a specific block by height  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height(block_height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str block_height: Block Height (required)
        :return: GithubComSatstreamSsApiServerApiBlockResponsesBlockResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_by_height_with_http_info(block_height, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_by_height_with_http_info(block_height, **kwargs)  # noqa: E501
            return data

    def get_block_by_height_with_http_info(self, block_height, **kwargs):  # noqa: E501
        """Get block info by height  # noqa: E501

        Get detailed information about a specific block by height  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_by_height_with_http_info(block_height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str block_height: Block Height (required)
        :return: GithubComSatstreamSsApiServerApiBlockResponsesBlockResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['block_height']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_by_height" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'block_height' is set
        if ('block_height' not in params or
                params['block_height'] is None):
            raise ValueError("Missing the required parameter `block_height` when calling `get_block_by_height`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'block_height' in params:
            path_params['block_height'] = params['block_height']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/block/height/{block_height}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiBlockResponsesBlockResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_count(self, **kwargs):  # noqa: E501
        """Get the height of the latest block  # noqa: E501

        Returns the height of the latest block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiBlockResponsesBlockCountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_count_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_block_count_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_block_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get the height of the latest block  # noqa: E501

        Returns the height of the latest block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiBlockResponsesBlockCountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_count" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blockcount', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiBlockResponsesBlockCountResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_hash_by_height(self, block_height, **kwargs):  # noqa: E501
        """Returns blockhash of specified block.  # noqa: E501

        Returns blockhash of specified block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_hash_by_height(block_height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str block_height: Block Height (required)
        :return: GithubComSatstreamSsApiServerApiBlockResponsesBlockHashResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_hash_by_height_with_http_info(block_height, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_hash_by_height_with_http_info(block_height, **kwargs)  # noqa: E501
            return data

    def get_block_hash_by_height_with_http_info(self, block_height, **kwargs):  # noqa: E501
        """Returns blockhash of specified block.  # noqa: E501

        Returns blockhash of specified block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_hash_by_height_with_http_info(block_height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str block_height: Block Height (required)
        :return: GithubComSatstreamSsApiServerApiBlockResponsesBlockHashResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['block_height']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_hash_by_height" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'block_height' is set
        if ('block_height' not in params or
                params['block_height'] is None):
            raise ValueError("Missing the required parameter `block_height` when calling `get_block_hash_by_height`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'block_height' in params:
            path_params['block_height'] = params['block_height']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blockhash/{block_height}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiBlockResponsesBlockHashResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_block_inscriptions(self, block_height, **kwargs):  # noqa: E501
        """Get inscriptions in a specific block  # noqa: E501

        Retrieve all inscriptions in a specific block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_inscriptions(block_height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int block_height: Block Height (required)
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_block_inscriptions_with_http_info(block_height, **kwargs)  # noqa: E501
        else:
            (data) = self.get_block_inscriptions_with_http_info(block_height, **kwargs)  # noqa: E501
            return data

    def get_block_inscriptions_with_http_info(self, block_height, **kwargs):  # noqa: E501
        """Get inscriptions in a specific block  # noqa: E501

        Retrieve all inscriptions in a specific block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_block_inscriptions_with_http_info(block_height, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int block_height: Block Height (required)
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['block_height']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_block_inscriptions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'block_height' is set
        if ('block_height' not in params or
                params['block_height'] is None):
            raise ValueError("Missing the required parameter `block_height` when calling `get_block_inscriptions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'block_height' in params:
            path_params['block_height'] = params['block_height']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/inscriptions/block/{block_height}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_blocks(self, **kwargs):  # noqa: E501
        """Returns the latest block height, last 100 block hashes, and featured inscriptions  # noqa: E501

        Returns the latest block height, last 100 block hashes, and featured inscriptions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blocks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiBlockResponsesBlocksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_blocks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_blocks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_blocks_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the latest block height, last 100 block hashes, and featured inscriptions  # noqa: E501

        Returns the latest block height, last 100 block hashes, and featured inscriptions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_blocks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiBlockResponsesBlocksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_blocks" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blocks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiBlockResponsesBlocksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inscription(self, inscription_id, **kwargs):  # noqa: E501
        """Get inscription info  # noqa: E501

        Get information about a specific inscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inscription(inscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str inscription_id: Inscription ID (required)
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_inscription_with_http_info(inscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_inscription_with_http_info(inscription_id, **kwargs)  # noqa: E501
            return data

    def get_inscription_with_http_info(self, inscription_id, **kwargs):  # noqa: E501
        """Get inscription info  # noqa: E501

        Get information about a specific inscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inscription_with_http_info(inscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str inscription_id: Inscription ID (required)
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['inscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'inscription_id' is set
        if ('inscription_id' not in params or
                params['inscription_id'] is None):
            raise ValueError("Missing the required parameter `inscription_id` when calling `get_inscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inscription_id' in params:
            path_params['inscription_id'] = params['inscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/inscription/{inscription_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiInscriptionResponsesInscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_block_height(self, **kwargs):  # noqa: E501
        """Returns the height of the latest block.  # noqa: E501

        Returns the height of the latest block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_block_height(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesLatestBlockHeightResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_block_height_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_block_height_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_latest_block_height_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the height of the latest block.  # noqa: E501

        Returns the height of the latest block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_block_height_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesLatestBlockHeightResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_block_height" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/latestblockheight', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesLatestBlockHeightResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_blockhash(self, **kwargs):  # noqa: E501
        """Returns blockhash for the latest block.  # noqa: E501

        Returns blockhash for the latest block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_blockhash(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesLatestBlockHashResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_blockhash_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_blockhash_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_latest_blockhash_with_http_info(self, **kwargs):  # noqa: E501
        """Returns blockhash for the latest block.  # noqa: E501

        Returns blockhash for the latest block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_blockhash_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesLatestBlockHashResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_blockhash" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/latestblockhash', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesLatestBlockHashResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_blocktime(self, **kwargs):  # noqa: E501
        """Get the timestamp of the latest block  # noqa: E501

        Returns the UNIX timestamp of when the latest block was mined  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_blocktime(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesLatestBlockTimeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_blocktime_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_blocktime_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_latest_blocktime_with_http_info(self, **kwargs):  # noqa: E501
        """Get the timestamp of the latest block  # noqa: E501

        Returns the UNIX timestamp of when the latest block was mined  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_blocktime_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ResponsesLatestBlockTimeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_blocktime" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/blocktime', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesLatestBlockTimeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_inscriptions(self, **kwargs):  # noqa: E501
        """Get latest inscriptions  # noqa: E501

        Retrieve the latest 100 inscriptions (first page)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_inscriptions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_inscriptions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_inscriptions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_latest_inscriptions_with_http_info(self, **kwargs):  # noqa: E501
        """Get latest inscriptions  # noqa: E501

        Retrieve the latest 100 inscriptions (first page)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_inscriptions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_inscriptions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/inscriptions/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_inscriptions_page(self, page, **kwargs):  # noqa: E501
        """Get latest inscriptions page  # noqa: E501

        Retrieve a specific page of 100 inscriptions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_inscriptions_page(page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number (required)
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_inscriptions_page_with_http_info(page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_inscriptions_page_with_http_info(page, **kwargs)  # noqa: E501
            return data

    def get_latest_inscriptions_page_with_http_info(self, page, **kwargs):  # noqa: E501
        """Get latest inscriptions page  # noqa: E501

        Retrieve a specific page of 100 inscriptions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_inscriptions_page_with_http_info(page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number (required)
        :return: GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_inscriptions_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_latest_inscriptions_page`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'page' in params:
            path_params['page'] = params['page']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/inscriptions/page/{page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiInscriptionResponsesLatestInscriptionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_runes(self, **kwargs):  # noqa: E501
        """Get latest runes  # noqa: E501

        Retrieve information about the last 100 inscribed runes (first page)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_runes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiRuneResponsesRunesListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_runes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_runes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_latest_runes_with_http_info(self, **kwargs):  # noqa: E501
        """Get latest runes  # noqa: E501

        Retrieve information about the last 100 inscribed runes (first page)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_runes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiRuneResponsesRunesListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_runes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/runes/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiRuneResponsesRunesListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_runes_page(self, page, **kwargs):  # noqa: E501
        """Get latest runes page  # noqa: E501

        Retrieve a specific page of 100 inscribed runes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_runes_page(page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number (required)
        :return: GithubComSatstreamSsApiServerApiRuneResponsesRunesListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_runes_page_with_http_info(page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_runes_page_with_http_info(page, **kwargs)  # noqa: E501
            return data

    def get_latest_runes_page_with_http_info(self, page, **kwargs):  # noqa: E501
        """Get latest runes page  # noqa: E501

        Retrieve a specific page of 100 inscribed runes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_runes_page_with_http_info(page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number (required)
        :return: GithubComSatstreamSsApiServerApiRuneResponsesRunesListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_runes_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_latest_runes_page`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'page' in params:
            path_params['page'] = params['page']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/runes/page/{page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiRuneResponsesRunesListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_output_by_outpoint(self, outpoint, **kwargs):  # noqa: E501
        """Get output info by outpoint  # noqa: E501

        Retrieve information about a specific UTXO using outpoint string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_output_by_outpoint(outpoint, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str outpoint: Outpoint (required)
        :return: ResponsesGetOutputByOutpointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_output_by_outpoint_with_http_info(outpoint, **kwargs)  # noqa: E501
        else:
            (data) = self.get_output_by_outpoint_with_http_info(outpoint, **kwargs)  # noqa: E501
            return data

    def get_output_by_outpoint_with_http_info(self, outpoint, **kwargs):  # noqa: E501
        """Get output info by outpoint  # noqa: E501

        Retrieve information about a specific UTXO using outpoint string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_output_by_outpoint_with_http_info(outpoint, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str outpoint: Outpoint (required)
        :return: ResponsesGetOutputByOutpointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outpoint']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_output_by_outpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'outpoint' is set
        if ('outpoint' not in params or
                params['outpoint'] is None):
            raise ValueError("Missing the required parameter `outpoint` when calling `get_output_by_outpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'outpoint' in params:
            path_params['outpoint'] = params['outpoint']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/output/outpoint/{outpoint}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponsesGetOutputByOutpointResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_outputs(self, body, **kwargs):  # noqa: E501
        """Get multiple outputs  # noqa: E501

        Retrieve information about multiple UTXOs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_outputs(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Outpoints (required)
        :return: list[ResponsesGetOutputsResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_outputs_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_outputs_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_outputs_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get multiple outputs  # noqa: E501

        Retrieve information about multiple UTXOs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_outputs_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: Outpoints (required)
        :return: list[ResponsesGetOutputsResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outputs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_outputs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/outputs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ResponsesGetOutputsResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rune(self, rune_name, **kwargs):  # noqa: E501
        """Get rune info  # noqa: E501

        Retrieve information about a specific rune  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rune(rune_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rune_name: Rune Name (required)
        :return: GithubComSatstreamSsApiServerApiRuneResponsesRuneResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rune_with_http_info(rune_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rune_with_http_info(rune_name, **kwargs)  # noqa: E501
            return data

    def get_rune_with_http_info(self, rune_name, **kwargs):  # noqa: E501
        """Get rune info  # noqa: E501

        Retrieve information about a specific rune  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rune_with_http_info(rune_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rune_name: Rune Name (required)
        :return: GithubComSatstreamSsApiServerApiRuneResponsesRuneResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rune_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rune" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rune_name' is set
        if ('rune_name' not in params or
                params['rune_name'] is None):
            raise ValueError("Missing the required parameter `rune_name` when calling `get_rune`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rune_name' in params:
            path_params['rune_name'] = params['rune_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rune/{rune_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiRuneResponsesRuneResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_satoshi(self, number, **kwargs):  # noqa: E501
        """Get satoshi info  # noqa: E501

        Retrieve information about a specific satoshi  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_satoshi(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int number: Satoshi Number (required)
        :return: GithubComSatstreamSsApiServerApiSatoshiResponsesSatoshiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_satoshi_with_http_info(number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_satoshi_with_http_info(number, **kwargs)  # noqa: E501
            return data

    def get_satoshi_with_http_info(self, number, **kwargs):  # noqa: E501
        """Get satoshi info  # noqa: E501

        Retrieve information about a specific satoshi  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_satoshi_with_http_info(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int number: Satoshi Number (required)
        :return: GithubComSatstreamSsApiServerApiSatoshiResponsesSatoshiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_satoshi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError("Missing the required parameter `number` when calling `get_satoshi`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sat/{number}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiSatoshiResponsesSatoshiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status(self, **kwargs):  # noqa: E501
        """Get server status  # noqa: E501

        Retrieve information about the server installation and index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiStatusResponsesStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_status_with_http_info(self, **kwargs):  # noqa: E501
        """Get server status  # noqa: E501

        Retrieve information about the server installation and index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GithubComSatstreamSsApiServerApiStatusResponsesStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiStatusResponsesStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction(self, txid, **kwargs):  # noqa: E501
        """Get transaction info  # noqa: E501

        Retrieve information about a specific transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GithubComSatstreamSsApiServerApiTransactionResponsesTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_transaction_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get transaction info  # noqa: E501

        Retrieve information about a specific transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GithubComSatstreamSsApiServerApiTransactionResponsesTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GithubComSatstreamSsApiServerApiTransactionResponsesTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
