# coding: utf-8

"""
    Satstream API

    Satstream API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: team@satstream.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from satstream_python_sdk.api_client import ApiClient


class TransactionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def combine_raw_transaction(self, body, **kwargs):  # noqa: E501
        """Combine Raw Transactions  # noqa: E501

        Combines multiple partially signed transactions into one transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.combine_raw_transaction(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionCombineRawTransactionRequest body: Array of hex-encoded raw transactions (required)
        :return: CombineRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.combine_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.combine_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def combine_raw_transaction_with_http_info(self, body, **kwargs):  # noqa: E501
        """Combine Raw Transactions  # noqa: E501

        Combines multiple partially signed transactions into one transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.combine_raw_transaction_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionCombineRawTransactionRequest body: Array of hex-encoded raw transactions (required)
        :return: CombineRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method combine_raw_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `combine_raw_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/combine', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CombineRawTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_to_psbt(self, body, **kwargs):  # noqa: E501
        """Convert Raw Transaction to PSBT  # noqa: E501

        Converts a network serialized transaction to a PSBT. This should be used only with createrawtransaction and fundrawtransaction. createpsbt and walletcreatefundedpsbt should be used for new applications.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_to_psbt(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionConvertToPSBTRequest body: Raw transaction conversion parameters (required)
        :return: ConvertToPSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.convert_to_psbt_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.convert_to_psbt_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def convert_to_psbt_with_http_info(self, body, **kwargs):  # noqa: E501
        """Convert Raw Transaction to PSBT  # noqa: E501

        Converts a network serialized transaction to a PSBT. This should be used only with createrawtransaction and fundrawtransaction. createpsbt and walletcreatefundedpsbt should be used for new applications.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_to_psbt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionConvertToPSBTRequest body: Raw transaction conversion parameters (required)
        :return: ConvertToPSBTResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_to_psbt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `convert_to_psbt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/convert-to-psbt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConvertToPSBTResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_raw_transaction(self, body, **kwargs):  # noqa: E501
        """Create Raw Transaction  # noqa: E501

        Creates a raw transaction spending the given inputs and creating new outputs. Note that the transaction's inputs are not signed, and it is not stored in the wallet or transmitted to the network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_raw_transaction(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionCreateRawTxRequest body: Transaction parameters (required)
        :return: CreateRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_raw_transaction_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create Raw Transaction  # noqa: E501

        Creates a raw transaction spending the given inputs and creating new outputs. Note that the transaction's inputs are not signed, and it is not stored in the wallet or transmitted to the network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_raw_transaction_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionCreateRawTxRequest body: Transaction parameters (required)
        :return: CreateRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_raw_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_raw_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateRawTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def decode_tx(self, txid, **kwargs):  # noqa: E501
        """Decode a transaction  # noqa: E501

        Decodes a transaction and returns its inscriptions and runestone data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decode_tx(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: DecodeTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.decode_tx_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.decode_tx_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def decode_tx_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Decode a transaction  # noqa: E501

        Decodes a transaction and returns its inscriptions and runestone data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.decode_tx_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: DecodeTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method decode_tx" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `decode_tx`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}/decode', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecodeTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_raw_transaction_decoded(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 1)  # noqa: E501

        Get raw transaction as a decoded object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_decoded(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GetRawTransactionDecodedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_raw_transaction_decoded_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_raw_transaction_decoded_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_raw_transaction_decoded_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 1)  # noqa: E501

        Get raw transaction as a decoded object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_decoded_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GetRawTransactionDecodedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_raw_transaction_decoded" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_raw_transaction_decoded`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}/decoded', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetRawTransactionDecodedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_raw_transaction_hex(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 0)  # noqa: E501

        Get raw transaction as a raw hex string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_hex(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GetRawTransactionHexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_raw_transaction_hex_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_raw_transaction_hex_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_raw_transaction_hex_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 0)  # noqa: E501

        Get raw transaction as a raw hex string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_hex_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GetRawTransactionHexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_raw_transaction_hex" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_raw_transaction_hex`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}/hex', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetRawTransactionHexResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_raw_transaction_prevout(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 2)  # noqa: E501

        Get raw transaction with prevout information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_prevout(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GetRawTransactionPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_raw_transaction_prevout_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_raw_transaction_prevout_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_raw_transaction_prevout_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get raw transaction (verbosity 2)  # noqa: E501

        Get raw transaction with prevout information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_raw_transaction_prevout_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GetRawTransactionPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_raw_transaction_prevout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_raw_transaction_prevout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}/prevout', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetRawTransactionPrevoutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction(self, txid, **kwargs):  # noqa: E501
        """Get transaction info  # noqa: E501

        Retrieve information about a specific transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GetTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_with_http_info(txid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_with_http_info(txid, **kwargs)  # noqa: E501
            return data

    def get_transaction_with_http_info(self, txid, **kwargs):  # noqa: E501
        """Get transaction info  # noqa: E501

        Retrieve information about a specific transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_with_http_info(txid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str txid: Transaction ID (required)
        :return: GetTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['txid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'txid' is set
        if ('txid' not in params or
                params['txid'] is None):
            raise ValueError("Missing the required parameter `txid` when calling `get_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'txid' in params:
            path_params['txid'] = params['txid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/{txid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tx_out(self, body, **kwargs):  # noqa: E501
        """Get transaction output  # noqa: E501

        Returns details about an unspent transaction output  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionGetTxOutRequest body: Transaction output request parameters (required)
        :return: GetTxOutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tx_out_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tx_out_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_tx_out_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get transaction output  # noqa: E501

        Returns details about an unspent transaction output  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionGetTxOutRequest body: Transaction output request parameters (required)
        :return: GetTxOutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tx_out" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_tx_out`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/out', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTxOutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tx_out_proof(self, body, **kwargs):  # noqa: E501
        """Get transaction output proof  # noqa: E501

        Returns a hex-encoded proof that one or more specified transactions were included in a block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_proof(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionGetTxOutProofRequest body: Transaction proof request parameters (required)
        :return: GetTxOutProofResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tx_out_proof_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tx_out_proof_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_tx_out_proof_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get transaction output proof  # noqa: E501

        Returns a hex-encoded proof that one or more specified transactions were included in a block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_proof_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionGetTxOutProofRequest body: Transaction proof request parameters (required)
        :return: GetTxOutProofResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tx_out_proof" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_tx_out_proof`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/outproof', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTxOutProofResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tx_out_set_info(self, body, **kwargs):  # noqa: E501
        """Get transaction output set information  # noqa: E501

        Returns statistics about the unspent transaction output set  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_set_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionGetTxOutSetInfoRequest body: UTXO set info request parameters (required)
        :return: InlineResponse2002
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tx_out_set_info_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tx_out_set_info_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_tx_out_set_info_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get transaction output set information  # noqa: E501

        Returns statistics about the unspent transaction output set  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_out_set_info_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionGetTxOutSetInfoRequest body: UTXO set info request parameters (required)
        :return: InlineResponse2002
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tx_out_set_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_tx_out_set_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/out/set/info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2002',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tx_spending_prevout(self, body, **kwargs):  # noqa: E501
        """Get transaction spending prevout  # noqa: E501

        Scans the mempool to find transactions spending any of the given outputs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_spending_prevout(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionGetTxSpendingPrevoutRequest body: Transaction spending prevout request (required)
        :return: GetTxSpendingPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tx_spending_prevout_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tx_spending_prevout_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_tx_spending_prevout_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get transaction spending prevout  # noqa: E501

        Scans the mempool to find transactions spending any of the given outputs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tx_spending_prevout_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionGetTxSpendingPrevoutRequest body: Transaction spending prevout request (required)
        :return: GetTxSpendingPrevoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tx_spending_prevout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_tx_spending_prevout`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/spending-prevout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTxSpendingPrevoutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_raw_transaction(self, body, **kwargs):  # noqa: E501
        """Send raw transaction  # noqa: E501

        Submits a raw transaction to local node and network  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_raw_transaction(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionSendRawTransactionRequest body: Raw transaction to send (required)
        :return: SendRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.send_raw_transaction_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def send_raw_transaction_with_http_info(self, body, **kwargs):  # noqa: E501
        """Send raw transaction  # noqa: E501

        Submits a raw transaction to local node and network  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_raw_transaction_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionSendRawTransactionRequest body: Raw transaction to send (required)
        :return: SendRawTransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_raw_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `send_raw_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SendRawTransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def verify_tx_out_proof(self, body, **kwargs):  # noqa: E501
        """Verify transaction output proof  # noqa: E501

        Verifies that a proof points to a transaction in a block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_tx_out_proof(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionVerifyTxOutProofRequest body: Proof to verify (required)
        :return: VerifyTxOutProofResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.verify_tx_out_proof_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.verify_tx_out_proof_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def verify_tx_out_proof_with_http_info(self, body, **kwargs):  # noqa: E501
        """Verify transaction output proof  # noqa: E501

        Verifies that a proof points to a transaction in a block  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_tx_out_proof_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionVerifyTxOutProofRequest body: Proof to verify (required)
        :return: VerifyTxOutProofResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_tx_out_proof" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `verify_tx_out_proof`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tx/outproof/verify', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VerifyTxOutProofResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
